#include "mailer.h"
#include "xmisc.h"

    #define MAXFINDHANDLES 255

    HDIR *bbs_findhandles[MAXINSTANCES];


void _fastcall init_bbsfindhandles (USHORT cp) {

  int x;

  bbs_findhandles[cp] = (HDIR *)malloc(sizeof(HDIR) * MAXFINDHANDLES);
  for(x = 0;x < MAXFINDHANDLES;x++)
      bbs_findhandles[cp][x] = (HDIR)-1;
}


int _fastcall bbs_findfirst (USHORT cp,char *s,HDIR *search_handle,USHORT attr,
                             FILEFINDBUF *fb,size_t size,USHORT *num,long res) {

    int x,y;

    if((int)cp == -1)
      return DosFindFirst(s,search_handle,attr,fb,size,num,res);

    for(x = 0;x < MAXFINDHANDLES;x++) {
      if(bbs_findhandles[cp][x] == (HDIR)-1) {
        y = DosFindFirst(s,search_handle,attr,fb,size,num,res);
        if(!y)
          bbs_findhandles[cp][x] = *search_handle;
        return y;
      }
    }

    return -1;  /* out of handles */
}


int _fastcall bbs_closefind (USHORT cp,HDIR search_handle) {

    int x,y;

    if((int)cp == -1)
      return DosFindClose(search_handle);

    for(x = 0;x < MAXFINDHANDLES;x++) {
      if(bbs_findhandles[cp][x] == search_handle) {
        y = DosFindClose(search_handle);
        bbs_findhandles[cp][x] = (HDIR)-1;
        return y;
      }
    }

    return -1;
}


void _fastcall bbs_closeallfind (USHORT cp) {

    int x;

    for(x = 0;x < MAXFINDHANDLES;x++) {
        if(bbs_findhandles[cp][x] != (HDIR)-1) {
            DosFindClose(bbs_findhandles[cp][x]);
            bbs_findhandles[cp][x] = (HDIR)-1;
        }
    }
}


void _fastcall bbs_freefindhandles (USHORT cp) {

    if(bbs_findhandles[cp]) {
        bbs_closeallfind(cp);
        free(bbs_findhandles[cp]);
        bbs_findhandles[cp] = NULL;
    }
}
