#include <stdarg.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "xmisc.h"


    #define MAXFILEHANDLES 255

    int *bbs_filehandles[MAXINSTANCES];    /* file handles */



void _fastcall init_filehandles (USHORT cp) {

    /* set all file handles to -1 to initialize */

    int y;

    bbs_filehandles[cp] = (int *)malloc(sizeof(int) * MAXFILEHANDLES);
    for(y = 0;y < MAXFILEHANDLES;y++) {
        bbs_filehandles[cp][y] = -1;
    }
}



int bbs_sopen (USHORT cp,const char _far *s, int at, int sh, ...) {

    int x,cr;
    va_list pArguments;


    if((int)cp == -1) {
        if(at & O_CREAT) {
            va_start(pArguments,sh);
            va_arg(pArguments,int);
            cr = va_arg(pArguments,int);
            if(!(cr & S_IWRITE)) cr = S_IWRITE | S_IREAD;
            va_end(pArguments);
            return sopen(s,at,sh,cr);
        }
        else return sopen(s,at,sh);
    }

    for(x = 0;x < MAXFILEHANDLES;x++) {
        if(bbs_filehandles[cp][x] == -1) {
            if(at & O_CREAT) {
                va_start(pArguments,sh);
                va_arg(pArguments,int);
                cr = va_arg(pArguments,int);
                if(!(cr & S_IWRITE)) cr = S_IWRITE | S_IREAD;
                va_end(pArguments);
                bbs_filehandles[cp][x] = sopen(s,at,sh,cr);
            }
            else bbs_filehandles[cp][x] = sopen(s,at,sh);
            return bbs_filehandles[cp][x];
        }
    }
    return -1;    /* out of file handles */
}




void _fastcall bbs_close (USHORT cp,int handle) {

    int x;


    if(handle == -1) return;

    if((int)cp == -1) {
        close(handle);
        return;
    }

    for(x=0;x < MAXFILEHANDLES;x++) {
        if(bbs_filehandles[cp][x] == handle) {
            close(bbs_filehandles[cp][x]);
            bbs_filehandles[cp][x] = -1;
            return;
        }
    }
}





void _fastcall bbs_closeall (USHORT cp) {

    int x;


    for(x = 0;x < MAXFILEHANDLES;x++) {
        if(bbs_filehandles[cp][x] != -1) {
            close(bbs_filehandles[cp][x]);
            bbs_filehandles[cp][x] = -1;
        }
    }
}




void _fastcall bbs_freefilehandles (USHORT cp) {

    if(bbs_filehandles[cp]) {
        bbs_closeall(cp);
        free(bbs_filehandles[cp]);
        bbs_filehandles[cp] = NULL;
    }
}
