  '***********************************************************************
  '** Program Name: Squish EchoMail Snoop Program (SEMS)                **
  '**       Author: R.J. (Bob) Ross                                     **
  '** Date Started: April 25th, 1995                                    **
  '**      Version: 1.00  - completed May 1st, 1995                     **
  '**      Version: 1.01  - completed May 16th, 1995                    **              **
  '**                                                                   **
  '**      Purpose: To read selected Squish EchoMail areas and make a   **
  '**               text output file containing EchoMail messages       **
  '**               based on selection criteria supplied in a SEMS      **
  '**               configuration file.                                 **
  '**                                                                   **
  '**     Language: Microsoft QuickBASIC 4.5                            **
  '**    Libraries: Crescent Software Inc - QuickPak Professional       **
  '**                                                                   **
  '***********************************************************************
  
    DEFINT A-Z
    DECLARE FUNCTION CurrentDate$ ()
    DECLARE FUNCTION Date2Num% (D$)
    DECLARE SUB EndPgm ()
    DECLARE FUNCTION Exist% (FileName$)
    DECLARE SUB Help ()
    DECLARE FUNCTION MonthName$ (Month%)
    DECLARE FUNCTION MsgDate$ (DateMsgWritten&)
    DECLARE FUNCTION MsgTime$ (DateMsgWritten&)
    DECLARE FUNCTION Num2Date$ (Days%)
    DECLARE FUNCTION QInstrB (Start%, Source$, Search$)
    DECLARE FUNCTION QPTrim$ (Work$)
    DECLARE FUNCTION QPValI% (Work$)
    DECLARE SUB SquishBase (SqFile$, NumMsgs%, TotSize&)
    DECLARE SUB WordWrap (X$, Wide, LeftMargin)
  
    CLS
  
    ON ERROR GOTO Bomb
  
    DIM Snoop$(1 TO 20)
    DIM LookFor$(1 TO 20)
  
    CONST False = 0
    CONST True = NOT False
  
    Apend% = False
    Snoop% = 0
    SquishCfg% = False
    CurrentDays% = Date2Num%(DATE$)
    DaysBack% = 0
    LongMsg% = False
    LookFor% = 0
    FlagMsg% = False
    UseDate% = CurrentDays% - DaysBack%
  
    IF COMMAND$ = "" THEN
        CALL Help
        END
    END IF
  
    CmdLine$ = UCASE$(COMMAND$)
    P% = INSTR(CmdLine$, "-C")  ' -C  Config file
    IF P% THEN
        Temp$ = MID$(CmdLine$, P% + 2)
        P% = INSTR(Temp$, " ")
        IF P% THEN
            ConFigFile$ = LEFT$(Temp$, P% - 1)
        ELSE
            ConFigFile$ = Temp$
        END IF
    ELSE
        CALL Help
        END
    END IF
  
    IF INSTR(CmdLine$, "-A") THEN Apend% = True
  
    CONST Version = "SEMS V1.01"
    Dt$ = CurrentDate$
  
    PRINT Dt$; TIME$; " SEMS Begin "; Version
  
    IF NOT Exist%(ConFigFile$) THEN
      ' no config file
        PRINT Dt$; TIME$; " SEMS ConfigFile "; ConFigFile$; " not found."
        CALL EndPgm
        END
    END IF
  
  'Type definitions for the Squish Message Base Files
  
    TYPE SQIDX  ' .SQI file: one of these per message (12 bytes)
        OFFST  AS LONG
        UmsgID AS LONG
        HASH   AS LONG
    END TYPE
  
    TYPE SQBASE ' .SQD database header (256 bytes): 1 per .SQD file
        SLEN    AS INTEGER
        RSVD1   AS INTEGER
        NUMMSG  AS LONG         ' No of msgs in area
        HiMsg   AS LONG         ' Highest msg number (same as NUMMSG)
        SKIPMSG AS LONG         ' # of msgs to protect from autoKill
        HIWATER AS LONG         ' Highwatermark
        UID     AS LONG         ' # of next UMSGID to use
        BASEID  AS STRING * 80  ' Name (incl path) of this message base
        FBEGIN  AS LONG         ' Offset to 1st frame
        FLAST   AS LONG         ' Offset to last frame
        FFBEGIN AS LONG         ' Offset to 1st free frame
        FFLAST  AS LONG         ' Offset to last free frame
        FEND    AS LONG         ' Offset to end of file
        MAXMSGS AS LONG         ' # of msgs to keep
        MAXDAYS AS INTEGER      ' # of days to keep msgs for
        SZSQHDR AS INTEGER      ' Size of SQHDR (32 bytes)
    END TYPE
  
    TYPE SQHDR
        ID     AS LONG
        NEXTF  AS LONG
        PREVF  AS LONG
        FLEN   AS LONG
        MSGLEN AS LONG
        CLEN   AS LONG
        FTYP   AS INTEGER
        RSVD   AS INTEGER
    END TYPE
  
    TYPE SQMESSAGE              ' The message Header, as it appears in a Squish area
        ATTRIB      AS STRING * 4               'Message Attribute Flag
        From        AS STRING * 36              'From Name with trailing nulls
        Dest        AS STRING * 36              'To Name with trailing nulls
        Subj        AS STRING * 72              'Message subject with trailing nulls
        OrigZone    AS INTEGER  'Origination Zone
        OrigNet     AS INTEGER  'Origination Net
        OrigNode    AS INTEGER  'Origination Node
        OrigPoint   AS INTEGER  'Origination Point
        DestZone    AS INTEGER  'Destination Zone
        DestNet     AS INTEGER  'Destination Net
        DestNode    AS INTEGER  'Destination Node
        DestPoint   AS INTEGER  'Destination Point
        DateWritten AS LONG     'DOS-ST date/time STAMP
        DateArrived AS LONG     'DOS-ST date/time STAMP
        UTCofs      AS INTEGER  'Not Used
        ReplyTo     AS LONG     'UMSGID of message this replies to
        Replies     AS STRING * 36              '36 bytes for reply array
        UmsgID      AS LONG     'UMSGID is only used if the MSGUID Bit is
      '       set in the ATTRIBUTE Field
        DateMsg     AS STRING * 20              'ASCII Z Date
    END TYPE
  
  
  'End Type definitions for the Squish message base files
  
    DIM IDX AS SQIDX
    DIM MBase AS SQBASE
    DIM Mhdr AS SQHDR
    DIM SqMsg AS SQMESSAGE
  
    OPEN ConFigFile$ FOR INPUT AS #5
    PRINT Dt$; TIME$; " SEMS Parsing "; ConFigFile$
    DO UNTIL EOF(5)
ParseCfg:
        DO UNTIL EOF(5)
            LINE INPUT #5, Record$
            Record$ = UCASE$(LTRIM$(Record$))
            IF LEFT$(Record$, 1) = ";" THEN EXIT DO
          
            IF LEFT$(Record$, 5) = "SNOOP" THEN
                Snoop% = Snoop% + 1
                IF Snoop% > 20 THEN
                  'do nothing
                ELSE
                    P% = INSTR(Record$, " ")
                    IF P% THEN
                        Snoop$(Snoop%) = QPTrim$(MID$(Record$, P%))
                        PRINT Dt$; TIME$; " SEMS Snoop at Node "; Snoop$(Snoop%)
                    END IF
                END IF
            END IF
          
            IF LEFT$(Record$, 10) = "OUTPUTFILE" THEN
                P% = INSTR(Record$, " ")
                IF P% THEN
                    OutPutFile$ = QPTrim$(MID$(Record$, P%))
                    PRINT Dt$; TIME$; " SEMS Output File is "; OutPutFile$
                    IF Apend% THEN
                        OPEN OutPutFile$ FOR APPEND AS #3
                    ELSE
                        OPEN OutPutFile$ FOR OUTPUT AS #3
                    END IF
                    PRINT #3, Dt$; TIME$; " SEMS Begin "; Version
                END IF
              
            END IF
          
            IF LEFT$(Record$, 8) = "DAYSBACK" THEN
                P% = INSTR(Record$, " ")
                IF P% THEN
                    DaysBack% = VAL(MID$(Record$, P%))
                    UseDate% = CurrentDays% - DaysBack%
                    PRINT Dt$; TIME$; " SEMS Looking back "; DaysBack%; " day(s)."
                END IF
            END IF
          
            IF LEFT$(Record$, 7) = "LOOKFOR" THEN
                LookFor% = LookFor% + 1
                IF LookFor% > 20 THEN
                  'do nothing
                ELSE
                    P% = INSTR(Record$, " ")
                    IF P% THEN
                        LookFor$(LookFor%) = QPTrim$(MID$(Record$, P%))
                    END IF
                END IF
            END IF
          
            IF LEFT$(Record$, 9) = "SQUISHCFG" THEN
                P% = INSTR(Record$, " ")
                IF P% THEN
                    SquishCfg$ = QPTrim$(MID$(Record$, P%))
                    SquishCfg% = True
                    PRINT Dt$; TIME$; " SEMS Using "; SquishCfg$
                    OPEN SquishCfg$ FOR INPUT AS #4
SqCfg:
                    DO UNTIL EOF(4)
                        DO UNTIL EOF(4)
                            LINE INPUT #4, Record$
                            Record$ = LTRIM$(UCASE$(Record$))
                            IF LEFT$(Record$, 1) = ";" THEN EXIT DO
                            IF LEFT$(Record$, 8) = "ECHOAREA" THEN
                                P% = INSTR(Record$, " ")
                                IF P% THEN
                                    Temp1$ = LTRIM$(MID$(Record$, P%))
                                END IF
                                P% = INSTR(Temp1$, " ")
                                IF P% THEN
                                    EchoTag$ = LEFT$(Temp1$, P% - 1)
                                    Temp2$ = LTRIM$(MID$(Temp1$, P%))
                                END IF
                                P% = INSTR(Temp2$, " ")
                                IF P% THEN
                                    SqFile$ = LEFT$(Temp2$, P% - 1)
                                    PRINT Dt$; TIME$; " SEMS Echo "; EchoTag$
                                    FoundMsgs% = 0
                                    GOSUB ProcMsgFiles
                                    PRINT Dt$; TIME$; " SEMS Found"; FoundMsgs%; "Msgs"
                                    IF FoundMsgs% THEN
                                        PRINT #3,
                                        PRINT #3, STRING$(79, 223)
                                    END IF
                                    PRINT #3, Dt$; TIME$; " SEMS Found"; FoundMsgs%; "Msgs in "; EchoTag$
                                END IF
                            ELSE EXIT DO
                            END IF
                        LOOP
                    LOOP
                END IF
            END IF
          
            IF LEFT$(Record$, 8) = "ECHOAREA" AND NOT SquishCfg% THEN
                P% = INSTR(Record$, " ")
                IF P% THEN
                    Temp1$ = LTRIM$(MID$(Record$, P%))
                END IF
                P% = INSTR(Temp1$, " ")
                IF P% THEN
                    EchoTag$ = LEFT$(Temp1$, P% - 1)
                    Temp2$ = LTRIM$(MID$(Temp1$, P%))
                END IF
                P% = INSTR(Temp2$, " ")
                IF P% THEN
                    SqFile$ = LEFT$(Temp2$, P% - 1)
                ELSE SqFile$ = Temp2$
                    PRINT Dt$; TIME$; " SEMS Echo "; EchoTag$
                    FoundMsgs% = 0
                    GOSUB ProcMsgFiles
                    PRINT Dt$; TIME$; " SEMS Found"; FoundMsgs%; "Msgs"
                    IF FoundMsgs% THEN
                        PRINT #3,
                        PRINT #3, STRING$(79, 223)
                    END IF
                    PRINT #3, Dt$; TIME$; " SEMS Found"; FoundMsgs%; "Msgs in "; EchoTag$
                END IF
            END IF
          
        LOOP
    LOOP
    PRINT Dt$; TIME$; " SEMS End "; Version
    PRINT #3, Dt$; TIME$; " SEMS End "; Version
    CLOSE
    IF Exist%("SEMS.$$$") THEN KILL "SEMS.$$$"
    IF Exist%("SEMS.$$1") THEN KILL "SEMS.$$1"
    END
  
Bomb:
    IF ERR = 14 THEN
      'out of string space'
        a$ = ""
        a$ = "**** Message text is too large for SEMS to process! ****" + STR$(Mhdr.MSGLEN)
        PRINT Dt$; TIME$; " SEMS Found a message to large to process. "; Mhdr.MSGLEN
        RESUME NEXT
    END IF
    IF ERR = 64 THEN
        PRINT #3, Dt$; TIME$; " SEMS Bad file name "; SqFile$; ".SQD"
        PRINT Dt$; TIME$; " SEMS Bad file name "; SqFile$; ".SQD"
        IF SquishCfg% THEN
            RESUME SqCfg
        ELSE
            RESUME ParseCfg
        END IF
    END IF
    PRINT Dt$; TIME$; " SEMS Program abended with error "; ERR
    END
  
ProcMsgFiles:
    IF NOT Exist%(SqFile$ + ".SQI") THEN
        PRINT Dt$; TIME$; " SEMS "; SqFile$; ".SQI "; "NOT found."
        PRINT #3, Dt$; TIME$; " SEMS "; SqFile$; ".SQI "; "NOT found."
        RETURN
    END IF
    OPEN SqFile$ + ".SQI" FOR RANDOM SHARED AS #1 LEN = 12
    OPEN SqFile$ + ".SQD" FOR BINARY SHARED AS #2
  
    GET #2, 1, MBase
    PRINT Dt$; TIME$; " SEMS Highest message ="; MBase.HiMsg
  
    FOR X% = 1 TO MBase.HiMsg
        GET #1, X%, IDX
        MsgOffst& = IDX.OFFST + 1 + LEN(Mhdr)
        GET #2, IDX.OFFST + 1, Mhdr
        GET #2, MsgOffst&, SqMsg
        ReceiveDays% = 0
        MsgDays% = Date2Num%(MsgDate$(SqMsg.DateWritten))
        IF SqMsg.DateArrived THEN
            ReceiveDays% = Date2Num%(MsgDate$(SqMsg.DateArrived))
        END IF
        IF MsgDays% >= UseDate% OR ReceiveDays% >= UseDate% THEN
            Temp$ = MsgDate$(SqMsg.DateWritten)
            Dy$ = MID$(Temp$, 4, 2)
            Mo$ = MonthName$(VAL(LEFT$(Temp$, 2)))
            Yr$ = RIGHT$(Temp$, 2)
            SqMsg.DateMsg = Dy$ + " " + Mo$ + " " + Yr$
            IF ReceiveDays% THEN
                Temp$ = MsgDate$(SqMsg.DateArrived)
                Dy$ = MID$(Temp$, 4, 2)
                Mo$ = MonthName$(VAL(LEFT$(Temp$, 2)))
                Yr$ = RIGHT$(Temp$, 2)
                DtArrived$ = Dy$ + " " + Mo$ + " " + Yr$
            END IF
            SEEK #2, MsgOffst&
            IF Mhdr.MSGLEN > 20000 THEN
                LongMsg% = True
                Remainder% = 0
                a$ = ""
                Sems1% = Mhdr.MSGLEN \ 2
                Remainder% = Mhdr.MSGLEN MOD 2
                Sems2% = Sems1% + Remainder%
                IF Exist%("SEMS.$$1") THEN KILL "SEMS.$$1"
                OPEN "SEMS.$$1" FOR BINARY AS #6
                a$ = INPUT$(Sems1%, #2)
                GOSUB CheckStrings
                PUT #6, 1, a$
                a$ = ""
                SEEK #2, MsgOffst& + (Sems1%)
                a$ = INPUT$(Sems2%, #2)
                GOSUB CheckStrings
                FOR S% = 1 TO Snoop%
                    Position% = 0
                    Orig% = QInstrB(-1, a$, "* Origin: ")
                    IF Orig% THEN
                        Position% = QInstrB(-1, MID$(a$, Orig%), Snoop$(S%))
                        IF Position% THEN
                            EXIT FOR
                        END IF
                    END IF
                NEXT
              
                PUT #6, , a$
                a$ = ""
              
                CLOSE 6
              
            ELSE
                LongMsg% = False
              
                a$ = INPUT$(Mhdr.MSGLEN, #2)
                GOSUB CheckStrings
                FOR S% = 1 TO Snoop%
                    Position% = 0
                    Orig% = QInstrB(-1, a$, "* Origin: ")
                    IF Orig% THEN
                        Position% = QInstrB(-1, MID$(a$, Orig%), Snoop$(S%))
                        IF Position% THEN
                            EXIT FOR
                        END IF
                    END IF
                NEXT
              
            END IF
          
            IF Snoop% = 0 THEN
                Position% = True
            END IF
          
            IF Position% THEN
                Position% = 0
              
                IF Exist%("SEMS.$$$") THEN KILL "SEMS.$$$"
                OPEN "SEMS.$$$" FOR BINARY AS #8
              
                IF LongMsg% THEN
                    GOSUB FormatLongText
                ELSE
                    GOSUB FormatText
                END IF
              
                TagNode$ = " " + EchoTag$ + " " + Snoop$(S%) + " "
                LSqMsgFm% = 6 + LEN(SqMsg.From)
                LSqMsgDt% = LEN(SqMsg.DateMsg)
                FoundMsgs% = FoundMsgs% + 1
                PRINT #3,
                PRINT #3, STRING$(79, 223)
                PRINT #3,
                PRINT #3, TagNode$;
                PRINT #3, STRING$(77 - LEN(TagNode$), 196); ""
                PRINT #3, " Written: "; SqMsg.DateMsg;
                PRINT #3, TAB(78); ""
                PRINT #3, " Arrived: ";
                IF ReceiveDays% THEN
                    PRINT #3, DtArrived$;
                END IF
                PRINT #3, TAB(78); ""
                PRINT #3, "    From: "; QPTrim$(SqMsg.From);
                PRINT #3, TAB(78); ""
                PRINT #3, "      To: "; QPTrim$(SqMsg.Dest);
                PRINT #3, TAB(78); ""
                PRINT #3, "    Subj: "; QPTrim$(SqMsg.Subj);
                PRINT #3, TAB(78); ""
                IF FlagMsg% THEN
                    FlagMsg% = False
                    PRINT #3, ""; STRING$(34, 196); "**LOOK**"; STRING$(34, 196); ""
                ELSE
                    PRINT #3, ""; STRING$(76, 196); ""
                END IF
              
                OPEN "SEMS.$$$" FOR INPUT AS #8
                DO UNTIL EOF(8)
                    LINE INPUT #8, text$
                    IF MID$(text$, 1, 1) = CHR$(1) THEN
                        MID$(text$, 1, 1) = "@"
                    END IF
                    IF LEFT$(text$, 3) = "---" THEN
                        MID$(text$, 1, 3) = "+++"
                    END IF
                    IF LEFT$(text$, 10) = " * Origin:" THEN
                        MID$(text$, 2, 1) = "+"
                    END IF
                    IF LEN(text$) > 80 THEN
                        CALL WordWrap(text$, 80, 1)
                    ELSE
                        PRINT #3, text$
                    END IF
                LOOP
                CLOSE 8
            END IF
        END IF
    NEXT
    MBase.HiMsg = 0
    CLOSE 1, 2
    RETURN
  
FormatLongText:
    OPEN "sems.$$1" FOR BINARY AS #6
    SEEK #6, 1
    a$ = INPUT$(Sems1%, #6)
    FOR a% = 1 TO LEN(a$)
        IF MID$(a$, a%, 1) = CHR$(1) AND MID$(a$, a% + 1, 3) <> "EOT" THEN
            P% = a%
        END IF
    NEXT
    IF P% THEN a$ = MID$(a$, P%)
    IF LEFT$(a$, 7) = CHR$(1) + "MSGID:" THEN
        P% = INSTR(9, a$, " ")
        IF P% THEN
            a$ = MID$(a$, P% + 10)
        END IF
    END IF
    IF LEFT$(a$, 7) = CHR$(1) + "REPLY:" THEN
        P% = INSTR(9, a$, " ")
        IF P% THEN
            a$ = MID$(a$, P% + 10)
        END IF
    END IF
    PUT #8, 1, a$
    a$ = ""
  
    SEEK #6, Sems1%
    a$ = INPUT$(Sems2%, #6)
    P% = INSTR(a$, "SEEN-BY: ")
    IF P% THEN a$ = LEFT$(a$, P% - 1)
  
    L% = LEN(SqMsg)
    a$ = MID$(a$, L%)
  
    IF Snoop% = 0 THEN
        P% = QInstrB(-1, a$, "(")
        IF P% THEN
            S% = 1
            Temp$ = MID$(a$, P%)
            P% = INSTR(Temp$, ")")
            IF P% THEN Snoop$(S%) = LEFT$(Temp$, P%)
        ELSE
            S% = 1
            Snoop$(S%) = "(Missing * Origin)"
        END IF
    END IF
    PUT #8, , a$
    a$ = ""
    CLOSE 8
    LongMsg% = False
    RETURN
  
FormatText:
    P% = INSTR(a$, "SEEN-BY: ")
    IF P% THEN a$ = LEFT$(a$, P% - 1)
    IF NOT LongMsg% THEN
        L% = LEN(SqMsg)
        a$ = MID$(a$, L%)
    END IF
    IF Snoop% = 0 THEN
        P% = QInstrB(-1, a$, "(")
        IF P% THEN
            S% = 1
            Temp$ = MID$(a$, P%)
            P% = INSTR(Temp$, ")")
            IF P% THEN Snoop$(S%) = LEFT$(Temp$, P%)
        ELSE
            S% = 1
            Snoop$(S%) = "(Missing * Origin)"
        END IF
    END IF
    P% = 0
    FOR a% = 1 TO LEN(a$)
        IF MID$(a$, a%, 1) = CHR$(1) AND MID$(a$, a% + 1, 3) <> "EOT" THEN
          'MID$(a$, a%, 1) = "*"
            P% = a%
        END IF
    NEXT
    IF P% THEN a$ = MID$(a$, P%)
    IF LEFT$(a$, 7) = CHR$(1) + "MSGID:" THEN
        P% = INSTR(9, a$, " ")
        IF P% THEN
            a$ = MID$(a$, P% + 10)
        END IF
    END IF
    IF LEFT$(a$, 7) = CHR$(1) + "REPLY:" THEN
        P% = INSTR(9, a$, " ")
        IF P% THEN
            a$ = MID$(a$, P% + 10)
        END IF
    END IF
    PUT #8, 1, a$
    a$ = ""
    CLOSE 8
    RETURN
  
CheckStrings:
    IF LookFor% THEN
        FOR LF% = 1 TO LookFor%
            P% = INSTR(UCASE$(a$), LookFor$(LF%))
            IF P% THEN
                FlagMsg% = True
                EXIT FOR
            END IF
        NEXT
    END IF
    RETURN

    FUNCTION CurrentDate$ STATIC
        Dt$ = DATE$
        Month$ = MonthName$(VAL(LEFT$(Dt$, 2)))
        CurrentDate$ = "  " + MID$(Dt$, 4, 2) + " " + Month$ + " "
    END FUNCTION

    SUB EndPgm
        SHARED Dt$
        PRINT Dt$; TIME$; " SEMS End "; Version
    END SUB

    SUB Help
        Temp1$ = "Squish EchoMail Snoop Program - " + Version
        Temp2$ = "Freeware"
        Temp3$ = "by R.J. (Bob) Ross"
        Temp4$ = "SysOp - RJ's Byteline BBS - FidoNet 1:134/75"
        CLS
        PRINT
        PRINT TAB(40 - LEN(Temp1$) \ 2); Temp1$
        PRINT TAB(40 - LEN(Temp2$) \ 2); Temp2$
        PRINT TAB(40 - LEN(Temp3$) \ 2); Temp3$
        PRINT TAB(40 - LEN(Temp4$) \ 2); Temp4$
        PRINT STRING$(79, 196)
        PRINT "Purpose:  To read selected Squish EchoMail areas and make a text output file"
        PRINT "          containing EchoMail messages based on selection criteria supplied"
        PRINT "          in a SEMS configuration file."
        PRINT STRING$(79, 196)
        PRINT "Switches:"
        PRINT "          -Cdrive:\path\Sems.cfg  [connfiguration file]"
        PRINT "          -A [optional - Appends output to an existing file]"
        PRINT
        PRINT
        PRINT
        PRINT
      
    END SUB

    FUNCTION MsgDate$ (DateMsgWritten&)
      ' Code thanks to Don Bly
      '
      '
        Da% = DateMsgWritten& AND &H1F&
        Mo% = (DateMsgWritten& AND &H1E0&) \ &H20
        Yr% = (DateMsgWritten& AND &HFE00&) \ &H200 + 1980
      
        Mo$ = LTRIM$(STR$(Mo%))
        IF Mo% < 10 THEN Mo$ = "0" + Mo$
        Da$ = LTRIM$(STR$(Da%))
        IF Da% < 10 THEN Da$ = "0" + Da$
        Yr$ = LTRIM$(STR$(Yr%))
        MsgDate$ = Mo$ + "/" + Da$ + "/" + Yr$
      
    END FUNCTION

    FUNCTION MsgTime$ (DateMsgWritten&)
      
      'Code thanks to Don Bly
      '
      'The time function does not work properly when it hits a negative
      'DateMsgWritten& number and I have no clue why.  However, SEMS does not
      'use the MsgTime.  I've left the code in in case someone wants to fiddle
      'with it
      '
        Hr% = (DateMsgWritten& AND &HF8000000) \ &H8000000
        Mi% = (DateMsgWritten& AND &H7E00000) \ &H200000
        Se% = (((DateMsgWritten& AND &H1F0000) \ &H10000) AND &H1F&) * 2
      
        Hr$ = LTRIM$(STR$(Hr%))
        IF Hr% < 10 THEN Hr$ = "0" + Hr$
        Mi$ = LTRIM$(STR$(Mi%))
        IF Mi% < 10 THEN Mi$ = "0" + Mi$
        Se$ = LTRIM$(STR$(Se%))
        IF Se% < 10 THEN Se$ = "0" + Se$
        MsgTime$ = Hr$ + ":" + Mi$ + ":" + Se$
      
    END FUNCTION

    SUB WordWrap (X$, Wide, LeftMargin) STATIC
      
        DO WHILE LEN(X$)        ' Loop while we have text
          ' find a place to break the line
            Pointer% = Wide + 1
            DO UNTIL MID$(X$, Pointer%, 1) = " " OR Pointer% = 1 OR Pointer% > LEN(X$)
                Pointer% = Pointer% - 1
            LOOP
          ' handle unbreakable text
            IF Pointer% = 1 THEN Pointer% = Wide + 1
            PRINT #3, TAB(LeftMargin%); LEFT$(X$, Pointer% - 1) ' dump the line
            X$ = MID$(X$, Pointer% + 1)
        LOOP
      
    END SUB

