#include "condir.h"

void back(char *);
void catads(char *);
void delback(char *);
char *itoa(int);
void rmdlgfile(char *, char *);

struct Library *DLGBase=NULL;


void main(int argc, char *argv[])
{
 int i=1;

 DLGBase = OpenLibrary(DLGNAME,0);
 if(!DLGBase) {
  printf("ERR:  Can't open dlg.library!\n\n");
  return;
 }
 for (i=1 ; i<argc; i++) {
   back(argv[i]);
   catads(argv[i]);
   delback(argv[i]);
 }
 if(DLGBase) CloseLibrary(DLGBase);
}

void delback(char *area)
{
 char oname[80];

 strcpy(oname, "FILE:");
 strcat(oname, area);
 strcat(oname, "/file.dat.bak");

 remove(oname);
}

void back(char *area)
{
 char oldname[80], newname[80];
 struct QuickFile qf;
 FILE *f1, *f2;

 strcpy(oldname, "FILE:");
 strcat(oldname, area);
 strcat(oldname, "/file.dat");

 strcpy(newname, oldname);
 strcat(newname, ".bak");

 if ((f1 = fopen(oldname, "rb"))==NULL) {
  printf("Can't open old file\n");
  return;
 }

 if ((f2 = fopen(newname, "wb"))==NULL) {
  printf("Can't open new file\n");
  return;
 }

 while(!feof(f1)) {
  fread(&qf, sizeof(struct QuickFile), 1, f1);
  if(!feof(f1))
   fwrite(&qf, sizeof(struct QuickFile), 1, f2);
 }

 fclose(f1);
 fclose(f2);
}

void catads(char *area)
{
 char oldname[40], newname[40], tempd[40], buffer[80];
 int number;
 char mff[40], maf[40], mdf[40];
 struct QuickFile *qf;
 FILE *f1, *f2, *f3;
 char ext[10];

 qf = (struct QuickFile *) malloc(sizeof(struct QuickFile));

 printf("Searching area %s\n", area);
 strcpy(oldname, "FILE:");
 strcat(oldname, area);
 strcpy(tempd, oldname);
 strcat(tempd, "/");
 strcat(oldname, "/file.dat");

 strcpy(newname, oldname);
 strcat(newname, ".bak");

 if ((f1 = fopen(newname, "rb"))==NULL) {
  printf("Can't open old file\n");
  return;
 }


 while(!feof(f1)) {
  fread(qf, sizeof(struct QuickFile), 1, f1);
  if(!feof(f1))
  {
    stcgfe(ext, qf->filename);
    if(stricmp(ext, "ads")==0) {
     printf("%s is a description file.  Aborting.\n", qf->filename);
    } else {
     number = qf->number;
     strcpy(mdf, tempd);
     strcat(mdf, itoa(number));
     strcat(mdf, ".fd");
     strcpy(mff, tempd);
     strcat(mff, qf->filename);
     strcpy(maf, mff);
     maf[strlen(maf)-3]='A';
     maf[strlen(maf)-2]='D';
     maf[strlen(maf)-1]='S';

     printf("File: %s -- ",mff);
     if ((f2 = fopen(maf, "r"))==NULL) {
      printf("ADS file not found\n");
     } else {
      if ((f3 = fopen(mdf, "a"))==NULL) {
       printf("Description file not found\n");
       fclose(f2);
       fclose(f3);
      } else {
       printf("ADS file found\n");
       fputs("\n\n", f3);
       while(!feof(f2)) {
        fgets(buffer, sizeof(buffer), f2);
        fputs(buffer, f3);
       }
       fclose(f2);
       fclose(f3);
       rmdlgfile(area, maf);

      }
     }
    }
  }
 }

 fclose(f1);
 free(qf);
}

void rmdlgfile(char *area, char *fname)
{
 char maf[40], mfdatf[40], tempd[40], comment[80];
 struct FileLock *lock;
 struct FileInfoBlock *fib_ptr;
 struct QuickFile qf;

 stcgfn(maf, fname);

 strcpy(qf.filename, maf);

 strcpy(mfdatf, "FILE:");
 strcat(mfdatf, area);
 strcpy(tempd, mfdatf);
 strcat(tempd, "/");
 strcat(mfdatf, "/file.dat");

 fib_ptr = (struct FileInfoBlock *)
  AllocMem( sizeof( struct FileInfoBlock ),
  MEMF_PUBLIC | MEMF_CLEAR );

 if( fib_ptr == NULL )
 {
  printf("Not enough memory!\n");
  return;
 }

 lock = (struct FileLock *) Lock( fname, SHARED_LOCK );

 if( lock == NULL )
 {
  printf("Could not lock the ads file!\n");
  FreeMem( fib_ptr, sizeof( struct FileInfoBlock ) );
  return;
 }

 if( Examine( lock, fib_ptr ) )
 {
  strcpy(comment, fib_ptr->fib_Comment);
 }

 UnLock(lock);
 FreeMem( fib_ptr, sizeof( struct FileInfoBlock ) );

 if(!remove(comment)) printf("Removed .fd file describing ads file\n");
 else printf("Couldn't remove .fd file describing ads file\n");

 if(!remove(fname)) printf("Removed ads file\n");
 else printf("Couldn't remove ads file\n");

 if(!DeleteStruct(mfdatf, &qf, sizeof(struct QuickFile), 36)) printf("Deleted file.dat entry\n");
 else printf("Could not delete file.dat entry.\n");

 return;
}



char *itoa(int zahl)
{
   static char res[10];
   char c, *dest = res;
   int maxpot = 1000000, flag = 0;

   while (maxpot >= 1)
   {
      c = zahl / maxpot + '0';
      if ((c != '0') || (maxpot == 1) || flag)
      {
         flag = 1;
         *dest++ = c;
      }
      zahl %= maxpot;
      maxpot /= 10;
   }
   *dest = '\0';
   return res;
}
