/****** Haiku.rexx *************************************************
*
*	$VER: Haiku 2.0 (6.5.95)  Generates pseudo-random Haiku poems
*
********************************************************************/

call InitVocab()
call random(,,time('s'))
say  GenHaiku()
exit 0

GenHaiku:
t = random(1,num_templates)
parse var tem.t line.1 '+' line.2 '+' line.3
out. = ''
do i = 1 to 3
	do while length(line.i)>0
		parse var line.i cmd 3 qual 4 line.i
		c = left(cmd,1)
		ucmd = upper(cmd)
		if v.ucmd ~= "" then
		do
			w = word(v.ucmd,random(1,words(v.ucmd)))
			if datatype(c,'u') then
			w = upper(left(w,1)) || substr(w,2)
			upper c
			if c = 'V' & qual = '@' then
			w = add_ing(w)
			else if c = 'N' & qual = 's' then
			w = pluralize(w)
			else
			line.i = qual || line.i
		end
		else if c = '/' then
		do
			parse value cmd || qual || line.i with '/' list '/' line.i
			w = word(list,random(1,words(list)))
		end
		else
		parse value cmd || qual || line.i with w 2 line.i
		out.i = out.i || w
	end
end
return translate(out.1 || '0a'x || out.2 || '0a'x || out.3 || '0a'x,' ','_')

add_ing: procedure
exc. = 0
exc.whisper = 1
exc.wander = 1
exc.flutter = 1
exc.wither = 1
exc.wonder = 1
exv = upper(arg(1))
parse value arg(1) with 100-3 l3+1 l2+1 l1
if index("mbgprndlt",l1) > 0 & index("aeiou",l2) > 0 & index("aeiou",l3) = 0 then
do
	if ~exc.exv then
	w = arg(1) || l1
	else
	w = arg(1)
end
else if l1 = 'e' then
w = left(arg(1),length(arg(1))-1)
else
w = arg(1)
return w || 'ing'

pluralize: procedure expose v.
exc. = 0
exc.rose = 1
exc.breeze = 1
exc.branch = 1
exc.beach = 1
exc.glance = 1
exc.thrush = 1
exc.child = 1
exc.fox = 1
exc.moss = 1
exc.sunrise = 2
exc.lotus = 2
exc.gecko = 10
exc.cry = 11
w = arg(1)
uw = upper(w)
do while exc.uw > 0 & exc.uw < 10
	list = value('v.n'exc.uw)
	w = word(list,random(1,words(list)))
	uw = upper(w)
end
if datatype(left(arg(1),1),'u') then
w = upper(left(w,1))substr(w,2)
select
	when exc.uw = 0 then w = w || 's'
	when exc.uw = 10 then w = w || 'es'
	when exc.uw = 11 then w = left(w,2) || 'es'
	otherwise
	call inform("Invalid pluralize exception" exc.uw)
	exit
end
return w

InitVocab:
v. = ""
v.a1 = "quick wild small hot white green blue pink thin old light dark"
v.a1 = v.a1 "sad deep lost free far slow sharp blunt hard soft damp dry"
v.a1 = v.a1 "bare tight loose low cold clean proud swift gnarled flat"
v.a1 = v.a1 "strong weak young dull ill"
v.a2 = "open lofty empty eager even weary leaden fallen dismal serene"
v.a2 = v.a2 "languid potent silver awkward shallow pliant simple wrinkled"
v.a2 = v.a2 "falling waiting sighing smiling dreaming sleeping dying"
v.a2 = v.a2 "almond jasmine mournful leaping supple"
v.n1 = "oak tree grove stream brook hill branch rose leaf breeze pool"
v.n1 = v.n1 "root thrush song moon cry glance flame child fox lamb shell"
v.n1 = v.n1 "moss cave cliff rock beach shore wave sea hand path bark fern"
v.n2 = "shadow forest clearing hunter sparrow mountain cavern shelter"
v.n2 = v.n2 "seagull lantern sunrise gecko welcome egret doorway water"
v.n2 = v.n2 "prison temple valley spirit soldier blossom lotus maple"
v.v1 = "walk write sing play look fail stray climb grow speak flow live"
v.v1 = v.v1 "soar crawl creep stand wake sink swim turn sit jump stink"
v.v1 = v.v1 "dive strive shine glow fade move crave spin hide writhe"
v.v2 = "wander desire return whisper decline accept withdraw contend"
v.v2 = v.v2 "rebel retire despair arise wither wonder bubble flutter grumble"
v.v2 = v.v2 "enchant descend ascend command"
v.p1 = "in near past through from"
v.p2 = "under over behind beyond above below around"
v.r1 = "where when while as"
v.l1 = "the this my your his her the the the"
v.h2 = "Gichin Koshi Raiko the_man a_maid Tanto the_queen Moki R.J. Gorby"
v.h2 = v.h2 "Sanka the_monk Glad_Child Yoko"
tem. = ""
tem.1 = "A1 n1, a2 n1.+L1 a1, a2 n2 v1s.+A1 n1, a1 n2."
tem.2 = "P2 the a1 n1,+R1 the a2 n2 v1s,+I v1; the n1 v1s."
tem.3 = "The a1 n1 v1@;+It is the a2 n2.+V2@, I v1."
tem.4 = "The a2 n1 v1s+R1 a2 n2s v2.+Does the a1 n1 v1?"
tem.5 = "Not a1, not a2,+H2 comes to the n2.+L1 a1 n2 v1s."
tem.6 = "A1, a2, a2,+H2 v1s. H2 v2s,+V2@, v1@."
tem.7 = "/Never Always/ a1, but a1,+H2 knows /no all/ a1 n2s.+/Angry Gladdened/, /he she/ v1s."
do i = 1 while tem.i ~= ""
end
num_templates = i-1
return

/*
**	EOF
*/
