' $linesize:132
' $title: 'RBBSSUB7.BAS 17.5, Copyright 1986 - 94 by D. Thomas Mack'
'  Copyright 1991 by D. Thomas Mack, all rights reserved.
'  Name ...............: RBBSSUB7.BAS
'  First Released .....: November 15, 1993
'  Subsequent Releases.:
'  Copyright ..........: 1986 - 1994
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'     RBBS-PC.BAS utilizes a lot of common subroutines.  Those that do not
'     require error trapping are incorporated within RBBSSUB 2-7 as
'     separately callable subroutines in order to free up as much
'     code as possible within the 64K code segment used by RBBS-PC.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine          Line     Function of Subroutine
'   Name              Number
' ----------          ------   ----------------------
'  AddLink            63620    Adds a conference link
'  ANSIChat            1000    Vertical Split Screen SysOp ANSI Chat Routine
'  AraAllCaps         63720    Capitalize an elment of an array
'  AskItems           63605    Get an list of items
'  AutoLogOff         63720    Log off after transfer
'  BadName            20235    Check for system crash attempt with bad file name
'  BufAsUnit          63440    Buffer out a string with CR's
'  ChangeInt          63590    Get an integer value
'  ChkAddedTime       63570    Check Proposed Change to Time Remaining
'  CheckRatio         20096    Test upload/download ratio
'  ChkIfMsgHeader     63550    Checks whether record is a msg header
'  ChkMsgName         63540    Match Name to one in message file
'  ClearScrn           7000    Clears screen using ANSI
'  ClearLocalLower     7400    Clears SysOp side lower half of split screen chat
'  ClearLocalUpper     7200    Clears SysOp side upper half of split screen chat
'  ClearRemoteLower    7300    Clears user side lower half of split screen chat
'  ClearRemoteUpper    7100    Clears user side upper half of split screen chat
'  CmdStackPushPop    63500    Save/Restore command stack
'  CurLocate           7500    Moves cursor using ANSI codes
'  Decorate            2000    Sets up screen for SysOp Split Screen Chat
'  DeLink             63620    Removes conference from linked ones
'  DispUserRec        63580    Displays user record
'  DoorExit           10983    Set up a .BAT file to exit RBBS-PC to a "door"
'  DoorInfo           10991    Writes out information for a door
'  DosExit            10935    Set up a .BAT file to exit to DOS (second level)
'  ExcludeCount       63715    Counts # of words in a string
'  FDMACEXE           63462    Unconditionally executes a macro
'  FileNameCheck      20240    Matches file name to a prefix & extension
'  FileNumbers        59000    Add File Numbers to FMS and .DIR Listings
'  FileNumberWrap     59100    Line wrapping routine for file numbers
'  FindIt             63490    Check whether file exists and if so open as #2
'  FormatDisplay      63600    This will display the file, size, approx time, total approx time
'  FormRead           63420    Read from file into a form
'  GetArc             20140    Handle request for verbose listing
'  GetFastFile        63750    Sets the Fast File Tabs List
'  LocalScreenWrite    4000    Writes to SysOp side of split screen chat
'  LockAppend         63400    Prepare for a file append
'  LogError           13660    Log error message to CALLERS file
'  MacroExe           63460    Execute internal macro rather than user
'  MarkedFileHeader   63600    This formats the file display header.
'  MarkItems          63600    Convert list of items into a "mark"
'  MsgNameMatch       63540    Match name to one in msg header
'  NextConf           63615    Sets up join to next conference link
'  NoPath             63480    Detects whether string has a path in it
'  PauseExit          63465    Forces a keyboard pause inside a Macro
'  PersonalRing       20350    Detects "Distinctive Ring" patterns from Phone Co.
'  QuickPeek          20340    Easy find user to send message to
'  RBBSExit           10992    RBBS-PC exit to transfer control to other programs
'  ReadParms          63490    Read certain number of parameters from file 2
'  RecoverMsg         10410    Recover a deleted message
'  RegToCurrent       63585    Sets registration date to current date
'  RemoteScreenWrite   3000    Writes to user side of split screen chat
'  ReportEcho         63635    Reports echo preference of caller
'  ReportMarked       63600    Show formatted display of marked files
'  ResetRegDate       63585    Checks proposed new registration date
'  SayWelcome         63640    Welcomes callers on logon
'  SelectCD           63800    Select Which CD to display
'  SetBPS             20245    Set BPS rates
'  SetGlobalUpDn      63675    Sets Global user stats
'  SetPrivileges      63650    Sets user privileges based on PASSWRDS
'  SetPrompt          63470    Set prompts based on the user's security
'  SetRegDisplay      63585    Sets display of registration date
'  SetSection         12000    Set the proper section prompts (main, file, util, libr)
'  SetSessionTime     63645    Sets the session time
'  SetSysOp           63625    Determines whether remote or global SysOp
'  SetUserFlag        63560    Sets specified user flag
'  SetUserPref        63630    Sets user preferences based on user record
'  SetUserUpDn        63675    Sets user's upload/download/bank time stats
'  SrchPasswrds       63652    Searches the PASSWRDS file
'  SysOpVChat          5000    Split Screen Chat
'  TakeOffHook        63530    Take modem off hook
'  TestANSI           63700    Tests caller for ANSI compatibility
'  TimeBack           63495    Give time back to user
'  UnLockAppend       63410    Clean up after file append
'  UnMarkItems        63610    Convert marked items into an input list
'  UntilRight         12878    Ask a question until user says answer is right
'  UpdateU            10600    Updates the user record on loging off/exiting RBBS-PC
'  VerifyAns          63510    Verify that string passes edits
'  WordInFile         10976    Find a whole word within a file/menu
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
' $SUBTITLE: 'ANSIChat - Vertical Split Screen SysOp ANSI Chat Routine'
'
' $PAGE
'
' ANSIChat Vertical Split Screen Chat for RBBS-PC '
'
'          (c) 1991,1992,1993 By Richie Molinelli
'
'  SUBROUTINE NAME    -  ANSIChat
'
'             INPUT   -  None
'
'             OUTPUT  -  None
'
'  PURPOSE -- Allows Vertical Split Screen ANSI SysOp Chat for RBBS
'
'
1000 SUB ANSIChat                      ' Main program
     CALL ClearScrn
     CALL Decorate
     CALL SysopVChat
     IF ZSubParm < 0 THEN _
        EXIT SUB
     CALL ClearScrn
     CALL SkipLine (1)
     END SUB
'
2000 SUB Decorate                      ' Sets up the screen for chat
     ScreenTxt$ = STRING$(78,177)
     CALL CurLocate (1,1)
     CALL QuickTPut (ZFG6$ + ScreenTxt$,0)
     CALL CurLocate (24,1)
     CALL QuickTput (ScreenTxt$,0)
     CALL CurLocate (1,1)
     CALL QuickTPut (ZFG8$ + "ANSIChat v1.5",0)
     OutTxt$ =  " >>> " +  ZRBBSName$ + " <<< "
     LocalColumn = 40 - (LEN(OutTxt$)/2)
     CALL CurLocate (1,LocalColumn)
     CALL QuickTPut (OutTxt$,0)
     CALL CurLocate (1,60)
     CALL QuickTPut ("(c) 1992 R Molinelli",0)
     Column = 40
     CALL QuickTPut (ZFGB$,0)
     FOR Row = 2 TO 23
        CALL CurLocate (Row,Column) : _
        CALL QuickTPut(STRING$(1,186),0) : _
     NEXT Row
     OutTxt$ = ZSysopFirstName$ + " " + ZSysopLastName$
     LocalColumn = (40 - LEN(OutTxt$))/2
     CALL CurLocate (24,LocalColumn)
     CALL QuickTPut (ZEmphasizeOn$ + OutTxt$,0)
     LocalColumn = 40 + ((40 - LEN(ZActiveUserName$))/2)
     CALL CurLocate (24,LocalColumn)
     CALL QuickTPut (ZActiveUserName$ + ZEmphasizeOff$,0)
     CALL Line25
     CALL CurLocate (2,1)
     END SUB
'
3000 SUB RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,Bs) STATIC  ' Writes Remote Users Input
     BackSpace = ZFalse
     IF HoldRTxt$ <> "" AND Bs = 1 THEN _
        HoldRTxt$ = MID$(HoldRTxt$,1,LEN(HoldRTxt$) - 1)
     IF Bs = 1 THEN _
        RemoteColumn = RemoteColumn - 1 : _
        RemoteTxt$ = " " : _
        BackSpace = ZTrue : _
        GOSUB 3010 : _
        Bs = 0 : _
        GOTO 3020
     IF LEN(HoldRTxt$) => 38 THEN
        HoldRTxt$ = ""
        RemoteColumn = 42
        RemoteRow = RemoteRow + 1
        IF RemoteRow > 23 THEN _
           CALL ClearRemoteUpper : _
           RemoteRow = 2
        CALL CurLocate (RemoteRow,RemoteColumn)
     END IF
     IF RemoteTxt$ <> " " THEN _
        HoldRTxt$ = HoldRTxt$ + RemoteTxt$ _
     ELSE _
        HoldRTxt$ = ""
     IF RemoteColumn > 78 AND RemoteTxt$ = " " THEN
        RemoteColumn = 42
        RemoteRow = RemoteRow + 1
        IF RemoteRow = 12 THEN _
           CALL ClearRemoteLower
        IF RemoteRow > 23 THEN _
           CALL ClearRemoteUpper : _
           RemoteRow = 2
        CALL CurLocate (RemoteRow,RemoteColumn)
        RemoteTxt$ = ""
        HoldRTxt$ = ""
        EXIT SUB
     END IF
     IF RemoteColumn > 79 AND RemoteTxt$ <> " " THEN
        RemoteColumn = 80 - LEN(HoldRTxt$)
        HoldCTxt$ = STRING$((LEN(HoldRTxt$) + 1),32)
        CALL CurLocate (RemoteRow,RemoteColumn)
        CALL QuickTPut (HoldCTxt$,0)
        RemoteColumn = 42
        RemoteRow = RemoteRow + 1
        IF RemoteRow = 12 THEN _
           CALL ClearRemoteLower
        IF RemoteRow > 23 THEN _
           CALL ClearRemoteUpper : _
           RemoteRow = 2
        CALL CurLocate (RemoteRow,RemoteColumn)
        CALL QuickTPut (ZFGE$ + HoldRTxt$,0)
        RemoteColumn = RemoteColumn + LEN(HoldRTxt$)
        CALL CurLocate (RemoteRow,RemoteColumn)
        ZRemoteTxt$ = ""
        EXIT SUB
     END IF
3010 CALL CurLocate (RemoteRow,RemoteColumn)
     IF BackSpace THEN _
        CALL QuickTPut (RemoteTxt$,0) _
     ELSE _
        CALL QuickTPut (ZFGE$ + RemoteTxt$,0)
     IF Bs > 0 THEN _
        CALL CurLocate (RemoteRow,RemoteColumn) : _
        RETURN
     RemoteColumn = RemoteColumn + LEN(RemoteTxt$)
3020 RemoteTxt$ = ""
     END SUB
'
4000 SUB LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,Bs) STATIC      ' Writes Local Users Input
     BackSpace = ZFalse
     IF HoldLTxt$ <> "" AND Bs = 1 THEN _
        HoldLTxt$ = MID$(HoldLTxt$,1,LEN(HoldLTxt$) - 1)
     IF Bs = 1 THEN _
        LocalColumn = LocalColumn - 1 : _
        BackSpace = ZTrue : _
        LocalTxt$ = " " : _
        GOSUB 4010 : _
        Bs = 0 : _
        GOTO 4020
     IF LEN(HoldLTxt$) => 38 THEN
        HoldLTxt$ = ""
        LocalColumn = 1
        LocalRow = LocalRow + 1
        IF LocalRow > 23 THEN _
           CALL ClearLocalUpper : _
           LocalRow = 2
        CALL CurLocate (LocalRow,LocalColumn)
     END IF
     IF LocalTxt$ <> " " THEN _
        HoldLTxt$ = HoldLTxt$ + LocalTxt$ _
     ELSE _
        HoldLTxt$ = ""
     IF LocalColumn > 37 AND LocalTxt$ = " " THEN
        LocalColumn = 1
        LocalRow = LocalRow + 1
        IF LocalRow = 12 THEN _
           CALL ClearLocalLower
        IF LocalRow > 23 THEN _
           CALL ClearLocalUpper : _
           LocalRow = 2
        CALL CurLocate (LocalRow,LocalColumn)
        LocalTxt$ = ""
        HoldLTxt$ = ""
        EXIT SUB
     END IF
     IF LocalColumn > 38 AND LocalTxt$ <> " " THEN
        LocalColumn = 39 - LEN(HoldLTxt$)
        HoldCTxt$ = STRING$((LEN(HoldLTxt$) + 1),32)
        CALL CurLocate (LocalRow,LocalColumn)
        CALL QuickTPut (HoldCTxt$,0)
        LocalColumn = 1
        LocalRow = LocalRow + 1
        IF LocalRow = 12 THEN _
           CALL ClearLocalLower
        IF LocalRow > 23 THEN
           CALL ClearLocalUpper : _
           LocalRow = 2
        END IF
        CALL CurLocate (LocalRow,LocalColumn)
        CALL QuickTPut (ZFGB$ + HoldLTxt$,0)
        LocalColumn = LocalColumn + LEN(HoldLTxt$)
        CALL CurLocate (LocalRow,LocalColumn)
        LocalTxt$ = ""
        EXIT SUB
     END IF
4010 CALL CurLocate (LocalRow,LocalColumn)
     IF BackSpace THEN _
        CALL QuickTPut (LocalTxt$,0) _
     ELSE _
        CALL QuickTPut (ZFGB$ + LocalTxt$,0)
     IF Bs > 0 THEN _
        CALL CurLocate (LocalRow,LocalColumn) : _
        RETURN
     LocalColumn = LocalColumn + LEN(LocalTxt$)
4020 LocalTxt$ = ""
     END SUB
'
     SUB SysopVChat                      ' Verticl SysOp ANSI Chat routine
5000 LocalColumn = 1
     LocalRow = 2
     RemoteColumn = 42
     RemoteRow = 2
     LocalTxt$ = "Hi, " + ZFirstName$ + ".  Go Ahead..."
     CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,0)
     LocalColumn = 1
     LocalRow = 4
     HoldLTxt$ = ""
     HoldRTxt$ = ""
     HoldCTxt$ = ""
     CALL CurLocate (RemoteRow,RemoteColumn)
     ZWaitExpired = ZFalse
5010 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL Carrier
     IF ZSubParm < 0 THEN _
        EXIT SUB
     CALL GoIdle
5020 CALL FindFKey
     IF ZSubParm < 0 THEN _
        EXIT SUB
     IF ZWasCM = 0 THEN _
        CALL FlushCom (ZCommPortStack$) : _
        ZKeyPressed$ = "" : _
        ZWasCM = ZTrue : _
        GOTO 5010
     LocalTxt$ = ZKeyPressed$
     IF ZKeyPressed$ = ZEscape$ THEN _
        EXIT SUB
     IF LocalTxt$ = "" THEN _
        GOTO 5030
     IF LocalTxt$ = CHR$(8) THEN _
        GOTO 5070 _
     ELSE IF LocalTxt$ = CHR$(9) THEN _
        GOTO 5090 _
     ELSE IF LocalTxt$ = CHR$(13) THEN _
        GOTO 6010
     CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,0)
     GOTO 5010
5030 IF ZLocalUser THEN _
        GOTO 5010
     IF ZCommPortStack$ <> "" THEN _
        RemoteTxt$ = LEFT$(ZCommPortStack$,LEN(ZCommPortStack$) - 1) : _
        CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     CALL EofComm (Char)
     IF Char <> -1 THEN _
        GOTO 5050 _
     ELSE _
        GOTO 5010
5050 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL GetCom (RemoteTxt$)
     IF RemoteTxt$ = CHR$(8) THEN _
        GOTO 6030 _
     ELSE IF RemoteTxt$ = CHR$(9) THEN _
        GOTO 6050 _
     ELSE IF RemoteTxt$ = CHR$(13) THEN _
        GOTO 6070
     CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     GOTO 5010
5070 IF LocalColumn - 1 > 0 THEN _     ' Local Back Space
        CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,1)
     GOTO 5010
5090 IF LocalColumn + 5 > 38 AND LocalRow < 24 THEN _ 'Local TAB
        LocalColumn = 38 _
     ELSE _
        LocalColumn = LocalColumn + 4
     LocalTxt$ = " "
     CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,0)
     GOTO 5010
6010 LocalColumn = 38                  ' Local Carriage Return
     LocalTxt$ = " "
     CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,0)
     GOTO 5010
6030 IF RemoteColumn - 1 > 41 THEN _   ' Remote Back Space
        CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,1)
     GOTO 5010
6050 IF RemoteColumn + 5 > 79 AND RemoteRow < 24 THEN _  ' Remote TAB
        RemoteColumn = 79 _
     ELSE _
        RemoteColumn = RemoteColumn + 4
     RemoteTxt$ = " "
     CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     GOTO 5010
6070 RemoteColumn = 79                 ' Remote Carriage Return
     RemoteTxt$ = " "
     CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     GOTO 5010
     END SUB
'
7000 SUB ClearScrn                     ' Clears the Entire screen
     CALL QuickTPut ("[2J[0m",0)
     ZSubParm = 2
     CALL Line25
     ZSubParm = 0
     CALL CurLocate (1,1)
     END SUB
'
7100 SUB ClearRemoteUpper              ' Clears the Upper half of Remote users screen
     Column = 42
     FOR Row = 2 TO 13
         CALL CurLocate (Row,Column)
         CALL QuickTPut ("[K",0)
     NEXT Row
     END SUB
'
7200 SUB ClearLocalUpper               ' Clears the Upper half of Local users screen
     Column = 1
     FOR Row = 2 TO 13
        CALL CurLocate (Row,Column)
        CALL QuickTPut (STRING$(38,32),0)
     NEXT Row
     END SUB
'
7300 SUB ClearRemoteLower              ' Clears the lower half of Remote users Screen
     Column = 42
     FOR Row = 14 TO 23
        CALL CurLocate (Row,Column)
        CALL QuickTPut ("[K",0)
     NEXT Row
     END SUB
'
7400 SUB ClearLocalLower                ' Clears the lower half of Local users screen
     Column = 1
     FOR Row = 14 TO 23
        CALL CurLocate (Row,Column)
        CALL QuickTPut (STRING$(38,32),0)
     NEXT Row
     END SUB
'
7500 SUB CurLocate (Row,Column)          ' Moves the cursor to desired position
     CALL QuickTPut ("[" + MID$(STR$(Row),2) + ";" + MID$(STR$(Column),2) + "H",0)
     END SUB
'
10410 ' $SUBTITLE: 'RecoverMsg - sub to recover deleted messages'
' $PAGE
'
'  NAME    -- RecoverMsg
'
'  INPUTS  --     PARAMETER                    MEANING
'                 MsgToRecover           MESSAGE NUMBER TO RECOVER
'                 ZFirstMsgRecord        RECORD # FOR FIRST MSG
'
'  OUTPUTS --     ActionFlag              SET TO 0 IF ERROR
'                                         SET TO -1 IF NO ERROR
'
'  PURPOSE --  To recover deleted messages.  Note that this is only
'              possible if you have not compressed your message file
'              using config.
'
      SUB RecoverMsg (MsgToRecover,ActionFlag) STATIC
      FIELD #1,128 AS ZMsgRec$
      MsgRec = ZFirstMsgRecord
10420 GET 1,MsgRec
      NumRecsInMsg = VAL(MID$(ZMsgRec$,117,4))
      IF NumRecsInMsg < 1 OR MsgRec => ZNextMsgRec THEN _
         ZWasY$ = "No Msg #" + _
              STR$(MsgToRecover) : _
         GOTO 10485
10440 IF VAL(MID$(ZMsgRec$,2,4)) <> MsgToRecover THEN _
         MsgRec = MsgRec + NumRecsInMsg : _
         GOTO 10420
10450 IF INSTR(ZMsgRec$,ZDeletedMsg$) <> 0 THEN _
         LSET ZMsgRec$ = LEFT$(ZMsgRec$,115) + _
                                ZActiveMessage$ + _
                                MID$(ZMsgRec$,117) : _
         PUT 1,LOC(1) : _
         ZWasY$ = "Restored Msg #" + _
              STR$(MsgToRecover) : _
         ActionFlag = ZTrue : _
         GOTO 10485
10480 ZWasY$ = "Msg #" + _
           STR$(MsgToRecover) + _
           " not Dead"
10485 CALL QuickTPut1 (ZWasY$)
      END SUB
'
10600 ' $SUBTITLE: 'UpdateU -- Update the users record at logoff'
' $PAGE
'  NAME    -- UpdateU
'
'  INPUTS  -- PARAMETER             MEANING
'             ZAdjustedSecurity
'             ZCurDate$
'             ZDnlds
'             ZElapsedTime
'             ZListDir
'             ZMainUserFileIndex
'             ZSecsPerSession!
'             ZUplds
'             ZUserSecLevel
'
'  OUTPUTS -- ZElapsedTime$
'             ZListNewDate$
'             ZSecLevel$
'             ZUserDnlds$
'             ZUserUplds$
'
'  PURPOSE -- Update the user record for the user when the user
'             exits RBBS-PC.
'
      SUB UpdateU (LoggingOff)
      IF ZActiveUserName$ = "" OR ZFirstName$ = "" THEN _
         EXIT SUB
      IF ZUserFileIndex < 1 THEN _
         GOTO 10607
      UpdateDefaults = ZTrue
10602 ZSubParm = 6
      ZWasY$ = ZLastDateTimeOn$
      CALL FileLock
      CALL OpenUser (ZHighestUserRecord)
      FIELD 5,31 AS ZUserName$, _
              15 AS ZPswd$, _
               2 AS ZSecLevel$, _
              14 AS ZUserOption$,  _
              24 AS ZCityState$, _
               1 AS MachineType$, _
               1 AS ZDropTimes$, _
               1 AS ZBankTime$,_
               4 AS ZTodayDl$, _
               4 AS ZTodayBytes$, _
               4 AS ZDlBytes$, _
               4 AS ZULBytes$, _
              14 AS ZLastDateTimeOn$, _
               3 AS ZListNewDate$, _
               2 AS ZUserDnlds$, _
               2 AS ZUserUplds$, _
               2 AS ZElapsedTime$
10604 GET 5,ZUserFileIndex
      IF ZActiveUserFile$ = ZOrigUserFile$ THEN _
         ZUplds = ZGlobalUplds : _
         ZDnlds = ZGlobalDnlds : _
         ZDLToday! = ZGlobalDLToday! : _
         ZBytesToday! = ZGlobalBytesToday! : _
         ZDLBytes! = ZGlobalDLBytes! : _
         ZULBytes! = ZGlobalULBytes! : _
         ZDropTimes = ZGlobalDropTimes : _
         ZBankTime = ZGlobalBankTime _
      ELSE ZBankTime = 0
      LSET ZBankTime$ = CHR$(ZBankTime)
      LSET ZDropTimes$ = CHR$(ZDropTimes)
      LSET ZLastDateTimeOn$ = ZWasY$
      LSET ZCityState$ = ZWasCI$
      IF UpdateDefaults THEN _
         CALL DefaultU
      IF ZListDir THEN _
         LSET ZListNewDate$ = CHR$(VAL(MID$(ZCurDate$,7,2))) + _
                              CHR$(VAL(MID$(ZCurDate$,1,2))) + _
                              CHR$(VAL(MID$(ZCurDate$,4,2)))
10605 LSET ZUserDnlds$ = MKI$(ZDnlds)
      LSET ZUserUplds$ = MKI$(ZUplds)
      IF ZEnforceRatios THEN _
         LSET ZTodayDl$ = MKS$(ZDLToday!) : _
         LSET ZTodayBytes$ = MKS$(ZBytesToday!) : _
         LSET ZDlBytes$ = MKS$(ZDLBytes!) : _
         LSET ZULBytes$ = MKS$(ZULBytes!)
      CALL CheckTime (ZUserLogonTime!, ZSecsUsedSession!, 2)
      IF (NOT ZExitToDoors) AND LoggingOff THEN _
         TempElapsed! = ZElapsedTime + _
                       (ZSecsUsedSession! - ZTimeCredits!) / 60 : _
         ZTimeCredits! = 0 _
      ELSE TempElapsed! = ZElapsedTime - ZExitToDoors*ZMinsInDoors
      IF TempElapsed! < -32767 THEN _
         TempElapsed! = -32767 _
      ELSE IF TempElapsed! > 32767 THEN _
         TempElapsed! = 32767
      LSET ZElapsedTime$ = MKI$(TempElapsed!)
      IF ZAdjustedSecurity THEN _
         LSET ZSecLevel$ = MKI$(ZUserSecLevel)
      PUT 5,ZUserFileIndex
      ZSubParm = 8
      CALL FileLock
      IF ZActiveUserFile$ <> ZOrigUserFile$ AND LoggingOff THEN _
         ZActiveUserFile$ = ZOrigUserFile$ : _
         ZUserFileIndex = ZOrigUserFileIndex : _
         UpdateDefaults = ZFalse : _
         ZAdjustedSecurity = ZFalse : _
         LSET ZLastDateTimeOn$ = ZOrigDateTimeOn$ : _
         GOTO 10602
10607 IF ZExitToDoors OR NOT LoggingOff THEN _
         EXIT SUB
      Temp = ZMinsPerSession
      IF ZMaxPerDay > 0 THEN _
         Temp = ZMaxPerDay - TempElapsed! : _
         IF Temp > ZMinsPerSession THEN _
            Temp = ZMinsPerSession
      Temp = -(Temp > 0) * Temp
      CALL QuickTPut1 (ZFGE$ + "You have " + ZFGF$ + LTRIM$(STR$(Temp)) + ZFGE$ + _
               " minutes left for next call today" + ZEmphasizeOff$)
      IF ZTimeBankInActive <> 1 AND ZMaxBank > 0 THEN _
         CALL QuickTPut1 (ZFGE$ + "and " + ZFGF$ + LTRIM$(STR$(ZGlobalBankTime)) + _
                       ZFGE$ + " Minutes Banked Time." + ZEmphasizeOff$)
      CALL SkipLine (1)
      CALL QuickTPut1 (ZFGF$ + ZFirstName$ + ZFGB$ + ", Thanks for calling " + ZFGF$ + ZRBBSName$ + _
                       ZFGB$ + " and please call again!" + ZColorReset$)
      IF NOT ZHiLiteOff THEN _
         CALL QuickTPut1 (ZColorReset$)
      CALL DelayTime (8 + ZBPS)
      IF ZOrigUserName$ = ZSecretName$ THEN
         ZMenuNewDate$ = LEFT$(DATE$,6) + RIGHT$(DATE$,2)
         ZMenuNewTime$ = LEFT$(TIME$,5)
         ZMenuNewUpld = 0
         ZMenuNewUsers = 0
         ZMenuNewCalls = 0
         ZMenuNewSysop = 0
         ZOutTxt$ = ""
      END IF
      CALL OpenOutW (ZMNewDef$)
      CALL PrintWork (2,ZMenuNewDate$,ZFalse)
      CALL PrintWork (2,ZMenuNewTime$,ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewUpld),ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewUsers),ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewCalls),ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewSysop),ZFalse)
      CLOSE 2
      END SUB
'
10935 ' $SUBTITLE: 'DosExit -- Setup to exit to DOS for Sysop'
' $PAGE
'  NAME    -- DosExit
'
'  INPUTS  -- PARAMETER             MEANING
'             ZComPort$
'             ZDoorsTermType
'             ZMultiLinkPresent
'             ZRBBSBat$
'             ZRedirectIOMethod
'             ZUseDeviceDriver$
'
'  OUTPUTS -- ZWasQ                    NUMBER OF LINES TO WRITE OUT TO
'                                      ZRCTTYBat$
'             ZUserIn$()               LINES TO WRITE OUT TO ZRCTTYBat$
'
'  PURPOSE -- Set up ZUserIn$() and ZWasQ in order to call "RBBSExit" and
'             exit to DOS for the remote RBBS-PC sysop
'
      SUB DosExit
      ZOutTxt$(1) = "ECHO OFF"
      IF ZUseDeviceDriver$ <> "" THEN _
         Port$ = ZUseDeviceDriver$ _
      ELSE Port$ = "COM" + RIGHT$(ZComPort$,1)
      IF ZRedirectIOMethod THEN _
         ZFF = 5 : _
         ZOutTxt$(2) = "CTTY " + _
                 Port$ : _
         ZOutTxt$(3) = ZDiskForDos$ + _
                 "COMMAND" : _
         ZOutTxt$(4) = "CTTY CON" : _
         ZOutTxt$(5) = ZRBBSBat$ _
      ELSE ZFF = 3 : _
           ZOutTxt$(2) = ZDiskForDos$ + _
                   "COMMAND >" + _
                   Port$ + _
                   " <" + _
                   Port$ : _
           ZOutTxt$(3) = ZRBBSBat$
10950 CALL AMorPM
      CALL UpdtCalr ("Exited to DOS at " + ZTime$,2)
      CALL QuickTPut1 ("RBBS-PC " + ZVersionID$)
      CALL QuickTPut1 ("SysOp in Remote Console mode")
      CALL RBBSExit (ZOutTxt$(),ZFF)
      END SUB
'
10976 ' $SUBTITLE: 'WordInFile -- Searches a file to find a word'
' $PAGE
'  NAME    -- WordInFile
'
'  INPUTS  -- PARAMETER             MEANING
'             FilName$              FILE TO SEARCH IN
'             Strng$                STRING TO SEARCH FOR
'
'  OUTPUTS -- InFile                WHETHER STRING FOUND IN FILE
'
'  PURPOSE -- Searches for "Strng$" in file "FILNAME$."   Used to limit
'               doors and questionnaires to those specified in their menu
'               files. The "Strng$" is capitalized but not the lines in the
'               file, so must be exact case-sensitive match to be found.
'               The only character that can immediately proceed or end a
'               name to be found must be a blank.
'
      SUB WordInFile (FilName$,Strng$,InFile) STATIC
      InFile = ZFalse
      CALL FindIt (FilName$)
      IF NOT ZOK THEN _
         EXIT SUB
      WasX = 0
      CALL AllCaps (Strng$)
      WHILE NOT EOF(2) AND WasX < 1
         LINE INPUT #2,ZOutTxt$
         WasY = 1
10978    WasX = INSTR(WasY,ZOutTxt$,Strng$)
         IF WasX < 1 THEN _
            GOTO 10980
         WasY = WasX + 1
         IF WasX > 1 THEN _
            IF MID$(ZOutTxt$,WasX - 1,1) <> " " THEN _
               WasX = 0
         IF WasX > 0 THEN _
            WasL = LEN(Strng$) : _
            IF LEN(ZOutTxt$) => (WasX + WasL) THEN _
               IF MID$(ZOutTxt$,WasX + WasL,1) <> " " THEN _
                  WasX = 0
         IF WasX = 0 THEN _
            GOTO 10978
10980 WEND
      CLOSE 2
      InFile = (WasX > 0)
      END SUB
'
10983 ' $SUBTITLE: 'DoorExit -- Setup to exit to a "door"'
' $PAGE
'  NAME    -- DoorExit
'
'  INPUTS  -- PARAMETER                MEANING
'
'             ZNodeID$                 NODE ID
'             ZRBBSBat$                BATCH FILE THAT RELOADS RBBS
'                                        AS DEFINED IN CONFIG
'             ZWasZ$                   USER INPUT FOR DOOR TO RUN
'
'  OUTPUTS -- ZWasQ                    NUMBER OF LINES TO WRITE OUT TO
'                                        ZRCTTYBat$
'             ZUserIn$()               LINES TO WRITE OUT TO ZRCTTYBat$
'
'  PURPOSE -- Set up ZUserIn$() and ZWasQ in order to call "EXITRBBS" and
'             exit RBBS-PC to invoke another program
'
      SUB DoorExit (ReqDoorsDef)
      IF ZWasZ$ = "" OR _
         ZWasZ$ = "NONE" THEN _
         EXIT SUB
      IF ZWasZ$ = ZRegProgram$ THEN                                  ' 175-1219
         CALL FindIt (ZWasZ$)                                        ' 175-1219
         IF NOT ZOK THEN _                                           ' 175-1219
            GOTO 10986                                               ' 175-1219
      END IF                                                         ' 175-1219
      CALL BreakFileName (ZWasZ$,WasX$,ExitTo$,ExitMethod$,ZFalse)
      ExitMethod$ = ""
      ZDooredTo$ = ExitTo$
      CALL FindIt (ZDoorsDef$)
      IF NOT ZOK THEN _
         IF ReqDoorsDef THEN _
            EXIT SUB _
         ELSE ExitTo$ = ExitTo$ + " " + ZNodeID$ : _
              GOTO 10989
10985 CALL ReadParms (ZOutTxt$(),13,1)                               ' 175-1223
      IF ZErrCode > 0 THEN _
         IF ReqDoorsDef THEN _
            EXIT SUB _
         ELSE ExitTo$ = ExitTo$ + " " + ZNodeID$ : _
              GOTO 10989
      IF ExitTo$ <> ZOutTxt$(1) THEN _
         GOTO 10985

      CheckCurDir$ = ZOutTxt$(13)                                    ' 175-1223
      IF (CheckCurDir$ <> "N") THEN                                  ' 175-1223
        CALL FindIt (ZWasZ$)                                         ' 175-1223
        IF NOT ZOK THEN _                                            ' 175-1223
          GOTO 10986                                                 ' 175-1223
      END IF                                                         ' 175-1223
      CALL CheckInt (ZOutTxt$(2))
      IF ZErrCode > 0 THEN _
         ZErrCode = 0 : _
         GOTO 10985
      IF ZUserSecLevel < ZTestedIntValue THEN _
         CALL SkipLine(1) : _
         CALL QuickTPut (ZFGC$ + "Too low security to use door "  + _
                         ZFGF$ + ExitTo$ + ZEmphasizeOff$, 2) : _
         CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue) : _
         EXIT SUB
      CALL CheckInt (ZOutTxt$(9))
      IF ZErrCode > 0 THEN _
         ZErrCode = 0 : _
         GOTO 10985
      IF ZUserSecLevel > ZTestedIntValue THEN _
         CALL SkipLine(1) : _
         CALL QuickTPut (ZFGC$ + "Too high security to use Door " + _
                         ZFGF$ + ExitTo$ + ZEmphasizeOff$,2) : _
         CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue) : _
         EXIT SUB
      WasX$ = LEFT$(ZOutTxt$(5),INSTR(ZOutTxt$(5)+" "," ")-1)
      CALL FindIt (WasX$)
      IF NOT ZOK THEN _
         GOTO 10986
      ZFileName$ = ZOutTxt$(3)
      ExitMethod$ = ZOutTxt$(4)
      ExitTemplate$ = ZOutTxt$(5)
      ZDoorDisplay$ = ZOutTxt$(7)
      ZDoorTime$ = ZOutTxt$(8)
      ZDoorCarrierDropOK$ = ZOutTxt$(10)
      ZDoorDropFile$ = ZOutTxt$(11)
      CALL CheckInt (ZOutTxt$(12))
      IF ZErrCode > 0 THEN _
         ZErrCode = 0 : _
         GOTO 10985
      ZRegDateChg = ZTestedIntValue
      CALL AskUsers
      REDIM ZUserIn$(ZMsgDim)
      CALL SmartText (ExitTemplate$,ZFalse,ZFalse)
      CALL MetaGSR (ExitTemplate$,ZFalse)
      ExitTo$ = ExitTemplate$
      GOTO 10989
10986 ZOutTxt$ = "Missing door program"
      CALL UpdtCalr (ZOutTxt$ + " " + ZWasZ$,1)
      ZSnoop = ZTrue
      CALL LPrnt (ZOutTxt$,1)
      EXIT SUB
10989 IF ZTransferFunction = 3 THEN _
         ZWasY$ = "Registration" _
      ELSE ZWasY$ = ZDooredTo$
      ZOutTxt$ = ZFGF$ + ZWasY$ + _
           ZFGE$ + " door loaded at " + _
           ZFGF$ + TIME$ + _
           ZFGE$ +" on " + _
           ZFGF$ + DATE$ + ZEmphasizeOff$
      ZSubParm = 5
      CALL TPut
      CALL UpdtCalr (ZDooredTo$ + " door opened at " + TIME$,2)
      CALL DoorInfo
      IF ExitMethod$ = "S" THEN
         CALL UpdateU (ZFalse)
         CLOSE 4,5
         CALL ShellExit (ExitTemplate$)           ' cmd line from doors.def
         ZPrevCaller$ = ""
         CALL SetCall
         ZExitToDoors = ZTrue
         CALL DoorReturn
         CALL BufFile (ZDoorDisplay$,WasX,ZFalse)
         ZExitToDoors = ZFalse
      ELSE ZOutTxt$(1) = ZDiskForDos$ + "COMMAND /C " + ExitTo$     ' command line from doors.def
           ZOutTxt$(2) = ZRBBSBat$
           CALL RBBSExit (ZOutTxt$(),2)
      END IF
      END SUB
'
10991 ' $SUBTITLE: 'DoorInfo -- Write info for doors to file'
'
      SUB DoorInfo
      CLOSE 2
      IF ZDoorDropFile$ = "R" OR ZDoorDropFile$ = "S" THEN _
         CALL DoorSys : _
         EXIT SUB _
      ELSE OPEN "O",2,"DINF" + ZNodeFileID$ + ".DEF"
      PRINT #2,ZRBBSName$
      PRINT #2,ZSysopFirstName$
      PRINT #2,ZSysopLastName$
      IF ZLocalUser THEN _
         PRINT #2,"COM0" _
      ELSE PRINT #2,ZComPort$
      ZUserIn$ = MID$(ZBaudParity$, INSTR(ZBaudParity$, ","))
      PRINT #2,ZTalkToModemAt$;" BAUD";
      IF ZReliableMode THEN PRINT #2,"-R";
      PRINT #2,ZUserIn$
      IF ZNetworkType = 7 THEN _
         NetworkType = 6 _
      ELSE _
         NetworkType = ZNetworkType
      PRINT #2,NetworkType
      IF ZGlobalSysop THEN _
         PRINT #2,"SYSOP" : _
         PRINT #2,"" _
      ELSE PRINT #2,OrigFirstName$ : _
           PRINT #2,ZLastName$
      PRINT #2,ZCityState$
      PRINT #2,ZWasGR
      PRINT #2,ZUserSecLevel
      CALL TimeRemain (MinsRemaining)
      CALL CheckInt (ZDoorTime$)
      IF ZErrCode = 0 AND ZTestedIntValue > 0 THEN _
         IF MinsRemaining > ZTestedIntValue THEN _
            MinsRemaining = ZTestedIntValue
      PRINT #2,INT(MinsRemaining)
      PRINT #2,ZFossil
      CLOSE 2
      END SUB
'
10992 ' $SUBTITLE: 'RBBSExit -- Setup to exit RBBS'
' $PAGE
'  NAME    -- RBBSExit
'
'  INPUTS  -- PARAMETER             MEANING
'             LINE.ARA        ARRAY OF LINES TO WRITE TO BATCH FILE
'             NumLines        HOW MANY LINES IN ARRAY
'
'  OUTPUTS -- ZRCTTYBat$
'
'  PURPOSE -- To create a batch file that control can be passed to
'             and to exit RBBS-PC while still keeping carrier up
'
      SUB RBBSExit (LineAra$(1),NumLines)
      CLOSE 2
      IF NumLines = 0 THEN _
         GOTO 10994
      OPEN "O",2,ZRCTTYBat$
      FOR WasI = 1 TO NumLines
         IF LineAra$(WasI) <> "" THEN _
            PRINT #2,LineAra$(WasI)
      NEXT
      CLOSE 2
10994 CLOSE 3
      ZExitToDoors = ZTrue
      IF NOT ZFossil THEN _
         OUT ZModemCntlReg,INP(ZModemCntlReg) OR 1
10996 CALL UpdateU (ZTrue)
      CALL GetTime
      CALL SaveProf (1)
      IF NumLines = 0 THEN _
         EXIT SUB
      CALL DelayTime (9 + ZBPS)
      IF ZFossil THEN _
         CALL FOSExit(ZComPort)
      SYSTEM
      END SUB
'
12000 ' $SUBTITLE: 'SetSection -- Setup section prompts'
' $PAGE
'  NAME    -- SetSection         Doug Azzarito
'
'  INPUTS  -- PARAMETER             MEANING
'             ZMenuIndex        2 = User is in MAIN Section
'                               3 = User is in FILE Section
'                               4 = User is in UTIL Section
'                               6 = User is in LIBR Section
'
'  OUTPUTS -- ZSection$         4 CHARCATER SECTION NAME
'             ZActiveMenu$      1 CHARACTER SECTION NAME
'             ZSectionPrompt$   SECTION NAME (if ZShowSection Config)
'             ZCmdPrompt$       COMMAND INPUT PROMPT STRING
'             ZSectionOpts$     LIST OF OPTIONS VALID IN THIS SECTION
'             ZInvalidOpts$     LIST OF OPTIONS INVALID IN THIS SECTION
'             ZSubSection       INDEX INTO SECURITY ARRAY FOR SECTION
'
'  PURPOSE -- To build the prompt strings for the current section
'
      SUB SetSection
      IF ZMenuIndex <> 6 THEN _
         ZCurDirPath$ = ZDirPath$
      IF ZCustomPUI THEN _
         IF ZMenuIndex = 6 THEN _
            GOTO 12015 _
         ELSE GOTO 12010
      ON ZMenuIndex GOTO 12001,12010,12005,12020,12001,12015
12001 EXIT SUB
12005 LSET ZSection$ = "FILE"
      ZSectionOpts$ = ZFileOpts$
      ZInvalidOpts$ = ZInvalidFileOpts$
      ZSubSection = ZBegFile
      GOTO 12025
12010 LSET ZSection$ = "MAIN"
      ZSectionOpts$ = ZMainOpts$
      ZInvalidOpts$ = ZInvalidMainOpts$
      ZSubSection = ZBegMain
      GOTO 12025
12015 LSET ZSection$ = "LIBR"
      ZSectionOpts$ = ZLibOpts$
      ZInvalidOpts$ = ZInvalidLibraryOpts$
      ZSubSection = ZBegLibrary
      ZCurDirPath$ = ZLibDirPath$
      GOTO 12025
12020 LSET ZSection$ = "UTIL"
      ZSectionOpts$ = ZUtilOpts$
      ZInvalidOpts$ = ZInvalidUtilOpts$
      ZSubSection = ZBegUtil
12025 IF NOT ZCustomPUI THEN_                                        ' 175-0120
      ZActiveMenu$ = LEFT$(ZSection$,1)                              ' 175-0120
      LSET ZLastCommand$ = ZActiveMenu$ + " "
      IF ZShowSection THEN _
         ZSectionPrompt$ = ZSection$ _
      ELSE ZSectionPrompt$ = "Your"
      IF ZCmndsInPrompt=0 THEN _
          ZSectionOpts$ = ""
      ZCmdPrompt$ = ZSectionPrompt$ + _
                        " command" + _
                        ZSectionOpts$
'      EXIT SUB
'12030 IF ZMenuIndex = 6 THEN
'         ZSubSection = ZBegLibrary
'         ZSectionOpts$ = ZLibOpts$
'         ZInvalidOpts$ = ZInvalidLibraryOpts$
'      ELSE
'         ZSubSection = ZBegMain
'         ZSectionOpts$ = ZMainOpts$
'         ZInvalidOpts$ = ZInvalidMainOpts$
'      END IF
      END SUB
'
12878 ' $SUBTITLE: 'UntilRight - asks question until answer okay'
' $PAGE
'
'  NAME    -- UntilRight
'
'  INPUTS  -- PARAMETER             MEANING
'             Ques$         QUESTION TO BE ASKED THE USER
'             Ans$          LOCATION TO STORE THE ANSWER
'             MinLen        MINIMUM LENGTH OF ANSWER
'             MaxLen        MAX LENGTH OF ANSWER
'
'  OUTPUTS -- Ans$          RESPONSE TO THE QUESTION WHICH THE
'                                      CALLERS SAYS IS CORRECT
'
'  PURPOSE -- Subroutine to ask a user a question until the caller
'             responds that the answer is correct
'
      SUB UntilRight (Ques$,Ans$,MinLen,MaxLen) STATIC
12880 ZParseOff = ZTrue
      ZOutTxt$ = Ques$
      CALL PopCmdStack
      IF ZSubParm = -1 THEN _
         GOTO 12882
      IF ZWasQ = 0 THEN _
         GOTO 12880
      IF LEN(ZUserIn$(ZAnsIndex)) > MaxLen THEN _
         ZLastIndex = 0 : _
         CALL QuickTPut1 (STR$(MaxLen) + " chars max") : _
         GOTO 12880 _
      ELSE IF LEN(ZUserIn$(ZAnsIndex)) < MinLen THEN _
              ZLastIndex = 0 : _
              CALL QuickTPut1 (STR$(MinLen) + " chars min") : _
              GOTO 12880
      Ans$ = ZUserIn$(ZAnsIndex)
      IF ZAnsIndex < ZLastIndex THEN _
         GOTO 12881
      ZOutTxt$ = ZUserIn$(ZAnsIndex) + _
           ", right ([Y],N)"
      ZTurboKey = -ZTurboKeyUser
      ZSubParm = 1
      CALL TGet
      IF ZSubParm = -1 THEN _
         GOTO 12882
      IF ZNo THEN _
         GOTO 12880
12881 CALL AllCaps (Ans$)
      EXIT SUB
12882 Ans$ = "GUEST"
      END SUB
'
13660 ' $SUBTITLE: 'LogError - sub to log errors to CALLERS file'
' $PAGE
'
'  NAME    -- LogError
'
'                 PARAMETER                    MEANING
'  INPUTS  --     ERR                  ERROR NUMBER DETECTED BY BASIC
'                 ERL                  LAST LINE NUMBER ENCOUNTERED
'                                        PRIOR TO ENCOUNTERNING ERROR
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- To set up a string to write to the callers log
'             indicating the date, time, error, and error line
'
      SUB LogError
      WasIX = ERR
      IF ERR < 1 THEN _
         WasIX = ZErrCode
      CALL UpdtCalr("+++ Error " + _
           STR$(WasIX) + _
           " line " + _
           STR$(ERL) + _
           " at " + _
           TIME$ + _
           " on " + _
           DATE$,2)
      END SUB
'
20096 ' $SUBTITLE: 'CheckRatio - subroutine to print ul/dl ratio'
' $PAGE
'
'  NAME    -- CheckRatio
'
'  INPUTS  --   PARAMETER                    MEANING
'               TellUser           TELL USER THEIR RATIO
'               ZDnlds             FILES DOWNLOADED
'               ZDLBytes!          BYTES DOWNLOADED
'               ZUplds             FILES UPLOADED
'               ZULBytes!          BYTES UPLOADED
'
'  OUTPUTS --   ZOK                -1 IF OKAY TO DOWNLOAD, 0 OTHERWISE
'
'  PURPOSE -- To determine whether the users violated
'             their upload to download restriction
'
      SUB CheckRatio (TellUser) STATIC
      ZOK = ZTrue
      IF ZRatioRestrict# <= 0 OR (NOT ZEnforceRatios) OR ZFreeDnld THEN _
         GOTO 20110
'
' Detemine method of ratio checking.  Look ahead to amount downloaded
'
      IF ZByteMethod = 1 OR ZByteMethod = 3 THEN
         Method$ = " Bytes"
         ULWork# = ZULBytes!
         DLWork# = ZDLBytes! + ZNumDnldBytes!
      END IF

      IF ZByteMethod = 0 OR ZByteMethod = 2 THEN
         Method$ = " Files"
         ULWork# = ZUplds
         DLWork# = ZDnlds + ZDownFiles
      END IF

      IF ULWork# < ZInitialCredit# THEN _
         ULWork# = ZInitialCredit#

      IF ZByteMethod = 2 THEN _
         Today# = ZRatioRestrict# - ZDLToday! - ZDownFiles
      IF ZByteMethod = 3 THEN _
         Today# = ZRatioRestrict# - ZBytesToday! - ZNumDnldBytes!
      Ratio# = 0
      RatioSuffix$ = ":0"
      IF ULWork# > 0 THEN _
         Ratio# = (DLWork# / ULWork#) : _
         RatioSuffix$ = ":1"
      IF ZByteMethod > 1 THEN
         IF ZBytesToday! > 0 THEN _
            DGSTemp! = ZBytesToday!
         DGSTemp! = DGSTemp! + ZNumDnldBytes!
         IF NOT TellUser THEN
            ZOutTxt$ = ZFGB$ + "Previous Downloads for Today     : " + _
                 ZFGF$ + STR$(ZDLToday!) + ZEmphasizeOff$ + ZCrLf$
            ZOutTxt$ = ZOutTxt$ + ZFGB$ + "Previous Download Bytes for Today: " + _
                 ZFGF$ + STR$(ZBytesToday!) + ZEmphasizeOff$
            ZSubParm = 5
            CALL TPut
         END IF
         IF ZDownFiles > 0 THEN
            CALL SkipLine(1)
            ZOutTxt$ = "             Today's      Current" + ZCrLf$
            ZOutTxt$ = ZOutTxt$ + "              D/L's       Request      New Totals" + ZCrLf$
            ZOutTxt$ = ZOutTxt$ + "             ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
            ZSubParm = 5
            CALL TPut
            ZOutTxt$ = ZFGA$ + "D/L Files  :" + _
                 ZFGE$ + STR$(ZDLToday!) + _
                 SPACE$(13-LEN(STR$(ZDLToday!))) + _
                 STR$(ZDownFiles) + _
                 SPACE$(13-LEN(STR$(ZDownFiles))) + _
                 STR$(ZDLToday! + ZDownFiles)
            ZSubParm = 5
            CALL TPut
            ZOutTxt$ = ZFGA$ + "D/L Bytes  :" + _
                 ZFGE$ + STR$(ZBytesToday!) + _
                 SPACE$(13-LEN(STR$(ZBytesToday!))) + _
                 STR$(ZNumDnldBytes!) + _
                 SPACE$(13-LEN(STR$(ZNumDnldBytes!))) + _
                 ZFGE$ + STR$(ZNumDnldBytes! + ZBytesToday!)
            ZSubParm = 5
            CALL TPut
         END IF
         DGSTemp! = 0
         GOTO 20100
      END IF
      WasX$ = STR$(Ratio#)
      X = INSTR(WasX$,".")
      IF X > 0 THEN _
         WasX$ = LEFT$(WasX$,X+1)
      CALL SkipLine(1)
      ZOutTxt$ = ZFG4$ + Method$ + " Downloaded:" + STR$(DLWork#) + _
              " Uploaded:" + _
              STR$(ULWork#) + _
              " Ratio:" + _
              WasX$ + _
              RatioSuffix$ + ZEmpasizeOff$
      ZSubParm = 5
      CALL TPut
'
'  CHECK TO SEE IF THE USER HAS VIOLATED THEIR UL/DL RESTRICTION
'
20100 IF NOT (ZRatioRestrict# > 0 AND TellUser) THEN _
         EXIT SUB
      IF ZByteMethod <= 1 THEN _
         GOTO 20105
      IF Today# < 0 THEN
         CALL SkipLine(1)
         ZOutTxt$ = ZFGF$ + ZBG4$ + _
              "Sorry, Today's Daily Download limit of"
         IF ZBytesToday! < 0 THEN
            ZOutTxt$ = ZOutTxt$ + STR$(ZRatioRestrict# - ZBytesToday!)
         ELSE
            ZOutTxt$ = ZOutTxt$ + STR$(ZRatioRestrict#)
         END IF
         ZOutTxt$ = ZOutTxt$ + " " + Method$ + ZBG0$ + ZEmphasizeOff$ + ZCrLf$
         ZOutTxt$ = ZOutTxt$ + ZFGF$ + ZBG4$ + _
                    "     will be EXCEEDED with your current request     " + _
                    ZBG0$ + ZEmphasizeOff$
         ZOK = ZFalse
         ZNumDnldBytes! = 0
      ELSE
         ZOutTxt$ = ZFGF$ + "D/L Balance:" + _
                ZFGE$ + SPACE$(26) + ZFGA$ + STR$(Today#) + _
                ZFGF$ + Method$ + ZEmphasizeOff$
      END IF
      ZSubParm = 5
      CALL TPut
      IF Today# < 0 THEN
         GOTO 20107
      END IF
      EXIT SUB
'
20105 IF Ratio# > ZRatioRestrict# OR ULWork# = 0 THEN _
         ZOK = ZFalse : _
         ZOutTxt$ = ZFG1$ + "Sorry, DL/UL ratio of" + _
              STR$(ZRatioRestrict#) + _
              ":1 " + _
              Method$ + " exceeded" + ZEmphasizeOff$ : _
         ZSubParm = 5 : _
         CALL TPut : _
         ZOutTxt$ = ZFG4$ + "Minimum upload of" + _
              STR$(INT(((DLWork# - (ULWork# * ZRatioRestrict#)) _
              / ZRatioRestrict#) + 1)) + _
              + " " + Method$ + " required to download" + ZEmphasizeOff$ : _
         GOTO 20107 _
      ELSE ZOutTxt$ = ZFG4$ + "Balance remaining before upload required:" + _
                STR$(INT((ULWork# * ZRatioRestrict#)-DLWork#)) + _
                " " + Method$ + ZEmphasizeOff$
      ZSubParm = 5
      CALL TPut
      EXIT SUB
20107 RatioName$ = ZHelpPath$ + "RATIO" + ZHelpExtension$
      CALL Graphic (RatioName$,ZTrue)
      CALL BufFile (RatioName$,WasX,ZFalse)
      ZNonStop = ZFalse
      CALL DelayTime(2)
      ZOK = ZFalse
20108 IF ZMarkedFiles$ <> "" THEN
         ZMarkedFiles$ = ""
         ZXferA = -1
      END IF
20110 END SUB
'
20140 ' $SUBTITLE: 'GetArc - sub to get what files to verbose list'
' $PAGE
'
'  NAME    -- GetArc
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZWasQ                       NUMBER OF ENTRIES TYPED
'                 ZUserIn$()                  ENTRIES TYPED
'
'  OUTPUTS --
'
'  PURPOSE --  Process the V)erbose list command.
'              Takes what user types and tries to list it.
'
      SUB GetArc STATIC
20141 IF ZAnsIndex >= ZLastIndex THEN _
         IF LEN(ZDefaultExtension$) > 0 THEN _
            CALL QuickTPut1 ("Default extension is "+ZDefaultExtension$)
      WasZ$ = "V"
      CALL Line25
      CALL AskItems ("V",WasZ$,ZFalse,"file",ZMarkedFiles$,ZPersonalDnld)
      IF ZSubParm = -1 OR ZWasQ = 0 THEN _
         EXIT SUB
      ZViolation$ = "View ARC"
      WasX = ZAnsIndex
      ZAnsIndex = WasX
20142 IF ZAnsIndex > ZLastIndex THEN _
         IF ZLastIndex > 1 OR Drive$ <> "" THEN _
            EXIT SUB _
         ELSE GOTO 20141
      GOSUB 20143
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZAnsIndex = ZAnsIndex + 1
      GOTO 20142
20143 IF LEN(ZUserIn$(ZAnsIndex)) < 4 THEN _
         CALL NumberCheck(ZUserIn$(ZAnsIndex),FileHasLetter) _
      ELSE FileHasLetter = ZTrue
      IF ZMarkFileNumber$ <> "" AND NOT FileHasLetter THEN _
         CALL FindFileNumber(ZUserIn$(ZAnsIndex),MarkFileName$,NumFound)
      IF NumFound THEN _
         ZUserIn$(ZAnsIndex) = MarkFileName$
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL UnMarkItems (ZMarkedFiles$,ZAnsIndex,ZLastIndex,Temp,ZFalse)
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      WasZ$ = ZWasZ$
      CALL AllCaps (ZWasZ$)
      CALL BreakFileName (ZWasZ$,Drive$,Prefix$,Ext$,ZFalse)
      IF Ext$ = "" THEN _
         Ext$ = ZDefaultExtension$ : _
         ZWasZ$ = ZWasZ$ + "." + ZDefaultExtension$
      ZFileNameHold$ = ZWasZ$
      ZFileName$ = ZWasZ$
      CALL BadFile (Prefix$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20144,20146,20147
20144 CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20145,20146,20147
20145 IF Drive$ <> "" THEN _
         ZFileNameHold$ = Prefix$ + "." + Ext$ : _
         CALL FindFile (ZFileName$,ZOK) _
      ELSE CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount + (NOT ZSysop),ZTrue,"V")
      IF NOT ZOK AND ZPersonalDnld THEN _
         ZFileName$ = ZPersonalDrvPath$ + ZWasZ$ : _
         CALL FindFile (ZFileName$,ZOK)
      IF ZOK THEN _
         GOTO 20148
20146 CALL AllCaps(WasZ$)
      ZWasZ$ = WasZ$ + _
           " not found!"
      CALL UpdtCalr (ZWasZ$,2)
      ZOutTxt$ = ZFGE$ + ZWasZ$ + _
           ZFGB$ + " Type correct filename " + ZFG4$ + ZFirstName$ + _
           ZPressEnterExpert$  + ZEmphasizeOff$
      ZSubParm = 1
      CALL TGet
      IF ZSubParm = -1 OR ZWasQ = 0 THEN _
         RETURN
      ZUserIn$(ZAnsIndex) = ZUserIn$(1)
      GOTO 20143
20147 CALL SecViolation
      IF ZDenyAccess THEN _
         EXIT SUB
      IF DGSViewVio THEN _
         EXIT SUB
      GOTO 20146
20148 WasX$ = ZDiskForDos$ + "VIEW.BAT"
      CALL Graphic (WasX$,ZFalse)
      IF NOT ZOK THEN _
         WasX$ = ZDiskForDos$ + "V" + Ext$ + ".BAT" : _
         CALL FindIt (WasX$) : _
         IF NOT ZOK THEN _
            GOTO 20150
      ZGSRAra$(3) = MID$(RIGHT$(ZComPort$,1)+"0",1-ZLocalUser, 1)
      CALL ReadDir (2,1)
      IF EOF(2) THEN _
         ZWasZ$ = ZOutTxt$ : _
         ZGSRAra$(1) = ZFileName$ : _
         ZGSRAra$(2) = ZArcWork$ _
      ELSE ZWasZ$ = WasX$ + " " + ZFileName$ + " " + ZArcWork$ + _
                    " " + Ext$ + " " + ZNodeID$ + " " + ZGSRAra$(3)
      CALL FilSecChk (ZViolation$, ZFileName$, ZOK)
      IF NOT ZOK THEN _
         DGSViewVio = ZTrue : _
         GOTO 20147
      IF ZErrCode = 53 THEN _
         CALL UpdtCalr ("Missing file " + ZFileSecFile$,2)
      IF ZErrCode = 62 THEN _
         CALL UpdtCalr (ZFileSecFile$ + " Bad format!",2)
      CALL ShellExit (ZWasZ$)
      CALL BufFile (ZArcWork$,WasX,ZFalse)
      RETURN
20150 WasX = INSTR(".ARC.PAK.ZIP.LZH.","."+Ext$+".")
      'IF (WasX < 1) OR (WasX = 1 AND NOT ZTurboRBBS) THEN _
      IF (WasX < 1) THEN _
         CALL QuickTPut1 ("View not implemented") : _
         RETURN
      CALL QuickTPut1 (ZFileNameHold$ + " has these files")
      CALL ViewArc
      RETURN
      END SUB
'
20235 ' $SUBTITLE: 'BadName - subroutine to find bad file names'
' $PAGE
'
'  NAME    -- BadName
'
'  INPUTS  --     PARAMETER                    MEANING
'               ZActiveMessageFile$
'               ZActiveUserFile$
'               ZCallersFile$
'               ZCmntsFile$
'               CONFIG.FILEANAME$
'               ZMainMsgBackup$
'               ZMainMsgFile$
'               ZMaxViolations
'               ZPswdFile$
'               ZRBBSBat$
'               ZRCTTYBat$
'               ZSubDir$()
'               ZSubDirIndex
'               ZViolation$
'               ZViolationsThisSession
'               ZWasZ$                          NAME OF FILE
'               ProtectExt              -1 IF CHECK FOR EXTENSION
'                                        0 TO ALLOW ANY EXTENSION
'
'  OUTPUTS  -- BadFileNameIndex         1 = FILE NAME IS OK
'                                       2 = SECURITY BREACH TRIED
'
'  PURPOSE -- To protect RBBS-PC against the use of bad file names
'             to either crash the system or to breach RBBS-PC's security
'
      SUB BadName (BadFileNameIndex,ProtectExt)
'
'
' *  TEST FOR SYSTEM FILE ATTEMPT
'
      BadFileNameIndex = 2
      ZWasZ$ = ZFileName$
      CALL BreakFileName (ZFileName$,DR$,Prefix$,Extension$,ZFalse)
      IF LEN(Extension$) = 3 AND ProtectExt THEN _
         IF INSTR("DEF,MNU,OLD,PUI,BAK,",Extension$+",") > 0 THEN _
            EXIT SUB
      ZOK = 0
      IF ProtectExt THEN _
         CALL FileNameCheck (ZActiveMessageFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZActiveUserFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZCallersFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZCmntsFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZFileSecFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZMainMsgBackup$,Prefix$,Extension$)
      CALL FileNameCheck (ZOrigMsgFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZOrigUserFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZPswdFile$,Prefix$,Extension$)
      CALL FileNameCheck (ZRBBSBat$,Prefix$,Extension$)
      CALL FileNameCheck (ZRCTTYBat$,Prefix$,Extension$)
      CALL FileNameCheck (ZConfigFileName$,Prefix$,Extension$)
      IF ZOK = 0 THEN _
         BadFileNameIndex = 1
      END SUB
'
20240 ' $SUBTITLE: 'FileNameCheck - checks file match except for drive'
' $PAGE
'
'  NAME    -- FileNameCheck
'
'  INPUTS  --     PARAMETER                    MEANING
'               CheckThis$           NAME OF FILE TO CHECK
'               Pref2$               PREFIX TO MATCH AGAINST
'               Ext2$                EXTENSION TO MATCH AGAINST
'
'  OUTPUTS  -- ZOK                    1 IF GOT MATCH
'
'  PURPOSE -- Checks for match on both prefix and extension of a file
'             name.   Used to catch match on system files not to be
'             downloaded.
'
      SUB FileNameCheck (CheckThis$,Pref2$,Ext2$) STATIC
      IF ZOK > 0 THEN _
         EXIT SUB
      CALL BreakFileName (CheckThis$,DR$,Pref1$,Ext1$,ZFalse)
      IF Pref1$ = Pref2$ THEN _
         IF Ext1$ = Ext2$ THEN _
            ZOK = 1
      END SUB
'
20245 SUB SetBPS (BaudTest!,BPS)
      IF BaudTest! > 0 AND BaudTest! < 50 THEN _
         BaudTest! = BaudTest! * 1000  ' Support 14.4 for 14,400
      IF BaudTest! = 0 THEN _
         BaudTest! = 300
      SELECT CASE BaudTest!
         CASE 300
            BPS = -1
         CASE 450
            BPS = -2
         CASE 1200
            BPS = -3
         CASE 1275
            BPS = -3
         CASE 2400
            BPS = -4
         CASE 4800
            BPS = -5
         CASE 7200
            BPS = -6
         CASE 9600
            BPS = -7
         CASE 12000
            BPS = -8
         CASE 14400
            BPS = -9
         CASE 16800
            BPS = -10
         CASE 19200
            BPS = -11
         CASE 21600
            BPS = -12
         CASE 24000
            BPS = -13
         CASE 26400
            BPS = -14
         CASE 28800
            BPS = -15
         CASE 38400
            BPS = -16
         CASE 57600
            BPS = -17
      END SELECT
      END SUB
'
20340 ' $SUBTITLE: 'QuickPeek - Easy find user to send message to'
' $PAGE
'
'  NAME    -- QuickPeek
'
'                 PARAMETER               MEANING
'
'  INPUTS  --     ZUserIn$                SEARCH STRING USER INPUT
'
'  OUTPUTS --     MsgTo$                  WHO MESSAGE IS TO
'
'  PURPOSE -- Save User keystrokes when looking for message addressee
'
      SUB QuickPeek (MsgTo$,WhoFound)  STATIC
      IF WhoFound = ZTrue THEN _
         EXIT SUB
      SaveTxt$ = ZOutTxt$
      WhichUser = 1
      CALL OpenUser (ZHighestUserRecord)
      WasX = 0
      WHILE NOT EOF(5)
         CALL MarkTime(WasX)
         GET #5, WhichUser
         TempMsgTo$ = ZUserName$
         CALL TRIM (TempMsgTo$)
         IF MsgTo$ = TempMsgTo$ THEN _
            EXIT SUB
         InTo = INSTR(TempMsgTo$,MsgTo$)
         IF InTo > 0 THEN
            IF TempMsgTo$ = ZSecretName$ THEN _
               GOTO 20345
            CALL WipeLine(79)
            Temp = LEN(MsgTo$)
            TempMsgToWork$ = TempMsgTo$
            TempMsgToWork$ = MID$(TempMsgTo$,1,Into - 1) + ZEmphasizeOn$ + MsgTo$ + _
                              ZEmphasizeOff$ + ZFGF$ + MID$(TempMsgTo$,InTo + Temp)
            ZOutTxt$ = ZFG4$ + SaveTxt$ + ZFGF$ + TempMsgToWork$ + _
                       ZFG4$ + " ( " + ZFGF$ + "Y" + ZFG4$ + ")es, [N]" + _
                       ZFG4$ + ")o, " + ZFGF$ + "A" + ZFG4$ + ")bort )" + ZEmphasizeOff$
            ZSubParm = 1
            CALL TGet
            IF ZSubParm = -1 THEN _
               EXIT SUB
            IF ZWasQ = 0 THEN _
               GOTO 20345
            CALL AllCaps (ZUserIn$)
            IF ZUserIn$ = "A" THEN _
               EXIT SUB
            IF ZUserIn$ = "Y" THEN
               MsgTo$ = TempMsgTo$
               WhoFound = ZTrue
               EXIT SUB
            END IF
         END IF
20345    WhichUser = WhichUser + 1
      WEND
20348 END SUB
'
20350 ' $SUBTITLE: 'PersonalRing - Detects Distinctive Ring patterns'
' PAGE$
'
' NAME  PersonalRing
'
'                 PARAMETER                    MEANING
'
' INPUTS         PAnswer
'
'                Sreg                    SETTING OF S0 REGISTER
'
' PURPOSE:  To distinguish the ring pattern on those phones using
'           multiple numbers on single line utilizing the Phone
'           Company's distinctive ring patterns.
'
'     Written by: John Rayfield Jr.
'
      DEFINT A-Z
      SUB PersonalRing (PAnswer, Sreg) STATIC
20352 LOCATE 21,23
      IF ZDosANSI THEN _
         CALL LPrnt(ZEscape$ + "[1;40;31m" + " PERSONAL RING" + _
                    ZEscape$ + "[00m",0) _
      ELSE _
         CALL LPrnt(" PERSONAL RING",0)
      ptimeout! = TIMER
      DO
         DetectedRing = INP(ZModemStatusReg) AND &H40
         ptimeend! = TIMER
         IF ptimeend! - ptimeout! > 5 THEN
            LOCATE 21,23
            CALL LPrnt("              ",0)
            EXIT SUB
         END IF
      LOOP UNTIL DetectedRing = 0
         ptimeout! = TIMER
         DO
            DetectedRing = INP(ZModemStatusReg) AND &H40
            ptimeend! = TIMER
            IF ptimeend! - ptimeout! > 5 THEN
               LOCATE 21,23
               CALL LPrnt("              ",0)
               EXIT SUB
            END IF
         LOOP UNTIL DetectedRing > 0
         RingStarted! = TIMER
         ptimeout! = TIMER
         DO
            DetectedRing = INP(ZModemStatusReg) AND &H40
            ptimeend! = TIMER
            IF ptimeend! - ptimeout! > 5 THEN
               LOCATE 21,23
               CALL LPrnt("              ",0)
               EXIT SUB
            END IF
         LOOP UNTIL DetectedRing = 0
         RingStopped! = TIMER
         RingLength! = RingStopped! - RingStarted!
            IF Sreg = 253 THEN
         ' Telephone Ring = Regular Ring...
               IF RingLength! > 1.5 THEN
                  PAnswer = 1
               END IF
         ' Telephone Ring = Short Ring...
            ELSEIF Sreg = 252 THEN
               IF RingLength! < 1.3 THEN
                  PAnswer = 1
               END IF
            END IF
            LOCATE 21,23
            CALL LPrnt("              ",0)
      END SUB
'
59000 ' $SUBTITLE: ' FileNumbers - Add File Numbers to FMS and .DIR Listings '
' $PAGE
'
'  NAME    -- FileNumbers
'
'  INPUTS  -- PARAMETER             MEANING
'             ZOutTxt$              FMS OR .DIR ENTRY
'
'  OUTPUTS -- ZOutTxtTemp$          MODIFIED ZOUTTXT$
'             ZFileNumberCount      FILE NUMBER COUNTER
'             ZMarkFileNumber$      LIST OF FILES PROCESSED
'
'  PURPOSE -- Add FileLetters to FMS and .DIR listing for easier marking,
'             downloading, and file viewing.
'
'
      SUB FileNumbers (ZOutTxt$,OutTxtTemp$)
      IF INSTR(ZOutTxt$," ") > 14 OR INSTR(ZOutTxt$," ") = 0 OR _
               LEFT$(ZOutTxt$,1) = "." OR LEFT$(ZOutTxt$,1) = "*" THEN _
         EXIT SUB
      LineHold$ = MID$(ZOutTxt$,1,12)
      IF INSTR(LineHold$,"*") <> 0 THEN _
          LineHold$ = MID$(LineHold$,1,INSTR(LineHold$,"*")-1)
      IF INSTR(LineHold$, ".") = 0 THEN
         SpacePlace = INSTR(ZOutTxt$, " ")
         File1$ = MID$(LineHold$,1,SpacePlace-1)
         File2$ = MID$(LineHold$,SpacePlace+1)
         CALL TRIM(File2$)
         FileNumberName$ = File1$ + "." + File2$
      ELSE
         CALL Trim(LineHold$)
         FileNumberName$ = LineHold$
      END IF
      FileNumber$ = LTRIM$(STR$(ZFileNumberCount))
      IF VAL(FileNumber$) < 10 THEN _
         FileNumber$ = "0" + FileNumber$
      IF ZWasGR > 1 THEN _
         OutTxtTemp$ = ZFG1$ + "["+ ZFGA$ + FileNumber$ + ZFG1$ + "]" _
      ELSE OutTxtTemp$ = "["+ FileNumber$ + "]"
      IF VAL(FileNumber$) < 100 THEN _
         OutTxtTemp$ = OutTxtTemp$ + " "
      ZMarkFileNumber$ = ZMarkFileNumber$ + _
                         FileNumberName$ + ZCarriageReturn$
      ZFileNumberCount = ZFileNumberCount + 1
      EXIT SUB
      END SUB
59100 ' $SUBTITLE: ' FileNumberWrap - Line wrapping routine'
' $PAGE
'
'  NAME    -- FileNumberWrap
'
'  INPUTS  -- PARAMETER             MEANING
'
'  OUTPUTS -- TextWrap$             EXTRA WORDS AT END OF LINE
'                                   TO BE ADDED TO THE NEXT LINE
'
'  PURPOSE -- To check the length of a line and wrap the extra
'             words to the next desription line.  Used with the
'             file number routine
'
      SUB FileNumberWrap (TextWrap$)
      EndDesc = 33 + ZMaxDescLen
      CALL TrimTrail (ZOutTxt$," ")
59110 CALL FindWrap(ZOutTxt$, I)
      IF I <= 1 THEN _
         I = EndDesc - 6
      TextWrap$ = MID$(ZOutTxt$, I + 1) + TextWrap$
      ZOutTxt$ = LEFT$(ZOutTxt$, I)
      IF LEFT$(ZOutTxt$,1) = " " THEN _
         WrapPoint = 0 _
      ELSE WrapPoint = 6
      IF LEN(ZOutTxt$) > (EndDesc - WrapPoint) THEN _
         GOTO 59110
      END SUB
63400 ' $SUBTITLE: 'LockAppend - prepares for file append'
' $PAGE
'
'  NAME    -- LockAppend
'
'  INPUTS  -- ZWasEN$            NAME OF FILE TO APPEND TO
'
'  OUTPUTS -- none
'
'  PURPOSE -- Locks and opens file to append to
'
      SUB LockAppend
      WasBX = &H4
      ZSubParm = 9
      CALL FileLock
      ZErrCode = 0
      CALL OpenWork (2,ZWasEN$,ZTrue)
      END SUB
'
63410 ' $SUBTITLE: 'UnLockAppend - cleans up after file append'
' $PAGE
'
'  NAME    -- UnLockAppend
'
'  INPUTS  -- none
'
'  OUTPUTS -- none
'
'  PURPOSE -- Unlocks and close file appending to
'
      SUB UnLockAppend
      WasBX = &H4
      ZSubParm = 10
      CALL FileLock
      CLOSE 2
      END SUB
'
63420 ' $SUBTITLE: 'FormRead - Reads from a file into a form'
' $PAGE
'
'  NAME    -- FormRead
'
'  INPUTS  -- Template$      DISPLAY FORM TO INVOKE SHELL WITH
'             FilName$       DATA FILE TO GET VALUES FROM
'             FixedLength    WHETHER FILE IS FIXED LENGTH
'             DataVar        # BYTES DATA IF FIXED LENGTH
'                            # FIELDS IF VARIABLE LENGTH
'             OverStrike     WHETHER TYPEOVER INTO FORM OR INSERT
'             RecPause       WHETHER PAUSE AFTER EVERY RECORD DISPLAYED
'                               OTHERWISE WHEN SCREEN FILLS
'
'  OUTPUTS -- (displays data base records)
'
'  PURPOSE -- Allows field oriented data base data to be displayed
'               in a human readable format by substituting field
'               data into template or form
'
      SUB FormRead (Template$,FilName$,FixedLength,DataVar,OverStrike,RecPause) STATIC
63422 IF EOF(2) OR ZNo OR (ZErrCode > 0) OR (ZSubParm < 0) THEN _
         Template$ = "" : _
         EXIT SUB
      IF FixedLength THEN _
         CALL ReadDir (2,1) : _
         ZGSRAra$(1) = ZOutTxt$ _
      ELSE CALL ReadParms (ZGSRAra$(),DataVar,1)
      WasX$ = Template$
      CALL SmartText (WasX$,ZTrue,OverStrike)
      CALL MetaGSR (WasX$,OverStrike)
      CALL BufAsUnit (WasX$)
      IF RecPause OR (ZPageLength > 0 AND (ZLinesPrinted >= ZPageLength-1)) THEN _
         CALL PauseExit : _
         EXIT SUB
      GOTO 63422
      END SUB
'
63440 ' $SUBTITLE: 'BufAsUnit - prints string with no pauses'
' $PAGE
'
'  NAME    -- BufAsUnit
'
'  INPUTS  -- Strng$           STRING TO PRINT
'
'  OUTPUTS -- none
'
'  PURPOSE -- Prints string with embedded carriage returns.
'             Will never pause.  Used to print when can't call TGet
'
      SUB BufAsUnit (Strng$) STATIC
      WasL = LEN(Strng$)
      IF WasL < 1 THEN _
         EXIT SUB
      StartByte = 1
63450 CRat = INSTR(StartByte,Strng$,ZCarriageReturn$)
      IF CRat > 0 AND CRat < WasL THEN _
         CRFound = (MID$(Strng$,CRat + 1,1) = ZLineFeed$) _
      ELSE CRFound = ZFalse
      EOLlen = -2 * CRFound
      IF CRFound THEN _
         EOD = CRat _
      ELSE EOD = WasL + 1
      NumBytes = EOD - StartByte
      ZOutTxt$ = MID$(Strng$,StartByte,NumBytes)
      ZSubParm = 4
      CALL TPut
      CALL SkipLine (-(CRFound))
      IF ZRet THEN _
         EXIT SUB
      StartByte = EOD + EOLlen
      IF StartByte <= WasL THEN _
         GOTO 63450
      END SUB
'
63460 ' Check if macro exists and execute if does
      SUB MacroExe (Strng$) STATIC
      CALL Trim (Strng$)
      CALL Macro (Strng$,Found)
      IF NOT Found THEN _
         EXIT SUB
      CALL FDMACEXE
      END SUB
'
63462 ' Unconditionally executes a macro
      SUB FDMACEXE STATIC
      ZOutTxt$ = ""
      ZMacroEcho = ZFalse
      ZSubParm = 1
      CALL TGet
      END SUB
'
63465 ' Forces a keyboard pause inside a macro
      SUB PauseExit STATIC
      ZSubParm = 4
      ZTurboKey = -ZTurboKeyUser
      ZOutTxt$ = ZMorePrompt$ + LEFT$(">",-1*ZExpertUser) + MID$("? : ",2*ZTurboKey+1,2)
      ZForceKeyboard = ZTrue
      ZNoAdvance = ZTrue
      CALL TPut
      ZLinesPrinted = 0
      ZUserIn$ = ""
      END SUB
'
63470 ' $SUBTITLE: 'SetPrompt - sub to set prompts based on user security'
' $PAGE
'
'  NAME    -- SetPrompt
'
'  INPUTS  -- PARAMETER           MEANING
'             ZBegMain          POSITION START OF MAIN CMDS
'             ZBegFile          POSITION START OF FILE CMDS
'             ZBegUtil          POSITION START OF UTIL CMDS
'             ZBegLibrary       POSITION START OF Library CMDS
'
'  OUTPUTS -- PRESENT.OPTS$     DISPLAY WHAT USER CAN DO (1st)
'             CALLERS.OPTS$     DISPLAY WHAT USER CAN DO (2nd)
'             ZMainOpts$        MAIN OPTS USER CAN DO
'             ZFileOpts$        FILE OPTS USER CAN DO
'             ZUtilOpts$        UTIL OPTS USER CAN DO
'             ZLibOpts$         LIBRARY OPTS USER CAN DO
'
'  PURPOSE -- Sets command line display of what user can do by
'             section and display of what all user can do
'
      SUB SetPrompt STATIC
      First = ZBegMain
      Last = ZBegFile - 1
      CALL SetOpts (ZMainOpts$,ZInvalidMainOpts$,First,Last)
      First = ZBegFile
      Last = ZBegUtil - 1
      CALL SetOpts (ZFileOpts$,ZInvalidFileOpts$,First,Last)
      First = ZBegUtil
      Last = ZBegLibrary - 1
      CALL SetOpts (ZUtilOpts$,ZInvalidUtilOpts$,First,Last)
      First = ZBegLibrary
      Last = ZBegLibrary + 6
      CALL SetOpts (ZLibOpts$,ZInvalidLibraryOpts$,First,Last)
      First = 50
      Last = 56
      CALL SetOpts (SysOpt$,ZInvalidSysOpts$,First,Last)
      First = 46
      Last = 49
      CALL SetOpts (GlobalOpts$,InvalidGlobalOpts$,First,Last)
      IF LEN(SysOpt$) > 0 THEN _
         ZSystemOpts$ = "Sysop: " + _
                        SysOpt$
      ZMainOpts$ = GlobalOpts$ + ZMainOpts$ + _
                   MID$(ZAllOpts$,INSTR(ZOrigCommands$,"G"),1)
      ZFileOpts$ = GlobalOpts$ + _
                   ZFileOpts$
      ZUtilOpts$ = GlobalOpts$ + _
                   ZUtilOpts$
      ZLibOpts$ = GlobalOpts$ + _
                      ZLibOpts$
      CALL SortString (SysOpt$)
      CALL SortString (ZMainOpts$)
      ZMainOpts$ = ZMainOpts$ + _
                   SysOpt$
      CALL SortString (ZFileOpts$)
      CALL SortString (ZUtilOpts$)
      CALL SortString (ZLibOpts$)
      CALL AddCommas (ZMainOpts$)
      CALL AddCommas (ZFileOpts$)
      CALL AddCommas (ZUtilOpts$)
      CALL AddCommas (ZLibOpts$)
      ZDirPrompt$ = "What directory(s) (" + _
         MID$("U)pload,A)ll,P)ers,L)ist,E)xtended +/-, [Q]uit)",8 * (ZUserSecLevel => ZMinSecToView) + 9)
      ZQuitPromptExpert$ = "QUIT C,S, or to F,[M],U,@"
      ZQuitPromptNovice$ = "QUIT C)onference, S)ession or to section " + _
                            "F)ile, [M]ain, U)til or @)Library"
      ZQuitList$ = "FMUS@C"
      IF ZUserSecLevel < ZOptSec(18) THEN _
         ZQuitPromptExpert$ = LEFT$(ZQuitPromptExpert$,23) : _
         ZQuitPromptNovice$ = LEFT$(ZQuitPromptNovice$,61) : _
         MID$(ZQuitList$,5) = " "
      IF ZUserSecLevel < ZOptSec(15) THEN _
         ZQuitPromptExpert$ = LEFT$(ZQuitPromptExpert$,22) + _
                               MID$(ZQuitPromptExpert$,25) : _
         ZQuitPromptNovice$ = LEFT$(ZQuitPromptNovice$,56) + _
                               MID$(ZQuitPromptNovice$,63) : _
         MID$(ZQuitList$,3,1) = " "
      IF ZUserSecLevel < ZOptSec(6) THEN _
         ZQuitPromptExpert$ = LEFT$(ZQuitPromptExpert$,16) + _
                               MID$(ZQuitPromptExpert$,19) : _
         ZQuitPromptNovice$ = LEFT$(ZQuitPromptNovice$,41) + _
                               MID$(ZQuitPromptNovice$,49) : _
         MID$(ZQuitList$,1,1) = " "
      CALL SetSection
      END SUB
'
63480 ' $SUBTITLE: 'NoPath - detects whether string has path'
' $PAGE
'
'  NAME    -- NoPath
'
'  INPUTS  -- Strng$     STRING TO CHECK
'
'  OUTPUTS -- Has.None   TRUE IF HAS NO PATH
'
'  PURPOSE -- Detects whether have path.  Used when shouldn't
'             be any
'
      SUB NoPath (Strng$,HasPath)
      CALL BreakFileName (Strng$,DrvPath$,Prefix$,Ext$,ZFalse)
      HasPath = (DrvPath$ <> "")
      END SUB
'
63490 ' $SUBTITLE: 'FindIt - Determine whether file exists'
' $PAGE
'
'  NAME    -- FindIt
'
'  INPUTS  -- FilName$    FILE NAME TO CHECK
'
'  OUTPUTS -- ZOK         TRUE IF FILE EXISTS.  OPENED AS #2 IF DOES
'
'  PURPOSE -- Determine whether file exists and open as standard work
'             file if it does (#2)
'
      SUB FindIt (FilName$)
      CALL FindItX (FilName$,2)
      END SUB
'
      SUB ReadParms (AraToUse$(1),NumParms,WhichLine)
      CALL ReadParmsX (2,AraToUse$(),NumParms,WhichLine)
      END SUB
'
63495 ' $SUBTITLE: 'TimeBack - Give time back to the user'
' $PAGE
'
'  NAME    -- TimeBack
'
'  INPUTS  -- Index       = 1    SET START OF TIME (BEGIN GIVE BACK)
'                         = 2    GIVE BACK TIME FROM DEFINED START
'
'  OUTPUTS -- ZTimeCredits!       NUMBER OF SECONDS TO CREDIT WITH
'             ZSecsPerSession!    NUMBER OF SECONDS IN CURRENT SESSION
'
'  PURPOSE -- Give time back to the user (e.g. sysop initiated chat)
'
      SUB TimeBack (Index)
      IF Index = 1 THEN _
         CALL TimeRemain (MinsRemaining) : _
         ZWasQ! = ZSecsUsedSession! : _
         EXIT SUB
      CALL TimeRemain (MinsRemaining)
      WasX! = (ZSecsUsedSession! - ZWasQ!)
      ZTimeCredits! = ZTimeCredits! + WasX!
      END SUB
'
63500 ' $SUBTITLE: 'CmdStackPushPop - Save/restore command stack'
' $PAGE
'
'  NAME    -- CmdStackPushPop
'
'  INPUTS  -- Index         = 1    SAVE COMMAND STACK
'                           = 2    RESTORE COMMAND STACK
'             ZAnsIndex
'             ZLastIndex
'             ZUserIn$()
'
'  OUTPUTS -- ZUserIn$()            STACKED COMMANDS
'             ZAnsIndex
'             ZLastIndex
'
'  PURPOSE -- Save restore a command stack list when need to input
'             another list in middle of previous list processing
'
      SUB CmdStackPushPop (Index) STATIC
      IF Index = 1 THEN _
         OrigLastIndex = ZLastIndex : _  ' save
         OrigIndex = ZAnsIndex : _
         FOR WasI = 1 TO OrigLastIndex : _
             ZOutTxt$(WasI) = ZUserIn$(WasI) : _
         NEXT : _
         EXIT SUB
      ZLastIndex = OrigLastIndex        ' restore
      ZAnsIndex = OrigIndex
      FOR WasI = 1 TO OrigLastIndex
         ZUserIn$(WasI) = ZOutTxt$(WasI)
      NEXT
      END SUB
'
63510 ' $SUBTITLE: 'VerifyAns - edits an answer'
' $PAGE
'
'  NAME    -- VerifyAns
'                                   MEANING
'  INPUTS  -- ZVerifying         WHETHER VERIFYING
'             ZUserIn$(1)        RESPONSE VERIFYING
'             ZVerifyList$       LIST OF APPROPRIATE ANSWERS.
'                                1st CHAR IS WHAT SEPARATES ANSWERS
'             ZVerifyNumeric     VERIFY WHAT IS A VALID INTEGER
'                                  IF FALSE, THEN VERIFYING THAT
'                                  A STRING IS BETWEEN 2 VALUES
'             ZVerifyLow$        LOWEST OK VALUE OF STRING
'             ZVerifyHigh$       HIGHEST OK VALUE OF STRING
'
'  OUTPUTS -- ZOK                WHETHER PASSES VERIFICATION
'             ZVerifyList$       EMPTIES IF OK
'             ZVerifying         SETS FALSE IF OK
'             ZVerifyNumeric     SETS FALSE IF OK
'
'  PURPOSE -- Processes edits on a user input
'
      SUB VerifyAns STATIC
      ZOK = ZTrue
      IF NOT ZVerifying THEN _
         EXIT SUB
      Temp$ = ZUserIn$(1)
      CALL AllCaps (Temp$)
      IF ZVerifyList$ <> "" THEN _
         WasX$ = LEFT$(ZVerifyList$,1) : _
         ZOK = (INSTR (ZVerifyList$, WasX$+Temp$+WasX$) > 0) _
      ELSE IF ZVerifyNumeric THEN _
              CALL CheckInt (ZUserIn$) : _
              ZOK = (ZErrCode = 0 AND _
                    ZTestedIntValue >= VAL(ZVerifyLow$) AND _
                    ZTestedIntValue <= VAL(ZVerifyHigh$)) _
           ELSE ZOK = (Temp$ >= ZVerifyLow$ AND Temp$ <= ZVerifyHigh$)
      IF ZOK THEN _
         ZVerifyList$ = "" : _
         ZVerifying = ZFalse : _
         ZVerifyNumeric = ZFalse
      END SUB
'
63530 ' Take modem offhook
      SUB TakeOffHook
      CALL ModemPut (ZModemGoOffHookCmd$)
      CALL DelayTime (3)
      END SUB
'
63540 ' Match Name to one in message file
      SUB ChkMsgName (MsgFromCaller,MsgToCaller) STATIC
      IF NOT ZRemoteSysop THEN
         WasX$ = LEFT$("SYSOP",-5*ZSysop)
         CALL MsgNameMatch (ZOrigUserName$,WasX$,6,MsgFromCaller)
         CALL MsgNameMatch (ZOrigUserName$,WasX$,37,MsgToCaller)
         IF ZAliasMode THEN
            CALL MsgNameMatch (ZActiveUserName$,WasX$,6,MsgFromCaller)
            CALL MsgNameMatch (ZActiveUserName$,WasX$,37,MsgToCaller)
         END IF
         EXIT SUB
      END IF
      CALL MsgNameMatch ("SYSOP",ZSysopFullName$,6,MsgFromCaller)
      IF NOT MsgFromCaller THEN _
         CALL MsgNameMatch (ZOrigUserName$,"",6,MsgFromCaller)
      CALL MsgNameMatch ("SYSOP",ZSysopFullName$,37,MsgToCaller)
      IF NOT MsgToCaller THEN _
         CALL MsgNameMatch (ZOrigUserName$,"",37,MsgToCaller)
      END SUB
'
      SUB MsgNameMatch (PrimeName$,AltName$,SearchPos,Found) STATIC
      WasX$ = LEFT$(PrimeName$+"  ",22-8*(SearchPos < 7))
      GOSUB 63542
      IF Found OR AltName$ = "" THEN _
         EXIT SUB
      WasX$ = LEFT$(AltName$ + "  ",22-8*(SearchPos < 7))
      GOSUB 63542
      EXIT SUB
63542 WasY$ = MID$(ZMsgRec$,SearchPos,LEN(WasX$))
      ZWasDF = INSTR(WasY$,"@")
      IF ZWasDF > 0 THEN _
         MID$(WasY$,ZWasDF) = "      "
      Found = (WasY$ = WasX$)
      RETURN
      END SUB
'
63550 ' Check whether message record is a msg header record
      SUB ChkIfMsgHeader STATIC
      ZOK = ZFalse
      IF MID$(ZMsgRec$,70,1) = "-" AND MID$(ZMsgRec$,73,1) = "-" THEN _
         WasY = ASC(MID$(ZMsgRec$,116,1)) : _
         IF WasY > 224 AND WasY < 227 THEN _
            ZOK = ZTrue
      END SUB
'
63560 ' Set specified user flag
      SUB SetUserFlag (RcvrRecNum, ChangeIndex, WhatGetting$) STATIC
      FIELD #5, 128 AS ZUserRecord$
      IF RcvrRecNum > 0 THEN _
         ZUserFileIndex = RcvrRecNum : _
         ZSubParm = 6 : _
         CALL FileLock : _
         GET 5, RcvrRecNum : _
         WasX = CVI(MID$(ZUserRecord$,57,2)) : _
         MID$(ZUserRecord$,57,2) = MKI$(WasX OR ChangeIndex) : _
         PUT 5, RcvrRecNum : _
         ZSubParm = 8 : _
         CALL FileLock : _
         CALL QuickTPut1 (ZWorkAra$(1) + " will be notified of new " + WhatGetting$) : _
         RcvrRecNum = 0
      END SUB
'
63570 ' Check Proposed Change to Time Remaining
      SUB ChkAddedTime (TimeToAdd) STATIC
      IF TimeToAdd <= 0 THEN _
         EXIT SUB
      IF ZTimeToDropToDos! = 0 OR ZOldDate$ = DATE$ THEN _
         GOTO 63571
      CALL CheckTime (ZTimeToDropToDos!, HowMuchTimeLeft!, 1)
      IF HowMuchTimeLeft! < -60 THEN _
         HowMuchTimeLeft! = (HowMuchTimeLeft! * -1) + 43200
      IF 60!*TimeToAdd + (ZSecsPerSession! - ZSecsUsedSession!) > HowMuchTimeLeft! THEN _
         TimeToAdd = (HowMuchTimeLeft! - ZSecsPerSession! + ZSecsUsedSession!) / 60 : _
         ZOutTxt$ = "Scheduled" : _
         GOSUB 63572
63571 CheckTheTime = ZMinsPerSession + TimeToAdd
      IF ZLimitMinsPerSession THEN _
         IF CheckTheTime > ZLimitMinsPerSession THEN _
            TimeToAdd = ZLimitMinsPerSession - ZMinsPerSession : _
            ZOutTxt$ = "External" : _
            GOSUB 63572
      EXIT SUB
63572 ZOutTxt$ = "Extension reduced to"+ STR$(TimeToAdd) + _
                 " due to " + ZOutTxt$ + " Event" : _
      CALL RingCaller
      END SUB
'
63580 ' Displays user record
      SUB DispUserRec (ToPrint) STATIC
      ZOK = ZFalse
      WasX$ = MID$(ZUserRecord$,ZStartHash,ZLenHash)
      IF ASC(WasX$) = 0 OR LEFT$(WasX$,3) = "   " THEN _
         EXIT SUB
      WasOF = CVI(ZSecLevel$)
      IF WasOF > ZUserSecLevel THEN _
         IF NOT ZGlobalSysop THEN _
            EXIT SUB
      ZOutTxt$ = ZFGB$ + RIGHT$("     " + STR$(LOC(5)),4) + _
           ":" + _
           ZFGF$ + ZUserName$ + _
           ZFG4$ + "SECURITY" + _
           RIGHT$("      " + STR$(WasOF),6) + _
           " "
      ZOutTxt$ = ZOutTxt$ + _
           ZFGA$ + "Password= " + _
           ZPswd$ + ZEmphasizeOff$
      GOSUB 63583
      IF WasOF < ZOrigMainSec THEN _
         ZOutTxt$ = ZEmphasizeOn$ + "<Locked out>" + ZEmphasizeOff$ + SPACE$(7) _
      ELSE IF WasOF >= ZSysopSecLevel THEN _
         ZOutTxt$ = ZEmphasizeOn$ + "  (SysOp)  " + ZEmphasizeOff$ + SPACE$(8) _
      ELSE ZOutTxt$ = SPACE$(19)
      ZOutTxt$ = ZOutTxt$ + _
          ZLastDateTimeOn$ + _
          "   " + _
          ZFG4$ + ZCityState$ + ZEmphasizeOff$
      GOSUB 63583
      ZOutTxt$ = "  DOWNLOADS = " + _
          RIGHT$("     " + STR$(CVI(ZUserDnlds$)),5) + _
          "   " + _
          "UPLOADS = " + _
          RIGHT$("     " + STR$(CVI(ZUserUplds$)),5) + _
          "   " + _
          " Times on ="
       ZOutTxt$ = ZOutTxt$ + RIGHT$("     " + STR$(CVI(MID$(ZUserOption$,1,2))),5) + _
          "   TIME USED= " + _
          STR$(CVI(ZElapsedTime$)) + _
          " Min"
      GOSUB 63583
      ZOutTxt$ = "  Bank Time : " +_
         RIGHT$("     " + STR$(ASC(ZBankTime$)),5)
      ZOutTxt$ = ZOutTxt$ + "   Dropped Carriers : " + _
         RIGHT$("     " + STR$(ASC(ZDropTimes$)),5)
      GOSUB 63583
      IF NOT ZEnforceRatios THEN _
         GOTO 63581
      ZOutTxt$ = "BYTES: Dwn=" + STR$(CVS(ZDlBytes$)) + _
           "  Up=" + STR$(CVS(ZULBytes$)) + _
           " TODAY Dwn: #=" + STR$(CVS(ZTodayDl$)) + _
           " Bytes=" + STR$(CVS(ZTodayBytes$))
      GOSUB 63583
63581 IF (ZStartIndiv = 0 OR ZLenIndiv = 0) AND _
         (ZStartHash = 0 OR ZLenHash = 0) AND _
         NOT ZRestrictByDate THEN _
            GOTO 63582
      IF (ZStartHash > 1 AND ZLenHash > 0) THEN _
         ZOutTxt$ = "Hash: " + MID$(ZUserRecord$,ZStartHash,ZLenHash) _
      ELSE ZOutTxt$ = ""
      IF (ZStartIndiv > 1 AND ZLenIndiv > 0) THEN _
         ZOutTxt$ = ZOutTxt$ + " Indiv: " + MID$(ZUserRecord$,ZStartIndiv,ZLenIndiv)
      IF ZRestrictByDate THEN _
          CALL SetRegDisplay : _
          ZOutTxt$ = ZOutTxt$ + "  Registered: " + _
                     ZRegDisplayDate$
      GOSUB 63583
63582 ZOK = ZTrue
      EXIT SUB
63583 IF ToPrint THEN _
          CALL Printit (ZOutTxt$)
      CALL QuickTPut1 (ZOutTxt$)
      RETURN
      END SUB
'
63585 '  *  CALCULATE REGISTRATION DATES
      ' checks proposed new registration date
'
      SUB ResetRegDate (WorkDate$) STATIC ' Formerly 11470
      IF LEN(WorkDate$) < 10 THEN _
         WorkDate$ = LEFT$(WorkDate$,6) + _
                      "19" + _
                      RIGHT$(WorkDate$,2)
      ZTodayRegYY = VAL(MID$(WorkDate$,7))
      ZTodayRegMM = VAL(LEFT$(WorkDate$,2))
      ZTodayRegDD = VAL(MID$(WorkDate$,4,2))
      ZOK = ZTodayRegYY > 1979 AND ZTodayRegMM > 0 AND _
            ZTodayRegMM < 13 AND ZTodayRegDD > 0 AND _
            ZTodayRegDD < 32
      IF ZOK THEN _
         CALL TwoByteDate (ZTodayRegYY,ZTodayRegMM,ZTodayRegDD,ZRegDate$)
      END SUB
'
'   ***   Sets display of registration date
       SUB SetRegDisplay STATIC  ' Formerly 11480
       WasX$ = MID$(ZUserOption$,11,2)
       IF CVI(WasX$) <> 0 THEN _
          ZRegDate$ = WasX$ : _
       ELSE CALL RegToCurrent
       CALL UnPackDate (ZRegDate$,ZUserRegYY,ZUserRegMM,ZUserRegDD,ZRegDisplayDate$)
       IF CVI(WasX$) = 0 THEN _
          ZRegDisplayDate$ = "00-00-00"
       END SUB
'
'   ***   Sets registration date to current date
       SUB RegToCurrent
       WorkDate$ = DATE$
       CALL ResetRegDate (WorkDate$)
       END SUB
'
63590 ' ChangeInt - General routine to get an integer value.
      '             Calling program has option to show current
      '             value in prompt (ShowCur) when changing from
      '             an old value to a new one, passing current
      '             value in CurVal.   Txt$ is part of prompt that
      '             calling program contributes.  Is whole prompt
      '             if not showing old value, otherwise is just
      '             description of what value represents.
      '                 Pass the inclusive minimum values (MinVal)
      '             and maximum values (MaxVal).
      '                 Returns the value gotten in ZTestedIntValue.
      '
      SUB ChangeInt (ShowCur,Txt$,CurVal,MinVal,MaxVal) STATIC
      IF ZAnsIndex < ZLastIndex THEN _
         GOTO 63594
63592 IF Showcur THEN _
         CALL QuickTPut ("Change ",0) : _
         CALL QuickTPut (Txt$,0) : _
         CALL QuickTPut (" from ",0) : _
         CALL QuickTPut (STR$(CurVal),0) : _
         CALL QuickTPut (" to (",0) _
      ELSE CALL QuickTPut (Txt$,0) : _
           CALL QuickTPut (" (",0)
      IF ZGetExtDesc THEN _
         CALL QuickTPut (STR$(MinVal + 1),0) _
      ELSE _
         CALL QuickTPut (STR$(MinVal),0)
      CALL QuickTPut (" -",0)
      IF ZGetExtDesc THEN _
         CALL QuickTPut (STR$(MaxVal + 1),0) _
      ELSE _
         CALL QuickTPut (STR$(MaxVal),0)
      ZOutTxt$ = ", [Q]uit)"
63594 CALL PopCmdStack
      Temp$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (Temp$)
      CALL Trim (Temp$)
      IF ZSubParm > -1 AND Temp$ <> "Q" AND ZWasQ <> 0 THEN _
         GOTO 63595
      ZWasQ = 0
      IF ShowCur THEN _
         CALL QuickTPut1 ("Unchanged")
      EXIT SUB
63595 IF ZGetExtDesc THEN _
         CALL CheckInt (STR$(VAL(Temp$) - 1)) _
      ELSE CALL CheckInt (Temp$)
      IF Temp$ = "Y" THEN _
         ZLastIndex = ZLastIndex + 1 : _
         ZUserIn$(ZAnsIndex+1) = Temp$ : _
         Temp$ = UCASE$(LTRIM$(ZUserIn$(ZAnsIndex-1))) : _
         CALL CheckInt (Temp$)
      IF ZTestedIntValue < MinVal OR ZTestedIntValue > MaxVal THEN _
         ZLastIndex = 0 : _
         CALL QuickTPut1 ("Min " + STR$(MinVal) + ", Max " + STR$(MaxVal)) : _
         GOTO 63592
      IF ShowCur THEN _
         CALL QuickTPut1 ("Set to " + STR$(ZTestedIntValue))
      END SUB
'
63600 ' MarkItems - Converts a list of items ZUserIn$(), items ZAnsIndex
      '             thru ZLastIndex, into a marked list MarkedList$.
      '
      ' Will also check for the existance of the file, for security breech,
      ' display a macro if one applies, and display to the user the filename,
      ' filesize and approximate time to download the file
      '
      SUB MarkItems (IsMarking,MarkedList$,MarkedDesc$,PersonalDnld)
      IF NOT IsMarking THEN _
         EXIT SUB
      IF ZFileSysParm < 1 THEN
         FOR MarkNum = ZAnsIndex to ZLastIndex
            MarkedList$ = MarkedList$ + ZUserIn$(MarkNum) + ZCarriageReturn$
         NEXT
         CALL ReportMarked (MarkedList$,MarkedDesc$)
         EXIT SUB
      END IF
      FirstMark = ZFalse
      IF MarkedList$ = "" THEN _
         FirstMark = ZTrue
      DidTitle = ZFalse
      IF MarkedDesc$ = "wild" THEN
         WildName$ = ZNodeWorkDrvPath$ + "WILD" + ZNodeId$ + ".DEF"
         FilNum = 13
         CALL OpenRand2 (WildName$,13,FilNum)
         FIELD FilNum,12 AS WildFileName$, _
                       1 AS WildCr$
         HighRec = LOF(FilNum)\13
      END IF
      FOR Temp = ZAnsIndex to ZLastIndex
         IF MarkedDesc$ = "wild" THEN
            IF ABS(INT(VAL(ZUserIn$(Temp)))) > HighRec THEN _
               CALL QuickTPut1 (ZFG5$ + "No such file number " + ZFG7$ + _
                                  ZUserIn$(Temp) + ZEmphasizeOff$) : _
               GOTO 63604
            GET FilNum,ABS(INT(VAL(ZUserIn$(Temp))))
            MarkFileName$ = WildFileName$
            CALL Trim(MarkFileName$)
         ELSE
            MarkFileName$ = UCASE$(ZUserIn$(Temp))
         END IF
         CALL Carrier
63601    IF LEN(MarkFileName$) < 4 AND MarkedDesc$ <> "wild" _
                AND MarkedDesc$ <> "File" THEN _
            CALL NumberCheck(MarkFileName$,FileHasLetter) _
         ELSE FileHasLetter = ZTrue
         IF ZMarkFileNumber$ <> "" AND NOT FileHasLetter _
               AND MarkedDesc$ <> "wild" AND MarkedDesc$ <> "File" THEN
            CALL FindFileNumber(MarkFileName$,NumFileName$,NumFound)
            IF NumFound THEN _
               MarkFileName$ = NumFileName$
         END IF
         CALL Carrier
         IF ZSubParm = -1 THEN
            IF MarkedDesc$ = "wild" THEN _
               CLOSE FilNum
            EXIT SUB
         END IF
         MarkingTime = ZFalse
         CALL Remove (MarkFileName$,", ")
         IF INSTR(MarkFileName$,".") = 0 THEN _
            MarkFileNameAlt$ = MarkFileName$ : _
            MarkFileName$ = MarkFileName$ + "." + ZDefaultExtension$ _
         ELSE _
            MarkFileNameAlt$ = ""
         IF INSTR(MarkedList$,MarkFileName$) > 0 AND MarkedDesc$ <> "File" THEN _
            CALL WipeLine(79) : _
            CALL QuickTPut1 (ZFGF$ + MarkFileName$ + ZFGE$ + " is already " + _
                             "marked for download!" + ZEmphasizeOff$) : _
            GOTO 63604
         MarkFileNameHold$ = UCASE$(MarkFileName$)
         CALL BadFile (MarkFileName$,BadFileNameIndex)
         ON BadFileNameIndex GOTO 63602,63603,63605
63602    IF PersonalDnld THEN _
            DnldType$ = "P" _
         ELSE DnldType$ = "D"
         ZFileName$ = UCASE$(MarkFileName$)
         ZViolation$ = "Mark "
         CALL RotorsDir (MarkFileName$,ZSubDir$(),ZSubDirCount + _
                         ((ZUserSecLevel < ZMinSecToView) OR _
                          NOT ZCanDnldFromUp),MarkingTime,DnldType$)
         CALL BreakFileName (MarkFileName$,Dr$,WasY$,WasX$,ZTrue)
         IF INSTR(MarkedDesc$,"#s") > 0 THEN _
            CALL WipeLine (79)
         IF ZAbort OR ZDotFlag THEN _
            ZAbort = ZFalse : _
            GOTO 63603
         IF NOT ZOK AND PersonalDnld THEN _
            MarkFileName$ = ZPersonalDrvPath$ + WasY$ + WasX$ : _
            CALL FindFile (MarkFileName$,ZOK)
         IF ZWasEL = 20242 AND ZErrCode = 62 THEN _
            CALL UpdtCalr (ZFileSecFile$ + " bad format!",2)
         IF INSTR(ZViolation$, MarkFileName$) > 0 THEN _
            CALL SecViolation : _
            ZFileName$ = "" : _
            GOTO 63604
         IF ZOK THEN
            IF NOT DidTitle AND (MarkedDesc$ = "File" OR MarkedDesc$ = "wild") THEN _
               CALL MarkFileHeader : _
               DidTitle = ZTrue
            IF (MarkedDesc$ = "File" OR MarkedDesc$ = "wild") THEN _
               CALL FormatDisplay (MarkFileName$,WasY$ + WasX$,FirstMark)
            IF MarkedDesc$ <> "File" THEN _
               MarkedList$ = MarkedList$ + WasY$ + WasX$ + ZCarriageReturn$
            FirstMark = ZFalse
            GOTO 63604
         ELSE
            IF MarkFileNameAlt$ <> "" THEN _
               MarkFileName$ = MarkFileNameAlt$ : _
               MarkFileNameAlt$ = "" : _
               GOTO 63602
            MarkFileName$ = WasY$ + WasX$
63603       ZOutTxt$ = ZFGE$ + MarkFileNameHold$ + ZFGF$ + " not found!" + _
                       ZFG1$ + " Enter Correct name" + ZPressEnterExpert$ + _
                       ZEmphasizeOff$
            ZSuspendAutoLogoff = ZFalse
            CALL WipeLine(79)
            ZSubParm = 1
            IF NOT ZNulls THEN _
               ZNoAdvance = ZTrue
            CALL TGet
            CALL WipeLine(79)
            IF ZSubParm < 0 THEN
               ZFileSysParm = 2
               IF MarkedDesc$ = "wild" THEN _
                  CLOSE FilNum
               EXIT SUB
            END IF
            IF ZWasQ = 0 THEN _
               GOTO 63604
            MarkFileName$ = ZUserIn$(1)
            GOTO 63601
         END IF
63604 NEXT
      IF MarkedDesc$ = "wild" THEN _
         CLOSE FilNum
      IF INSTR(ZOutTxt$,"Mark") = 0 AND INSTR(ZOutTxt$," Enter Correct name") = 0 THEN _
         CALL ReportMarked (MarkedList$,MarkedDesc$)
      CALL FindLast (MarkedList$,ZCarriageReturn$,Temp,ZNumMarked)
      EXIT SUB
63605 ZViolation$ = "Marking File " + MarkFileName$
      CALL SecViolation
      IF ZDenyAccess THEN
         ZFileSysParm = 4
         IF MarkedDesc$ = "wild" THEN _
            CLOSE FilNum
         EXIT SUB
      END IF
      GOTO 63603
      END SUB
'
' This will display the file, size, approx time, total approx time
'
      SUB FormatDisplay (FilName$,DFilName$,FirstMark) STATIC
      IF ZUserXferDefault$ = "N" THEN
         ZSpeedFactor! = .95               ' Most use Zmodem for this calc
         ZFLen = 1024
      END IF
      IF FirstMark THEN _
         TotBlocks# = 0
      FilNum = 2
      ZErrCode = 0
      CALL OpenRSeq (FilName$,MaxBlock&,LenLastRec,ZFLen,FilNum)
      IF ZErrCode = 0 THEN
         ZMarkBytesInFile# = LOF(FilNum)
         ZMarkBlocksInFile# = MaxBlock&
         ZNumDnldBytes! = ZNumDnldBytes! + LOF(FilNum)
         CLOSE FilNum
         Blocks# = ZMarkBlocksInFile# / _
            VAL(MID$("00000300045012002400480072009601200144016801920216024002640288038405760", -4 * ZCBPS, 4))
         Blocks# = Blocks# * ZFLen / ZSpeedFactor!
         TotBlocks# = TotBlocks# + Blocks#
         Estimate$ = RIGHT$(SPACE$(5) + STR$(INT(Blocks#/60)),5) + ":" + _
                     RIGHT$(STRING$(2,48) + _
                     LTRIM$(STR$(INT(Blocks#-(INT(Blocks# / 60) * 60)))),2)
         Estimate2$ = RIGHT$(SPACE$(5) + STR$(INT(TotBlocks#/60)),5) + ":" + _
                      RIGHT$(STRING$(2,48) + _
                      LTRIM$(STR$(INT(TotBlocks#-(INT(TotBlocks# / 60) * 60)))),2)
         MBodyTxt$ = ZFGB$ + DFilName$ + _
                     SPACE$(14-LEN(DFilName$)) + _
                     ZFG4$ + STR$(ZMarkBytesInFile#) + _
                     SPACE$(12-LEN(STR$(ZMarkBytesInFile#))) + _
                     ZFG4$ + Estimate$ + _
                     SPACE$(17-LEN(Estimate$)) + _
                     ZFG4$ + Estimate2$ + ZEmphasizeOff$
      ELSE
         MBodyTxt$ = ZFGB$ + DFilName$ + _
                     SPACE$(14-LEN(DFilName$)) + _
                     ZFG4$ + "File size & Dnld est. unavailable at this time" + _
                     ZEmphasizeOff$
      END IF
      CALL QuickTPut1 (MBodyTxt$)
      END SUB
'
' This formats the file display header.  With some modification, it can also
' be used in FileSys where Yaser displays a header.  We can used a passed param
' to alter display format.
'
      SUB MarkFileHeader
      MHedrTxt$ = ZFG1$ + "                            Approx.      Approx. Total"
      CALL QuickTPut1 (MHedrTxt$)
      MHedrTxt$ = ZFG1$ + "FileName       Bytes        DL Time          DL Time  "
      CALL QuickTPut1 (MHedrTxt$)
      MHedrTxt$ = ZFG2$ + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + _
                  ZEmphasizeOff$
      CALL QuickTPut1 (MHedrTxt$)
      END SUB
'
'
'
      SUB ReportMarked (MarkedList$,ListDesc$) ' STATIC
      CALL FindLast (MarkedList$,ZCarriageReturn$,Temp,ZLastIndex)
      IF ListDesc$ = "wild" THEN _
         ListDesc$ = "file"
      IF INSTR(ListDesc$,"#'s") <> 0 THEN _
         ListDesc$ = "file"
      CALL QuickTPut1 (STR$(ZLastIndex) + " " + ListDesc$ + "(s) now marked")
      IF ZAutoEnd <> 5 THEN
         IF ZFileSysParm < 1 THEN
            IF ZNonStop THEN
               ZOneStop = ZTrue
               ZNonStop = ZFalse
            END IF
            CALL AskMore ("",ZTrue,ZFalse,WasX,ZFalse)
         END IF
      END IF
      ZLastIndex = 0
      END SUB
'
63608 ' AskItems - general routine for asking for a list of items.
      '            Calling program instructs what the valid commands
      '            are (ValidCmnd$), what the actual user command is
      '            (UserCmnd$), and whether to Mark the items.  Returns
      '            list of items in ZUserIn$().   Supports lists for viewing,
      '            downloading, and marking.   Gives option to operate
      '            on marked when items have been previously marked.
      '                Calling program tells what to mark (MarkedItems$)
      '            and how to describe the items gathering (ItemDesc$).
      '
      SUB AskItems (ValidCmnd$,UserCmnd$,DoMark,ItemDesc$,MarkedItems$,PersonalDnld)
      CALL AllCaps (UserCmnd$)
      Temp = INSTR(ValidCmnd$,UserCmnd$)
      IF Temp = 0 OR UserCmnd$ = "" THEN _
         EXIT SUB
      IF UserCmnd$ = "W" THEN _
         CALL MarkItems (ZTrue,MarkedItems$,ItemDesc$,PersonalDnld) : _
         EXIT SUB
      Temp = INSTR("VDMU",UserCmnd$)
      ZOutTxt$ = MID$("ViewDnldMarkUpld",4*Temp-3,4) + " what " + ItemDesc$ + "(s)"
      IF Temp = 2 AND ZWildDownOK AND NOT ZPersonalDnld THEN _
         ZOutTxt$ = ZOutTxt$ + " (WildCard '*' OK)"
      IF Temp < 3 THEN IF MarkedItems$ <> "" THEN _
         ZoutTxt$ = ZOutTxt$ + ", M)arked"
      ZStackC = ZTrue
      CALL PopCmdStack
      IF ZWasQ > 0 AND DoMark AND Temp = 3 THEN _
         CALL MarkItems (ZTrue,MarkedItems$,ItemDesc$,PersonalDnld)
      END SUB
'
63610 ' UnMarkItems - takes an input (ZWasZ$), on input item number
      '               "OnItem", where number of last of the inputs
      '               is "LastItem", determines whether the option
      '               is one for marked items, and inserts any marked
      '               items in MarkedList$ into the input stream (ZUserIn$())
      '               at the item number (OnItem).  Reports
      '               whether found marked (FoundMarked),
      '               and if calling programs says to reinitialize
      '               the marked items (ReInit), empties the
      '               list of marked items (MarkedList$) when they
      '               are found.
      '
      SUB UnMarkItems (MarkedList$,OnItem,LastItem,FoundMarked,ReInit) STATIC
      FoundMarked = ZFalse
      CALL AllCaps (ZWasZ$)
      IF MarkedList$ <> "" THEN IF ZWasZ$ ="M" THEN _
         FoundMarked = ZTrue : _
         EndFile = LEN (MarkedList$) : _
         Temp = INSTR(MarkedList$,ZCarriageReturn$) : _
         ZUserIn$(OnItem) = MID$(MarkedList$,1,Temp-1) : _
         StartFile = Temp + 1 : _
         InsertAt = OnItem + 1 : _
         WHILE StartFile < EndFile : _
            Temp = INSTR(StartFile,MarkedList$,ZCarriageReturn$) : _
            FOR X = LastItem TO InsertAt STEP -1 : _
               ZUserIn$(X + 1) = ZUserIn$(X) : _
            NEXT : _
            LastItem = LastItem + 1 : _
            ZUserIn$(InsertAt) = MID$(MarkedList$,StartFile,Temp-StartFile) : _
            InsertAt = InsertAt + 1 : _
            StartFile = Temp + 1 : _
         WEND : _
         IF ReInit THEN _
            MarkedList$ = ""
      END SUB
'
63615 ' * Sets up next message base link *
      SUB NextConf (DoJoin) STATIC
      IF ZLinkedConf$ = "" OR (NOT DoJoin) THEN _
         EXIT SUB
63616 EndConf = INSTR(ZLinkedConf$,ZCarriageReturn$)
      LastConf = (EndConf = LEN(ZLinkedConf$))
      ZHomeConf$ = LEFT$(ZLinkedConf$,EndConf-1)
      IF ZNonStop THEN _
         CALL QuickTPut1 ("Joining linked conference " + ZHomeConf$) _
      ELSE _
         ZOutTxt$ = "Continue to linked conference " + ZHomeConf$ + " ([Y],S)kip,A)bort)" : _
         CALL DeLink (ZHomeConf$) : _
         ZTurboKey = -ZTurboKeyUser : _
         ZSubParm = 1 : _
         CALL TGet : _
         IF ZWasQ > 0 AND NOT ZYes THEN _
            ZWasX$ = ZUserIn$(1) : _
            CALL AllCaps (ZWasX$) : _
            ZLinkedConf$ = ZLinkedConf$ + ZHomeConf$ + ZCarriageReturn$ : _
            IF LastConf OR ZWasX$ = "A" THEN _
               ZHomeConf$ = ""  : _
               ZGlobalRead = ZFalse : _
               EXIT SUB _
            ELSE GOTO 63616
      END SUB
'
63620 ' * Adds/Deletes a new link to conference link list *
      SUB AddLink (Conf$)
      IF INSTR(ZCarriageReturn$+ZLinkedConf$,ZCarriageReturn$+Conf$+ZCarriageReturn$) THEN _
         EXIT SUB
      ZLinkedConf$ = ZLinkedConf$ + Conf$ + ZCarriageReturn$
      END SUB
'
      SUB DeLink (Conf$)
      Temp = INSTR(ZCarriageReturn$+ZLinkedConf$,ZCarriageReturn$+Conf$+ZCarriageReturn$)
      IF Temp > 0 THEN _
         Temp = Temp - 1 : _
         ZLinkedConf$ = LEFT$(ZLinkedConf$,Temp) + RIGHT$(ZLinkedConf$,LEN(ZLinkedConf$)-Temp-LEN(Conf$)-1)
      END SUB
'
63625 ' * Sets SysOp security variables Formerly 5370 of rbbs-pc.bas
      ' * Returns ZWasA true when remote or global sysop
      SUB SetSysOp
      ZRemoteSysop = ((ZActiveUserName$ = ZSecretName$) OR _
                      (ZOrigUserName$ = ZSecretName$))
      ZWasA = ZRemoteSysop
      ZGlobalSysop = (ZGlobalSysop OR (ZWasA AND ZOrigCnfg$ = ZConfigFileName$))
      IF ZGlobalSysop THEN _
         ZWasA = ZTrue
      END SUB
'
63630 ' * Sets the user preferences based on user record.
      ' * Formerly in RBBS-PC.BAS
      SUB SetUserPref STATIC
      IF ZWasA THEN _
         ZUserSecLevel = ZSysopSecLevel _
      ELSE ZUserSecLevel = CVI(ZSecLevel$)
      ZDropTimes = ASC(ZDropTimes$)
      ZBankTime = ASC(ZBankTime$)
      ZLastMsgRead = CVI(MID$(ZUserOption$,3,2))
      ZUserXferDefault$ = MID$(ZUserOption$,5,1)
      IF ZUserXferDefault$ = " " THEN _
         ZUserXferDefault$ = "N"
      CALL XferType (2,ZTrue)
      WasX = ASC(MID$(ZUserOption$,6,1))
      ZWasGR = (WasX MOD 3)
      ZBoldText$ = CHR$(48 - (WasX > 50))
      ZUserTextColor = (WasX - ZWasGR)/3 + 21
      IF ZUserTextColor > 37 THEN _
         ZUserTextColor = ZUserTextColor - 7
      IF ZEmphasizeOff$ <> "" THEN _
         CALL QuickTPut (ZColorReset$,0)
      IF ZEmphasizeOnDef$ <> "" THEN _
         ZEmphasizeOff$ = ZEscape$ + "[" + ZBoldText$ + ";40;" + MID$(STR$(ZUserTextColor),2) + "m" _
      ELSE ZEmphasizeOff$ = ""
      IF ZWasGR = 1 AND NOT ZEightBit THEN _
         ZWasGR = 0
      CALL SetGraphic (ZWasGR)
      ZRightMargin = CVI(MID$(ZUserOption$,7,2))
      IF ZRightMargin > 72 THEN _
         ZRightMargin = 72
      IF NOT ZConfMode THEN _
         ZWasCI$ = ZCityState$ : _
         CALL Trim (ZWasCI$)
      UserOptions = CVI(MID$(ZUserOption$,9,2))
      ZPromptBell = (UserOptions AND 1) > 0
      ZExpertUser = (UserOptions AND 2) > 0
      CALL SetExpert (ZFalse)
      ZNulls = (UserOptions AND 4) > 0
      ZUpperCase = (UserOptions AND 8) > 0
      ZLineFeeds = (UserOptions AND 16) > 0
      ZCheckBulletLogon = (UserOptions AND 32) > 0
      ZSkipFilesLogon = (UserOptions AND 64) > 0
      ZAutoDownDesired = (UserOptions AND 128) > 0
      ZReqQuesAnswered = (UserOptions AND 256) > 0
      ZMailWaiting = (UserOptions AND 512) > 0
      WasX = (UserOptions AND 1024 ) > 0
      CALL SetHiLite (NOT WasX)
      IF NOT ZHiLiteOff THEN _
         CALL QuickTPut (ZEmphasizeOff$,0)
      ZTurboKeyUser = (UserOptions AND 2048) > 0
      ZTurboKey = ZFalse
      ZFileWaiting = (UserOptions AND 4096) > 0
      ZAvailableForChat = (UserOptions AND 8192) > 0
      CALL SetRegDisplay
      ZPageLength = ASC(MID$(ZUserOption$,13,1))
      IF ZSubBoard THEN _
         GOTO 63632
      WasX$ = ZEchoer$
      ZEchoer$ = MID$(ZUserOption$,14,1)
      IF INSTR("ICR",ZEchoer$) = 0 THEN _
         ZEchoer$ = "R"
      IF WasX$ <> ZEchoer$ THEN _
         CALL ReportEcho
      CALL SetEcho (ZEchoer$)
63632 ZNul$ = MID$(STRING$(5,0),1, - 5 * ZNulls)
      CALL SetCrLf
      ZUseTPut = (ZUpperCase OR ZXOnXOff)
      ZPswdSave$ = ZPswd$
      END SUB
'
63635 ' * Reports who is doing echoing.  Formerly 9525 of rbbs-pc.bas
      SUB ReportEcho
      IF ZEchoer$ = "R" THEN _
         ZOutTxt$ =  "RBBS now set" _
      ELSE IF ZEchoer$ = "C" THEN _
              ZOutTxt$ = "Please set your communications package" _
           ELSE ZOutTxt$ = "Intermediate host now set"
      CALL QuickTPut1 (ZOutTxt$ + " to echo what you type")
      END SUB
'
63640 ' * Welcomes caller on
      SUB SayWelcome
      LOCATE 24,1
      CALL AMorPM
      ZUserLogonTime! = TIMER
      ZTimeLoggedOn$ = TIME$
      ZLinesPrinted = 0
      ZExpertUser = ZFalse
      CALL SetExpert (ZFalse)
      ZOutTxt$ = ""
      IF ZMaxNodes > 1 THEN _
         ZOutTxt$ = " - Node " + ZNodeID$
      ZOutTxt$ = ZOutTxt$ + " - connected at " + ZCBaud$ + " bps"
      IF ZReliableMode THEN _
         ZOutTxt$ = ZOutTxt$ + " (Reliable)"
      CALL QuickTPut1 ("Welcome to " + ZRBBSName$ + ZOutTxt$)
      CALL TestANSI
      ZTestParity = ZTrue
      ZStopInterrupts = ZTrue
      ZFileName$ = ZPreLog$
      CALL FlushCom (WasX$)
      ZCommPortStack$ = ""
      END SUB
'
63645 ' * computes the session time.  Formerly 825 in rbbs-pc.bas
      SUB SetSessionTime STATIC
      WasX = (ZMaxPerDay - ZMinsPerSession)
      WasX = -WasX * (WasX > 0)    ' extra from daily max
      ZWasQ! = WasX + ZMinsPerSession + (ZMaxPerDay > 0) * ZElapsedTime
      IF ZWasQ! > ZMinsPerSession AND ZElapsedTime >= 0 THEN _
         ZWasQ! = ZMinsPerSession
      ZSecsPerSession! = ZWasQ! * 60 + ZTimeCredits!
      END SUB
'
63650 ' * Sets privileges based on PASSWRDS file
      ' * Formerly 5135-5160 in RBBS-PC.BAS
      SUB SetPrivileges STATIC
      ZWasZ$ = ""
      CALL SrchPasswrds (Found)
      IF NOT Found THEN _
         ZTempTimeAllowed = ZMinsPerSessionDef : _
         ZTempMaxPerDay = ZMaxPerDayDef : _
         ZTempExpiredSec = ZExpiredSec : _
         ZMaxBank = ZMaxBankTimeDef _
      ELSE ZTimeLockSet = ZTempTimeLock : _
           ZDaysInRegPeriod = ZTempRegPeriod : _
           ZMaxBank = ZTempMaxBank
      ZMinsPerSession = ZTempTimeAllowed
      ZMaxPerDay = -(ZMaxPerDay * (ZTempMaxPerDay <= 0)) - _
                     (ZTempMaxPerDay * (ZTempMaxPerDay > 0))
      IF ZLimitMinsPerSession THEN
         IF ZMinsPerSession > ZLimitMinsPerSession THEN
            ZMinsPerSession = ZLimitMinsPerSession
            CALL QuickTPut1 (ZFGF$ + ZBG1$ + "Mail/Maintenance " + _
                    "event scheduled to start in " + _
                    STR$(ZMinsPerSession) + " Minutes." + _
                    ZEmphasizeOff$)
            ZOutTxt$ = "Shortened your time on for this call"
            CALL SkipLine (1)
            CALL RingCaller
            ZCurrHourDGS = 1
         END IF
      END IF
      CALL SetSessionTime
      END SUB
'
63652 ' * Searches file ZPswdFile$, looking for match to
      ' * ZWasZ$.  Returns whether found in "Found" and sets
      ' * varibles read in by GetPassword
      '
      SUB SrchPasswrds (Found) STATIC
      Found = ZFalse
      GOSUB 63665
      CALL ReadDir (2,1)
      CALL FindLast (ZOutTxt$,",",WhereFound,NumFinds)
      NumFinds = NumFinds + 1
      SEEK 2,1
      MatchPass$ = ZWasZ$
      IF MatchPass$ <> "" THEN _
         MatchPass$ = LEFT$(MatchPass$ + SPACE$(15),15)
      MatchPass = (MatchPass$ <> "")
63654 IF EOF(2) THEN _
         GOTO 63659
63656 CALL GetPassword (NumFinds)
      IF ZErrCode <> 0 THEN _
         CALL UpdtCalr (ZPswdFile$ + " bad format!",2) : _
         GOTO 63659
      IF MatchPass THEN _
         ZTempPassword$ = LEFT$(ZTempPassword$ + SPACE$(15),15) : _
         IF MatchPass$ <> ZTempPassword$ THEN _
            GOTO 63654 _
         ELSE IF ZUserSecLevel >= ZMinSecForTempPswd THEN _
                 GOTO 63658 _
              ELSE GOTO 63654
      IF ZUserSecLevel <> ZTempSecLevel OR ZTempPassword$ <> "" THEN _
         GOTO 63654
      IF ZStartTime = 0 THEN _
         GOTO 63658
      WorkTime$ = TIME$
      TestTime = VAL(LEFT$(WorkTime$,2) + MID$(WorkTime$,4,2))
      IF TestTime => ZStartTime AND TestTime <= ZEndTime THEN _
         GOTO 63658
      IF ZEndTime < ZStartTime THEN _
         IF TestTime => ZStartTime OR TestTime <= ZEndTime THEN _
            GOTO 63658
      GOTO 63654
63658 Found = ZTrue
63659 ZErrCode = 0
      IF ZTempMaxBank > 255 THEN _
         ZTempMaxBank = 255
      IF ZDropCarSecChng > 255 THEN _
         ZDropCarSecChng = 255
      EXIT SUB
63665 CALL OpenWork (2,ZPswdFile$,ZFalse)
      IF ZErrCode > 0 THEN _
         CALL UpdtCalr ("Err"+STR$(ZErrCode)+" opening " + ZPswdFile$,2) : _
         GOTO 63659
      RETURN
      END SUB
'
63675 SUB SetUserUpDn STATIC
      ZDnlds = CVI(ZUserDnlds$)
      ZUplds = CVI(ZUserUplds$)
      ZDropTimes = ASC(ZDropTimes$)
      ZBankTime = ASC(ZBankTime$)
      IF ZEnforceRatios THEN _
         ZDLToday! = CVS(ZTodayDl$) : _
         ZBytesToday! = CVS(ZTodayBytes$) : _
         ZDLBytes! = CVS(ZDlBytes$) : _
         ZULBytes! = CVS(ZULBytes$)
      END SUB
'
      SUB SetGlobalUpDn STATIC
      IF NOT ZGlobalsSet THEN _
         ZGlobalsSet = ZTrue : _
         ZGlobalDnlds = ZDnlds : _
         ZGlobalUplds = ZUplds : _
         ZGlobalDLToday! = ZDLToday! : _
         ZGlobalBytesToday! = ZBytesToday! : _
         ZGlobalDLBytes! = ZDLBytes! : _
         ZGlobalULBytes! = ZULBytes! : _
         ZGlobalDropTimes = ZDropTimes : _
         ZGlobalBankTime = ZBankTime
      END SUB
'
63700 ' $SUBTITLE: 'TestANSI - test caller for ANSI support'
' $PAGE
'
'  NAME    -- TestANSI
'                                  MEANING
'  INPUTS  -- ZTestANSITime   # of seconds to wait for ANSI response
'                             0 = do not test for ANSI
'
'  OUTPUTS -- ZANSITest       = True if ANSI Detected
'
'  PURPOSE -- Test callers' software for support of ANSI graphics
'
      SUB TestANSI
      IF ZTestANSITime < 1 THEN _
         GOTO 63705
      IF ZLocalUser THEN _
         IF ZDOSAnsi THEN _
            GOTO 63710 _
         ELSE GOTO 63705
      CALL QuickTPut1 ("Testing GRAPHICS, Please Wait...")
      CALL SkipLine (1)
      CALL FlushCom(Temp$)
      CALL PutCom (ZEscape$ + "[6n")
      CALL DelayTime(ZTestANSITime)
      CALL WipeLine (5)
      CALL FlushCom(Temp$)
      CALL WipeLine (5)
      Temp = INSTR(Temp$,ZEscape$ + "[")
      IF Temp > 0 THEN _
         Temp = INSTR(Temp,Temp$,"R") : _
         IF TEMP > 0 AND TEMP < 9 THEN _
            GOTO 63710
63705 ZHiLiteOff = ZTrue
      CALL SetGraphic (0)
      EXIT SUB
63710 IF ZCheckForRIP AND NOT ZLocalUser THEN
         CALL FlushCom (Temp$)
         CALL PutCom (ZEscape$ + "[!" + CHR$(8))
         CALL DelayTime (ZTestANSITime)
         CALL WipeLine (5)
         CALL FlushCom (Temp$)
         CALL WipeLine (5)
         Temp = INSTR(Temp$,"RIPSCRIP")
         IF Temp THEN _
            CALL QuickTPut1 ("RIP detected!") : _
            ZRIPTest = ZTrue : _
            GOTO 63712
      END IF
      CALL QuickTPut1 ("ANSI detected!")
63712 CALL SetGraphic(2)
      ZHiLiteOff = ZFalse
      ZANSITest = ZTrue
      END SUB
'
63715 ' Counts the number of words NumFound in ParseThis, defined
      ' as strings separated by those in ExcludeThis$
      '
      SUB ExcludeCount (ExcludeThis$, ParseThis$, NumFound) STATIC
      NumFound = 0
      StartAt = 1
      FOR I = 1 TO LEN(ParseThis$)
         IF INSTR(ExcludeThis$, MID$(ParseThis$, I, 1)) > 0 THEN _
            ParseLen = I - StartAt : _
            IF ParseLen > 0 THEN _
               NumFound = NumFound + 1
      NEXT
      END SUB
'
63720 SUB AraAllCaps (Ara$(1),WhichElement)
      Temp$ = Ara$(WhichElement)
      CALL AllCaps (Temp$)
      Ara$(WhichElement) = Temp$
      END SUB
63750 ' $SUBTITLE: 'GetFastFile - Sets the Fast File Tabs List'
' $PAGE
'
'  NAME    -- GetFastFile
'                                    MEANING
'  INPUTS  -- ZFastFileList$      The FIDX file
'             ZFastFileLocator$   The LIDX file
'
'  OUTPUTS -- ZFastTabs$          The Fast File Tabs string
'             ZFastFileSearch     Set true if fast file system in use
'
'  PURPOSE -- Sees if the tabs file for the fast file is present, and
'             loads it's contants if found.  Originally in RBBS-PC.BAS
'
      SUB GetFastFile
      CALL FindFile (ZFastFileList$,ZOK)
      IF ZOK THEN _
         CALL FindFile (ZFastFileLocator$,ZOK) : _
         IF ZOK THEN _
            ZFastFileSearch = ZTrue : _
            CALL BreakFileName (ZFastFileList$,Drive$,WasX$,ZWasY$,ZTrue) : _
            ZFileName$ = Drive$ + WasX$ + "T" + ZWasY$ : _
            CALL FindFile (ZFileName$,ZOK) : _
            ZErrCode = 0 : _
            IF ZOK THEN _
               FilNum = 2 : _
               CALL OpenRSeq (ZFileName$, WasX, WasY, 160, FilNum) : _
               FIELD FilNum, 160 AS IndexRec$ : _
               GET FilNum, 1 : _
               ZFastTabs$ = IndexRec$ : _
               CLOSE FilNum _
            ELSE ZFastTabs$ = ""
      END SUB
63800 ' $SUBTITLE: 'SelectCD - Select Which CD to display'
' $PAGE
'
'  NAME    -- SelectCD
'                                  MEANING
'  INPUTS  -- WhichDisk         1 - select CD Disk default
'                               2 - select CD Disk (user)
'                               3 - reset system defaults
'
'  OUTPUTS --
'
'  PURPOSE -- Select from a list of CD-ROM disks and set up system for
'             display of list and download of files.
'
      SUB SelectCD (WhichDisk)
      ON WhichDisk GOTO 63801,63801,63830
63801 CDCnfgFile$ = ZNodeWorkDrvPath$ + "CDR" + ZNodeID$ + ".CFG"
      CALL FindFile (CDCnfgFile$,Found)
      IF NOT Found THEN _
         EXIT SUB
      ZAbort = ZFalse
      FilNum = 10
      CALL OpenWork (FilNum,CDCnfgFile$,ZFalse)
      X = 0
      Temp = UBOUND(ZOutTxt$)
      DO WHILE NOT EOF(FilNum)
         X = X + 1
         LINE INPUT #FilNum,ZOutTxt$
         IF Temp < X THEN
            IF FRE(ZOutTxt$(1)) > 4096 THEN
               REDIM PRESERVE ZOutTxt$(X)
            ELSE
               CALL Lprnt ("Too many disks for available memory!",1)
               CALL UpdtCalr ("Too many CD-Disks listed for avail. memory",1)
               EXIT DO
            END IF
         END IF
         ZOutTxt$(X) = ZOutTxt$
      LOOP
      CLOSE FilNum
      IF WhichDisk = 1 THEN _
         Y = 1 : _
         GOTO 63820
63810 CALL SkipLine (1)
      FOR Y = 1 to X
          CALL QuickTPut1 (ZFG7$ + STR$(Y) + SPACE$(4 - LEN(STR$(Y))) + ZFG3$ + _
          MID$(MID$(ZOutTxt$(Y),1,INSTR(ZOutTxt$(Y),",") - 1),1,ZRightMargin - 4) + ZEmphasizeOff$)
          CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
      NEXT
      CALL SkipLine (1)
      ZOutTxt$ = "List which CD-ROM [ENTER] = Quit"
      ZTurboKey = -ZTurboKeyUser
      ZStackC = ZFalse
      CALL PopCmdStack
      IF ZSubParm = -1 THEN _
         GOTO 63827
      IF ZWasQ = 0 THEN _
         ZAbort = ZTrue : _
         GOTO 63827
      IF VAL(ZUserIn$(ZAnsIndex)) < 1 OR VAL(ZUserIn$(ZAnsIndex)) > X THEN _
         CALL QuickTPut1 (ZEmphasizeOn$ + "Ivalid choice.  Must be 1 - " + LTRIM$(STR$(X)) + ZEmphasizeOff$) : _
         GOTO 63810
      Y = VAL(ZUserIn$(ZAnsIndex))
63820 CALL AllCaps (ZOutTxt$(Y))
      X = INSTR(ZOutTxt$(Y),",")
      Z = INSTR(X + 1,ZOutTxt$(Y),",")
      Temp$ = MID$(ZOutTxt$(Y),X + 1,Z - (X+ 1))
      CALL BreakFileName (Temp$,DR$,Pre$,Ext$,ZTrue)
      ZLibDir$ = Temp$
      ZLibDirPath$ = DR$
      ZCurDirPath$ = DR$
      X = INSTR(Z + 1,ZOutTxt$(Y),",")
      Temp$ = MID$(ZOutTxt$(Y),Z + 1,X - (Z + 1))
      ZDirPrefix$ = MID$(Temp$,1,INSTR(Temp$,".") - 1)
      ZLibDirExtension$ = MID$(Temp$,INSTR(Temp$,".") + 1)
      Z = INSTR(X + 1,ZOutTxt$(Y),",")
      ZDirCatFile$ = DR$ + MID$(ZOutTxt$(Y),X + 1,Z - (X + 1))
      X = INSTR(Z + 1,ZOutTxt$(Y),",")
      ZFastFileList$ = DR$ + MID$(ZOutTxt$(Y),Z + 1,X - (Z + 1))
      Z = INSTR(X + 1,ZOutTxt$(Y),",")
      ZFastFileLocator$ = DR$ + MID$(ZOutTxt$(Y),X + 1,Z - (X + 1))
      X = INSTR(Z + 1,ZOutTxt$(Y),",")
      ZLibDrive$ = MID$(ZOutTxt$(Y),Z + 1,1)
      Z = INSTR(X + 1,ZOutTxt$(Y),",")
      ZUseCDWorkDrive = (UCASE$(MID$(ZOutTxt$(Y),X + 1,1)) <> "N")
      X = INSTR(Z + 1,ZOutTxt$(Y),",")
      ZCDMultiChanger = (UCASE$(MID$(ZOutTxt$(Y),Z + 1,1)) = "Y")
      Z = INSTR(X + 1,ZOutTxt$(Y),",")
      IF Z > X + 1 AND MID$(ZOutTxt$(Y),X + 1,1) <> " " THEN
         ZCDRomWorkDir$ = LTRIM$(RTRIM$(UCASE$(MID$(ZOutTxt$(Y),X + 1,Z - (X + 1)))))
         IF RIGHT$(ZCDRomWorkDir$,1) <> "\" THEN _
            ZCDRomWorkDir$ = ZCDRomWorkDir$ + "\"
      ELSE
         ZCDRomWorkDir$ = ZOrigCDRomWorkDir$
      END IF
      ZOptSec(41) = VAL(MID$(ZOutTxt$(Y),Z + 1))
      ZOptSec(45) = VAL(MID$(ZOutTxt$(Y),Z + 1))
      CALL SetPrompt
      CALL SetSection
      IF ZCDMultiChanger THEN _
         ZLibDrive$ = ""
      CALL GetFastFile
63827 REDIM ZOutTxt$(Temp)
      EXIT SUB
63830 ZLibDir$ = ZLibDirSave$
      ZLibDirPath$ = ZLibDirPathSave$
      ZDirPrefix$ = ZDirPrefixSave$
      ZCurDirPath$ = ZCurDirPathSave$
      ZLibDirExtension$ = ZLibDirExtensionSave$
      ZDirCatFile$ = ZDirCatFileSave$
      ZLibDrive$ = ZLibDriveSave$
      ZUseCDWorkDrive = ZFalse
      ZCDMultiChanger = ZFalse
      IF ZFastFileList$ <> ZFastFileListSave$ THEN
         ZFastFileList$ = ZFastFileListSave$
         ZFastFileLocator$ = ZFastFileLocatorSave$
         CALL GetFastFile
      END IF
      ZOptSec(41) = ZOrigSec41
      ZOptSec(45) = ZOrigSec45
      END SUB
'
' $SUBTITLE: 'AutoLogOff - Subroutine to  to log off after transfer'
' $PAGE
'
'  Oringial Code by Maple
'
64950 SUB AutoLogOff STATIC
      ZAutoEnd = 0
      ZAbort = ZFalse
      IF ZGetExtDesc = ZTrue or ZOK = ZFalse or ZAutoLogOffReq = ZTrue THEN _
         EXIT SUB
64960 IF ZExpertUser THEN _
         GOTO 64981
64980 AutoOffFile$ = ZMnuPath$ + "AUTOOFF." + ZMnuExt$
      CALL Graphic(AutoOffFile$,ZTrue)
      IF ZOK THEN _
         CALL BufFile(AutoOffFile$,X,ZFalse)
64981 CALL SkipLine (1)
      CALL QuickTPut (ZFGF$ + "AutoLogOff " + ZFGE$ + _
                 "command: " + ZEmphasizeOff$,0)
      ZOutTxt$ = LEFT$("A)bort",-5 * (NOT ZExpertUser) + 1) + _
        LEFT$(",[C]ontinue",-7 * (NOT ZExpertUser) + 4) + _
        LEFT$(",E)dit",-4 * (NOT ZExpertUser) + 2) + _
        LEFT$(",G)oodbye",-7 * (NOT ZExpertUser) + 2) + _
        LEFT$(",M)ark",-4 * (NOT ZExpertUser) + 2) + ",?" + _
        LEFT$(",H)elp",-4 * (NOT ZExpertUser) + 2)
64990 ZTurboKey = -ZTurboKeyUser
      ZStackC = ZTrue
      CALL PopCmdStack
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         EXIT SUB
      CALL AllCaps (ZUserIn$(ZAnsIndex))
      IF ZWasQ = 0 THEN _
         GOTO 64995
      ON INSTR("CAGH?EM",ZUserIn$(ZAnsIndex)) GOTO 64995,64991,64998,64980,64980,64997,64992
      GOTO 64981
64991 ZAutoEnd = 2               '  ABORT
      GOTO 65000
64992 ZAutoEnd = 5               '  MARK
      GOTO 65000
64995 ZAutoEnd = 3               '  CONTINUE
      GOTO 65000
64997 ZAutoEnd = 4               '  EDIT
      IF ZMarkedFiles$ = "" THEN
         CALL SkipLine(1)
         CALL QuickTPut1(ZFGE$ + "You do not have any Marked Files... " + ZEmphasizeOff$)
         CALL QuickTPut1(ZFGE$ + "Pick " + ZFGF$ + "A)bort " + ZFGE$ + _
                    "to remove File(s) from Queue" + ZEmphasizeOff$)
         CALL DelayTime(2)
         GOTO 64960
      END IF
      IF ZDownFiles < 2 AND ZMarkedFiles$ <> "" THEN
         ZOutTxt$ = "Remove Marked File: " + UCASE$(ZFileNameHold$) + " ([Y],N)"
         ZTurboKey = -ZTurboKeyUser
         CALL PopCmdStack
         IF ZSubParm < 0 THEN _
            ZFileSysParm = 2
         IF NOT ZNo THEN _
            ZMarkedFiles$ = "" : _
            ZMarkBytesInFile# = 0 : _
            ZmarkBlocksInFile# = 0 : _
            ZDownFiles = 0 : _
            ZDGSMarkedFiles$ = "" : _
            ZOK = ZFalse
      END IF
      GOTO 65000
64998 ZAutoEnd = 1               '  GOODBYE
      ZAutoLogoffReq = ZTrue
65000 CALL SkipLine (1)
      END SUB
'
