' $linesize:132
' $title: 'RBBSSUB4.BAS 17.5, Copyright 1986 - 94 by D. Thomas Mack'
'  Copyright 1992 by D. Thomas Mack, all rights reserved.
'  Name ...............: RBBSSUB4.BAS
'  First Released .....: June 21, 1992
'  Subsequent Releases.:
'  Copyright ..........: 1986 - 1994
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'     RBBS-PC.BAS utilizes a lot of common subroutines.  Those that do not
'     require error trapping are incorporated within RBBSSUB 2-7 as
'     separately callable subroutines in order to free up as much
'     code as possible within the 64K code segment used by RBBS-PC.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine      Line       Function of Subroutine
'   Name          Number
' ----------      ------     ----------------------
'  AnyBut         59760      Determine where a "word" begins
'  AskUsers       64003      Ask users questions based on a script and save answers
'  AskMore        59858      Check whether screen full
'  AutoPage       60300      Check whether to notify sysop caller is on
'  BadFileChar    59800      Check file name for bad character
'  Bracket        59960      Puts strings around a substring
'  BufFile        58400      Write a file to the user quickly
'  BufString      58350      Write a string with imbedded CR/LF to the user quickly
'  CheckColor     59930      Highlighting based on search string
'  CmndToggle     64635      Processes user command to T)oggle preferences
'  CmndSysopXfer  64640      Sysop function to change Xfer counts
'  ColorDir       59920      Adds colorization to FMS directory entry
'  ColorPrompt    59940      Colorizes prompts
'  CompDate       59880      Produces a computational data from YY, MM, DD
'  ConfMail       59850      Check conference mail waiting
'  ConvertDir     58950      Checks for U & A (shorthand) and converts appropriately
'  DoorSys        70000      Make DOOR.SYS drop file
'  EofComm        60000      Determine whether any chars in comm port buffer
'  ExpireDate     59890      Calculate registration expiration date
'  FakeXRpt       62650      Write out file transfer report for protocols that don't
'  FindEnd        59770      Find where a "word" ends
'  FindFile       58790      Determine whether a file exists without opening it
'  FindLast       58600      Find last occurence of a string
'  FMS            58200      Search the upload management system for entries
'  FMSHedr        58203      Draws header when listing files
'  GetAll         59780      Get list of all directories to display
'  GetDirs        58895      Prompts for directories for file list/new/search cmds
'  GetMsgAttr     62530      Restore attributes of original message
'  GetYMD         59204      Pulls YY, MM, or DD from a 2 byte stored date
'  GlobalSrchRepl 60100      Global search and replace
'  LogPDown       59400      Records download in private directory
'  MarkTime       60200      Give visual feedback during lengthy process
'  MetaGSR        60130      Meta statement global search and replace
'  MsgImport      59698      Allow local user to import a text file to a message
'  Muzak          59100      Play musical themes for different RBBS functions
'  NewPassword    60668      Get a new password
'  PackDate       59201      Compress date in string format to 2 characters
'  PersFile       59300      Processes requests for personal files
'  PrivDoorRtn    62624      Private door exit routine
'  Protocol       62600      Determine if external protocols are available
'  PutMsgAttr     62520      Save attributes of original message
'  ReadDoorSys    70005      Reads a DOOR.SYS drop file
'  Remove         58210      Remove characters from within strings
'  RotorsDir      58700      Searches for a file using list of subdirs
'  RptTime        62540      Report date/time and time on
'  SearchArray    58190      Check for the occurance of a string in an array
'  SetEcho        59600      Set RBBS properly for who is to echo
'  SetExpert      62660      Adjust for expert change
'  SetHiLite      59934      Set user preference on highlighting
'  SetGraphic     59980      Sets graphic preference for text file display
'  SetNewUserDef  64645      Sets new user defaults
'  SmartText      58250      Process SMART TEXT control strings
'  SubMenu        59500      Processes options that have sub-menus
'  TimedOut       63000      Write timed exit semaphore file
'  TimeLock       60180      Check for TIME LOCK on certain features
'  Transfer       62620      RBBS-PC support for external protocols for file transfer
'  Toggle         57000      Toggles or views user options
'  TwoByteDate    59200      Reduces a data to 2 byte string for space compression
'  UnPackDate     59202      Uncompresses a 2 byte date
'  UserColor      59965      Lets user set color for text and whether bold
'  UserFace       59450      Processes programmable user interface
'  ViewArc        64600      Display .ARC file contents to user
'  WipeLine       58800      Wipes away a line so next prints in its place
'  WordWrap       59703      Adjust a msg -- wrap lines and perserve paragraphs
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
57000 ' $SUBTITLE: 'Toggle - Toggle User Preferences'
' $PAGE
'
'  NAME    -- Toggle
'
'  INPUTS  -- ToggleOption      OPTION TO TOGGLE OR VIEW
'                               ACCORDING TO THE FOLLOWING:
'
'    ToggleOption         PREFERENCE
'   Toggle   VIEW
'     1       -1           Autodownload
'     2       -2           Bulletin review on logon
'     3       -3           Case change
'     4       -4           File review on logon
'     5       -5           Highlight
'     6       -6           Line feeds
'     7       -7           Nulls
'     8       -8           TurboKey
'     9       -9           Expert
'    10      -10           Bell
'    11      -11           Chat Availability
'
'  OUTPUTS -- ZSubParm   passed from TPut
'
'  PURPOSE -- Sets or views any single user preference value
'
      SUB Toggle (ToggleOption) STATIC
      ZSubParm = 0
      IF ToggleOption < 0 THEN _
         GOTO 57005
      ON ToggleOption GOSUB _
         57010, _         'Autodownload
         57120, _         'Bulletin review on logon
         57260, _         'Case change
         57150, _         'File review on logon
         57040, _         'Highlight
         57100, _         'Line feeds
         57210, _         'Nulls
         57230, _         'TurboKey
         57190, _         'Expert
         57170            'Bell
'        57300            'Internode Chat Availability
      EXIT SUB
57005 CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
      ON -ToggleOption GOSUB _
         57030, _         'Autodownload
         57130, _         'Bulletin review on logon
         57270, _         'Case change
         57160, _         'File review on logon
         57050, _         'Highlight
         57110, _         'Line feeds
         57220, _         'Nulls
         57240, _         'TurboKey
         57200, _         'Expert
         57180            'Bell
'        57310            'Internode Chat Availability
      EXIT SUB
57010 '
57020 ZAutoDownDesired = NOT ZAutoDownDesired
57030 ZOutTxt$ = "Autodownload " + FNOffOn$(ZAutoDownDesired)
      CALL QuickTPut1 (ZOutTxt$)
      RETURN
57040 IF ZEmphasizeOnDef$ = "" THEN _
        CALL QuickTPut1 ("Highlighting unavailable") : _
        RETURN
     IF NOT ZHiLiteOff THEN _
        CALL QuickTPut (ZColorReset$,0)
     CALL SetHiLite (NOT ZHiLiteOff)
     GOSUB 57050
     CALL UserColor
     RETURN
57050 IF ZEmphasizeOn$ <> "" THEN _
        ZEmphasizeOff$ = ZEscape$ + "[" + ZBoldText$ + _
        ";40;" + MID$(STR$(ZUserTextColor),2) + "m"
     CALL QuickTPut1 (ZEmphasizeOn$ + "Highlighting" + ZEmphasizeOff$ + _
                 " " + FNOffOn$(NOT ZHiLiteOff))
     RETURN
57100 ZLineFeeds = NOT ZLineFeeds
      IF ZLocalUser THEN _
         ZLineFeeds = ZTrue
57110 CALL QuickTPut1 ("Line Feeds " + FNOffOn$(ZLineFeeds))
      CALL SetCrLf
      RETURN
57120 ZCheckBulletLogon = NOT ZCheckBulletLogon
57130 ZOutTxt$ = MID$("Skip Check",1 -5 * ZCheckBulletLogon,5) + _
           " old Bulletins in logon"
      CALL QuickTPut1 (ZOutTxt$)
      RETURN
57150 ZSkipFilesLogon = NOT ZSkipFilesLogon
57160 ZOutTxt$ = MID$("CheckSkip",1 -5 * ZSkipFilesLogon,5) + _
           " new files in logon"
      CALL QuickTPut1 (ZOutTxt$)
      RETURN
57170 ZPromptBell = NOT ZPromptBell
57180 ZOutTxt$ = "Prompt Bell " + FNOffOn$(ZPromptBell)
      CALL QuickTPut1 (ZOutTxt$)
      RETURN
57190 ZExpertUser = NOT ZExpertUser
      CALL SetExpert (ZFalse)
57200 ZOutTxt$ = MID$("NoviceExpert",1 -6 * ZExpertUser,6)
      CALL QuickTPut1 (ZOutTxt$)
      RETURN
57210 ZNulls = NOT ZNulls
      ZNul$ = MID$(STRING$(5,0),1, - 5 * ZNulls)
      CALL SetCrLf
57220 ZOutTxt$ = "Nulls " + FNOffOn$(ZNulls)
      CALL QuickTPut1 (ZOutTxt$)
      RETURN
57230 ZTurboKeyUser = NOT ZTurboKeyUser
57240 CALL QuickTPut1 ("TurboKey " + FNOffOn$(ZTurboKeyUser))
      RETURN
57260 IF NOT ZUpperCase THEN _
         IF (NOT ZHiLiteOff) OR ZUserGraphicDefault$ = "C" THEN _
            CALL QuickTPut1 ("Graphics & Hilite must be OFF to use UpperCase") : _
            RETURN
      ZUpperCase = NOT ZUpperCase
57270 ZOutTxt$ = "UPPER CASE " + _
            MID$("and lowerONLY",1 - 9 * ZUpperCase,9)
      CALL QuickTPut1 (ZOutTxt$)
57280 ZUseTPut = (ZUpperCase OR ZXOnXOff)
      RETURN
'57300 ZAvailableForChat = NOT ZAvailableForChat
'57310 ZOutTxt$ = "Availability for node chat: " + MID$("NO YES", 1 -3 * ZAvailableForChat, 3)
'      CALL QuickTPut1 (ZOutTxt$)
'      RETURN
      END SUB
'
58190 ' $SUBTITLE: 'SearchArray - subroutine to check for a string in an array'
' $PAGE
'
'  NAME    -- SearchArray
'
'  INPUTS  -- PARAMETER                      MEANING
'             Element$                THE STRING TO CHECK FOR
'             Array$()                THE ARRAY TO BE SEARCHED
'             NumEntriesToSearch      NUMBER OF ENTRIES WITHIN IN
'                                     THE ARRAY TO BE SEARCHED
'
'  OUTPUTS -- IsInAra                 0 = STRING NOT FOUND IN THE
'                                         ARRAY SPECIFIED
'                                     OTHERWISE IT IS THE NUMBER OF
'                                     ELEMENT WITHIN THE ARRAY THAT
'                                     WAS FOUND TO MATCH
'
'  PURPOSE -- Search an array for a specified string and, if found,
'             return the number of the element that matched.
'
      SUB SearchArray (Element$,Array$(1),NumEntriesToSearch,IsInAra) STATIC
      IsInAra = 1
      CALL AllCaps (Element$)
      MaxTries = NumEntriesToSearch + 1
      Array$(MaxTries) = Element$
      WHILE Array$(IsInAra) <> Element$
         IsInAra = IsInAra + 1
      WEND
      IF IsInAra = MaxTries THEN _
         IsInAra = 0
      END SUB
'
58200 ' $SUBTITLE: 'FMS - subroutine to search the upload management system'
' $PAGE
'
'  NAME    -- FMS
'
'  INPUTS  -- PARAMETER                      MEANING
'             DirToSearch$          RBBS-PC "DIR" CATEGORY TO LOOK
'                                     FOR
'             SearchString$          STRING TO SEARCH FOR
'             SearchDate$            DATE TO SEARCH FOR
'             ZCategoryName$()
'             ZCategoryCode$()
'             ZCategoryDesc$()
'             CatFound
'             ZNumCategories
'
'  OUTPUTS -- ProcessedInFMS
'             DnldFlag
'
'  PURPOSE -- To search the file management system and display the
'             files being searched for as well as the catetory descriptions
'
      SUB FMS (DirToSearch$,SearchString$,SearchDate$, _
               ProcessedInFMS,ZCategoryName$(1),ZCategoryCode$(1), _
               ZCategoryDesc$(1),DnldFlag,CatFound,AbortIndex) STATIC
      DnldFlag = 0
      CALL SearchArray (DirToSearch$,ZCategoryName$(),ZNumCategories,CatFound)
      ProcessedInFMS = ProcessedInFMS OR (CatFound > 0)
      IF ProcessedInFMS THEN
         ZSubParm = 5
         IF ZRIPTest = ZTrue THEN
            CALL FindFile (ZFileScanRIP$,FoundRip)
            IF FoundRip THEN
               ZNonStop = ZTrue
               CALL BufFile (ZFileScanRIP$,WasX,ZTrue)
               ZNonStop = ZFalse
               ZLinesPrinted = 0
            END IF
         ELSE
            FilName$ = ZDirPath$ + "FMSHEAD.TXT"
            CALL Graphic (FilName$,ZTrue)
            IF ZOK THEN
               GOSUB 58202
               ZDirToSearch$ = DirToSearch$
               ZHDR$ = HDR$
               ZCatDesc$ = ZCategoryDesc$(CatFound)
               CALL BufFile (FilName$,ZWasX,ZTrue)
            END IF
         END IF
         Cat$ = ZCategoryCode$(CatFound)
         TurboTemp = ZTurboKeyUser
         CALL SetExpert (ZTrue)
         CALL DispUpDir (Cat$,SearchString$,SearchDate$,DnldFlag,AbortIndex)
         CALL SetExpert (ZFalse)
         ZTurboKeyUser = TurboTemp
      END IF
      EXIT SUB
58202 ZOutTxt$ = SearchDate$
      IF LEN(ZOutTxt$) > 0 THEN _
         ZOutTxt$ = MID$(ZOutTxt$,3) + LEFT$(ZOutTxt$,2)
      HDR$ = SearchString$ + _
             ZOutTxt$
      IF HDR$ <> "" THEN _
         HDR$ = ZFGE$ + "Scanning for " + ZFGF$ + HDR$
      RETURN
      END SUB
'
58210 ' $SUBTITLE: 'Remove - subroutine to delete a string from within a string'
' $PAGE
'
'  NAME    -- Remove
'
'  INPUTS  -- PARAMETER                      MEANING
'             BADSTRING$              STRING CONTAINING CHARACTERS
'                                     TO BE DELETED FROM "WasL$"
'             WasL$                      STRING TO BE ALTERED
'
'  OUTPUTS -- WasL$                      WITH THE CHARACTERS IN
'                                     "BADSTRING$" DELETED FROM IT
'
'  PURPOSE -- To remove all instances of the characters in
'                        "BADSTRING$" from "WasL$"
'
      SUB Remove (WasL$,BadString$)
      WasJ = 0
      FOR WasI=1 TO LEN(WasL$)
         IF INSTR(BadString$,MID$(WasL$,WasI,1)) = 0 THEN _
            WasJ = WasJ + 1 : _
            MID$(WasL$,WasJ,1) = MID$(WasL$,WasI,1)
      NEXT WasI
      WasL$ = LEFT$(WasL$,WasJ)
      END SUB
'
58250 ' $SUBTITLE: 'SmartText - smart text substitution'
' $PAGE
'
'  NAME    -- SmartText   (WRITTEN BY DOUG AZZARITO)
'                          Additional Foreground/Background
'
'  INPUTS  -- StringWork$        STRING TO SCAN FOR SMART TEXT
'             CRFound            DOES THIS LINE CONTAIN A CR?
'             ZSmartTextCode     SMART TEXT CONTROL CODE
'
'  OUTPUTS -- StringWork$        INPUT STRING WITH TEXT REPLACED
'
'  PURPOSE -- Smart Text allows control strings in text files
'             to be replaced at runtime with user info or other
'             data.  The Smart Text control code is a 1-byte
'             code (configurable) with a 2-byte action code.
'
      SUB SmartText (StringWork$, CRFound, OverStrike) STATIC
      IF SmartCarry$ <> "" THEN _
         StringWork$ = SmartCarry$ + StringWork$
      Index = INSTR(StringWork$, ZSmartTextCode$)
      WHILE Index > 0 AND Index < LEN(StringWork$)-1
         IF INSTR(MID$(StringWork$, Index+1,2)," ") THEN _
            SmartAct = 0 _
         ELSE SmartAct = INSTR(ZSmartTable$, MID$(StringWork$, Index+1, 2))
         IF SmartAct = 0 THEN _
            WasI = 1 : _
            GOTO 58254
         SmartAct = (SmartAct+2)/3
         IF SmartAct > 50 THEN _
            GOTO 58251
         ON SmartAct GOSUB 58260, 58261, 58262, 58263, 58264, _
                           58265, 58266, 58267, 58268, 58269, _
                           58270, 58271, 58272, 58273, 58274, _
                           58275, 58276, 58277, 58296, 58297, _
                           58298, 58299, 58278, 58279, 58280, _
                           58281, 58282, 58283, 58284, 58285, _
                           58286, 58287, 58289, 58290, 58291, _
                           58292, 58293, 58294, 58295, 58255, _
                           58300, 58301, 58302, 58303, 58304, _
                           58305, 58306, 58307, 58308, 58309
         GO TO 58253
58251    SmartActTemp = SmartAct - 50
         ON SmartActTemp GOSUB _
                           58310, 58311, 58312, 58313, 58314, _
                           58315, 58316, 58317, 58319, 58318, _
                           58320, 58321, 58322
58253    GOSUB 58256
         WasI = LEN(SmartHold$)
         ReplaceLen = 3
         IF OverStrike OR Overlay THEN _
            IF WasI > 2 THEN _
               ReplaceLen = WasI _
            ELSE SmartHold$ = SmartHold$ + SPACE$(3 - WasI)
         StringWork$ = LEFT$(StringWork$, Index-1) + SmartHold$ + _
                       MID$(StringWork$,Index+ReplaceLen)
58254    Index = INSTR(Index+WasI, StringWork$, ZSmartTextCode$)
      WEND
      IF Index AND (Index > LEN(StringWork$)-2) AND NOT CRFound THEN _
         SmartCarry$ = MID$(StringWork$,Index) : _
         StringWork$ = LEFT$(StringWork$,Index-1) : _
      ELSE SmartCarry$ = ""
      EXIT SUB
58255 SmartHold$ = STR$(ZDropTimes)         ' DC Carrier Drops
      CALL Trim (SmartHold$)
      RETURN
58256 IF TrimSmart THEN _
         CALL Trim (SmartHold$)
      RETURN
58258 ZLastSmartColor$ = SmartHold$
      RETURN
58260 ZLinesPrinted = 0                     ' CS (Clear screen line count reset)
      SmartHold$ = ""
      RETURN
58261 ZLinesPrinted = ZPageLength           ' PB Page Break
      IF ZNonStop THEN _                    ' force a 1-time pause
         ZOneStop = ZTrue : _               ' if NON STOP is on
         ZNonStop = ZFalse
      SmartHold$ = ""
      ZForceKeyboard = ZTrue
      RETURN
58262 ZNonStop = ZTrue                      ' NS Non-stop
      SmartHold$ = ""
      RETURN
58263 IF ZGlobalSysop THEN _                ' FN First Name
         SmartHold$ = ZOrigSysopFN$ _
      ELSE SmartHold$ = ZFirstName$
      CALL NameCaps(SmartHold$)
      RETURN
58264 IF ZGlobalSysop THEN _
         SmartHold$ = ZOrigSysopLN$ _
      ELSE SmartHold$ = ZLastName$
      CALL NameCaps(SmartHold$)
      RETURN
58265 SmartHold$ = STR$(ZUserSecLevel)      ' SL Security level
      CALL Trim (SmartHold$)
      RETURN
58266 SmartHold$ = DATE$                    ' DT Date
      RETURN
58267 CALL AMorPM
      SmartHold$ = ZTime$                   ' TM Time
      RETURN
58268 CALL TimeRemain(MinsRemaining)
      SmartHold$ = MID$(STR$(INT(MinsRemaining)),2)
      RETURN
58269 CALL TimeRemain(MinsRemaining)        ' TE Time elapsed (mm:ss)
      SmartHold$ = MID$(STR$(INT(ZSecsUsedSession!/60)),2)+":"+ _
         MID$(STR$((ZSecsUsedSession! MOD 60)+100),3)
      RETURN
58270 SmartHold$ = MID$(STR$(INT((ZTempTimeLock+0.5)/60)),2) ' TL - Time Lock period
      SmartHold$ = SmartHold$ + ":"+ MID$(STR$((ZTempTimeLock MOD 60)+100),3)
      RETURN
58271 SmartHold$ = MID$(STR$(ZDaysInRegPeriod),2)
      RETURN                                ' RP Registration Length
58272 SmartHold$ = MID$(STR$(ZRegDaysRemaining),2)
      RETURN                                ' RR Registration Remaining
58273 SmartHold$ = ZCityState$              ' CT Users CITY & STATE
      CALL Trim (SmartHold$)
      RETURN
58274 SmartHold$ = ZFG1$                    ' C1 Color 1
      GOTO 58258
58275 SmartHold$ = ZFG2$                    ' C2 Color 2
      GOTO 58258
58276 SmartHold$ = ZFG3$                    ' C3 Color 3
      GOTO 58258
58277 SmartHold$ = ZFG4$                    ' C4 Color 4
      GOTO 58258
58278 SmartHold$ = ZEmphasizeOff$           ' C0 Reset color
      ZLastSmartColor$ = ""
      RETURN
58279 SmartHold$ = MID$(STR$(INT(ZDLToday!)),2)
      RETURN                                ' DD files Dnlded TODAY
58280 SmartHold$ = MID$(STR$(INT(ZBytesToday!)),2)
      RETURN                                ' BD Bytes Dnlded TODAY
58281 SmartHold$ = MID$(STR$(INT(ZDLBytes!)),2)
      RETURN                                ' DB Download Bytes
58282 SmartHold$ = MID$(STR$(INT(ZULBytes!)),2)
      RETURN                                ' UB Upload Bytes
58283 SmartHold$ = MID$(STR$(ZDnlds),2)     ' DL Number of Dnlds
      RETURN
58284 SmartHold$ = MID$(STR$(ZUplds),2)     ' UL Number of Uplds
      RETURN
58285 SmartHold$ = ZFileName$               ' FI  File Name
      RETURN
58286 Overlay = ZTrue                       ' VY Overlay ON
      GOTO 58288
58287 Overlay = ZFalse                      ' VN Overlay OFF
58288 SmartHold$ = ""
      RETURN
58289 TrimSmart = ZTrue                     ' TY Trim Yes
      GOTO 58288
58290 TrimSmart = ZFalse                    ' TN Trim No
      GOTO 58288
58291 SmartHold$ = ZRBBSName$               ' BN Board Name
      RETURN
58292 SmartHold$ = ZNodeID$                 ' ND Node Number
      IF SmartHold$ >= "A" THEN _
         SmartHold$ = MID$(STR$(ASC(SmartHold$) - 54),2)
      RETURN
58293 SmartHold$ = ZSysopFirstName$         ' FS Sysops First Name
      CALL NameCaps(SmartHold$)
      RETURN
58294 SmartHold$ = ZSysopLastName$          ' LS Sysops Last Name
      CALL NameCaps(SmartHold$)
      RETURN
58295 SmartHold$ = ZConfName$               ' CN Conference Name
      RETURN
58296 SmartHold$ = ZFG5$                    ' C5 Color 5
      GOTO 58258
58297 SmartHold$ = ZFG6$                    ' C6 Color 6
      GOTO 58258
58298 SmartHold$ = ZFG7$                    ' C7 Color 7
      GOTO 58258
58299 SmartHold$ = ZFG8$                    ' C8 Color 8
      GOTO 58258
58300 SmartHold$ = ZFG9$                    ' C9 Color 9
      GOTO 58258
58301 SmartHold$ = ZFGA$                    ' CA Color 10
      GOTO 58258
58302 SmartHold$ = ZFGB$                    ' CB Color 11
      GOTO 58258
58303 SmartHold$ = ZFGC$                    ' CC Color 12
      GOTO 58258
58304 SmartHold$ = ZFGD$                    ' CD Color 13
      GOTO 58258
58305 SmartHold$ = ZFGE$                    ' CE Color 14
      GOTO 58258
58306 SmartHold$ = ZFGF$                    ' CF Color 15
      GOTO 58258
58307 SmartHold$ = ZBG0$                    ' G0 Background Color 1
      GOTO 58258
58308 SmartHold$ = ZBG1$                    ' G1 Background Color 2
      GOTO 58258
58309 SmartHold$ = ZBG2$                    ' G2 Background Color 3
      GOTO 58258
58310 SmartHold$ = ZBG3$                    ' G3 Background Color 4
      GOTO 58258
58311 SmartHold$ = ZBG4$                    ' G4 Background Color 5
      GOTO 58258
58312 SmartHold$ = ZBG5$                    ' G5 Background Color 6
      GOTO 58258
58313 SmartHold$ = ZBG6$                    ' G6 Background Color 7
      GOTO 58258
58314 SmartHold$ = ZBG7$                    ' G7 Background Color 8
      GOTO 58258
58315 SmartHold$ = ZDirToSearch$         'FD
      RETURN
58316 SmartHold$ = ZHDR$                 'FH
      RETURN
58317 SmartHold$ = ZCatDesc$             'FC
      RETURN
58318 SmartHold$ = STR$(ZBaudTest!)         ' BA Baud Rate
      RETURN
58319 IF ZOnlyOneTimeLockPerDay AND LEFT$(ZLastDateTimeOnSave$,8) = ZCurDate$ THEN _
         CALL TimeRemain(MinsRemaining) : _ ' LT - Time Lock period elapsed
         Temp = INT(ZSecsUsedSession!/60) : _
         Temp = Temp + CVI(ZElapsedTime$) : _
         SmartHold$ = MID$(STR$(Temp),2) + ":" + _
         MID$(STR$((ZSecsUsedSession! MOD 60) + 100),3) : _
         RETURN _
      ELSE _
         GOTO 58269
58320 SmartHold$ = STR$(ZGlobalBankTime)    ' BT Banked Time
      RETURN
58321 SmartHold$ = ZUserXferDefault$        ' TP Transfer Protocol
      RETURN
58322 SmartHold$ = ZFGG$                    ' CG Color 16
      GOTO 58258
      END SUB
'
58350 ' $SUBTITLE: 'BufString - write a string with imbedded ZCR/LF'
' $PAGE
'
'  NAME    -- BufString
'
'  INPUTS  -- PARAMETER                      MEANING
'             PassedStrng$           STRING TO BE WRITTEN OUT
'             DataSize               LENGTH OF STRING - # LEFT
'                                        CHARS TO OUTPUT
'
'  OUTPUTS -- PassedStrng$           IS WRITTEN TO THE USER
'
'  PURPOSE -- To search the string, PassedStrng$, for embedded carriage
'             returns and line feeds and write out each line with
'             the appropriate substitution (cr/lf if to the local
'             screen or cr/nulls/lf if to the communications port).
'
      SUB BufString (PassedStrng$,PassedDataSize,AbortIndex) STATIC
'print "^";passedstrng$;"^"
      WasL = LEN(PassedStrng$)
'print "passed length=";wasl;" pds=";passeddatasize
      IF PassedDataSize < WasL THEN _
         WasL = PassedDataSize
      IF WasL = 0 THEN _
         EXIT SUB
      Temp = LEN(Hold$)
      IF WasL = -1 THEN _         ' Clear Buffer
         IF Temp < 1 THEN _
            EXIT SUB _
         ELSE WasL = 0
      IF LEN(Strng$) >= WasL+Temp THEN _
         LSET Strng$ = Hold$ : _
         MID$(Strng$,Temp+1) = PassedStrng$ _
      ELSE Strng$ = Hold$ + PassedStrng$
'if len(hold$) > 0 then print "adding <";hold$;">":input xxx$
'print "hold len=";temp;" wasl=";wasl
      WasL = WasL + LEN(Hold$)
      Hold$ = ""
      ZFF = ZPageLength - 1
      StartByte = 1
      ZRet = ZFalse
      IF CarryOver THEN _
         IF ASC(Strng$) = 10 THEN _
            StartByte = 2 : _
            CALL SkipLine (1+ZJumpSearching)
      CarryOver = (MID$(Strng$,WasL,1) = ZCarriageReturn$)
      WasL = WasL + CarryOver
58351 CRat = INSTR(StartByte,Strng$,ZCarriageReturn$)
      IF CRat > 0 AND CRat < WasL THEN _
         CRFound = (MID$(Strng$,CRat + 1,1) = ZLineFeed$) _
      ELSE CRFound = ZFalse
      EOLlen = -2 * CRFound
      IF CRFound THEN _
         EOD = CRat _
      ELSE EOD = WasL + 1
      NumBytes = EOD - StartByte
      StringWork$ = MID$(Strng$,StartByte,NumBytes)
      IF NOT ZDeleteInvalid THEN _
         GOTO 58352
      Index = INSTR(StringWork$,"[")
      WasJ = LEN(StringWork$) - 1
      WHILE Index > 0 AND Index < WasJ
         IF MID$(StringWork$,Index + 2,1) = "]" THEN _
            IF INSTR (ZInvalidOpts$,MID$(StringWork$,Index + 1,1)) THEN _
               MID$(StringWork$,Index + 1,1) = "*"
         Index = INSTR(Index + 1,StringWork$,"[")
      WEND
58352 IF ZJumpSearching THEN _
         Temp$ = StringWork$ : _
         CALL AllCaps (Temp$) : _
         HiLitePos = INSTR (Temp$,ZJumpTo$) : _
         IF HiLitePos = 0 THEN _
            GOTO 58357 _
         ELSE CALL Bracket (StringWork$,HiLitePos,HiLitePos+LEN(ZJumpTo$)-1,ZEmphasizeOn$,ZEmphasizeOff$) : _
              ZJumpSearching = ZFalse
      IF ZSmartTextCode THEN _
         CALL SmartText (StringWork$, CRFound, ZFalse)
      IF NOT ZLocalUser THEN _
         CALL EofComm (Char) : _
         IF Char <> -1 THEN _
            GOTO 58353            ' comm port input
      ZKeyboardStack$ = INKEY$ : _
      IF ZKeyboardStack$ <> "" THEN _  ' keyboard input
         GOTO 58353
      CALL QuickTPut (StringWork$, - (CRFound))
      GOTO 58354
58353 ZOutTxt$ = StringWork$
      ZSubParm = 4
      IF CRFound THEN ZSubParm = 5
      CALL TPut
58354 IF ZRet THEN
         IF ZFossil THEN
            CALL FosTxPurge(ZComPort)
            CALL SkipLine (1)
            CALL QuickTPut (ZEmphasizeOff$,0)
         END IF
         EXIT SUB
      END IF
      IF ZLinesPrinted < ZFF THEN _
         GOTO 58357
58355 CALL CheckTimeRemain (MinsRemaining)
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         EXIT SUB
      IF ZNonStop THEN _
         GOTO 58357
      IF NOT CRFound THEN _
         GOTO 58357
      ZForceKeyboard = ZTrue
      CALL AskMore ("",ZTrue,ZFalse,AbortIndex,ZStopInterrupts)
      IF ZNo THEN _
         ZRet = ZTrue : _
         EXIT SUB
58357 StartByte = EOD + EOLlen
      IF StartByte <= WasL THEN _
         GOTO 58351
      END SUB
'
58400 ' $SUBTITLE: 'BufFile - subroutine to write a sequential file to the user'
' $PAGE
'
'  NAME    -- BufFile
'
'  INPUTS  -- PARAMETER                      MEANING
'             FileName$               NAME OF THE FILE TO WRITE
'                                     OUT TO THE USER
'             AbortIndex              PASSED TO BUFSTRING FUNCTION
'             BMode                   TO USE FINDIT OR FINDFILE
'                                     ZFALSE = FINDIT  ZTRUE = FINDFILE
'
'                              NOTE:  USE ZFalse when a call to GRAPHIC
'                                     using ZTRUE is used first.
'                              NOTE:  FINDITX OPENS THE FILE
'                              NOTE:  FINDFILE DOES NOT OPEN FILE
'
'
'  OUTPUTS -- NONE                    FILE IS WRITTEN TO THE USER
'
'  PURPOSE -- To display a sequential file to the user
'
      SUB BufFile (FilName$,AbortIndex,BMode) STATIC
      IF NOT BMode THEN _
         CALL FindIt (FilName$) _
      ELSE CALL FindFile (FilName$,ZOK)
      IF NOT ZOK THEN _
         GOTO 58419
      FilNum = 2
      ZNo = ZFalse
      CALL OpenRSeq (FilName$,NumRecs,LenLastRec,ZBufferSize,FilNum)
      IF ZErrCode > 0 THEN _
         GOTO 58419
      DataSize = ZBufferSize
      FIELD FilNum, DataSize AS SeqRec$
      ZNonStop = ZNonStop OR (ZPageLength < 1)
      ZJumpLast$ = ""
      ZJumpSearching = ZFalse
      ZJumpSupported = ZTrue
      IF NOT ZStopInterrupts THEN _
         IF NOT ZConcatFIles THEN _
            IF NOT ZNonStop THEN _
               IF NOT ZExpertUser AND ZCtrlX THEN _
                  ZOutTxt$ = "* Ctrl-K(^K) / ^X aborts. ^S suspends ^Q resumes *" : _
                  ZSubParm = 2 : _
                  CALL TPut
      WasTU = 0
      SecLevelHold = ZUserSecLevel
58405 WasTU = WasTU + 1
      IF WasTU < NumRecs THEN _
         GET FilNum,WasTU _
      ELSE IF WasTU = NumRecs THEN _
              GET FilNum,WasTU : _
              WasX = INSTR(SeqRec$,CHR$(26)) : _
              IF WasX = 0 OR WasX > LenLastRec THEN _
                 DataSize = LenLastRec _
              ELSE DataSize = WasX - 1 _
           ELSE GOTO 58419
      CALL BufString (SeqRec$,DataSize,AbortIndex)
58408 IF ZSubParm <> -1 AND NOT ZRet THEN _
         GOTO 58405
58419 IF ZUserSecLevel <> SecLevelHold THEN _
         CALL SetPrivileges
      CLOSE FilNum
      CALL BufString ("",-1,AbortIndex)
      ZBypassTimeCheck = ZFalse
      ZStopInterrupts = ZFalse
      CALL QuickTPut (ZEmphasizeOff$,0)
      ZJumpSupported = ZFalse
      END SUB
'
58600 ' $SUBTITLE: 'FindLast - find last occurence of a string'
' $PAGE
'
'  NAME    -- FindLast
'
'  INPUTS  -- PARAMETER             MEANING
'              LookIn$           STRING TO LOOK INTO
'              LookFor$          STRING TO SEARCH FOR
'
'  OUTPUTS -- WhereFound        POSITION IN LookIn$ THAT
'                                   LookFor$ Found
'             NumFinds          HOW MANY OCCURENCES IN LookIn$
'
'  PURPOSE -- Finds last occurence of LookFor$ in LookIn$ and
'             returns count of # of occurences.  If none found,
'             both returned parameters are set to 0.
'
      SUB FindLast (LookIn$,LookFor$,WhereFound,NumFinds)
      WhereFound = INSTR(LookIn$,LookFor$)
      NumFinds = -(WhereFound > 0)
      NextFound = INSTR(WhereFound + 1,LookIn$,LookFor$)
      WHILE NextFound > 0
         NumFinds = NumFinds + 1
         WhereFound = NextFound
         NextFound = INSTR(WhereFound + 1,LookIn$,LookFor$)
      WEND
      END SUB
'
58700 ' $SUBTITLE: 'RotorsDir - search thru a list of subdirs for a file'
' $PAGE
'
'  NAME    -- RotorsDir
'
'  INPUTS  --     PARAMETER                    MEANING
'             FilName$                  FILE NAME TO LOOK FOR
'             SDIR.ARA                  ARRAY OF SUBDIRECTORIES
'             MaxSearch                 MAX # OF SUBDIRECTORIES
'             MarkingTime               WHETHER TO MARK TIME
'
'  OUTPUTS -- FNAME$                    ADD SUBDIRECTORY TO THE
'                                       FILE NAME IF FOUND.  OTHER-
'                                       WISE DON'T.
'             ZOK                       TRUE IF FILE WAS FOUND
'
'  PURPOSE -- Hunt through a list of subdirectories to determine
'             if a file is in any of them.  If file is found, open
'             the file as file #2, add the drive/path to the file
'             name, and sets ZOK to true.  If file isn't found, set
'             file name to the last subdirectory searched -- which
'             should be the upload subdirectory.
'
      SUB RotorsDir (FilName$,SDirAra$(1),MaxSearch,MarkingTime,PassToMacro$) STATIC
      FilNum = 2
      ZOK = ZFalse
      ZDotFlag = ZFalse
      IF ZMenuIndex = 6 AND ZCDRom AND ZUseCDWorkDrive THEN
         NoticeSent = ZFalse
         X = 1
         WasX = 0
58701    CALL FindFile ("CDWORK" + ZLibDrive$ + ".WRK",Found)
         IF Found THEN
            CALL OpenWork (FilNum,"CDWORK" + ZLibDrive$ + ".WRK",ZFalse)
            CALL ReadDir (FilNum,1)
            CLOSE FilNum
            IF ZOutTxt$ = ZNodeID$ AND ZCDWorkDriveFull THEN _
               GOTO 58703
            CALL Carrier
            IF ZSubParm = -1 THEN _
               EXIT SUB
            IF NOT NoticeSent THEN _
               CALL QuickTPut (ZFG1$ + "CD ROM Drive is busy...please wait" + _
                                 ZEmphasizeOff$,0) : _
               NoticeSent = ZTrue
            CALL Delaytime (1)
            CALL MarkTime (WasX)
            X = X + 1
            IF X = 30 THEN _          ' Allow 30 seconds for clear
               CALL SkipLine (1) : _
               CALL QuickTPut1 (ZEmphasizeOn$ + "File " + FilName$ + _
                                " currently unavailable...please try again!" + _
                                 ZEmphasizeOff$) : _
               ZDotFlag = ZTrue : _
               GOTO 58710
            GOTO 58701
         END IF
      END IF
58703 IF MarkingTime THEN _
         CALL QuickTPut (ZFG5$ + "Searching for " + ZFG7$ + FilName$ + ZEmphasizeOff$,0)
      NumSearch = 1
      WasX = 0
      WHILE (NOT ZOK) AND NumSearch <= MaxSearch AND _
         SDirAra$(NumSearch) <> ""
         WasX$ = SDirAra$(NumSearch) + FilName$
         CALL FindFile (WasX$,ZOK)
         NumSearch = NumSearch + 1
      WEND
      IF ZOK OR NOT ZFastFileSearch THEN _
         GOTO 58710
      FSize = 21
      CALL OpenRSeq (ZFastFileList$,HighRec&,WasX,FSize,FilNum)
      FIELD FilNum, 12 AS SearchFile$, _
                     4 AS SearchPath$, _
                     3 AS SearchDate$, _
                     2 AS SearchCrLf$
      GET FilNum,1
      IF SearchCrLf$ <> ZCrLf$ THEN _
         CLOSE FilNum : _
         FSize = 18 : _
         CALL OpenRSeq (ZFastFileList$,HighRec&,WasX,FSize,FilNum)
      IF ZErrCode <> 0 THEN _
         GOTO 58710
      CALL TrimTrail (FilName$,".")
      CALL BinSearch (FilName$,1,12,FSize,HighRec&,RecFoundAt&,RecFound$,FilNum,WCSearch)
      ZOK = (RecFoundAt& > 0)
      IF NOT ZOK THEN _
         GOTO 58710
      ZOK = ZFalse
      CALL CheckInt (MID$(RecFound$,13,4))
      IF ZTestedIntValue < 1 THEN _
         GOTO 58710
      Temp$ = WasX$
      IF FSize = 21 THEN
         WasX$ = DATE$
         LSET SearchDate$ = CHR$(VAL(MID$(WasX$,9,2))-48) + _
                            CHR$(VAL(MID$(WasX$,1,2))+31) + _
                            CHR$(VAL(MID$(WasX$,4,2))+31)
         PUT FilNum, RecFoundAt&
      END IF
      CALL OpenRSeq (ZFastFileLocator$,HighRec&,WasX,66,FilNum)
      IF ZErrCode <> 0 OR ZTestedIntValue > HighRec& THEN _
         GOTO 58710
      FIELD FilNum, 66 AS LocatorRec$
      GET FilNum, ZTestedIntValue
      Temp$ = WasX$
      WasX$ = LEFT$(LocatorRec$,63)
      CALL Trim (WasX$)
      IF LEFT$(WasX$,2) = "M!" THEN
         IF ZFoundExtra THEN
            ZOK = ZTrue
            GOTO 58710
         ELSE
            ZOK = ZFalse
            ZGSRAra$(1) = PassToMacro$
            WasX$ = RIGHT$(WasX$,LEN(WasX$)-2)
            CALL Trim (WasX$)
            ZFileLocation$ = ""
            CALL MacroExe (WasX$)
            IF ZFileLocation$ = "" THEN
               ZOK = ZFalse
               WasX$ = Temp$
               GOTO 58710
            ELSE
               WasX$ = ZFileLocation$
            END IF
         END IF
      END IF
      WasX$ = WasX$ + FilName$
'
'  Let's see if the file is where the path points to
'
58708 CALL FindFile (WasX$,ZOK)
      IF NOT ZOK THEN _
         WasX$ = SDirAra$(MaxSearch) + FilName$
58710 FilName$ = WasX$
58711 CALL SkipLine (-MarkingTime)
      CLOSE FilNum
      END SUB
'
58800 ' $SUBTITLE: 'WipeLine - Wipe away a line so next overprints'
' $PAGE
'
'  NAME    -- WipeLine
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZCarriageReturn$
'                 CharsToWipe            # OF CHARACTERS TO BLANK
'                 ZNulls
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- Wipe away a line and leave cursor at beginning of the
'             same line so that the next line will print in its place
'
      SUB WipeLine (CharsToWipe)
      IF ZNulls OR CharsToWipe > 79 THEN _
         CALL SkipLine (1) : _
         EXIT SUB
      IF NOT ZLocalUser THEN _
         Strng$ = ZCarriageReturn$ + SPACE$(CharsToWipe) + ZCarriageReturn$ : _
         CALL PutCom (Strng$)
      IF ZSnoop THEN _
         LOCATE ,1 :  _
         CALL LPrnt(SPACE$(CharsToWipe),0) : _
         LOCATE ,1
      IF ZF7Msg$ = "" OR _
         ZF7Msg$ = "NONE" OR _
         NOT ZSysopNext THEN _
         EXIT SUB
      ZBypassTimeCheck = ZTrue
      CALL BufFile (ZF7Msg$,WasX,ZFalse)
      END SUB
'
58895 ' $SUBTITLE: 'GetDirs -- Prompt for directories to search'
' $PAGE
'
'  NAME    -- GetDirs
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZDirPrompt$             BASE OF DIRECTORY PROMPT
'                 ShowHelp                WHETHER TO DISPLAY HELP
'                                         ON ENTRY
'  OUTPUTS --     ZUserIn$
'                 ZWasQ
'
'  PURPOSE -- Prompt for directories to search
'
      SUB GetDirs (ShowHelp) STATIC
      IF ShowHelp AND (ZAnsIndex >= ZLastIndex ) THEN _
         GOTO 58902
58900 ZOutTxt$ = ZDirPrompt$
      ZMacroMin = 2
      CALL PopCmdStack
      IF ZWasQ = 0 OR ZSubParm = -1 OR ZSubParm < -5 THEN _          ' 175-1219
         EXIT SUB                                                    ' 175-1219
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
      IF ZUserIn$(ZAnsIndex) = "Q" THEN _
         ZWasQ = 0 : _
         EXIT SUB
      ZWasA = INSTR("E+.E-.E.L.H.?.",ZUserIn$(ZAnsIndex)+".")
      IF ZWasA = 0 THEN _
         EXIT SUB
      IF ZWasA > 8 THEN _
         IF ZAnsIndex < ZLastIndex THEN _
            GOTO 58900 _
         ELSE GOTO 58902
      IF ZWasA = 7 THEN _
         ZExtendedOff = NOT ZExtendedOff _
      ELSE ZExtendedOff = (ZWasA > 3)
      CALL QuickTPut1 ("Extended directory display "+FNOffOn$(NOT ZExtendedOff))
      GOTO 58900
58902 ZFileName$ = ZCurDirPath$ + ZDirPrefix$ + _
                    "." + ZDirExtension$
      CALL Graphic (ZFileName$,ZTrue)
      CALL BufFile (ZFileName$,ZAnsIndex,ZFalse)
      GOTO 58900
      END SUB
'
58950 ' $SUBTITLE: 'ConvertDir -- Converts coded response to right directory'
' $PAGE
'
'  NAME    -- ConvertDir
'
'  INPUTS  --     PARAMETER                    MEANING
'                 Start               ELEMENT TO BEGIN WITH
'                 ZUserIn$            ARRAY TO CONVERT
'                 ZWasQ               LAST ELEMENT TO CONVERT
'
'  OUTPUTS --     ZUserIn$            CONVERTED DIRECTORY LIST
'
'  PURPOSE -- Let the user put in a short standard string for a directory
'
'
      SUB ConvertDir (Start)
      FOR WasI=Start TO ZLastIndex
         CALL AraAllCaps (ZUserIn$(),WasI)
         IF ZUserIn$(WasI)="U" THEN _
            ZUserIn$(WasI) = ZUpldDirCheck$
         IF ZUserIn$(WasI) = "A" THEN _
            ZUserIn$(WasI) = "ALL"
      NEXT
      END SUB
59100 ' $SUBTITLE: 'Muzak - subroutine to PLAY ZMusic'
' $PAGE
'
'  NAME    -- Muzak
'
'  INPUTS  --   PARAMETER     MEANING
'                       1   PLAY CONSIDER YOURSELF(OPENING SCREEN)
'                       2   PLAY WALK RIGHT IN(NEW USERS)
'                       3   PLAY DRAGNET (SECURITY VIOLATION)
'                       4   PLAY GOODBYE CHARLIE (GOODBYE)
'                       5   PLAY TAPS (ACCESS DENIED)
'                       6   PLAY OOM PAH PAH (DOWNLOAD)
'                       7   PLAY THNKS FOR MEMORIES(UPLOAD)
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- Provide sysops and the visually impaired with
'             auditory feedback on what RBBS-PC is doing
'
      SUB Muzak (PassedArg)
      ZFF = PassedArg
      ZSubParm = 0
      IF (NOT ZSnoop) OR (NOT ZMusic) OR ZLocalUserMode THEN _
         EXIT SUB
      ON ZFF GOTO 59102,59104,59106,59108,59110,59112,59114
      EXIT SUB
59102 '---[Introduction CONSIDER YOURSELF]---
    Music$ = "MBT180A4B-8B-8B-8B-2.G4A8F2"
    PLAY "O2 X" + VARPTR$(Music$)
    EXIT SUB
59104 '---[New User WALK RIGHT IN]---
    Music1$ = "MBT180G4G4D2G8F+8F8E2A8B8"
    Music2$ = "C8C+8D8C8"
    Music3$ = "B4G2"
    PLAY "O2 X" + VARPTR$(Music1$) + "O3 X" + VARPTR$(Music2$) + "O2 X" + VARPTR$(Music3$)
    EXIT SUB
59106 '---[Security Violation DRAGNET THEME]---
     Music$ = "MBT120C2D8E-4C2.C2D8E-4C4G-2."
     PLAY "O2 X" + VARPTR$(Music$)
     EXIT SUB
59108 '---[Goodbye GOODBYE CHARLIE]---
      Music$ = "MBT180B-2.G2.F4D2."
      PLAY "O2 X" + VARPTR$(Music$)
      EXIT SUB
59110 '---[Access Denied TAPS]---
      Music1$ = "MBT90F8A16"
      Music2$ = "C4."
      Music3$ = "A4F4C2.C8C16F2"
      PLAY "O2 X" + VARPTR$(Music1$) + "O3 X" + VARPTR$(Music2$) + "O2 X" + VARPTR$(Music3$)
      EXIT SUB
59112 '---[Download OOM PAH PAH]---
       Music$ = "MBT180F4A4A4C4A4A4G4A4G4D2"
       PLAY "O2 X" + VARPTR$(Music$)
       EXIT SUB
59114 '---[Upload THANKS FOR THE MEMORIES]---
       Music1$ = "MBT180C2."
       Music2$ = "A8G8F4D2"
       PLAY "O3 X" + VARPTR$(Music1$) + "O2 X" + VARPTR$(Music2$)
       END SUB
'
59200 ' $SUBTITLE: 'TwoByteDate -- subroutine to put date in 2 bytes'
' $PAGE
'
'  NAME    -- TwoByteDate
'
'  INPUTS  --   PARAMETER     MEANING
'                  TYear      FOUR DIGIT YEAR (I.E. 1987)
'                  WasMM      MONTH
'                  WasDD      DAY
'                Result$      LOCATION TO PLACE THE RESULT
'
'  OUTPUTS -- Result$       TWO BYTE COMPRESSED DATE FOR USE IN
'                           A RANDOM RECORD
'
'  PURPOSE -- Compress a WasY,ZMsgPtr,WasD date into two characters
'
      SUB TwoByteDate (TYear,WasMM,WasDD,Result$)
      Result$ = CHR$(((TYear - 1980) * 2) OR - ((WasMM AND 8) <> 0)) + _
                CHR$((WasMM AND NOT 8) * 32 + WasDD)
      END SUB
'
59201 ' $SUBTITLE: 'PackDate -- subroutine to Compress STRING DATE'
' $PAGE
'
'  NAME    -- PackDate
'
'  INPUTS  --   PARAMETER     MEANING
'                 Strng$    STRING DATE (mm-dd-yyyy)
'
'  OUTPUTS --    Result$    TWO BYTE COMPRESSED DATE FOR USE IN
'                                      A RANDOM RECORD
'
'  PURPOSE -- Compress an 8-character date into two characters
'
      SUB PackDate (Strng$,Result$)
      IF LEN(Strng$) < 8 THEN _
         EXIT SUB
      TYear = VAL(MID$(Strng$,7))
      WasMM = VAL(Strng$)
      WasDD = VAL(MID$(Strng$,4))
      CALL TwoByteDate (TYear,WasMM,WasDD,Result$)
      END SUB
'
59202 ' $SUBTITLE: 'UnPackDate -- subroutine to UNCompress DATE'
' $PAGE
'
'  NAME    -- UnPackDate
'
'  INPUTS  --   PARAMETER          MEANING
'             CompressedDate$    DATE IN 2 BYTE COMPRESSED FORM
'
'  OUTPUTS --     TYear          YEAR OF COMPRESSED DATE
'                 WasMM          MONTH OF COMPRESSED DATE
'                 WasDD          DAY OF COMPRESSED DATE
'             DisplayDate$       8 CHAR DISPLAY DATE (mm-dd-yyyy)
'
'  PURPOSE -- Uncompress a 2 char date to get Y,M,D & display
'
      SUB UnPackDate (CompressedDate$,TYear,WasMM,WasDD,DisplayDate$)
      CALL GetYMD (CompressedDate$,1,TYear)
      CALL GetYMD (CompressedDate$,2,WasMM)
      CALL GetYMD (CompressedDate$,3,WasDD)
      DisplayDate$ = RIGHT$("00" + MID$(STR$(WasMM),2),2) + _
                      "-" + _
                      RIGHT$("00" + MID$(STR$(WasDD),2),2) + _
                      "-" + _
                      RIGHT$(STR$(TYear),2)
      END SUB
'
59204 ' $SUBTITLE: 'GetYMD -- subroutine to unpack a two-byte date'
' $PAGE
'
'  NAME    -- GetYMD
'
'  INPUTS  --   PARAMETER     MEANING
'                 TwoByte$    PACKED TWO-BYTE DATE FIELD
'                   YMD       1 = YEAR
'                             2 = MONTH
'                             3 = DAY
'                 Result      LOCATION TO PLACE THE RESULT
'
'  OUTPUTS -- Result        FOUR DIGIT RESULT OF UNPAKING THE DATE
'
'  PURPOSE -- Unpack a compressed two-byte date field
'
      SUB GetYMD (TwoByte$,YMD,Result)
      ON YMD GOTO 59206,59210,59215
      EXIT SUB
59206 Result = (ASC(TwoByte$)AND NOT 1) / 2 + 1980
      EXIT SUB
59210 Result = FIX((ASC(MID$(TwoByte$,2)) / 32)) OR ((ASC(TwoByte$) AND 1) * 8)
      EXIT SUB
59215 Result = ASC(MID$(TwoByte$,2)) AND NOT 224
      END SUB
'
59400 ' $SUBTITLE: 'LogPDown -- subroutine to record private downloads'
' $PAGE
'
'  NAME    --   LogPDown
'
'               PARAMETER               MEANING
'  INPUTS  --   ZActiveFMSDir$          PRIVATE FMS DIR
'               DwnIndex                FILE INDEX
'
'  OUTPUTS --   NONE
'
'  PURPOSE -- Puts a "!" in place of an "*" in private directory
'             after downloaded
'
      SUB LogPDown (PrivateDnld,DwnIndex) STATIC
      IF NOT PrivateDnld THEN _
         EXIT SUB
      ZWasEN$ = ZActiveFMSDir$
      WasBX = &H4
      ZSubParm = 9
      CALL FileLock
      CALL OpenRand2 (ZWasEN$,ZFMSFileLength,2)
      IF ZErrCode > 0 THEN _
         GOTO 59405
      FIELD #2,ZFMSFileLength AS PersonalRec$
      L = LEN(ZUserIn$(0))
      FOR Temp = 1 TO ZDownFiles
         X = 5 * (DwnIndex - Temp) + 1
         IF X > 0 AND X < L THEN _
            ZWasA = VAL(MID$(ZUserIn$(0),X,5)) : _
            IF ZWasA > 0 THEN _
               GET #2,ZWasA : _
               MID$(PersonalRec$,ZFMSFileLength-2,1) = "!" : _
               PUT #2,ZWasA
      NEXT
59405 CALL UnLockAppend
      IF ZWasEN$ = ZPersonalDir$ THEN _
         ZFileWaiting = ZFalse
      END SUB
'
59450 ' $SUBTITLE: 'UserFace - handles programmable user interface'
' $PAGE
'
'  NAME    --  UserFace
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZCurPUI$             PUI TO USE
'              ZExpertUser          WHETHER CALL IN EXPERT MODE
'
'  OUTPUTS --  ZWasQ
'              ZUserIn$()
'              ZWasZ$
'
'  PURPOSE --  When sysop overrides RBBS-PC's default user
'              interface (provides a MAIN.PUT), this routine
'              reads in the table of specifications, presents
'              the sysop menu, presents the prompt, verifies
'              that a valid option has been picked, determines
'              whether the option is another PUI, and passes
'              back choices to be processed.
'
      SUB UserFace STATIC
59455 IF ZPrevPUI$ = ZCurPUI$ THEN _
         GOTO 59458
59456 ZFileName$ = ZCurPUI$
      CALL Graphic (ZFileName$,ZFalse)
      IF NOT ZOK THEN _
         CALL UpdtCalr ("Missing menu " + ZCurPUI$,2) : _
         ZCurPUI$ = ZPrevPUI$ : _
         GOTO 59456
      CALL BreakFileName(ZFileName$,ZWasZ$,ZActiveMenu$,ZWasZ$,ZTrue)
      ZActiveMenu$ = LEFT$(ZActiveMenu$,1)
      LSET ZLastCommand$ = ZActiveMenu$ + " "
      ZPrevPUI$ = ZCurPUI$
      LINE INPUT #2,ZFileName$
      LINE INPUT #2,Prompt$
      INPUT #2,ValidChoice$,ActualCommands$
      LINE INPUT #2,MenuChoice$
      LINE INPUT #2,MenuName$
      LINE INPUT #2,QuitCmd$
      LINE INPUT #2,QuitPrompt$
      LINE INPUT #2,QuitSubCmds$
      LINE INPUT #2,QuitMenuOpt$
      LINE INPUT #2,QuitMenus$
      CALL Graphic (ZFileName$,ZTrue)
      CALL BreakFileName (ZFileName$,MenuDrvPath$,WasX$,ZWasY$,ZTrue)
      MenuToDisplay$ = ZFileName$
      WasJ = INSTR(ZOrigCommands$,"?")
      IF WasJ < 1 THEN _
         WasX$ = "" _
      ELSE WasX$ = MID$(ZAllOpts$,WasJ,1)
59458 IF ZExpertUser THEN _
         GOTO 59461
59460 ZNonStop = (ZPageLength < 1)
      CALL BufFile (MenuToDisplay$,WasX,ZFalse)
59461 MID$(ZLastCommand$,2,1) = " "
      ZOutTxt$ = Prompt$
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm = -1 OR ZFunctionKey <> 0 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         GOTO 59458
59462 ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (ZWasZ$)
      WasJ = INSTR(ValidChoice$,ZWasZ$)
      IF WasJ < 1 THEN _
         GOTO 59492
      ZWasZ$ = MID$(ActualCommands$,WasJ,1)
      ZUserIn$(ZAnsIndex) = ZWasZ$
      WasJ = INSTR(MenuChoice$,ZWasZ$)
      IF WasJ > 0 THEN _
         ZCurPUI$ = MID$(MenuName$,1 + (WasJ - 1) * 7,7) : _
         GOTO 59490
      IF ZWasZ$ = WasX$ THEN _
         GOTO 59460
      IF ZWasZ$ <> QuitCmd$ THEN _
         EXIT SUB
59470 MID$(ZLastCommand$,2,1) = ZWasZ$
      ZOutTxt$ = QuitPrompt$
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm = -1 OR ZFunctionKey <> 0 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         ZUserIn$(1) = LEFT$(QuitSubCmds$,1) : _
         ZWasQ = 1
59480 ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (ZWasZ$)
      WasJ = INSTR(QuitSubCmds$,ZWasZ$)
      IF WasJ < 1 THEN _
         GOTO 59470
      WasJ = INSTR(QuitMenuOpt$,ZWasZ$)
      IF WasJ > 0 THEN _ 'quit to submenu
         ZCurPUI$ = MID$(QuitMenus$,1 + (WasJ - 1) * 7,7) : _
         GOTO 59490
      ZUserIn$(ZAnsIndex) = QuitCmd$ 'valid but not menu-send to RBBS
      EXIT SUB
59490 CALL Remove (ZCurPUI$," ")
      ZCurPUI$ = MenuDrvPath$ + _
                     ZCurPUI$ + _
                     ".PUI"
      GOTO 59455
59492 CALL QuickTPut1 (ZFGC$ + "No such option <" + ZFGF$ + ZWasZ$ + _
                       ZFGC$ + ">" + ZEmphasizeOff$)
      Call FlushKeys
      GOTO 59460
      END SUB
'
59500 ' $SUBTITLE: 'SubMenu -- subroutine to process menus'
' $PAGE
'
'  NAME    -- SubMenu
'
'  INPUTS  -- PARAMETER       MEANING
'             PassedPrompt$   PROMPT TO DISPLAY
'             CurMenu$        NOVICE MENU TO DISPLAY
'             FrontOpt$       DRIVE/PATH/PREFIX OF FILE
'                             NEEDED FOR TYPED OPTION
'             BackOpt$        SUFFIX/EXTENSION OF FILE
'                             NEEDED WITH TYPED OPTION
'             ReturnOn$       LETTERS CALLING PROGRAM WANTS
'                             CONTROL ON
'             GRDefault$      GRAPHICS DEFAULT TO USE
'             VerifyInMenu    WHETHER VERIFY OPTION IS IN MENU
'             AllMenuOK       WHETHER CONTROL SHOULD RETURN
'                             WHEN IN MENU
'             ZAnsIndex       # OF COMMANDS IN TYPE AHEAD
'             RequireInMenu   WHETHER OPTION MUST BE IN MENU
'
'  OUTPUTS -- ZWasZ$          OPTION PICKED
'             ZFileName$      NAME OF FILE SUPPORTING OPTION
'
'
'  PURPOSE -- Handles menus - including conference, bulletins,
'             doors, questionnaires.  Supports sub-menus (i.e.
'             an option on the menu that invokes another menu)
'
      SUB SubMenu (PassedPrompt$,CurMenu$,FrontOpt$, _
          BackOpt$,ReturnOn$,PassedVerifyInMenu, _
          AllMenuOK,RequireInMenu,BackOpt2$,InMenu,ChkGraphic) STATIC
59510 ZFileName$ = CurMenu$
      InMenu = ZTrue
      CALL BreakFileName (FrontOpt$,WasX$,FrontPre$,ZWasDF$,ZTrue)
      CALL BreakFileName (CurMenu$,MenuDrv$,WasX$,ZWasDF$,ZTrue)
      MenuFront$ = MenuDrv$ + LEFT$(WasX$,LEN(WasX$)-LEN(PreSuf$))
      IF CurMenu$ = LastSubMenu$ THEN _
         MenuFront$ = LEFT$(MenuFront$,LEN(MenuFront$)-1)
      CALL Graphic (ZFileName$,ZTrue)
      CurMenuVer$ = ZFileName$
      ZStopInterrupts = ZFalse
59514 IF ZAnsIndex < ZLastIndex OR ZExpertUser THEN _
         GOTO 59520
59515 CALL BufFile (CurMenuVer$,ZAnsIndex,ZFalse) 'show menu
59520 CALL Line25
      ZOutTxt$ = PassedPrompt$            'get response
      CALL PopCmdStack
      IF ZWasQ = 0 OR ZSubParm = -1 OR ZSubParm < -5 THEN _          ' 175-1219
         EXIT SUB
59530 ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (ZWasZ$)
      IF INSTR(ReturnOn$,","+ZWasZ$+",") THEN _  'check if calling pgm wants
         EXIT SUB
      IF INSTR("LH?",ZWasZ$) THEN _       'check whether caller wants help
         GOTO 59515
      IF INSTR(ZWasZ$,".") > 0 THEN _
         GOTO 59532
      CALL BadFile (ZWasZ$,WasBF)
      IF WasBF > 1 THEN _
         GOTO 59532
      FPre$ = MenuFront$                   ' check for sub-option
      PreSuf$ = "-"
      CALL BadFile (FPRE$ + ZWasZ$ + "-",WasBF)

      IF (BackOpt$ = ".BAT") THEN                                    ' 175-1223
        CALL FindIt (ZDoorsDef$)                                     ' 175-1223
        IF ZOK THEN _                                                ' 175-1223
          ReturnOn$ = BackOpt$                                       ' 175-1223
      END IF                                                         ' 175-1223

      IF BackOpt$ <> ReturnOn$ THEN                                  ' 175-1219
        ZOK = ZFalse                                                 ' 175-1219
        IF WasBF < 2 THEN                                            ' 175-1219
           VerifyInMenu = ZFalse                                     ' 175-1219
           GOSUB 59538                                               ' 175-1219
        END IF                                                       ' 175-1219
      ELSE                                                           ' 175-1219
        ZOK = ZTrue                                                  ' 175-1219
        ZFileName$ = ZWasZ$ + BackOpt$                               ' 175-1219
      END IF                                                         ' 175-1219

      PreSuf$ = ""
      VerifyInMenu = PassedVerifyInMenu
      IF NOT ZOK THEN _
         FPre$ = FrontOpt$ : _    ' check standard option
         GOSUB 59538 : _
         IF NOT ZOK THEN _      ' check option where menu is
            FPre$ = MenuDrv$ + FrontPre$ : _
            IF FrontOpt$ <> FPre$ THEN _
               GOSUB 59538
      IF NewMenu THEN _
         NewMenu = ZFalse : _
         GOTO 59515
      IF ZOK THEN _
         EXIT SUB
59532 GOSUB 59547
      GOTO 59514
59538 FilName$ = FPre$ + ZWasZ$ + PreSuf$
      ZFileName$ = FilName$ + BackOpt$
      GOSUB 59543
      IF WasBF > 1 THEN _
         ZOK = ZFalse : _
         RETURN
      GOSUB 59542
      IF NOT ZOK THEN _
         IF BackOpt2$ <> "" THEN _
            ZFileName$ = FilName$ + _
                         BackOpt2$ : _
         GOSUB 59543 : _
         IF WasBF > 1 THEN _
            ZOK = ZFalse : _
            RETURN _
         ELSE GOSUB 59542
      IF ZOK THEN _
         CALL WordInFile (CurMenu$,ZWasZ$,InMenu) : _
         IF ZSysop OR InMenu OR (NOT RequireInMenu) THEN _
            RETURN _
         ELSE GOTO 59540
      IF (NOT VerifyInMenu) THEN _
         GOTO 59540
      CALL WordInFile (CurMenu$,ZWasZ$,InMenu)  'verify against menu itself
      IF InMenu THEN _
         IF AllMenuOK THEN _
            RETURN
59540 WasX$ = FPre$ + _
           ZWasZ$ + PreSuf$ + _
           ".MNU"                       'check whether option is a menu
      ZFileName$ = WasX$
      CALL Graphic (ZFileName$,ZFalse)
      IF ZOK THEN _
         NewMenu = ZTrue : _
         CurMenuVer$ = ZFileName$ : _
         CurMenu$ = WasX$ : _
         CALL BreakFileName (FPre$ + ZWasZ$,MenuDrv$,WasX$,ZWasDF$,ZTrue) : _
         MenuFront$ = MenuDrv$ + WasX$ : _
         IF PreSuf$ = "-" THEN _
            LastSubMenu$ = CurMenu$
      RETURN
59542 IF ChkGraphic THEN _
         CALL Graphic (ZFileName$,ZFalse) _
      ELSE CALL FindIt (ZFileName$)
      RETURN
59543 WasZ$ = ZWasZ$
      CALL BadName (WasBF,ZFalse)
      ZWasZ$ = WasZ$
      RETURN
59547 CALL QuickTPut1 (ZFG8$ + "No such option " + ZFGF$ + ZWasZ$ + ZEmphasizeOff$)
      ZLastIndex = 0
      IF VerifyInMenu AND InMenu AND NOT RequireInMenu THEN _
         CALL UpdtCalr("Option " + ZWasZ$ + " on menu " + CurMenu$ + " but not found",1)
      IF NOT ZExpertUser THEN _
        CALL SkipLine(1) : _
        CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
      RETURN
59548 END SUB
'
59600 ' $SUBTITLE: 'SetEcho -- subroutine to reset who echoes'
' $PAGE
'
'  NAME    -- SetEcho
'
'  INPUTS  --   PARAMETER     MEANING
'               NewEcho$    THE NEW ECHO OPTION
'               ZLocalUser
'
'  OUTPUTS -- ZRemoteEcho   WHETHER RBBS IS TO ECHO WHAT A
'                           REMOTE CALLER TYPES
'
'  PURPOSE -- Resets who echos.  "R" is for RBBS to echo.
'             "I" is for intermediate host to echo.
'             "C" is for caller's communication pgm to echo.
'
      SUB SetEcho (NewEcho$) STATIC
      IF NewEcho$ = PrevEcho$ THEN _
         EXIT SUB
      IF NewEcho$ = "R" THEN _
         ZRemoteEcho = (NOT ZLocalUser) _
      ELSE ZRemoteEcho = ZFalse
      IF ZLocalUser THEN _
         GOTO 59602
      IF NewEcho$ = "I" THEN _
          IF ZFossil THEN _
             Bytes = LEN(ZHostEchoOn$) : _
             CALL FosWrite(ZComPort,Bytes,ZHostEchoOn$) : _
             GOTO 59602 _
          ELSE PRINT #3,ZHostEchoOn$; : _
               GOTO 59602
      IF PrevEcho$ = "I" THEN _
          IF ZFossil THEN _
             Bytes = LEN(ZHostEchoOff$) : _
             CALL FosWrite(ZComPort,Bytes,ZHostEchoOff$) _
          ELSE PRINT #3,ZHostEchoOff$;
59602 PrevEcho$ = NewEcho$
      END SUB
'
59698 ' $SUBTITLE: 'MsgImport -- subroutine to import a message'
' $PAGE
'
'  NAME    -- MsgImport
'
'  INPUTS  --   PARAMETER     MEANING
'               MaxLines     MAXIMUM # OF LINES
'               MaxLen       MAXIMUM LENGTH OF A LINE
'               NumLines     NUMBER OF LINES ALREADY IN MESSAGE
'               LineAra$     ARRAY OF LINES IN MESSAGE
'
'  OUTPUTS --   NumLines
'               LineAra$
'
'  PURPOSE -- Allows local user to append a text file to
'             a message.   Will word wrap if needed.
'
      SUB MsgImport (MaxLines,MaxLen,NumLines,LineAra$(1)) STATIC
      IF NOT (ZLocalUser OR ZSysop) THEN _
         CALL QuickTPut1 ("Only for SysOps/local users") : _
         EXIT SUB
59700 ZOutTxt$ = "Import what file" + ZPressEnter$
      CALL PopCmdStack
      IF ZSubParm = -1 OR ZWasQ = 0 THEN _
         EXIT SUB
      CALL FindIt (ZUserIn$(ZAnsIndex))
      IF NOT ZOK THEN _
         CALL QuickTPut1 (ZUserIn$(ZAnsIndex) + " not found") : _
         GOTO 59700
59701 WHILE NOT EOF(2) AND NumLines < MaxLines
         NumLines = NumLines + 1
         LINE INPUT #2,LineAra$(NumLines)
      WEND
      CLOSE 2
      CALL WordWrap (MaxLen,NumLines,LineAra$())
      END SUB
'
59703 ' $SUBTITLE: 'WordWrap -- subroutine to wrap lines in a message'
' $PAGE
'
'  NAME    -- WordWrap
'
'  INPUTS  --   PARAMETER     MEANING
'               MaxLen       MAXIMUM LENGTH OF A SINGLE LINE
'               NumLines     NUMBER OF LINES IN A MESSAGE
'               LineAra$     ALL THE LINES IN THE MESSAGE
'
'  OUTPUTS --   NumLines
'               LineAra$
'
'  PURPOSE -- Batch adjusts a message, wrapping lines if
'             needed.  Preserves paragraph structure.
'
      SUB WordWrap (MaxLen,NumLines,LineAra$(1)) STATIC
      WasJ = 1
      SplitOn = 1 + .4 * MaxLen
      WHILE WasJ <= NumLines
         ReFormatted = ZFalse
59704    CALL TrimTrail (LineAra$(WasJ)," ")
         WasK = LEN(LineAra$(WasJ))
         IF WasK <= MaxLen THEN _
            GOTO 59705
         CALL FindLast (LineAra$(WasJ)," ",LastPos,HowMany)
         IF MID$(LineAra$(WasJ), 3, 1) = ">" THEN _
            CALL AnyBut (LineAra$(WasJ),3,">",WasX) _
         ELSE _
            CALL AnyBut (LineAra$(WasJ),1,">",WasX)
         IF WasX = 0 THEN WasX = 2
         IF MID$(LineAra$(WasJ + 1),3,1) = ">" THEN _
            CALL AnyBut (LineAra$(WasJ + 1),3,">",Temp) _
         ELSE _
            CALL AnyBut (LineAra$(WasJ+1),1,">",Temp)
         IF LEFT$(LineAra$(WasJ + 1),2) = "  " OR ((Temp > 0) AND WasX <> Temp) THEN _
            FOR WasK = NumLines TO WasJ + 1 STEP -1 : _
               LineAra$(WasK + 1) = LineAra$(WasK) : _
            NEXT : _
            NumLines = NumLines + 1 : _
            LineAra$(WasJ + 1) = ""
         IF WasX > 1 THEN _
            IF MID$(LineAra$(WasJ),WasX,1) = " " THEN _
               WasX = WasX + 1
         WasX$ = LEFT$(LineAra$(WasJ),WasX-1)
         IF LastPos < SplitOn THEN _
            LineAra$(WasJ + 1) = WasX$ + MID$(LineAra$(WasJ),MaxLen) + MID$(LineAra$(WasJ + 1),WasX) : _
            LineAra$(WasJ) = LEFT$(LineAra$(WasJ),MaxLen - 1) + "-" _
         ELSE ZUserIn$ = LEFT$(" ", - (LEN(LineAra$(WasJ + 1)) > 0)) : _
              LineAra$(WasJ + 1) = WasX$ + MID$(LineAra$(WasJ),LastPos + 1) + ZUserIn$ + MID$(LineAra$(WasJ + 1),WasX) : _
              LineAra$(WasJ) = LEFT$(LineAra$(WasJ),LastPos - 1)
         ReFormatted = ZTrue
         GOTO 59704
59705    IF ReFormatted THEN _
            IF WasJ = NumLines THEN _
               NumLines = NumLines + 1
         WasJ = WasJ + 1
      WEND
      END SUB
'
59760 ' $SUBTITLE: 'AnyBut -- subroutine to find where a word begins'
' $PAGE
'
'  NAME    -- AnyBut
'
'  INPUTS  --   PARAMETER     MEANING
'               Strng$        STRING TO SEARCH FOR WORDS
'               Beg           BYTE POSITION IN Strng$ TO
'                             BEGIN SEARCHING
'               SkipChars$    CHARACTERS TO SKIP OVER WHEN
'                                SEARCHING
'
'  OUTPUTS --   WhereIs      BYTES POSITION IN Strng$ WHERE
'                             WORD BEGINS
'
'  PURPOSE -- Parser.   Finds where a "word" begins, where
'             any character will be accepted as the beginning of a
'             word except those listed in SKIP.CHAR$
'
      SUB AnyBut (Strng$, Beg, SkipChars$, WhereIs) STATIC
      WasX$ = Strng$ + _
           CHR$(0)
      WhereIs = Beg
      IF WhereIs < 1 THEN _
         WhereIs = 1
      WHILE INSTR(SkipChars$, MID$(WasX$, WhereIs, 1)) > 0
         WhereIs = WhereIs + 1
      WEND
      IF WhereIs > LEN(Strng$) THEN _
         WhereIs = 0
      END SUB
'
59770 ' $SUBTITLE: 'FindEnd -- subroutine to find where a word ends'
' $PAGE
'
'  NAME    -- FindEnd
'
'  INPUTS  --   PARAMETER        MEANING
'               Strng$        STRING TO SEARCH FOR WORDS
'               Beg           POSITION IN Strng$ TO BEGIN SEARCH
'               StopWith$     CHARACTERS THAT TERMINATE A WORD
'
'  OUTPUTS      WhereIs       POSITION IN Strng$ WHERE WORD ENDS
'                             (I.E. THE LAST CHARACTER OF THE WORD)
'
'  PURPOSE -- Parser.   Finds where a "word" ends, where
'             any character will be counted as in a word
'             except for those in StopWith$ or when the end of
'             the string is found.
'
      SUB FindEnd (Strng$, Beg, StopWith$, WhereIs) STATIC
      ZWasB = Beg
      IF ZWasB < 1 THEN _
         ZWasB = 1
      IF ZWasB > LEN(Strng$) THEN _
         WasX$ = StopWith$ _
      ELSE WasX$ = MID$(Strng$, ZWasB) + _
                StopWith$
      WasI = 1
      WasX = INSTR(StopWith$, MID$(WasX$, WasI, 1))
      WHILE WasX = 0
         WasI = WasI + 1
         WasX = INSTR(StopWith$, MID$(WasX$, WasI, 1))
      WEND
      WhereIs = WasI - 1 + ZWasB - 1
      END SUB
'
59780 ' $SUBTITLE: 'GetAll -- subroutine to create directory list'
' $PAGE
'
'  NAME    -- GetAll
'
'  INPUTS  --   PARAMETER     MEANING
'               LookIn$       NAME OF FILE TO SEARCH
'               DIR.EXT$      MAIN DIRECTORY EXTENSION TO USE
'               StartPos      LAST POSITION USED IN ARRAY
'
'  OUTPUTS      StartPos     LAST ELEMENT USED IN ARRAY
'               LoadInto$    ARRAY TO LOAD ELEMENTS FOUND
'
'  PURPOSE -- Creates a list (LoadInto$) of all directories
'             to be listed when ZWasA)ll is selected for a directory.
'             All uses config parm, which can be either a single
'             directory or list of directories (begin with "@").
'
      SUB GetAll (LoadInto$(1), StartPos) STATIC
      IF ZMasterDirName$ <> "" AND LEFT$(ZMasterDirName$,1) <> "@" THEN _
         StartPos = StartPos + 1 : _
         LoadInto$(StartPos) = ZMasterDirName$ : _
         EXIT SUB
      ZOK = ZFalse
      IF LEN (ZMasterDirName$) > 1 AND LEFT$(ZMasterDirName$,1) = "@" THEN _
         CALL FindIt(MID$(ZMasterDirName$,2))
      IF NOT ZOK THEN _
         CALL QuickTPut1 ("No dirs defined for A)ll") : _
         EXIT SUB
      MaxLoad = UBOUND(LoadInto$, 1)
      StartSort = StartPos + 1
      WHILE NOT EOF(2) AND StartPos < MaxLoad
         LINE INPUT #2, ZOutTxt$
         StartPos = StartPos + 1
         LoadInto$(StartPos) = ZOutTxt$
      WEND
      CLOSE 2
      END SUB
'
59800 ' $SUBTITLE: 'BadFileChar -- checks file for illegal char'
' $PAGE
'
'  NAME    --  BadFileChar
'
'  INPUTS  --  PARAMETER         MEANING
'               FilName$         NAME OF FILE TO CHECK
'
'  OUTPUTS --  IsOK            WHETHER NAME OK
'
'  PURPOSE --  Part of test for file's existence.  If bad
'              character in name, can't exist.
'
      SUB BadFileChar (FilName$,IsOK) STATIC
      WasL = LEN(FilName$)
      IF WasL > 2 THEN _
         IF INSTR(3,FilName$,":") > 0 THEN _
            IsOK = ZFalse : _
            EXIT SUB
      WasX$ = FilName$ + "="
      WasI = 1
      WHILE INSTR("/[]|<>+=;, ?*",MID$(WasX$,WasI,1)) = 0 AND ASC(MID$(WasX$,WasI)) < 128
         WasI = WasI + 1
      WEND
      IsOK = WasI > WasL
      END SUB
'
59850 ' $SUBTITLE: 'ConfMail -- quickly checks mail waiting'
' $PAGE
'
'  NAME    -- ConfMail
'
'  INPUTS  -- PARAMETER             MEANING
'         SKIP.CONFIRM            WHETHER TO SKIP CONFIRM OF OPTION
'         ZConfMailList$          FILE OF USER/MESSAGE PAIRS TO CHECK
'         ZActiveUserFile$        ACTIVE USER FILE (RESTORED ON EXIT)
'         ZActiveMessageFile$     ACTIVE MESSAGE FILE (RESTORED ON EXIT)
'
'  OUTPUTS -- None
'
'  PURPOSE -- Quicking scans message header record to get
'             last msg # and user record to get whether any
'             new mail and last msg read, reports both, using
'             highlighting if new mail to caller.
'
      SUB ConfMail (MailCheckConfirm,LinkNew,LinkPers) STATIC
      SkipJoinUnjoin = ZNonStop OR LinkNew OR LinkPers
      IF ZStartHash = 1 AND ZUserFileIndex > 0 THEN _
         CALL FindIt (ZConfMailList$) _
      ELSE ZOK = ZFalse
      IF NOT ZOK THEN _
         EXIT SUB
      IF PrevMailList$ <> ZConfMailList$ THEN _
         SkipParms = 0
      PrevMailList$ = ZConfMailList$
      IF MailCheckConfirm THEN _
         ZOutTxt$ = ZFG1$ + "Check conferences for mail/uploads ([Y]" + _
                    ZFG1$ + ",N)" + ZEmphasizeOff$ : _
         ZTurboKey = -ZTurboKeyUser : _
         CALL PopCmdStack : _
         IF ZNo OR ZSubParm < 0 THEN _
            EXIT SUB
      HaveMailFile% = ZFalse
      CALL BreakFileName (ZActiveUserFile$,WasX$,NowInPre$,NowInExt$,ZFalse)
      CALL BreakFileName (ZOrigUserFile$,WasX$,OrigPre$,OrigExt$,ZFalse)
      CALL SkipLine (1)
      CALL QuickTPut1 (ZFGF$ + "Checking Message Bases... (* = linked)" + ZEmphasizeOff$)
      IF LinkNew OR LinkPers THEN _
         ZLinkedConf$ = ""
      AnyMail = ZFalse
      ZStopInterrupts = ZFalse
      WasA1$ = ZActiveUserFile$
      MsgFileSave$ = ZActiveMessageFile$
      TempIndivValue$ = ""
      UserFileIndexSave = ZUserFileIndex
      UserRecordHold$ = ZUserRecord$
      ZOK = ZTrue
      CALL ReadParms (ZWorkAra$(),1,SkipParms)
      IF SkipParms = 0 THEN _
         LogicalEOF$ = "" _
      ELSE LogicalEOF$ = ZWorkAra$(1)
59851 IF NOT ZOK THEN _
         GOTO 59856 _
      ELSE IF EOF(2) THEN _
              IF LogicalEOF$ = "" OR SkipParms = 0 THEN _
                 GOTO 59856 _
              ELSE CALL FindIt (ZConfMailList$) : _
                   SkipParms = 0 : _
                   GOTO 59851
         CALL ReadAny
         ZActiveUserFile$ = ZOutTxt$
         CALL ReadAny
         IF ZErrCode > 0 THEN _
            GOTO 59856
         SkipParms = SkipParms + 2
         ZActiveMessageFile$ = ZOutTxt$
         CALL FindFile (ZActiveUserFile$,ZOK)
         IF NOT ZOK THEN _
            GOTO 59856
         CALL OpenUser (HighestUserRecord)
         FIELD 5, 128 AS ZUserRecord$
         CALL FindFile (ZActiveMessageFile$,ZOK)
         IF NOT ZOK THEN _
            GOTO 59856
         CALL FindUser (ZOrigUserName$,"",ZStartHash,ZLenHash,_
                        0,0,HighestUserRecord,_
                        Found,HoldUserFileIndex,ZWasSL)
         IF NOT Found THEN _
            GOTO 59853
         CALL OpenMsg
         FIELD 1, 128 AS ZMsgRec$
         GET 1,1
         AnyMail = ZTrue
         WasX = CVI(MID$(ZUserRecord$,57,2))
         FileWait = (WasX AND 4096) > 0
         WasX = (WasX AND 512) > 0
         CALL BreakFileName (ZActiveUserFile$,WasX$,CurPre$,CurExt$,ZFalse)
         InCur = (CurPre$ = NowInPre$ AND CurExt$ = NowInExt$)
59852    IF InCur THEN _
            FileWait = ZFileWaiting : _
            WasX = ZMailWaiting : _
            ZWasA = ZLastMsgRead _
         ELSE ZWasA = CVI(MID$(ZUserRecord$,51,2))
         ZWasB = VAL(LEFT$(ZMsgRec$,8))
         WasZ = (ZWasB - ZWasA)
         IF WasZ < 0 THEN _
            ZWasA = 0 : _
            WasZ = ZWasB _
         ELSE IF WasZ = 0 THEN _
                 WasX = ZFalse
         ZWasSL = LEN(CurPre$)
         IF CurPre$ = "USERS" AND CurExt$ = "" THEN _
            Conf$ = "MAIN" _
         ELSE Conf$ = LEFT$(CurPre$,ZWasSL-1)
         ZOutTxt$ = MID$(STR$((ZWasB > ZWasA) * WasZ),2)
         Temp = LEN(ZOutTxt$)
         ZOutTxt$ = SPACE$(-(Temp<4) * (4-Temp)) + ZOutTxt$
         ConMsg = VAL(ZOutTxt$)
         IF ConMsg = 0 THEN _
            ZOutTxt$ = ZFGF$ + "  No" _
         ELSE _
            ZOutTxt$ = ZFGF$ + ZOutTxt$
         IF (WasZ > 0 AND LinkNew) OR (WasX AND LinkPers) THEN _
            IF (NOT InCur) THEN _
               CALL AddLink (Conf$)
         Temp = (INSTR(ZCarriageReturn$ + ZLinkedConf$,ZCarriageReturn$ + Conf$ + ZCarriageReturn$) > 0)
         ZWasY$ = MID$(" *",1-Temp,1) + Conf$ + SPACE$(-(ZWasSL<8) * (8-ZWasSL))
         IF WasX THEN _
            WasX$ = ZEmphasizeOn$ + "Some to you" + ZEmphasizeOff$ _
         ELSE WasX$ = "           "
         IF FileWait THEN _
            Temp$ = " - " + ZEmphasizeOn$ + "Personal file(s)" + ZEmphasizeOff$ _
         ELSE Temp$ = ""
         ZSubParm = 5
         IF ConMsg OR ZFF = 16 OR FileWait THEN _
            ZOutTxt$ = ZFGB$ + ZWasY$ + ": " + ZOutTxt$ + ZFG4$ + _
                       " new message(s) " + ZEmphasizeOff$ + WasX$ + Temp$ : _
            CALL TPut : _
            HaveMailFile% = ZTrue
         ZJumpSupported = ZFalse
         IF SkipJoinUnjoin THEN _
            CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue) : _
            GOTO 59853
         ZTurboKey = -ZTurboKeyUser
         CALL AskMore (",J)oin,U)njoin,L)ink,D)elink",ZTrue,ZFalse,WasX,ZFalse)
         IF ZNo THEN _
            GOTO 59856
         WasX$ = LEFT$(ZUserIn$(1),1)
         CALL AllCaps (WasX$)
         IF WasX$ = "J" THEN _
            ZLastIndex = ZWasQ : _
            ZHomeConf$ = Conf$ : _
            GOTO 59856
         IF WasX$ = "D" THEN _
            CALL DeLink (Conf$) : _
            GOTO 59852
         IF WasX$ = "L" THEN _
            CALL AddLink (Conf$) : _
            GOTO 59852
         IF WasX$ = "U" THEN _
            IF InCur OR (OrigPre$ = CurPre$ AND OrigExt$ = CurExt$) THEN _
               CALL QuickTPut1 ("Can't omit yourself from the board or conference you're in") _
            ELSE LSET ZUserRecord$ = CHR$(0) + "deleted user" : _
                 ZUserFileIndex = HoldUserFileIndex : _
                 ZSubParm = 6 : _
                 CALL FileLock : _
                 PUT 5, HoldUserFileIndex : _
                 ZSubParm = 8 : _
                 CALL FileLock : _
                 CALL QuickTPut1 ("Omitted you from " + Conf$)
59853 IF ZActiveMessageFile$ = LogicalEOF$ THEN _
         GOTO 59856
      IF NOT ZRet THEN _
         GOTO 59851
59856 ZActiveUserFile$ = WasA1$
      CALL OpenUser (ZHighestUserRecord)
      FIELD 5, 128 AS ZUserRecord$
      IF (NOT ZRet) AND NOT AnyMail THEN _
         CALL QuickTPut1 (ZFGB$ + " You have not joined any conferences" + _
                          ZEmphasizeOff$) _
      ELSE _
         IF NOT HaveMailFile% THEN _
            CALL QuickTPut1 (ZFGB$ + " There is no new mail" + ZEmphasizeOff$)
      ZUserFileIndex = UserFileIndexSave
      LSET ZUserRecord$ = UserRecordHold$
      ZActiveMessageFile$ = MsgFileSave$
      CALL OpenMsg
      FIELD 1, 128 AS ZMsgRec$
      GET 1,1
      ZNonStop = (ZPageLength < 1)
      WasX$ = ZUserIn$(ZAnsIndex+1)
      CALL AllCaps (WasX$)
      ZAnsIndex = ZAnsIndex - (WasX$ = "C")
      SkipParms = -(NOT EOF(2))*SkipParms
      LinkNew = ZFalse
      LinkPers = ZFalse
      CLOSE 2
      END SUB
'
59858 ' $SUBTITLE: 'AskMore -- pauses when possible screen full'
' $PAGE
'
'  NAME    -- AskMore
'
'  INPUTS  --   PARAMETER     MEANING
'               ExtraPrompt$  STRING TO ADD TO MORE PROMPT AT END
'               OverWrite     WHETHER TO WIPE AWAY PROMPT
'
'  OUTPUTS --   ZUserIn$()
'               ZNo
'
'  PURPOSE -- Determines whether need to pause if screen full.
'             And, if so, asks the appropriate question.  If non-
'             stop, at least check for carrier present.
'
      SUB AskMore (ExtraPrompt$,OverWrite,CheckLines,AbortIndex,CantInterrupt) STATIC
      ZNo = ZFalse
      IF CheckLines THEN _
         WasX = -ZDisplayAsUnit*ZUnitCount -(NOT ZDisplayAsUnit)*ZLinesPrinted : _
         IF WasX < ZPageLength OR (ZPageLength = 0) THEN _
            ZWasQ = 0 : _
            EXIT SUB
      IF ZOneStop THEN _
         ZOneStop = ZFalse : _
         ZNonStop = ZTrue : _
         GOTO 59860
      IF ZNonStop THEN _
         ZLinesPrinted = 0 : _
         CALL CheckCarrier : _
         IF ZKeyboardStack$ = "" AND ZCommPortStack$ = "" THEN _
            EXIT SUB _
         ELSE ZNonStop = ZFalse
59860 CALL QuickTPut (ZEmphasizeOff$,0)
      IF CantInterrupt THEN _
         ZTurboKey = 2 : _
         ZForceKeyboard = ZTrue : _
         ZOutTxt$ = ZFG8$ + "Press any key to continue" + ZFG0$ + ZEmphasizeOff$ _
      ELSE GOSUB 59870 : _
           ZOutTxt$ = ZMorePrompt$ + Temp$ + ExtraPrompt$ + LEFT$(")",-ZExpertUser)
      WasX = LEN(ZOutTxt$) + 2
      IF INSTR(ZOutTxt$, "Marked-") > 0 THEN _
         IF NOT ZHiLiteOff THEN _
            WasX = WasX - 17
      ZNoAdvance = OverWrite
      CALL Line25
      ZSubParm = 1
      IF ExtraPrompt$ = "" AND ZTurboKey = 0 THEN _
         ZTurboKey = -ZTurboKeyUser
      ZMacroMin = 2
      CALL TGet
      IF ZSubParm = -1 THEN _
        EXIT SUB
      ZTurboKey = ZFalse
      ZWasDF$ = ZUserIn$ (1)
      CALL AllCaps (ZWasDF$)
      WasI = INSTR(";C;A;",";"+ZWasDF$+";")
      IF WasI = 1 THEN _
         ZNonStop = ZTrue : _
         ZWasQ = 0
      CALL WipeLine (WasX + LEN(ZUserIn$))
      IF NOT ZHiLiteOff THEN _
         CALL QuickTPut (ZLastSmartColor$,0)
      IF CantInterrupt THEN _
         ZNo = ZFalse : _
         EXIT SUB
      IF WasI = 3 THEN _
         ZLastIndex = 0 : _
         AbortIndex = 32000
      IF ZNo THEN _
         ZKeyboardStack$ = "" : _
         ZCommPortStack$ = "" : _
         ZLastSmartColor$ = ""
      IF NOT ZJumpSupported THEN _
         EXIT SUB
      IF ZWasDF$ = "J" THEN _
         IF ZWasQ > 1 THEN _
            ZUserIn$ = ZUserIn$(2) : _
            GOTO 59866 _
         ELSE ZOutTxt$ = "Jump to what text" + ZPressEnterExpert$ : _
              CALL PopCmdStack : _
              IF ZWasQ = 0 THEN _
                 EXIT SUB _
              ELSE GOTO 59866
      IF ZWasDF$ <> "R" THEN _
         EXIT SUB
      ZUserIn$ = ZJumpLast$
59866 ZJumpTo$ = ZUserIn$
      CALL AllCaps (ZJumpTo$)
      ZJumpSearching = ZTrue
      ZJumpLast$ = ZJumpTo$
      EXIT SUB
59870 Temp$ = ""
      IF NOT ZJumpSupported THEN _
         RETURN
      IF ZJumpLast$ = "" THEN _
         Temp$ = LEFT$(",J)ump",2+4*(ZExpertUser+1)) _
      ELSE IF ZExpertUser THEN _
              Temp$ = ",J,R=" + ZJumpLast$ _
           ELSE Temp$ = ",J)ump,R)ejump=" + ZJumpLast$
      RETURN
      END SUB
'
59880 ' $SUBTITLE: 'CompDate -- subroutine to compute elased days'
' $PAGE
'
'  NAME    -- CompDate
'
'  INPUTS  --   PARAMETER     MEANING
'                   TYear       YEAR
'                   WasMM       MONTH
'                   WasDD       DAY
'                 Result!    LOCATION TO PLACE THE RESULT
'
'  OUTPUTS -- Result!        COMPUTE COMPUTATIONAL DATE
'
'  PURPOSE -- Computes a computational date from YEAR, MONTH, DAY.
'             Results may be used to compute the number of elapsed
'             days between two dates.  You may pass a 2 or 4 digit
'             year, but for meaningful results, be consistent
'
      SUB CompDate (TYear,WasMM,WasDD,Result!) STATIC
      IF WasMM < 1 OR WasMM > 12 THEN _
         WasMM = 1
      Result! = TYear * 365.0 + _
                INT((TYear - 1) / 4) + _
                (WasMM - 1) * 28 + _
                VAL(MID$("000303060811131619212426",(WasMM - 1) * 2 + 1,2)) - _
                ((WasMM > 2) AND ((TYear MOD 4) = 0)) + _
                WasDD
      END SUB
'
59890 ' $SUBTITLE: 'ExpireDate -- subroutine to display expiration date'
' $PAGE
'
'  NAME    -- ExpireDate
'
'  INPUTS  --   PARAMETER           MEANING
'             RegDate!          COMPUTATIONAL REGISTRATION DATE
'             RegPeriod         DAYS IN REGISTRATION PERIOD
'
'  OUTPUTS -- ExpDate$             DISPLAYABLE EXPIRATION DATE
'
'  PURPOSE -- Computes/creates a displayable registration
'             expiration date using registration date and days in
'             registration period.
'
      SUB ExpireDate (RegDate!,RegPeriod,ExpDate$) STATIC
      ExpDate! = RegDate! + RegPeriod
      ExpireYear = INT((ExpDate! - ExpDate! / 1461) / 365)
      ExpireDay = ExpDate! - (ExpireYear * 365.0 + INT((ExpireYear -1)/4))
      ExpireMonth = -((ExpireYear MOD 4)<>0) * _
                      (1 - (ExpireDay > 31) - (ExpireDay > 59) - _
                      (ExpireDay > 90) - (ExpireDay >120) - _
                      (ExpireDay > 151) - (ExpireDay > 181) - _
                      (ExpireDay > 212) - (ExpireDay > 243) - _
                      (ExpireDay > 273) - (ExpireDay > 304) - _
                      (ExpireDay > 334)) - ((ExpireYear MOD 4) = 0) * _
                      (1 - (ExpireDay > 31) - (ExpireDay > 60) - _
                      (ExpireDay > 91) - (ExpireDay >121) - _
                      (ExpireDay > 152) - (ExpireDay > 182) - _
                      (ExpireDay > 213) - (ExpireDay > 243) - _
                      (ExpireDay > 274) - (ExpireDay > 305) - _
                      (ExpireDay > 335))
      ExpireDay = (ExpireDay - ((ExpireMonth - 1) * 28 + _
         VAL(MID$("000303060811131619212426",(ExpireMonth -1) * 2 + 1,2)))) + _
         ((ExpireMonth > 2) AND ((ExpireYear MOD 4) = 0))
      ExpDate$ = RIGHT$("0" + MID$(STR$(ExpireMonth),2),2) + _
                  "/" + _
                  RIGHT$("0" + MID$(STR$(ExpireDay),2),2) + _
                  "/" + _
                  RIGHT$(STR$(ExpireYear),2)
      END SUB
'
59920 ' $SUBTITLE: 'ColorDir - builds a color FMS directory string'
' $PAGE
'
'  NAME    --  ColorDir
'
'  INPUTS  --  PARAMETER                   MEANING
'               Strng$              STRING TO ALTER
'               FMSDir$             "Y" FOR FMS DIR
'                                   "N" FOR PERSONAL DOWNLOAD
'
'     Colors in file listings are based on the colors chosen in CONFIG
'
      SUB ColorDir (Strng$,FMSDir$) STATIC
      IF ZWasGR < 2 THEN _
         EXIT SUB
      IF FMSDir$ = "N" THEN _
         GOTO 59921
      ON INSTR("\ *",LEFT$(Strng$,1)) GOTO 59924,59922,59923
59921 IF ZWasGR = 2 THEN
         Strng$ = ZFileColor1$ + LEFT$(Strng$,13) + ZFileColor2$ + MID$(Strng$,14,10) + _
                  ZFileColor3$ + MID$(Strng$,24,10) + ZFileColor4$ + MID$(Strng$,34,ZMaxDescLen)
      ELSE
         Strng$ = LEFT$(Strng$,13) + MID$(Strng$,14,10) + MID$(Strng$,24,10) + _
                  MID$(Strng$,34,ZMaxDescLen)
      END IF
      GOTO 59923
59922 Strng$ = ZFileColor5$ + Strng$
      EXIT SUB
59923 Strng$ = ZEmphasizeOff$ + Strng$
59924 END SUB
'
59930 ' $SUBTITLE: 'CheckColor - highlights based on search string'
' $PAGE
'
'  NAME    --  CheckColor
'
'  INPUTS  --  PARAMETER                   MEANING
'              LookFor$           STRING THAT TRIGGERS HIGHLIGHT
'              LookIn$            STRING BEING SEARCHED
'              EndColor$          TERMINATING COLOR
'
'  OUTPUTS --  Strng$             REVISED STRING
'
'  PURPOSE --  Adds highlighting to a string within a string.
'              Respects previous colorization.
      SUB CheckColor (LookIn$,LookFor$,PassedEndColor$) STATIC
      IF LookFor$ = "" THEN _
         EXIT SUB
      WasX$ = LookIn$
      CALL AllCaps (WasX$)
      StartColor = INSTR(WasX$,LookFor$)
      IF StartColor < 1 THEN _
         EXIT SUB
      EndColor$ = PassedEndColor$
      IF EndColor$ = "" THEN _
         EndColor$ = ZEmphasizeOff$ : _
         CALL FindLast (LEFT$(LookIn$,StartColor-1),ZEscape$,WhereFound,WasJ) : _
         IF WhereFound > 0 THEN _
            WasJ = INSTR(WhereFound,LookIn$,"m") : _
            IF WasJ > 0 THEN _
               EndColor$ = MID$(LookIn$,WhereFound,WasJ-WhereFound+1)
      CALL Bracket (LookIn$,StartColor,StartColor + LEN(LookFor$)-1,ZEmphasizeOn$,EndColor$)
      END SUB
'
59934 ' $SUBTITLE: 'SetHiLite - subroutine to reset highlight preference'
' $PAGE
'
'  NAME    --  SetHiLite
'
'  INPUTS  --  PARAMETER               MEANING
'              SetTo                   NEW VALUE (True or False)
'              ZEmphasizeOnDef$        STRING TURNS EMPHASIZE ON
'              ZEmphasizeOffDef$       STRING TURNS EMPHASIZE OFF
'
'  OUTPUTS --  ZHiLiteOff              CALLERS PREFERENCE ON HILITE
'              ZEmphasizeOn$           STRING TO USE FOR EMPHASIS
'              ZEmphasizeOff$          STRING TO USE AFTER EMPHASIS
'
'
      SUB SetHiLite (SetTo) STATIC
      ZHiLiteOff = (ZEmphasizeOnDef$ <> "" AND SetTo)
      IF ZHiLiteOff THEN
         ZEmphasizeOn$ = ""
         ZEmphasizeOff$ = ""
         ZDR1$ = ""
         ZDR2$ = ""
         ZDR3$ = ""
         ZDR4$ = ""
         ZFG1$ = ""
         ZFG2$ = ""
         ZFG3$ = ""
         ZFG4$ = ""
         ZFG5$ = ""
         ZFG6$ = ""
         ZFG7$ = ""
         ZFG8$ = ""
         ZFG9$ = ""
         ZFGA$ = ""
         ZFGB$ = ""
         ZFGC$ = ""
         ZFGD$ = ""
         ZFGE$ = ""
         ZFGF$ = ""
         ZFGG$ = ""
         ZBG0$ = ""
         ZBG1$ = ""
         ZBG2$ = ""
         ZBG3$ = ""
         ZBG4$ = ""
         ZBG5$ = ""
         ZBG6$ = ""
         ZBG7$ = ""
      ELSE
         ZEmphasizeOn$ = ZEmphasizeOnDef$
         ZFG1$ = ZFG1Def$
         ZFG2$ = ZFG2Def$
         ZFG3$ = ZFG3Def$
         ZFG4$ = ZFG4Def$
         ZFG5$ = ZFG5Def$
         ZFG6$ = ZFG6Def$
         ZFG7$ = ZFG7Def$
         ZFG8$ = ZFG8Def$
         ZFG9$ = ZFG9Def$
         ZFGA$ = ZFGADef$
         ZFGB$ = ZFGBDef$
         ZFGC$ = ZFGCDef$
         ZFGD$ = ZFGDDef$
         ZFGE$ = ZFGEDef$
         ZFGF$ = ZFGFDef$
         ZFGG$ = ZFGGDef$
         ZBG0$ = ZBG0Def$
         ZBG1$ = ZBG1Def$
         ZBG2$ = ZBG2Def$
         ZBG3$ = ZBG3Def$
         ZBG4$ = ZBG4Def$
         ZBG5$ = ZBG5Def$
         ZBG6$ = ZBG6Def$
         ZBG7$ = ZBG7Def$
      ENDIF
      END SUB
'
59940 ' $SUBTITLE: 'ColorPrompt - subroutine to colorize prompts'
' $PAGE
'
'  NAME    --  ColorPrompt
'
'  INPUTS  --  PARAMETER                   MEANING
'              Strng$              STRING TO COLORIZE
'              ZHiLiteOff          WHETHER HIGHLIGHTING IS OFF
'              ZEmphasizeOn$       STRING TO USE FOR EMPHASIS
'              ZEmphasizeOff$      STRING TO USE AFTER EMPHASIS
'
'  OUTPUTS --  Strng$              COLORIZED STRING
'
'  PURPOSE -- colorizes a string based on sysop settings
'             and the string.
'                        [...] is the default - put in emphasis
'                        <...> options to type - put in ZFG4$
'                        and first two preceeding words use ZFG1$ and ZFG2$
'                        options identified on right by ) and on
'                        left by space or comma - put in ZFG4$
'
      SUB ColorPrompt (Strng$) STATIC
      IF ZHiLiteOff THEN _
         EXIT SUB
      AlreadyColorized = (INSTR(Strng$,ZEscape$) > 0)
      WasX = INSTR(Strng$,"<")
      IF WasX > 0 THEN _
         GOTO 59943
      WasX = INSTR(Strng$,"[")   ' highlight default
      IF WasX > 0 THEN _
         WasY = INSTR(WasX,Strng$,"]") : _
         IF WasY > 0 THEN _
            CALL FindLast (LEFT$(Strng$,WasY),"[",WasX,Temp) : _
            CALL Bracket (Strng$,WasX,WasY,ZEmphasizeOn$,ZEmphasizeOff$)
      IF AlreadyColorized THEN _
         EXIT SUB
      WasX = INSTR(Strng$,"<")
      IF WasX < 1 THEN _
         GOTO 59945
59943 WasY = INSTR(WasX,Strng$,">")
      IF WasY < 1 THEN _
         GOTO 59945
      CALL Bracket (Strng$,WasX,WasY,ZFG4$,ZEmphasizeOff$)
      WasY = INSTR(Strng$," ")
      IF WasY > 1 AND WasY < WasX THEN _
         Strng$ = ZFGC$ + Strng$ : _
         WasZ = INSTR(WasY+1,Strng$," ") : _
         IF WasZ > 1 AND WasZ < WasX+LEN(ZFGC$) THEN _
            Strng$ = LEFT$(Strng$,WasZ) + ZFG9Def$ + MID$(Strng$,WasZ+1) + ZEmphasizeOff$
      EXIT SUB
59945 WasX = 1
      IF INSTR(Strng$,"More") > 0 THEN _
         Strng$ = ZFG4$ + LEFT$(Strng$,4) + ZEmphasizeOff$ + MID$(Strng$,5)
      IF INSTR(Strng$,"End list.") > 0 THEN _
         Strng$ = ZFG4$ + LEFT$(Strng$,9) + ZEmphasizeOff$ + MID$(Strng$,10)
      DidInsert = ZFalse
      WasL = LEN(ZFG4$)
59950 WasY = INSTR (WasX,Strng$,")")  ' x: where command begins, y: terminating pos
      WasZ = INSTR (WasX,Strng$,",")
      IF WasY = 0 OR (WasZ > 0 AND WasZ < WasY) THEN _
         WasY = WasZ
      WasK = LEN(Strng$)
      IF WasX > WasK THEN _
         EXIT SUB
      IF WasY < 1 THEN _
         IF NOT DidInsert THEN _
            EXIT SUB _
         ELSE WasY = WasK+1
      WasZ = WasY - 1
      WHILE WasZ > 0    ' got terminating pos: find beginning
         IF INSTR(ZOptionEnd$,MID$(Strng$,WasZ,1)) > 0 THEN _
            WasX = WasZ + 1 : _
            WasZ = 0
         WasZ = WasZ - 1
      WEND
      IF WasY-WasX < 3 THEN _     ' exclude commands too long
         CmndString$ = MID$(Strng$,WasX,WasY-WasX) : _
         WasX$ = CmndString$ : _
         CALL AllCaps (CmndString$) : _
         IF WasX$ = CmndString$ THEN _  ' exclude lower case
            DidInsert = ZTrue : _
            CALL Bracket (Strng$,WasX,WasY-1,ZFG4$,ZEmphasizeOff$) : _
            WasY = WasY + WasL
      WasX = WasY + 1
      GOTO 59950
      END SUB
'
59960 ' $SUBTITLE: 'Bracket - Inserts strings around a string'
' $PAGE
'
'  NAME    --  Bracket
'
'  INPUTS  --  PARAMETER                   MEANING
'              Strng$              INSERT IN THIS STRING
'              B4Here              INSERT 1st BEFORE THIS POS
'              AfterHere           INSERT 2nd AFTER THIS POS
'              B4String$           STRING TO INSERT BEFORE
'              AfterString$        STRING TO INSERT AFTER
'
'  OUTPUTS --  Strng$
'
'  PURPOSE -- Primarily for colorization
'
      SUB Bracket (Strng$,B4Here,AfterHere,B4String$,AfterString$) STATIC
      Strng$ = LEFT$(Strng$,B4Here-1) + _
               B4String$ + _
               MID$(Strng$,B4Here,AfterHere-B4Here+1) + _
               AfterString$ + _
               RIGHT$(Strng$,LEN(Strng$) - AfterHere)
      END SUB
'
59965 ' $SUBTITLE: 'UserColor - lets user set color for normal text'
' $PAGE
'
'  NAME    --  UserColor
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZEmphasizeOff$            NORMAL TEXT COLOR
'
'  OUTPUTS --  ZEmphasizeOff$            NEW TEXT COLOR
'              ZBoldText$                WHETHER BOLD (0 NOT, 1 BOLD)
'              ZUserTextColor            ANSI COLOR SELECTED
'
'  PURPOSE --  Lets caller select desired color and whether bold.
'
      SUB UserColor STATIC
      IF ZHiLiteOff THEN _
         EXIT SUB
59970 CALL QuickTPut (ZEmphasizeOff$,0)
      ZOutTxt$ = "Make text R)ed,G)reen,Y)ellow,B)lue,P)urple,C)yan,W)hite" + ZPressEnterExpert$
      GOSUB 59973
      IF ZWasQ = 0 THEN _
         ZEmphasizeOff$ = ZEscape$ + "[" + ZBoldText$ + _
             ";40;" + MID$(STR$(ZUserTextColor),2) + "m" : _
         EXIT SUB
      CALL AllCaps (ZUserIn$)
      WasX = INSTR("RGYBPCW",ZUserIn$)
      IF WasX = 0 THEN _
         GOTO 59970
      ZUserTextColor = 30 + WasX
      ZOutTxt$ = "Make text BRIGHT (Y,[N])"
      GOSUB 59973
      ZBoldText$ = CHR$(48 - ZYes)
      ZEmphasizeOff$ = ZEscape$ + "[" + ZBoldText$ + ";40;" + MID$(STR$(ZUserTextColor),2) + "m"
      GOTO 59970
59973 ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm = -1 THEN _
         EXIT SUB
      RETURN
      END SUB
'
59980 ' $SUBTITLE: 'SetGraphic - Sets user graphic preference'
' $PAGE
'
'  NAME    --  SetGraphic
'
'  INPUTS  --  PARAMETER                   MEANING
'              GraphicsNumber        0=NONE, 1=ASCII, 2=COLOR
'
'  OUTPUTS --  ZWasGR                SHARED VAR - SET TO
'                                    Graphics.Number
'              ZUserGraphicDefault$  WHAT ADD TO FILE NAME TO
'                                    SEE IF GOT GRAPHICS FILE VER
'
'
'  PURPOSE --  Sets file graphics preference
'
      SUB SetGraphic (GraphicsNumber) STATIC
      ZWasGR = GraphicsNumber
      IF ZWasGR = 2 THEN _
         ZDR1$ = ZFG1Def$ : _
         ZDR2$ = ZFG2Def$ : _
         ZDR3$ = ZFG3Def$ : _
         ZDR4$ = ZFG4Def$ : _
         ZDR5$ = ZFG5Def$ : _
         ZDR6$ = ZFG6Def$ : _
         ZDR7$ = ZFG7Def$ : _
         ZDR8$ = ZFG8Def$ : _
         ZDR9$ = ZFG9Def$ : _
         ZDRA$ = ZFGADef$ : _
         ZDRB$ = ZFGBDef$ : _
         ZDRC$ = ZFGCDef$ : _
         ZDRD$ = ZFGDDef$ : _
         ZDRE$ = ZFGEDef$ : _
         ZDRF$ = ZFGFDef$ : _
         ZDRG$ = ZFGGDef$ _
      ELSE ZDR1$ = "" : _
           ZDR2$ = "" : _
           ZDR3$ = "" : _
           ZDR4$ = "" : _
           ZDR5$ = "" : _
           ZDR6$ = "" : _
           ZDR7$ = "" : _
           ZDR8$ = "" : _
           ZDR9$ = "" : _
           ZDRA$ = "" : _
           ZDRB$ = "" : _
           ZDRC$ = "" : _
           ZDRD$ = "" : _
           ZDRE$ = "" : _
           ZDRF$ = "" : _
           ZDRG$ = ""
      IF ZRIPTest = ZTrue THEN _
         ZUserGraphicDefault$ = "R" _
      ELSE ZUserGraphicDefault$ = MID$(" GC",ZWasGR+1, - (ZWasGR > 0))
      END SUB
'
60000 ' $SUBTITLE: 'EofComm - Determines whether input in comm port buffer'
' $PAGE
'
'  NAME    --  EofComm
'
'  INPUTS  --  PARAMETER                   MEANING
'               ZFossil              WHETHER FOSSIL DRIVER USED
'               ZComPort             COMM PORT # IN USE
'
'  OUTPUTS --  NoChars            -1 (True) IF NO CHARS IN BUFFER.
'                                    ANYTHING ELSE MEANS HAS CHAR.
'
'  PURPOSE -- Query comm port to see if input waiting
'
      SUB EofComm (NoChars) STATIC
      IF ZFossil THEN _
         CALL FosReadAhead(ZComPort,NoChars) _
      ELSE NoChars = EOF(3)
      END SUB
'
60100 ' $SUBTITLE: 'GlobalSrchRepl - Global search and replace'
' $PAGE
'
'  NAME    --  GlobalSrchRepl
'
'  INPUTS  --  PARAMETER                   MEANING
'              Strng$              STRING TO EDIT
'              LookFor$            STRING TO LOOK FOR
'              ReplaceBy$          STRING TO REPLACE BY
'
'  OUTPUTS --  Strng$              EDITED STRING
'
'  PURPOSE --  Replaces every occurence of LookFor$ that
'                         is in Strng$ by ReplaceBy$
'
      SUB GlobalSrchRepl (Strng$,LookFor$,ReplaceBy$,OverStrike) STATIC
      IF LookFor$ = "" THEN _
         EXIT SUB
      WasX = 1
      WasL = LEN(ReplaceBy$)
      ZMsgPtr = LEN(LookFor$)
60102 WasY = INSTR(WasX,Strng$,LookFor$)
      IF WasY < 1 THEN _
         EXIT SUB
      IF OverStrike THEN _
         MID$(Strng$,WasY) = ReplaceBy$ + SPACE$((WasL-ZMsgPtr)*(WasL < ZMsgPtr)) _
      ELSE Strng$ = LEFT$(Strng$,WasY-1) + _
                    ReplaceBy$ + _
                    RIGHT$(Strng$,LEN(Strng$)-WasY+1-ZMsgPtr)
      WasX = WasY + WasL
      IF WasX > LEN(Strng$) THEN _
         EXIT SUB
      GOTO 60102
      END SUB
'
60130 ' $SUBTITLE: 'MetaGSR -- Meta Global search and replace'
' $PAGE
'
'  NAME    --  MetaGSR
'
'  INPUTS  --  PARAMETER               MEANING
'              Strng$              STRING TO EDIT
'
'  OUTPUTS --  Strng$              EDITED STRING
'
'  PURPOSE --  Global search and replace for meta variables
'
      SUB MetaGSR (Strng$,OverStrike) STATIC
      WasY = 1
60131 IF WasY > LEN(Strng$) THEN _
         EXIT SUB
      WasX = INSTR(WasY,Strng$,"[")
      IF WasX = 0 THEN _
         EXIT SUB
      WasY = INSTR(WasX,Strng$,"]")
      IF WasY = 0 THEN _
         EXIT SUB
      ZMsgPtr = WasY-WasX+1
      Temp = WasY-WasX-1
      CALL CheckInt(MID$(Strng$,WasX+1,Temp))
      IF (ZErrCode > 0) OR (ZTestedIntValue < 1) OR (ZTestedIntValue > ZMaxWorkVar) THEN _
         GOTO 60135
      IF ((ZTestedIntValue < 10) AND (Temp = 1)) OR ((ZTestedIntValue > 9) AND (Temp = 2)) THEN _
         GOTO 60132
      WasY = WasX + 1
      GOTO 60131
60132 WorkHold$ = ZGSRAra$(ZTestedIntValue)
      IF WasY = LEN(Strng$) THEN _
         GOTO 60151
      IF MID$(Strng$,WasY+1,1) <> "(" THEN _
         GOTO 60151
      WasI = INSTR(WasY+1,Strng$,")")
      IF WasI = 0 THEN _
         GOTO 60151
      WasJ = INSTR(WasY+1,Strng$,":")
      IF WasJ > WasI THEN _
         GOTO 60151
      CALL CheckInt (MID$(Strng$,WasY+2))
      IF (ZErrCode > 0) OR (ZTestedIntValue < 1) OR _
         (ZTestedIntValue > LEN(WorkHold$)) THEN _
            GOTO 60151
      WasY = WasI
      ZMsgPtr = WasI-WasX+1
      StartSub = ZTestedIntValue
      CALL CheckInt (MID$(Strng$,WasJ+1))
      IF ZErrCode > 0 OR ZTestedIntValue < 1 OR _
         (ZTestedIntValue > LEN(WorkHold$)) THEN _
            GOTO 60151
      LenSub = ZTestedIntValue
      WorkHold$ = MID$(WorkHold$,StartSub,LenSub)
      GOTO 60151
60135 MetaVal$ = MID$(Strng$,WasX+1,WasY-WasX-1)
      WasI = INSTR("      BAUD  CBAUD PORT  PORT# PARITYPROTO NODE  FILE  UPDIR ",MetaVal$)
      IF WasI = 0 OR LEN(MetaVal$) < 4 THEN _
         WasY = WasX + 1 : _
         GOTO 60131
      WasJ = (WasI-1)\6 + 1
      WasK = (WasI+4)\6 + 1
      IF WasK > WasJ THEN _
         EXIT SUB
      ON WasJ GOTO 60155, _
                60137, _
                60138, _
                60139, _
                60141, _
                60143, _
                60145, _
                60147, _
                60149, _
                60150, _
                60151
60137 WorkHold$ = ZTalkToModemAt$
      GOTO 60151
60138 WorkHold$ = ZCBaud$
      GOTO 60151
60139 WorkHold$ = ZComPort$
      GOTO 60151
60141 WorkHold$ = MID$(ZComPort$,4)
      GOTO 60151
60143 WorkHold$ = MID$(ZBaudParity$,INSTR(ZBaudParity$,",")+1,1)
      GOTO 60151
60145 WorkHold$ = ZWasFT$
      GOTO 60151
60147 WorkHold$ = ZNodeID$
      GOTO 60151
60149 IF ZWasBatchTransfer AND NOT ZHighSpeedTransfer THEN _
         WorkHold$ = ZUpldSubDir$ + "\" : _
         GOTO 60151
      IF ZBatchTransfer OR ZHighSpeedTransfer THEN _
         WorkHold$ = "@" + ZDownloadWorkFile$ _
      ELSE WorkHold$ = ZFileName$
      GOTO 60151
60150 WorkHold$ = ZUpldSubDir$
60151 WasL = LEN(WorkHold$)
      IF OverStrike THEN _
         MID$(Strng$,WasX) = WorkHold$ + SPACE$((WasL-ZMsgPtr)*(WasL < ZMsgPtr)) _
      ELSE Strng$ = LEFT$(Strng$,WasX-1) + WorkHold$ + RIGHT$(Strng$,LEN(Strng$)-WasY)
      WasY = 1 ' WasY = WasX + WasL
      GOTO 60131
60155 WasY = WasY + 1
      GOTO 60131
      END SUB
'
60180 ' $SUBTITLE: 'TimeLock - Test TIME LOCK for premium features'
' $PAGE
'
'  NAME    --  TimeLock  (written by Doug Azzarito)
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZTimeLockSet             SECONDS/SESSION TO LOCK
'
'  OUTPUTS --  ZSubParm              -1 IF FEATURE IS LOCKED
'
'  PURPOSE -- Check elapsed time for lock duration
'
      SUB TimeLock STATIC
      CALL TimeRemain(MinsRemaining)
      IF ZSecsUsedSession! >= ZTimeLockSet THEN _
         ZOK = ZTrue : _
         EXIT SUB
      ZOutTxt$ = ZFirstName$
      CALL NameCaps(ZOutTxt$)
      CALL QuickTPut1 ("Sorry, " + ZOutTxt$ + ", function locked" + _
                   STR$(INT((ZTimeLockSet-ZSecsUsedSession!)/60)) + _
                   " more minutes" + _
                   STR$(INT(ZTimeLockSet-ZSecsUsedSession!) MOD 60) + " seconds")
      CALL BufFile(ZHelpPath$+"TIMELOCK"+ZHelpExtension$,WasX,ZFalse)
      ZOK = ZFalse
      ZLastIndex = 0
      IF ZAutoLogoffReq = ZTrue THEN _
         ZAutoLogoffReq = ZFalse
      IF NOT ZExpertUser THEN _
        CALL SkipLine(1) : _
        CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
      END SUB
'
60200 ' $SUBTITLE: 'MarkTime - Give feedback for lengthy processes'
' $PAGE
'
'  NAME    --  MarkTime
'
'  INPUTS  --  PARAMETER                   MEANING
'              DotNumber          HOW MANY DOTS PRINTED
'
'  OUTPUTS --  DotNumber
'
'  PURPOSE --  Marks time by putting colorized dots out
'              to 4, then erasing or using sysop defined
'              characters from CONFIG
'
      SUB MarkTime (DotNumber) STATIC
      IF char1$ = "" THEN
         IF ZTwirlyType$ = "" THEN
            char1$ = "."
            char2$ = char1$
            char3$ = char1$
            char4$ = char1$
            WasX$ = ""
         ELSE
            char1$ = MID$(ZTwirlyType$,1,1)
            char2$ = MID$(ZTwirlyType$,2,1)
            char3$ = MID$(ZTwirlyType$,3,1)
            char4$ = MID$(ZTwirlyType$,4,1)
         END IF
         IF ZTwirlyType$ = "" THEN _
            TimeToWait! = 1.00 _
         ELSE TimeToWait! = 0.50
      END IF
      TimeNow! = TIMER
      IF TimeNow! - PrevTI! < TimeToWait! THEN _
         EXIT SUB
      PrevTI! = TimeNow!
      IF ZTwirlyType$ = "" THEN
         IF RemoveDot AND DotNumber > 0 THEN _
            CALL QuickTPut (ZBackSpace$,0) : _
            DotNumber = DotNumber - 1 : _
            WasX$ = "" : _
            EXIT SUB
      END IF
      IF ZTwirlyType$ <> "" THEN
         IF DotNumber = 0 THEN _
            CALL QuickTPut("  ",0)
         IF DotNumber > 4 THEN _
            DotNumber = 1
         WasX$ = ZBackSpace$ + " " + ZBackSpace$
      END IF
      DotNumber = DotNumber + 1
      ON DotNumber GOTO 60201,60202,60203,60204
60201 WasX$ = WasX$ + char1$
      RemoveDot = ZFalse
      GOTO 60205
60202 WasX$ = WasX$ + char2$
      GOTO 60205
60203 WasX$ = WasX$ + char3$
      GOTO 60205
60204 WasX$ = WasX$ + char4$
      RemoveDot = ZTrue
60205 CALL QuickTPut (WasX$,0)
      WasX$ = ""
      EXIT SUB
      END SUB
'
60300 ' $SUBTITLE: 'AutoPage - NOTIFIES ZSysop WHEN SPECIFIC USER CALLS'
' $PAGE
'
'  NAME    --  AutoPage      'Contributed  by Gregg and Bob Snyder
'                            'and RoseMarie Siddiqui
'
'  INPUTS  --  ZAutoPageDef$     LIST OF CONDITIONS THAT TRIGGER
'                                NOTIFICATION AND HOW
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- Search ZAutoPageDef$ for match on whether
'             on name, security level, whether new user.
'             Also controls whether caller notified and
'             number of times sysop has bell rung.
'             And what tune to play (if any).
'
      SUB AutoPage STATIC
      CALL FindIt (ZAutoPageDef$)
      IF NOT ZOK THEN _
         EXIT SUB
      ZErrCode = 0
      ZOK = ZFalse
      WHILE NOT EOF(2) AND ZOK = ZFalse AND ZErrCode = 0
         CALL ReadParms (ZWorkAra$(),4,1)
         IF ZErrCode = 0 THEN _
            ZOK = (ZWorkAra$(1) = ZActiveUserName$) : _
            IF NOT ZOK THEN _
               IF ZNewUser AND ZWorkAra$(1) = "NEWUSER" THEN _
                  ZOK = ZTrue _
               ELSE IF LEFT$(ZWorkAra$(1),1) = "/" AND LEN(ZWorkAra$(1)) > 2 THEN _
                       ZWasB = INSTR (2,ZWorkAra$(1),"/") : _
                       IF ZWasB > 0 AND LEN(ZWorkAra$(1)) > ZWasB THEN _
                          IF ZUserSecLevel <= VAL(MID$(ZWorkAra$(1),ZWasB+1)) AND _
                             ZUserSecLevel >= VAL(MID$(ZWorkAra$(1),2)) THEN _
                                ZOK = ZTrue
      WEND
      CLOSE 2
      IF ZErrCode > 0 OR NOT ZOK THEN _
         ZErrCode = 0 : _
         EXIT SUB
      ZPageStatus$ = "AP!"
      IF LEFT$(ZWorkAra$(2),1) = "N" THEN _
         ZOutTxt$ = "Telling SysOp you're on..." : _
         CALL RingCaller
      ZWasB = (ZWorkAra$(4) = "")
      ZWorkAra$(5) = ""
      TempSnoop = ZSnoop
      ZSnoop = ZTrue
      CALL Line25
      FOR WasI = 1 TO VAL(ZWorkAra$(3))
         IF ZWasB THEN _
            CALL LPrnt (ZBellRinger$,0) : _
         ELSE ZWorkAra$(5) = ZWorkAra$(5) + "O4 X" + VARPTR$(ZWorkAra$(4))
      NEXT
      IF NOT ZWasB THEN _
         CALL RBBSPlay (ZWorkAra$(5))
      ZSnoop = TempSnoop
      END SUB
'
62520 ' $SUBTITLE: 'PutMsgAttr - subroutine to save msg. attributes'
' $PAGE
'
'  NAME    --  PutMsgAttr
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZWasQ
'              ZUserIn$
'              ZLinesInMsg
'              ZWasS
'              ZNonStop
'              ZMsgDimIndex
'
'  OUTPUTS --  ZWasSQ
'              ZWasLG$(10)
'              ZLinesInMsgSave
'              ZWasSL
'              ZNonStopSave
'              ZMsgDimIndexSave
'
'  PURPOSE --  WHEN REPLYING TO A MESSAGE THIS ROUTINE SAVES
'              THE ATTRIBUTES OF THE ORGINAL MESSAGE
'
      SUB PutMsgAttr STATIC
      ZWasSQ = ZWasQ
      ZWasLG$(10) = ZUserIn$
      ZLinesInMsgSave = ZLinesInMsg
      ZWasSL = ZWasS
      ZNonStopSave = ZNonStop
      ZMsgDimIndexSave = ZMsgDimIndex
      END SUB
'
62530 ' $SUBTITLE: 'GetMsgAttr - subroutine to get msg. attributes'
' $PAGE
'
'  NAME    --  GetMsgAttr
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZWasSQ
'              ZWasLG$(10)
'              ZLinesInMsgSave
'              ZWasSL
'              ZNonStopSave
'              ZMsgDimIndexSave
'
'  OUTPUTS --  ZWasQ
'              ZUserIn$
'              LINES.IN.MESSAGESAVE
'              ZWasS
'              ZNonStop
'              ZMsgDimIndex
'              ZKillMessage
'
'  PURPOSE --  After replying to a message this routine restores
'              the attributes of the orginal message
'
      SUB GetMsgAttr STATIC
      ZWasQ = ZWasSQ
      ZUserIn$ = ZWasLG$(10)
      ZLinesInMsg = ZLinesInMsgSave
      ZWasS = ZWasSL
      ZNonStop = ZNonStopSave
      ZMsgDimIndex = ZMsgDimIndexSave
      ZKillMessage = ZFalse
      END SUB
'
62540 ' $SUBTITLE: 'RptTime -- Reports time on system'
' $PAGE
'
'  NAME    --  RptTime
'
'              PARAMETER                   MEANING
'  INPUTS  --  NONE
'
'  OUTPUTS --  NONE
'
'  PURPOSE --  Tells user time used on system
'
      SUB RptTime
      CALL SkipLine (1)
      CALL GetTime
      CALL AMorPM
      Mins = (ZSessionHour * 60) + ZSessionMin
      CALL Carrier
      IF ZSubParm = -1 THEN _
         EXIT SUB
      CALL QuickTPut1 (ZFGB$ + "It's Now: " + ZFGF$ + DATE$ + ZFGB$ + " at " + _
                       ZFGF$ + TIME$ + ZEmphasizeOff$)
      CALL QuickTPut1 (ZFGB$ + "Time On:" + ZFGF$ + STR$(Mins) + ZFGB$ + " mins," + _
                        ZFGF$ + STR$(ZSessionSec) + ZFGB$ + " secs" + ZEmphasizeOff$)
      CALL Talk (7,ZOutTxt$)
      END SUB
'
62600 ' $SUBTITLE: 'Protocol - Determine protocols available'
' $PAGE
'
'  NAME    -- Protocol
'
'             PARAMETER                MEANING
'  INPUTS  -- ZProtoDef$               FILE OF INSTALLED PROTOCOLS
'
'  OUTPUTS -- ZTransferOption$         PROMPT FOR PROTOCOL CHOICE
'             ZDefaultXfer$            LETTERS OF PROTOCOLS
'             ZInternalEquiv$          INTERNAL PROTOCOL TO USE
'
'  PURPOSE -- TO determine what protocols are available to user
'
      SUB Protocol STATIC
      CALL FindIt (ZProtoDef$)
      IF NOT ZOK THEN _
         ZTransferOption$ = "A)scii,X)modem,C)rcXmodem,Y)modem" : _
         ZInternalEquiv$ = "AXCY" : _
         ZDefaultXfer$ = "AXCY" : _
         GOTO 62604
      ZDefaultXfer$ = ""
      ZInternalEquiv$ = ""
      ZTransferOption$ = ""
      WasL = 0
62602 IF EOF(2) THEN _
         GOTO 62604
      CALL ReadParms (ZWorkAra$(),13,1)
      IF ZErrCode > 0 THEN _
         EXIT SUB
      ZDefaultXfer$ = ZDefaultXfer$ + " "
      ZInternalEquiv$ = ZInternalEquiv$ + " "
      IF ZUserSecLevel < VAL(ZWorkAra$(2)) THEN _
         GOTO 62602
      IF LEFT$(ZWorkAra$(5),1) = "R" THEN _
         IF NOT ZReliableMode THEN _
            GOTO 62602
      IF LEFT$(ZWorkAra$(3),1) = "I" THEN _
         GOTO 62603
      WasX = INSTR(ZWorkAra$(12)+" "," ")
      WasX$ = LEFT$(ZWorkAra$(12),WasX-1)
      CALL FindFile (WasX$,Found)
      IF Found THEN _
         WasX = INSTR(ZWorkAra$(13)+" "," ") : _
         WasX$ = LEFT$(ZWorkAra$(13),WasX-1) : _
         CALL FindFile (WasX$,Found)
      IF NOT Found THEN _
         GOTO 62602
62603 MID$(ZDefaultXfer$,LEN(ZDefaultXfer$),1) = LEFT$(ZWorkAra$(1),1)
      CALL FindLast (ZWorkAra$(1),ZCrLf$,WasX,WasI)
      CALL FindLast (ZWorkAra$(1),ZSmartTextCode$,WasDan,NumFinds)
      NumFinds = NumFinds * 3
      IF WasX > 0 AND WasX >= (LEN(ZWorkAra$(1)) - NumFinds - 2) THEN _
         ZWorkAra$(1) = LEFT$(ZWorkAra$(1),WasX-1)
      IF (WasL + (LEN(ZWorkAra$(1)) - NumFinds) < 72) AND WasX = 0 THEN
         IF ZTransferOption$ = "" THEN _
            AddSpace = 0 _
         ELSE AddSpace = 3
         ZTransferOption$ = ZTransferOption$ + SPACE$(AddSpace) + ZWorkAra$(1)
         WasL = WasL + (LEN(ZWorkAra$(1)) - NumFinds) + 1
      ELSE
         WasL = (LEN(ZWorkAra$(1)) - NumFinds) + 1
         ZTransferOption$ = ZTransferOption$ + ZCrLf$ + ZWorkAra$(1)
      END IF
      IF LEFT$(ZWorkAra$(3),1) = "I" AND RIGHT$(ZWorkAra$(3),1) <> "I" THEN _
         MID$(ZInternalEquiv$,LEN(ZInternalEquiv$),1) = RIGHT$(ZWorkAra$(3),1)
      GOTO 62602
62604 IF INSTR(ZInternalEquiv$,"N") > 0 THEN _
         GOTO 62605
      IF WasX = 0 THEN _
         ZTransferOption$ = ZTransferOption$ + ",N)one" _
      ELSE ZTransferOption$ = ZTransferOption$ + ZCrLf$ + "N)one"
      ZDefaultXfer$ = ZDefaultXfer$ + "N"
      ZInternalEquiv$ = ZInternalEquiv$ + "N"
62605 IF LEFT$(ZTransferOption$,1) = "," THEN _
         ZTransferOption$ = MID$(ZTransferOption$,2)
      IF INSTR(ZDefaultXfer$,ZUserXferDefault$) = 0 THEN _
         CALL QuickTPut1 ("Protocol "+ZUserXferDefault$+" unavailable.  Default reset to None") : _
         ZUserXferDefault$ = MID$(ZDefaultXfer$,INSTR(ZInternalEquiv$,"N"),1)
      END SUB
'
62620 ' $SUBTITLE: 'Transfer - Subroutine for external protocols'
' $PAGE
'
'  NAME    -- Transfer
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZTransferFunction         = 1 DOWNLOAD FILE TO USER
'                                        = 2 UPLOAD FILE TO RBBS-PC
'              ZFileName$                NAME OF FILE FOR Transfer
'              ZComPort$                 NAME OF COMMUNICATIONS PORT
'                                        TO BE USED BY KERMIT (COM1
'                                        OR COM2)
'              ZBPS                      = -1 FOR   300 BAUD
'                                        = -2 FOR   450 BAUD
'                                        = -3 FOR  1200 BAUD
'                                        = -4 FOR  2400 BAUD
'                                        = -5 FOR  4800 BAUD
'                                        = -6 FOR  7200 BAUD
'                                        = -7 FOR  9600 BAUD
'                                        = -8 FOR 12000 BAUD
'                                        = -9 FOR 14400 BAUD
'                                        = -10 FOR 16800 BAUD
'                                        = -11 FOR 19200 BAUD
'                                        = -12 FOR 21600 BAUD
'                                        = -13 FOR 24000 BAUD
'                                        = -14 FOR 26400 BAUD
'                                        = -15 FOR 28800 BAUD
'                                        = -16 FOR 38400 BAUD
'                                        = -17 FOR 57600 BAUD
'
'  OUTPUTS  -- NONE
'
'  PURPOSE -- To transfer files using external protocols
'
      SUB Transfer STATIC
      IF ZUpBatchTransfer THEN _
         EXIT SUB
      IF ZPrivateDoor THEN _
         CALL PrivDoorRtn : _
         EXIT SUB
      IF ZTransferFunction = 1 THEN _
         ZUserIn$ = ZDownTemplate$ : _
         ZWasZ$ = "send: " _
      ELSE IF ZTransferFunction = 2 THEN _
              ZUserIn$ = ZUpTemplate$ : _
              ZWasZ$ = "receive: "
      CALL MetaGSR (ZUserIn$,ZFalse)
      ProtoStr$ = ZFG9$ + "Protocol     : " + ZFGF$ + ZProtoPrompt$ + ZEmphasizeOff$
      CALL BufString (ProtoStr$,4096,WasX)
      CALL SkipLine(1)
      CALL QuickTPut (ZFG9$ + "Ready to " + ZWasZ$ + ZEmphasizeOff$,0)
      IF ZBatchTransfer OR (ZWasBatchTransfer AND NOT ZHighSpeedTransfer) THEN _
         CALL QuickTPut1 (ZFGF$ + "(BATCH)" + ZEmphasizeOff$)
      IF (ZWasBatchTransfer AND NOT ZHighSpeedTransfer) OR ZTransferFunction = 2 THEN _
         Temp$ = ZUploadWorkFile$ : _
         GOTO 62621
      IF ZBatchTransfer OR ZHighSpeedTransfer THEN
         Temp$ = ZDownloadWorkFile$
      ELSE
         CALL QuickTPut1 (ZFG7$ + ZFileNameHold$ + ZEmphasizeOff$)
         GOTO 62622
      END IF
62621 CALL OpenWork (2,Temp$,ZFalse)
      IF ZErrCode > 0 THEN
        CLOSE 2
        GOTO 62622
      END IF
      WHILE NOT EOF(2)
        CALL ReadAny
        CALL BreakFileName (ZOutTxt$,ZWasZ$,ZWasY$,WasX$,ZTrue)
        CALL QuickTPut1 (ZFGE$ + "   " + ZWasY$+WasX$ + ZEmphasizeOff$)
      WEND
62622 IF ZAutoEnd = 1 THEN _
         CALL QuickTPut1 (ZFG9$ + "Automatic LogOff if " + _
              ZFGB$ + "TRANSFER " + _
              ZFG9$ + "Successful" + ZEmphasizeOff$)
      CALL PrivDoorRtn
      END SUB
'
62624 ' $SUBTITLE: 'PrivDoorRtn - subroutine to exit as a private door.'
' $PAGE
'
'  NAME    -- PrivDoorRtn
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZTransferFunction         = 1 DOWNLOAD FILE TO USER
'                                        = 2 UPLOAD FILE TO RBBS-PC
'                                        = 3 USER REGISTRATION PGM
'              ZUserIn$                      NAME OF FILE TO EXIT TO
'              ZComPort$                 NAME OF COMMUNICATIONS PORT
'                                        TO BE USED BY KERMIT (COM1
'                                        OR COM2)
'              ZBPS                      = -1 FOR   300 BAUD
'                                        = -2 FOR   450 BAUD
'                                        = -3 FOR  1200 BAUD
'                                        = -4 FOR  2400 BAUD
'                                        = -5 FOR  4800 BAUD
'                                        = -6 FOR  9600 BAUD
'                                        = -7 FOR 19200 BAUD
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- To transfer control to another program
'
      SUB PrivDoorRtn STATIC
      IF ZPrivateDoor THEN _
         GOTO 62630
      IF ZFakeXRpt THEN _
         CALL FakeXRpt (ZWasFT$)
      IF ZAdvanceProtoWrite THEN _
         CALL OpenOutW ("XFER"+ZNodeID$+".DEF") : _
         IF ZErrCode < 1 THEN _
            CALL PrintWork (2,ZFileName$+",,"+ZWasFT$,ZFalse) : _
            CLOSE 2
      IF (ZTransferFunction = 1 AND LEFT$(ZProtoMethod$,1) = "S") OR _
         (ZTransferFunction = 2 AND RIGHT$(ZProtoMethod$,1) = "S") THEN _
         GOTO 62629
62628 WasX$ = LEFT$(ZUserIn$,INSTR(ZUserIn$+" "," ")-1)
      IF WasX$ = "" THEN _
         EXIT SUB
      CALL FindIt (WasX$)
      IF NOT ZOK THEN _
         ZOutTxt$ = "Missing door program" : _
         CALL UpdtCalr (ZOutTxt$ + " " + WasX$,1) : _
         ZSnoop = ZTrue : _
         CALL LPrnt (ZOutTxt$,1) : _
         EXIT SUB
      ZOutTxt$(1) = "CLS"
      GOSUB 62633
      ZOutTxt$(2) = "ECHO" + ZOutTxt$
      ZOutTxt$(3) = ZDiskForDos$ + _
              "COMMAND /C " + _
              ZUserIn$
      ZOutTxt$(4) = ZRBBSBat$
      ZPrivateDoor = ZTrue
      CALL QuickTPut1 ("Exiting to External Pgm for Transfer")
      LOCATE 25,1
      CALL LPrnt(ZLineFeed$,0)
      CALL DoorInfo
      CALL RBBSExit (ZOutTxt$(),4)
62629 GOSUB 62633
      CALL LPrnt (ZOutTxt$,1)
      CALL ShellExit (ZUserIn$)
62630 IF ZPrivateDoor THEN _
         CALL RestoreCom : _
         CALL DelayTime (7 + ZBPS) : _
         CALL SetBaud : _
         CALL QuickTPut1 ("Reloading RBBS-PC.  Please be patient.")
62631 CALL SkipLine (2)
      LOCATE 24,1
62632 EXIT SUB
62633 ZOutTxt$ = ZEscape$ + ZFGF$ + STR$(ZUserSecLevel) + _
                 " " + _
                 ZActiveUserName$ + _
                 " " + _
                 ZWasCI$ + ZEmphasizeOff$
      RETURN
      END SUB
'
62650 ' $SUBTITLE: 'FakeXRpt - subroutine to create fake xfer report'
' $PAGE
'
'  NAME    --  FakeXRpt
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZFileNameHold$      FILE TO BE TRANSFERRED
'              ProtoUsed$          PROTOCOL USED
'
'  OUTPUTS --  WRITES OUT TRANSFER FILE REPORT
'
'  PURPOSE --  External protocol drivers that do not write
'              out a standard transfer report must have one
'              provided in order for "dooring" to external
'              protocols to work properly, since this file
'              is read upon returning from an external protocol.
'
      SUB FakeXRpt (ProtoUsed$) STATIC
      CLOSE 2
      OPEN "O",2,"XFER" + _
                 ZNodeFileID$ + _
                 ".DEF"
      PRINT #2,ZFileName$
      PRINT #2,
      PRINT #2,ProtoUsed$
      PRINT #2,"S"
      CLOSE 2
      END SUB
'
62660 ' $SUBTITLE: 'SetExpert - subroutine to adjust for expert change'
' $PAGE
'
'  NAME    --  SetExpert
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZExpertUser          WHETHER IS AN EXPERT
'              FileSystem           ARE WE IN THE FILE SYSTEM
'
'  OUTPUTS --  ZMorePrompt$         PAUSE PROMPT
'              ZPressEnter$         PROMPT TO PRESS ENTER
'
'  PURPOSE --  Make more helpful prompt for novices and shorter
'              one for experts
'
      SUB SetExpert (FileSystem) 'STATIC
      IF FileSystem THEN _
         ZMorePrompt$ = ZFGA$ + "-" + LTRIM$(STR$(ZNumMarked)) + _
                        " Marked-" + ZEmphasizeOff$ + " More "  : _
      ELSE ZMorePrompt$ = "More "
      IF ZExpertUser THEN _
         ZMorePrompt$ = ZMorePrompt$ + "([Y],N,C,A" : _
         ZPressEnter$ = ZPressEnterExpert$ : _
         EXIT SUB _
      ELSE ZMorePrompt$ = ZMorePrompt$ + "[Y]es,N)o,C)ont,A)bort" : _
           ZPressEnter$ = ZPressEnterNovice$
      END SUB
'
62668 ' $SUBTITLE: 'NewPassword - subroutine to get new password'
' $PAGE
'
'  NAME    --  NewPassword
'
'  INPUTS  --  PARAMETER                   MEANING
'              Prompt$               PROMPT TO DISPLAY
'              DisallowSpaces        WHETHER ANSWER CAN HAVE SPACES
'
'  OUTPUTS --  ZWasZ$                PASSWORD
'
'  PURPOSE --  To get a new password.
'
      SUB NewPassword (Prompt$,DisallowSpaces) STATIC
62670 ZOutTxt$ = Prompt$
      ZMacroMin = 99
      ZHidden = ZTrue
      CALL PopCmdStack
      ZHidden = ZFalse
      IF ZSubParm < 0 OR ZWasQ = 0 THEN _
         EXIT SUB
      ZOutTxt$ = ""
      IF LEN(ZUserIn$) > 15 THEN _
         ZOutTxt$ = "15 chars max"
      IF INSTR(ZUserIn$,";") > 0 THEN _
         ZOutTxt$ = "Cannot use ';'"
      IF DisallowSpaces THEN _
         IF ZUserIn$ = SPACE$(LEN(ZUserIn$)) THEN _
            ZOutTxt$ = "Not all blanks"
      IF ZOutTxt$ <> "" THEN _
         CALL QuickTPut1(ZOutTxt$) : _
         GOTO 62670
      CALL AllCaps (ZUserIn$)
      ZWasZ$ = ZUserIn$
      END SUB
'
63000 ' $SUBTITLE: 'TimedOut - exits based on time of day'
' $PAGE
'
'  NAME    --  TimedOut
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZRCTTYBat$
'              ZNodeRecIndex
'              ZMsgRec$
'              ZModemInitBaud$
'              ZModemGoOffHookCmnd$
'
'  OUTPUTS --  NONE
'
'  PURPOSE --  When RBBS-PC is to xit to DOS at a specific time of
'              day, this routine writes out to the file specified
'              in "RCTTY.BAT" the one-line entry:
'                          RBTMx.DEF
'               WHERE "x" is the node id.
'
      SUB TimedOut STATIC
      FIELD #1,128 AS ZMsgRec$
      ZSubParm = 3
      CALL FileLock
      GET 1,ZNodeRecIndex
      WasX$ = DATE$
      CALL PackDate (WasX$,ZWasY$)
      MID$(ZMsgRec$,77,2) = ZWasY$
      'MID$(ZMsgRec$,86,5) = LEFT$(TIME$,5)
      PUT 1,ZNodeRecIndex
      ZSubParm = 2
      CALL FileLock
      CLOSE 2
      ZFileName$ = ZNodeWorkDrvPath$ + "RBTM" + ZNodeFileID$ + ".DEF"
      OPEN "O",2,ZFileName$
      PRINT #2,MID$(ZFileName$,3,7)
      CLOSE 2
      IF ZLocalUserMode THEN _
         EXIT SUB
      IF ZSubParm <> 7 THEN _
         ZSubParm = 4 : _
         CALL FileLock : _
         CALL OpenCom(ZModemInitBaud$,",N,8,1")
      CALL TakeOffHook
      END SUB
'
64003 ' $SUBTITLE: 'AskUsers - subroutine to get registration information'
' $PAGE
'
'  NAME    --  AskUsers  (WRITTEN BY JON MARTIN)
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZFileName$           NAME OF THE FILE CONTAINING THE
'                                   SCRIPT TO BE USED WHEN ASKING
'                                   THE USER QUESTIONS.
'              ZActiveUserName$     NAME OF THE CURRENT USER
'              ZUserSecLevel        USER'S SECURITY
'              ZUpperCase           SET IF USER NEEDS UPPERCASE
'
'  OUTPUTS --  WRITE THE USER'S RESPONSES TO THE QUESTIONS TO THE
'              FILE NAME SPECIFIED AS THE First PARAMETER IN THE
'              First RECORD OF THE FILE CONTAINING THE SCRIPT TO
'              BE USED.
'              ZUserSecLevel  CAN BE RAISED OR LOWERED
'
'  PURPOSE --  Provides a sophisticated, script driven mechanism by
'              which a sysop can control the interaction with the
'              user.  Special function questionnaires include the
'              registration questionnaire and the epilog.
'
      SUB AskUsers STATIC
      ZQuestAborted = ZFalse
      ZQuestChainStarted = ZFalse
      Temp = 256
      REDIM ZOutTxt$(Temp)
      REDIM ZWorkAra$(ZMaxWorkVar),ZGSRAra$(ZMaxWorkVar)
      PrevAppend$ = ""
      AppendFileName$ = ""
'
' *  LOAD SCRIPT CONTAINING THE QUESTIONS INTO THE ZOutTxt$ DIMENSION  *
'
64005 ZChatAvail = ZFalse
      QestChain = ZFalse
      LastQues = 0
      CALL Graphic (ZFileName$,ZFalse)
      IF NOT ZOK THEN _
         EXIT SUB
      CALL ReadParms (ZOutTxt$(),2,1)
      IF ZErrCode > 0 THEN _
         EXIT SUB
      PrevAppend$ = AppendFileName$
      AppendFileName$ = ZOutTxt$(1)
      MaxSecLevel = VAL(ZOutTxt$(2))
      WasX = INSTR(ZOutTxt$(2)," ")
      IF WasX > 0 THEN _
         IF ZUserSecLevel < VAL(MID$(ZOutTxt$(2),WasX)) THEN _
            CALL QuickTPut1 ("Higher security needed for questionnaire") : _
            EXIT SUB
'
' *  THE FIRST RECORD OF THE SCRIPT FILE CONTAINS THREE PARAMETERS:
' *   1.  THE NAME OF THE FILE TO APPEND THE ANSWERS TO.
' *   2.  THE MAXIMUM SECURITY LEVEL THE + COMMAND CAN RAISE A USER SECURITY
' *   3.  THE MINIMUM SECURITY TO USE THIS QUESTIONNAIRE
' * e.g. 'C:XXX.DAT,6 5' writes answers to C:XXX.DAT, can raise to 6,
' *      and requires security 5 or more to access
      ScriptIndex = 1
      ZOutTxt$(ScriptIndex) = ZActiveUserName$ + _
                         " " + _
                         DATE$ + _
                         " " + _
                         TIME$
64010 IF EOF(2) OR ScriptIndex > 255 THEN _
         GOTO 64100
      ScriptIndex = ScriptIndex + 1
      LINE INPUT #2,ZOutTxt$(ScriptIndex)
      IF LEFT$(ZOutTxt$(ScriptIndex),1) = ":" THEN _
         Temp$ = ZOutTxt$(ScriptIndex) : _
         CALL AllCaps (Temp$) : _
         CALL Trim (Temp$) : _
         ZOutTxt$(ScriptIndex) = Temp$
      IF ZUpperCase THEN _
         CALL AllCaps (ZOutTxt$(ScriptIndex))
      IF LEFT$(ZOutTxt$(ScriptIndex),1) = "?" THEN _
         ScriptIndex = ScriptIndex + 1 : _
         ZOutTxt$(ScriptIndex) = "!"
      GOTO 64010
'
' *  PROCESS QUESTIONS IN THE SCRIPT AS FOLLOWS:
' *
' * First COLUMN     MEANING
' *      :        THIS LINE IS A LABEL THAT MAY BE BRANCHED TO
' *      !        THIS MEANS THIS IS AN ANSWER
' *      >        THIS IS A "GOTO" COMMAND TO ONE OF THE LABELS
' *      *        THIS MEANS THE LINE IS A MESSAGE TO BE WRITTEN TO THE USER
' *      ?        THIS MEANS THIS IS A QUESTION FOR THE USER
' *      =        THIS MEANS THAT THIS LINE CONTAINS DECISION CRITERIA
' *      -        THIS MEANS TO LOWER THE USER'S SECURITY LEVEL
' *      +        THIS MEANS TO RAISE THE USER'S SECURITY LEVEL
' *      @        THIS MEANS TO ABORT THE QUESTIONNAIRE DO NOT WRITE OUT
' *      &        THIS MEANS TO CHAIN TO ANOTHER QUESTIONNAIRE
' *      M        Execute specified macro
' *      T        Turbo Key
' *      <        Assign value to work variable
'
64100 ScriptMax = ScriptIndex
      ScriptIndex = 1
64110 CALL Carrier
      IF ZSubParm = -1 THEN _
         GOTO 64510
      ScriptIndex = ScriptIndex + 1
      IF ScriptIndex > ScriptMax THEN _
         GOTO 64400
      ZOutTxt$ = MID$(ZOutTxt$(ScriptIndex),2)
      WasX = ZFalse
      IF LEFT$(ZOutTxt$,3) = "/FL" THEN _
         ZOutTxt$ = RIGHT$(ZOutTxt$,LEN(ZOutTxt$)-3) : _
         WasX = ZTrue
      CALL MetaGSR (ZOutTxt$,WasX)
      CALL SmartText (ZOutTxt$,ZFalse,WasX)
      WasX$ = ZOutTxt$
      ON INSTR(" :!@MT><*?=-+&",LEFT$(ZOutTxt$(ScriptIndex),1)) GOTO _
         64111, _       ' catch invalid lines
         64110, _       ' : label
         64110, _       ' ! stored answer
         64420, _       ' @ abort
         64120, _       ' M macro execute
         64430, _       ' T turbo key
         64440, _       ' > goto label
         64190, _       ' < assign value
         64450, _       ' * display line
         64113, _       ' ? prompt for answer
         64114, _       ' = conditional branch
         64460, _       ' - decrease security level
         64465, _       ' + increase security level
         64470          ' & chain
64111 ZOutTxt$ = "Invalid line.  Column 1 is <" + LEFT$(ZOutTxt$(ScriptIndex),1)+">.  Must be: * ? = + - > @ & M T <"
      ZSubParm = 5
      CALL TPut
      GOTO 64510
64113 LastQues = ScriptIndex  ' process ?
      GOSUB 64180
      ZSubParm = 1
      CALL TGet
      IF ZSubParm = -1 THEN _
         GOTO 64510 _
      ELSE IF ZWasQ = 0 THEN _
              ZOutTxt$ = WasX$ : _
              GOTO 64113 _
           ELSE ZOutTxt$(ScriptIndex + 1) = "!" + _
                                       ZUserIn$ : _
                ZGSRAra$(ZTestedIntValue) = ZUserIn$
      GOTO 64110
64114 IF LEFT$(ZOutTxt$(ScriptIndex),2) = "=#" THEN _        ' Numeric
         GOSUB 64350 : _
         GOTO 64110
      GOSUB 64300             ' process =
      GOTO 64445
64120 ZWasZ$ = MID$(ZOutTxt$(ScriptIndex),2)   ' Execute macro
      CALL Trim (ZWasZ$)
      CALL Macro (ZWasZ$,Found)
      IF Found THEN _
          CALL FDMACEXE
      GOTO 64110
64180 CALL CheckInt (ZOutTxt$)
      IF (ZErrCode > 0) OR (ZTestedIntValue < 1) OR _
          (ZTestedIntValue > ZMaxWorkVar) OR _
          (INSTR("123456789",LEFT$(ZOutTxt$,1)) = 0) THEN _
             ZTestedIntValue = 0 _
      ELSE ZOutTxt$ = RIGHT$(ZOutTxt$,LEN(ZOutTxt$)-1+(ZTestedIntValue > 9))
      RETURN
64190 GOSUB 64180
      IF ZTestedIntValue > 0 THEN _
         ZGSRAra$(ZTestedIntValue) = MID$(ZOutTxt$,2)
      GOTO 64110
'
' *  SEARCH FOR GOTO LABEL
'
64200 ScriptIndex = 1
      CALL MetaGSR (BranchLabel$,ZFalse)
      CALL SmartText (BranchLabel$,ZFalse,ZFalse)
      CALL AllCaps (BranchLabel$)
      CALL Trim (BranchLabel$)
64210 ScriptIndex = ScriptIndex + 1
      IF ScriptIndex > ScriptMax THEN _
         ZOutTxt$ = BranchLabel$ + _
              " not found!" : _
         ZSubParm = 5 : _
         CALL TPut : _
         IF ZSubParm = -1 THEN _
            RETURN _
         ELSE IF LastQues > 0 THEN _
                 ScriptIndex = LastQues - 1 : _
                 RETURN _
              ELSE GOTO 64510
      IF LEFT$(ZOutTxt$(ScriptIndex),1) <> ":" THEN _
         GOTO 64210
      IF MID$(ZOutTxt$(ScriptIndex),2) <> BranchLabel$ THEN _
         GOTO 64210
      RETURN
'
' *  DETERMINE BRANCH LOGIC
'
64300 CurEquals = 1
      ZWasZ$ = RIGHT$(ZOutTxt$(LastQues + 1),1)
      CALL AllCaps (ZWasZ$)
64310 NextEquals = INSTR(CurEquals + 1, ZOutTxt$(ScriptIndex),"=")
      IF NextEquals = 0 THEN _
         BranchLabel$ = MID$(ZOutTxt$(ScriptIndex),CurEquals + 2) : _
         GOTO 64320
      IF ZWasZ$ <> _
         MID$(ZOutTxt$(ScriptIndex),CurEquals + 1,1) THEN  _
         CurEquals = NextEquals : _
         GOTO 64310
      BranchLabel$ = MID$(ZOutTxt$(ScriptIndex),CurEquals + 2,NextEquals-(CurEquals + 2))
64320 GOSUB 64200
      RETURN
'
' *  DETERMINE Numeric BRANCH LOGIC
'
64350 CurEquals = 1
64360 NextEquals = INSTR(CurEquals + 1, ZOutTxt$(ScriptIndex),"=")
      IF NextEquals = 0 THEN _
         BranchLabel$ = MID$(ZOutTxt$(ScriptIndex),CurEquals + 2) : _
         GOTO 64380
      Numeric = ZTrue
      LoopIndex = 2
      WHILE LoopIndex < LEN(ZOutTxt$(ScriptIndex - 1)) +1
         IF INSTR("()1234567890- ",MID$(ZOutTxt$(ScriptIndex - 1),LoopIndex,1)) THEN _
            GOTO 64370
         Numeric = ZFalse
64370    LoopIndex = LoopIndex + 1
      WEND
      IF NOT Numeric THEN _
         CurEquals = NextEquals : _
         GOTO 64360
      BranchLabel$ = MID$(ZOutTxt$(ScriptIndex),CurEquals + 2,NextEquals-(CurEquals + 2))
64380 GOSUB 64200
      RETURN
'
' *  WRITE RESPONSES TO DESIGNATED FILE
'
64400 ScriptIndex = 0
      ZWasEN$ = AppendFileName$
      CALL LockAppend
      IF ZErrCode <> 0 THEN _
         ZOutTxt$ = "Fatal Error in script!" : _
         ZSubParm = 5 : _
         CALL TPut : _
         GOTO 64500
64410 ScriptIndex = ScriptIndex + 1
      IF ScriptIndex > ScriptMax THEN _
         GOTO 64500
      IF LEFT$(ZOutTxt$(ScriptIndex),1) = ":" THEN _
         QuestionSave$ = MID$(ZOutTxt$(ScriptIndex),2) : _
         GOTO 64410
      IF LEFT$(ZOutTxt$(ScriptIndex),1) = "!" AND _
         LEN(ZOutTxt$(ScriptIndex)) < 2 THEN _
         GOTO 64410
      IF LEFT$(ZOutTxt$(ScriptIndex),1) = "!" THEN _
         CALL PrintWork (2,QuestionSave$,ZFalse) : _
         CALL PrintWork (2,MID$(ZOutTxt$(ScriptIndex),2),ZFalse)
      IF ScriptIndex = 1 AND _
         AppendFileName$ <> PrevAppend$ THEN _
         CALL PrintWork (2,ZOutTxt$(ScriptIndex),ZFalse)
      IF ZErrCode <> 0 THEN _
         ZOutTxt$ = "Unrecoverable failure in script!" : _
         ZSubParm = 5 : _
         CALL TPut : _
         GOTO 64500
      GOTO 64410
64420 ZQuestAborted = ZTrue  ' @ abort
      GOTO 64510
64430 ZTurboKey = -ZTurboKeyUser   ' T turbo key
      GOTO 64110
64440 BranchLabel$ = ZOutTxt$            ' = branch
      GOSUB 64200
64445 IF ZSubParm = -1 THEN _
         GOTO 64510 _
      ELSE GOTO 64110
64450 CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)  ' * display
      ZSubParm = 5
      CALL TPut
      GOTO 64445
64460 WasX = -1        ' - lower security
64462 CALL CheckInt (ZOutTxt$)
      IF ZErrCode = 0 THEN _
         Temp = ZUserSecLevel + _
            WasX * ZTestedIntValue : _
         IF Temp <= MaxSecLevel THEN _
            ZUserSecLevel = Temp : _
            ZUserSecSave = ZUserSecLevel : _
            ZAdjustedSecurity = ZTrue
            IF ZOrigMsgFile$ = ZActiveMessageFile$ THEN _
               ZOrigSec = ZUserSecLevel
      GOTO 64110
64465 WasX = 1               ' + raise security
      GOTO 64462
64470 QestChain = ZTrue  ' & chain questionnaires
      ZFileNameHold$ = ZOutTxt$
      GOTO 64110
64500 CALL UnLockAppend
      CALL Carrier
      IF QestChain THEN _
         ZQuestChainStarted = ZTrue : _
         ZFileName$ = ZFileNameHold$ : _
         GOTO 64005
64510 ZChatAvail = (INSTR("MUF",ZActiveMenu$) > 0)
      ZOK = ZTrue
      ZLastIndex = 0
      END SUB
'
64600 ' $SUBTITLE: 'ViewArc - subroutine to display .ARC contents'
' $PAGE
'
'  NAME    --  ViewArc  (Written by Jon Martin)
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZFileName$           NAME OF THE ARC FILE TO BE
'                                   VIEWED.
'
'  OUTPUTS --  NONE
'
'  PURPOSE --  Provides a mechanism to provide users with the
'              contents of a libraried file prior to downloading.
'
      SUB ViewArc STATIC
      CLOSE 2
      RetCode = 0
      CALL ArcV (ZArcWork$,ZFileName$,RetCode)
      CALL BufFile (ZArcWork$,WasX,ZFalse)
      EXIT SUB
      END SUB
'
64635 ' * processes T)oggle command requests
      ' * formerly 1500-1512 in RBBS-PC.BAS
      SUB CmndToggle STATIC
64636 IF ZAnsIndex < ZLastIndex THEN _
         GOTO 64638
      ZOutTxt$ = "A)utodwnld   B)ullet  C)ase     F)ile   H)ilite"
      CALL TopPrompt
      ZOutTxt$ = "L)ine feeds  N)ulls   T)urboKey X)pert  !)bell"
'      CALL TopPrompt
'      ZOutTxt$ = "I)nternode Chat Page Availability"
      CALL ColorPrompt (ZOutTxt$)
64638 ZStackC = ZTrue
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZWasQ=0 OR ZSubParm < 0 THEN _
         EXIT SUB
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (ZWasZ$)
      ZFF = INSTR("ABCFHLNTX!I",ZWasZ$)
      IF ZFF < 1 THEN _
         GOTO 64636
      CALL Toggle (ZFF)
      GOTO 64636
      END SUB
      SUB TopPrompt STATIC
      CALL ColorPrompt (ZOutTxt$)
      CALL QuickTPut1 (ZOutTxt$)
      END SUB
'
64640 ' * SysOp function 5 - change xfer stats
      SUB CmndSysOpXfer STATIC
      CALL QuickTPut1 ("[ENTER] leaves unchanged")
      ZOutTxt$ = "Upload file total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZUserUplds$ = MKI$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Upload byte total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZULBytes$ = MKS$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Download file total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZUserDnlds$ = MKI$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Download byte total"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZDlBytes$ = MKS$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Files downloaded TODAY"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZTodayDl$ = MKS$(VAL(ZUserIn$(1)))
      ZOutTxt$ = "Bytes downloaded TODAY"
      GOSUB 64642
      IF LEN(ZUserIn$(1)) > 0 THEN _
         LSET ZTodayBytes$ = MKS$(VAL(ZUserIn$(1)))
      EXIT SUB
64642 ZSubParm = 1
      CALL TGet
      IF ZSubParm >= 0 THEN _
         RETURN
      END SUB
'
64645 ' * sets new user defaults
      ' * formerly 12900 of rbbs-pc.bas
      SUB SetNewUserDef STATIC
      LSET ZUserName$ = ZActiveUserName$
      LSET ZUserOption$ = MKI$(0) + _
                           MKI$(0) + _
                           " 0" + _
                           MKI$(64) + _
                           MKI$(16) + _
                           MKI$(0) + _
                           CHR$(23) + _
                           ZDefaultEchoer$
      LSET ZUserDnlds$ = MKI$(0)
      LSET ZUserUplds$ = MKI$(0)
      IF ZEnforceRatios THEN _
         LSET ZTodayDl$ = MKS$(0) : _
         LSET ZTodayBytes$ = MKS$(0) : _
         LSET ZDlBytes$ = MKS$(0) : _
         LSET ZULBytes$ = MKS$(0)
      LSET ZSecLevel$ = MKI$(ZTempSecLevel)
      LSET ZElapsedTime$ = MKI$(0)
      LSET ZDropTimes$ = CHR$(0)
      LSET ZBankTime$ = CHR$(0)
      END SUB
'
64650 ' Checks/stacks keyboard input while running long process
      SUB CheckKBStop STATIC
      ZOutTxt$ = ""
      ZSubParm = 4
      CALL TPut
      END SUB
'
70000 ' *** Creates a DOOR.SYS drop file ***
'
      SUB DoorSys STATIC
      CALL TimeRemain (MinsRemaining)
      Close 2
      OPEN "O", 2, ZNodeWorkDrvPath$ + "DOOR.SYS"
      IF ZLocalUser THEN _
         PRINT #2, "COM0:" _
      ELSE PRINT #2, ZComPort$ + ":"                            '(1)
      PRINT #2, ZCBaud$                                         '(2)
      ZPosition% = INSTR(ZBaudParity$, "N,")
      PRINT #2, MID$(ZBaudParity$, ZPosition% + 2, 1)           '(3)
      PRINT #2, ZNodeFileID$                                    '(4)
      PRINT #2, ZTalkToModemAt$                                 '(5)
      IF ZSnoop = -1 THEN _                                     '(6)
         PRINT #2, "Y" _
      ELSE PRINT #2, "N"
      IF ZPrinter = -1 THEN _                                   '(7)
         PRINT #2, "Y" _
      ELSE PRINT #2, "N"
      IF ZSysopAvail = -1 OR ZSysopAnnoy = -1 THEN _            '(8)
         PRINT #2, "Y" _
      ELSE PRINT #2, "N"
      IF ZSysopAvail = -1 OR ZSysopAnnoy = -1 THEN _            '(9)
         PRINT #2, "Y" _
      ELSE PRINT #2, "N"
      IF ZGlobalSysop THEN _                                   '(10)
         PRINT #2, ZSysopFirstName$ + " " + ZSysopLastName$ _
      ELSE PRINT #2, ZFirstName$ + " " + ZLastName$
      PRINT #2, ZCityState$                                    '(11)
      PRINT #2, ""    'Home Phone                              '(12)
      PRINT #2, ""    'Data Phone                              '(13)
      PRINT #2, ZPswdSave$                                     '(14)
      ZZ$ = STR$(ZUserSecLevel)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(15)
      ZZ$ = STR$(ZTimesLoggedOn)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(16)
      PRINT #2, MID$(ZLastDateTimeOn$, 1, 2) + "/" + _
                MID$(ZLastDateTimeOn$, 4 ,2) + "/" + _
                MID$(ZLastDateTimeOn$, 7 ,2)
      CALL TimeRemain (MinsRemaining)
      CALL CheckInt (ZDoorTime$)
      IF ZErrCode = 0 AND ZTestedIntValue > 0 THEN _
         IF MinsRemaining > ZTestedIntValue THEN _
            MinsRemaining = ZTestedIntValue
      ZZ$ = STR$(INT(MinsRemaining) * 60)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(18)
      PRINT #2,INT(MinsRemaining)                              '(19)
      IF ZWasGR = 2 THEN _                                     '(20)
         PRINT #2, "GR" _
      ELSE PRINT #2, "NG"
      ZZ$ = STR$(ZPageLength)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(21)
      IF ZExpertUser THEN _                                    '(22)
         PRINT #2, "Y" _
      ELSE PRINT #2, "N"
      PRINT #2, ""       'Conferences registered in            '(23)
      ZZ$ = ZConfName$
      CALL Trim (ZZ$)
      PRINT #2, ZZ$                                            '(24)
      PRINT #2, ZExpirationDate$                               '(25)
      ZZ$ = STR$(ZUserFileIndex)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(26)
      PRINT #2, ZUserXferDefault$                              '(27)
      IF ZUplds = 0 THEN _
         PRINT #2, "1" _
      ELSE _
         ZZ$ = STR$(ZUplds) : _
         CALL Trim(ZZ$) : _
         PRINT #2, ZZ$                                         '(28)
      ZZ$ = STR$(ZDnlds)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(29)
      ZZ$ = STR$(ZBytesToday!)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(30)
      IF ZByteMethod = 3 THEN _
         Today# = ZRatioRestrict# - ZBytesToday! - ZNumDnldBytes! : _
         ZZ$ = STR$(Today#) : _
         CALL Trim(ZZ$) : _
         PRINT #2, ZZ$ _
      ELSE PRINT #2, ""
      PRINT #2, ""         'Callers birthday mm/dd/yy          '(32)
      CALL BreakFileName (ZMainUserFile$,Drive$,filename$,extension$,ZFalse)
      PRINT #2, Drive$                                         '(33)
      PRINT #2, ""   'Path to GEN Directory                    '(34)
      PRINT #2, ZSysopFirstName$                               '(35)
      PRINT #2, ZActiveUserName$                               '(36)
      PRINT #2, ""   'Event Time        (hh:mm)                '(37)
      IF ZReliableMode = -1 THEN _                             '(38)
         PRINT #2, "Y" _
      ELSE PRINT #2, "N"
      PRINT #2, ""       'ANSI Supported but caller is NG (Y,N)'(39)
      IF ZShareIt THEN _                                       '(40)
         PRINT #2, "Y" _
      ELSE PRINT #2, "N"
      PRINT #2, ""       'BBS Default color     (1-15)         '(41)
      ZZ$ = STR$(ASC(ZBankTime$))
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(42)
      ZZ$ = RIGHT$(STR$(ASC(MID$(ZListNewDate$,2))),2) + _ '(43)
                "/" + _
                RIGHT$(STR$(ASC(MID$(ZListNewDate$,3))),2) + _
                "/" + _
                RIGHT$(STR$(ASC(ZListNewDate$)),2)
      CALL Trim (ZZ$)
      PRINT #2, ZZ$
      PRINT #2, LEFT$(ZTimeLoggedOn$, 5)                       '(44)
      PRINT #2, RIGHT$(ZLastDateTimeOnSave$, 5)                '(45)
      PRINT #2, ""       'Max daily files limit                '(46)
      ZZ$ = STR$(ZDLToday!)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(47)
      ZZ$ = STR$(ZULBytes!/1000)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(48)
      ZZ$ = STR$(ZDLBytes!/1000)
      CALL Trim(ZZ$)
      PRINT #2, ZZ$                                            '(49)
      PRINT #2, "RBBS-PC is the Best!"                         '(50)
      PRINT #2, ""      'Total Doors opened                    '(51)
      PRINT #2, ""      'Total Messages left                   '(52)
      CLOSE 2
      END SUB
'
' $SUBTITLE: 'ReadDoorSys - Reads a DOOR.SYS drop file'
' $PAGE
'
'  SUBPROGRAM NAME    --     ReadDoorSys
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'
'  OUTPUT PARAMETERS  --     ZUserSecLevel
'                            ZUplds
'                            ZDnlds
'                            ZBytesToday!
'                            ZBankTime$
'                            ZDLToday!
'                            ZULBytes!
'                            ZDLBytes!
'
'  SUBPROGRAM PURPOSE --  Update Users Record From DOOR.SYS
'
' SecurityLevel (15), Total Uploads (28), Total Downloads (29),
' Daily Download "K" Total (30) Time Credits (42), Files DL today (47),
' Total "K" Uploaded (48), and Total "K" DL (49) can be modified by a
' Door, so let RBBS read back in the values!
'
'
70005 SUB ReadDoorSys STATIC
      CALL OpenWork (2,ZNodeWorkDrvPath$+"DOOR.SYS",ZFalse)
      IF ZErrCode = 52 THEN _
         EXIT SUB
      FOR I = 1 TO 15
         CALL ReadDir (2,1)
      NEXT I
      OldVal = ZUserSecLevel
      ZUserSecLevel = VAL (ZOutTxt$)
      IF OldVal <> ZUserSecLevel THEN _
         CALL UpdtCalr ("Door set Security Level From" + _
              STR$(OldVal) +" to" + STR$(ZUserSecLevel),2) : _
         ZAdjustedSecurity = ZTrue : _
         ZUserSecSave = ZUserSecLevel : _
         IF (NOT ZConfMode) AND (NOT ZSubBoard) THEN _
             ZOrigSec = ZUserSecLevel
      MID$(ZUserRecord$,47,2) = MKI$(VAL(ZOutTxt$)) ' sec. level (15)
      FOR I = 16 TO 28
         CALL ReadDir (2,1)
      NEXT I
      ZZ$ = ZOutTxt$
      CALL Trim (ZZ$)
      MID$(ZUserRecord$,125,2) = MKI$(VAL(ZZ$)) 'total uploads   (28)
      CALL ReadDir (2,1)
      ZZ$ = ZOutTxt$
      CALL Trim (ZZ$)
      MID$(ZUserRecord$,123,2) = MKI$(VAL(ZZ$)) 'total downloads (29)
      CALL ReadDir (2,1)
      ZZ$ = ZOutTxt$
      CALL Trim (ZZ$)
      MID$(ZUserRecord$,94,4) = MKS$(VAL(ZZ$))  'bytes dnld today(30)
      FOR I = 31 TO 42
         CALL ReadDir (2,1)
      NEXT I
      ZZ$ = ZOutTxt$
      CALL Trim (ZZ$)
      MID$(ZUserRecord$,89,1) = CHR$(VAL(ZZ$))  ' banked time    (42)
      FOR I = 43 TO 47
         CALL ReadDir (2,1)
      NEXT I
      ZZ$ = ZOutTxt$
      CALL Trim (ZZ$)
      MID$(ZUserRecord$,90,4) = MKS$(VAL(ZZ$))  ' files dl today (47)
      CALL ReadDir (2,1)
      ZZ$ = ZOutTxt$
      CALL Trim (ZZ$)
      MID$(ZUserRecord$,102,4) = MKS$(VAL(ZZ$)*1000)' total kbytes uploaded (48)
      CALL ReadDir (2,1)
      ZZ$ = ZOutTxt$
      CALL Trim (ZZ$)
      MID$(ZUserRecord$,98,4) = MKS$(VAL(ZZ$)*1000) ' total kbytes downloaded (49)
      CLOSE 2
      END SUB
