///////////////////////////////////////////////////////////////////////////
//  This file is a collection of the author's favorite Polyray textures  //
//                                                                       //
//  This file requires that Polyray's "colors.inc", "texture.inc", and   //
//  "stones.inc" already be parsed...                                    //
//                                                                       //
//  If you add your own textures to this file, add the texture name to   //
//  the file "textures.def" so they'll appear in the texture list in     //
//  POVCAD.                                                              //
///////////////////////////////////////////////////////////////////////////

// We only need to define these things on the very first frame.
if (frame == start_frame) {

// Rob McGregor's mirrored marble texture
static define mirrored_white_marble
texture {
  noise surface {
    color white
    position_fn position_objectx
    lookup_fn lookup_sawtooth
    octaves 3
    turbulence 6
    ambient 0.3
    specular white, 0.7
    microfacet Cook 5
    reflection 0.75
    color_map([0.0, 0.8, <1, 1, 1>, <0.6, 0.6, 0.6>]
              [0.8, 1.0, <0.6, 0.6, 0.6>, <0.1, 0.1, 0.1>])
  }
}

// Alfonso Hermida's moon texture
static define moon
texture {
  noise surface {
    color white
    position_fn position_spherical
    position_scale 1.0
    lookup_fn lookup_sawtooth
    octaves 3
    turbulence 0.53
    ambient 0.4
    diffuse 0.8
    specular 0.2
    microfacet Reitz 5
    normal  dented_normal
    bump_scale 0.2
    frequency 10
    color_map([0.0, 0.8, <1, 1, 1>, <0.6, 0.6, 0.6>]
              [0.8, 1.0, <0.6, 0.6, 0.6>, <0.1, 0.1, 0.1>])
  }
}

// Rob McGregor's bumpy_white texture
static define bumpy_white_map
  color_map(
    [0.000, 0.154, <0.894, 0.886, 0.886>, <0.745, 0.745, 0.753>]
    [0.154, 0.308, <0.745, 0.745, 0.753>, <0.902, 0.902, 0.859>]
    [0.308, 0.444, <0.902, 0.902, 0.859>, <0.729, 0.706, 0.694>]
    [0.444, 0.615, <0.729, 0.706, 0.694>, <0.588, 0.592, 0.635>]
    [0.615, 0.803, <0.588, 0.592, 0.635>, <0.608, 0.616, 0.659>]
    [0.803, 1.001, <0.608, 0.616, 0.659>, <0.894, 0.886, 0.886>]
  )

static define bumpy_white
texture {
  layered
  Crack1 { scale <1, 2, 1.4> rotate <10, 0, -20> }, 
  texture { 
    special shiny { color bumpy_white_map }
    scale <1.2, 2.4, 1.2> 
    rotate <0, 0, -30> 
    rotate <40, 0, 0> 
  }
  scale <0.010, .024, 0.012> 
}

// Alfonso Hermida's water texture
static define water
texture {
  noise surface {
    color <0.4, 0.4, 1.0>
    normal ripple_normal
    frequency 100
    bump_scale 1
    ambient 0.3
    diffuse 0.3
    specular white, 0.7
    reflection 0.9
    microfacet Reitz 10
  }
  scale<10, 1, 10>
}

// Rob's variation on the old standard blue_ripple
static define green_ripple
texture {
  special shiny {
    color <0.043137, 0.764706, 0.588235>
    normal N + ripple_val
    reflection 0.55
  }
}

// Variations on the standard marble texture
static define green_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, aquamarine, 0.6 * aquamarine]
      [0.8, 1.0, 0.6 * aquamarine, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Red marble texture
static define blood_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, red, 0.6 * red]
      [0.8, 1.0, 0.6 * red, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Ice marble texture
static define ice_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, cyan, 0.6 * cyan]
      [0.8, 1.0, 0.6 * cyan, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Blue marble texture
static define blue_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, blue, 0.6 * cyan]
      [0.8, 1.0, 0.6 * blue, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Black marble texture
static define black_marble
texture {
  noise surface {
    ambient 0.3
    diffuse 0.8
    specular 0.3
    reflection white, 0.3
    microfacet Reitz 5
    position_fn 1
    lookup_fn 1
    octaves 3
    turbulence 3
    color_map(
      [0.0, 0.8, black, 0.6 * midnight_blue]
      [0.8, 1.0, 0.6 * black, <0.1, 0.1, 0.1>])
  }
  scale <5, 5, 5>
}

// Rob McGregor's desert texture...
// Create a desert wasteland
static define sand_dunes
texture {
  noise surface {
    color <0.85, 0.75, 0.69>
    normal 2
    frequency 100
    bump_scale 1.5
    ambient 0.37
    diffuse 0.75
  }
  // apply to a disc w/radius 10000 and scale to make it look good...
  // haze makes it look more realistic
  // scale <92, 92, 92>
}

// Rob McGregor's chrome textures
static define chrome1
texture {
  special surface {
    color white * 0.85 
    ambient 0.05
    diffuse 0.1
    specular white * 0.95, 0.4
    reflection 0.85
    microfacet Cook 5
  }
}

static define chrome2
texture {
  special surface {
    color white * 0.9
    ambient 0.05
    diffuse 0.1
    specular white * 0.9, 0.3
    reflection 0.75
    microfacet Cook 3
  }
}

// A firey combo
static define fire_map
color_map(
  [0.0, 0.6, <0.85, 0.275, 0>, <1, 0, 0>]
  [0.6, 0.8, <1, 1, 0>, <1, 0.79, 0>]
  [0.8, 1.0, <1, 0.79, 0>, <1, 0.275, 0>])

static define fire_sky
texture {
  special surface {
    color fire_map[noise(P)]
    ambient 0.9
    diffuse 0
    specular 0
  }
}
} // End of definitions


