/*
	WILDFILE.C

	Some routines to support wildcard filename handling.. Done by MikMak
*/

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>
#include <malloc.h>
#include <process.h>
#include <errno.h>
#include "wildfile.h"

static char path[MAXPATH];
static char drive[MAXDRIVE];
static char dir[MAXDIR];
static char name[MAXFILE];
static char ext[MAXEXT];

static struct ffblk ffblk;


char *GetFirstName(char *wildname,int attrib)
/*
	Finds the first file in a directory that corresponds to the wildcard
	name 'wildname'.

	returns:	ptr to full pathname

				or

				NULL if file couldn't be found
*/
{
	int found;

	fnsplit(wildname,drive,dir,name,ext);

	if(!findfirst(wildname,&ffblk,attrib)){
		fnmerge(path,drive,dir,ffblk.ff_name,NULL);
		return path;
	}
	return NULL;
}



char *GetNextName(void)
/*
	Finds another file in a directory that corresponds to the wildcard
	name of the GetFirstName call.

	returns:	ptr to full pathname

				or

				NULL if file couldn't be found
*/
{
	if(!findnext(&ffblk)){
		fnmerge(path,drive,dir,ffblk.ff_name,NULL);
		return path;
	}
	return NULL;
}


static char *first;
static int count;


void TackOn(char *s)
{
	char *p;

	if((p=sbrk(strlen(s)+1))<0){
		perror("Glob");
		exit(-1);
	}

	// was it the first one ?

	if(first==NULL) first=p;

	// copy the match into allocated memory

	while(*(p++)=(*s++));

	// increase match counter

	count++;
}



void Expand(char *wildname,int attrib)
{
	char *s;

	s=(strpbrk(wildname,"*?")==NULL) ? NULL : GetFirstName(wildname,attrib);

	if(s==NULL){

		/* wildname is not a pattern, or there's no match for
		   this pattern -> add wildname to the list */

		TackOn(wildname);
	}
	else do{

		/* add all matches to the list */
		TackOn(s);

	} while((s=GetNextName()) != NULL);
}



int fcmp(const void *a,const void *b)
{
	return(strcmp(*(char **)a,*(char **)b));
}



void MyGlob(int *argc,char **argv[],int attrib)
{
	int i;
	char **newargv;
	int *idxarr;

	first=NULL;
	count=1;

	idxarr=calloc(*argc+1,sizeof(int));

	if(idxarr==NULL){
		errno=ENOMEM;
		perror("Glob");
		exit(-1);
	}

	// Try to expand all arguments except argv[0]

	for(i=1;i<*argc;i++){

		// remember position old arg -> new arg

		idxarr[i]=count;

		// expand the wildcard argument

		Expand((*argv)[i],attrib);
	}

	idxarr[i]=count;

	// allocate new argv array.. (+1 for terminating NULL)

	newargv=calloc(count+1,sizeof(char *));

	if(newargv==NULL){
		errno=ENOMEM;
		perror("Glob");
		exit(-1);
	}

	// init newargv[0]

	newargv[0]=(*argv)[0];

	// initialize rest of newargv

	for(i=1;i<count;i++){
		newargv[i]=first;
		first+=strlen(first)+1;
	}

	for(i=1;i<*argc;i++){
		qsort(&newargv[idxarr[i]],
			  idxarr[i+1]-idxarr[i],
			  sizeof(char *),fcmp);
	}

	// replace the old argc and argv values by the new ones

	*argc=count;
	*argv=newargv;

	free(idxarr);
}
