#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mtypes.h"
#include "mdriver.h"
#include "mwav.h"


typedef struct WAV{
	char  rID[4];
	ULONG rLen;
	char  wID[4];
	char  fID[4];
	ULONG fLen;
	UWORD wFormatTag;
	UWORD nChannels;
	ULONG nSamplesPerSec;
	ULONG nAvgBytesPerSec;
	UWORD nBlockAlign;
	UWORD nFormatSpecific;
} WAV;



SAMPLEINFO *MW_LoadWavFP(FILE *fp)
{
	SAMPLEINFO *si;
	WAV wh;
	char dID[4];

	fread(&wh,sizeof(WAV),1,fp);

	if( memcmp(wh.rID,"RIFF",4) ||
		memcmp(wh.wID,"WAVE",4) ||
		memcmp(wh.fID,"fmt ",4) ){
		myerr="Not a WAV file";
		return NULL;
	}

	// skip other crap

	fseek(fp,wh.fLen-16,SEEK_CUR);
	fread(dID,4,1,fp);

	if( memcmp(dID,"data",4) ){
		myerr="Not a WAV file";
		return NULL;
	}

	if(wh.nChannels>1){
		myerr="Only mono WAV's are supported";
		return NULL;
	}

//	printf("wFormatTag: %x\n",wh.wFormatTag);
//	printf("blockalign: %x\n",wh.nBlockAlign);
//	prinff("nFormatSpc: %x\n",wh.nFormatSpecific);

	if((si=calloc(1,sizeof(SAMPLEINFO)))==NULL){
		myerr="Out of memory";
		return NULL;
	};

	si->c2spd=8192;
	si->volume=64;
	fread(&si->length,4,1,fp);

	if(wh.nBlockAlign==2){
		si->flags=SF_16BITS|SF_SIGNED;
		si->length>>=1;
	}
	si->handle=-1;

	if(!MD_SampleLoad(fp,si)){
		free(si);
		return NULL;
	}
	return si;
}


SAMPLEINFO *MW_LoadWavFN(char *filename)
{
	FILE *fp;
	SAMPLEINFO *si;

	if((fp=fopen(filename,"rb"))==NULL){
		myerr="Couldn't open wav file";
		return NULL;
	}

	si=MW_LoadWavFP(fp);

	fclose(fp);
	return si;
}


void MW_FreeWav(SAMPLEINFO *si)
{
	if(si!=NULL){
		MD_SampleUnLoad(si);
		free(si);
	}
}
