#ifndef BLITZBLANK_H
#define BLITZBLANK_H

#include <exec/ports.h>
#include <exec/tasks.h>


/****************************************/
/* $VER: BlitzBlank.h 2.50 (01.03.95)   */
/****************************************/

/********************************/
/* Stuff for blitzblank.library */
/********************************/

#define BLITZBLANKLIB_VER 6

extern struct BitMap   *BBL_AllocBitMap        (ULONG width,ULONG height,ULONG depth,ULONG flags);
extern struct BitMap   *BBL_AllocDBufBitMap    (struct Screen *screen);
extern struct RastPort *BBL_AllocRastPort      (ULONG width,ULONG height,ULONG depth,ULONG flags);
extern void             BBL_BlankDone          (void);
extern struct Window   *BBL_BlankMouse         (struct Screen *screen,UBYTE mode);
extern void             BBL_CloseScreenSafe    (struct Screen *screen);
extern BOOL             BBL_CopyOriginalColors (struct Screen *screen);
extern BOOL             BBL_CopyOriginalScreen (struct Screen *screen);
extern void             BBL_EndDBuf            (ULONG handle);
extern BOOL             BBL_FadeDown           (struct Screen *screen,UBYTE final,UBYTE delay);
extern void             BBL_FreeBitMap         (struct BitMap *bitmap);
extern void             BBL_FreeRastPort       (struct RastPort *rastport);
extern long             BBL_GetDarkestPen      (struct Screen *screen);
extern char*            BBL_GetString          (UWORD num,char *text);
extern ULONG            BBL_InitDBuf           (struct Screen *screen,struct BitMap *bitmap);
extern void             BBL_ModuleRunning      (void);
extern BOOL             BBL_ScreenAvailable    (struct Screen *screen);
extern BOOL             BBL_SendMessage        (struct BB_Message *bbmessage,char *portname);
extern void             BBL_ShowBitMap         (struct Screen *screen,struct BitMap *bitmap,ULONG handle);
extern void             BBL_UnBlankMouse       (struct Window *window);


/*******************************************************************/
/* The different kinds of GUI-objects for a module's config-window */
/*******************************************************************/

#define BB_PGroup     1 /* Indicates the start of a new page group */
#define BB_PGroup_End 2 /* Indicates the end of the page group */
#define BB_VGroup     3 /* Indicates the start of a new vertical group */
#define BB_VGroup_End 4 /* Indicates the end of the vertical group */
#define BB_Check      5 /* Checkmark, uses set field in BB_Object */
#define BB_String     6 /* Textgadget, uses max/contents fields in BB_Object */
#define BB_File       7 /* Stringgadget with attached filerequester */
#define BB_Slider     8 /* Slidergadget, uses min/max/set fields in BB_Object */
#define BB_Cycle      9 /* Cyclegadget, uses set/contents in BB_Object */
#define BB_Dummy     10 /* Dummy, if you want no gadgets at all */
#define BB_Font      11 /* Stringgadget with attached fontrequester */
#define BB_Dir       12 /* Stringgadget with attached filerequester, Dirs only */

/*****************************************/
/* Flags used in BB_Message's flag-field */
/*****************************************/

#define BBF_Screenmode   (1L <<  0)  /* Allows screenmode-selection */
#define BBF_Colors       (1L <<  1)  /* Allows screendepth-selection */
#define BBF_Sample       (1L <<  2)  /* Not supported yet */
#define BBF_NoWatch      (1L <<  3)  /* Eats no CPU-time, so needs no checking */
#define BBF_NoScreen     (1L <<  4)  /* Wants no screen from BlitzBlank */
#define BBF_FirstScreen  (1L <<  5)  /* Wants pointer to screen in front, be CAREFUL with this! */
#define BBF_CloneScreen  (1L <<  6)  /* Wants a clone from the FrontScreen */
#define BBF_AmigaOnly    (1L <<  7)  /* Not supported yet */
#define BBF_NoMouseBlank (1L <<  8)  /* No mouseblanking from BlitzBlank wanted */
#define BBF_NoKeyPass    (1L <<  9)  /* No keypassing necessary (no mouseblanking, no own active window */
#define BBF_BigWindow    (1L << 10)  /* The blankwindow fills the whole screen */
#define BBF_Interleaved  (1L << 11)  /* BlitzBlank TRIES to give you a screen with an Interleaved BitMap */


/*****************************************/
/* The structure, that holds config-data */
/*****************************************/

struct BB_Object
{
  struct BB_Object* next;     /* Pointer to next object or NULL if last object */
  WORD              type;     /* What kind of GUI-object this is */
  long              min;      /* Minimum value for BB_Slider */
  long              max;      /* Maximum value for BB_Slider, max length of BB_String */
  long              set;      /* Value of BB_Slider, state of BB_Checkmark, BB_Cycle */
  char             *contents; /* Pointer to buffer for BB_String, pointer to stringarray for BB_Cycle */
  char             *label;    /* Label for ALL objects */
};


/*****************************************************/
/* The message to send to BlitzBlank/BlitzBlankPrefs */
/*****************************************************/

struct BB_Message
{
  struct Message    msg;        /* Normal Exec-Message-structure */
  long              flags;      /* Flags for this module */
  char             *infotext;   /* Pointer to infotext for this module */
  struct BB_Object *first;      /* Pointer to first BB_Object or NULL for Info-action */
  WORD              modpri;     /* not of use, if you use the library */
  char             *path;       /* Path to directory for module-data */
  struct Task      *blitzblank; /* not of use, if you use the library */
};


/***************************************/
/* The BlitzBlank-Screeninfo-structure */
/***************************************/

struct BB_Screeninfo
{
  WORD             xpos;       /* should be 0 */
  WORD             ypos;       /* should be 0 */
  WORD             width;      /* User-selected screen-width */
  WORD             height;     /* User-selected screen-height */
  WORD             depth;      /* User-selected screen-depth */
  long             mode;       /* User-selected screen-mode */
  struct Screen   *bbscreen;   /* module screen */
  struct Window   *bbwindow;   /* blank window */
  WORD             mindepth;   /* desired minimum depth or 0 */
  WORD             maxdepth;   /* desired maximum depth or 0 */
};


/************************************************************/
/* Flag-definition for BBL_AllocBitMap()/BBL_AllocRastPort, */
/* if you don't have the V39-includes                       */
/************************************************************/

#ifndef BMB_CLEAR
#define BMB_CLEAR 0
#define BMB_DISPLAYABLE 1
#define BMB_INTERLEAVED 2
#define BMF_CLEAR (1l<<BMB_CLEAR)
#define BMF_DISPLAYABLE (1l<<BMB_DISPLAYABLE)
#define BMF_INTERLEAVED (1l<<BMB_INTERLEAVED)
#endif

#endif
