
/* Beispiel fr eine GUI, ohne Blank-Funktion und ohne Lokalisierung! */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <pragmas/blitzblank_pragmas.h>
#include <BlitzBlank.h>


struct Library *BlitzBlankBase;

char *pgrouplabels[]={"PGroup Page 1","PGroup Page 2",NULL};
char *cycleentries[]={"Option 1","Option 2","Option 3",NULL};
char fontname[101]="Lall";
char filename[101]="sys:";

char *infotext="\33c\33uTest\33n\n\nModul fr BlitzBlank\n\nCopyright\n1994\nby Nobody";


struct BB_Object object[]={ {&object[1] ,BB_PGroup,0,0,0,NULL,(char *)pgrouplabels},
                            {&object[2] ,BB_VGroup,0,0,0,NULL,"VGroup1"},
                            {&object[3] ,BB_Slider,0,99,10,NULL,"S_lider:"},
                            {&object[4] ,BB_Font,0,100,0,fontname,"_Font:"},
                            {&object[5] ,BB_VGroup_End,0,0,0,NULL,NULL},
                            {&object[6] ,BB_VGroup,0,0,0,NULL,NULL},
                            {&object[7] ,BB_File,0,100,0,filename,"_File:"},
                            {&object[8] ,BB_Cycle,0,0,1,(char *)cycleentries,"C_ycle:"},
                            {&object[9] ,BB_VGroup_End,0,0,0,NULL,NULL},
                            {&object[10],BB_PGroup_End,0,0,0,NULL,NULL},
                            {&object[11],BB_VGroup,0,0,0,NULL,"VGroup3"},
                            {&object[12],BB_Check,0,0,1,NULL,"Check_1:"},
                            {&object[13],BB_Check,0,0,0,NULL,"Check_2:"},
                            {&object[14],BB_Check,0,0,1,NULL,"Check_3:"},
                            {NULL       ,BB_VGroup_End,0,0,0,NULL,NULL} };


/* You would use this for no GUI-objects at all */
/* struct BB_Object object[]={ {NULL,BB_Dummy,0,0,0,NULL,NULL}}; */


struct BB_Message message;
struct BB_Screeninfo *screeninfo;


void blank (void)
{
  printf ("xpos:%i\n",screeninfo->xpos);
  printf ("ypos:%i\n",screeninfo->ypos);
  printf ("width:%i\n",screeninfo->width);
  printf ("height:%i\n",screeninfo->height);
  printf ("depth:%i\n",screeninfo->depth);
  printf ("mode:%x\n",screeninfo->mode);
  printf ("bbscreen:%x\n",screeninfo->bbscreen);

  printf ("PGroup:%i\n",object[0].set);
  printf ("Slider:%i\n",object[2].set);
  printf ("Font:%s\n",fontname);
  printf ("File:%s\n",filename);
  printf ("Cycle:%i\n",object[7].set);
  printf ("Check:%i\n",object[11].set);
  printf ("Check:%i\n",object[12].set);
  printf ("Check:%i\n",object[13].set);

  if (!CheckSignal (SIGBREAKF_CTRL_C))
  {
    BBL_ModuleRunning ();

    /* Blankaction */

    Wait (SIGBREAKF_CTRL_C);

  }
  return;
}


void main (int argc,char **argv)
{

  if (!(BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
    exit (0);

  message.flags=BBF_NoScreen;
  message.infotext=infotext;
  message.first=&object[0];

  if (strcmp (argv[1],"BLANK")==0)
  {
    StrToLong (argv[3],(long *) &screeninfo);
    BBL_SendMessage (&message,argv[2]);
    // if (screeninfo->bbscreen)
      blank ();
    BBL_BlankDone ();
  }
  else
    if (strcmp (argv[1],"CONFIG")==0)
    {
      BBL_SendMessage (&message,argv[2]);
    }
    else
    {
      message.first=NULL;
      BBL_SendMessage (&message,argv[2]);
    }
  CloseLibrary (BlitzBlankBase);
  exit (0);
}

