#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <pragmas/blitzblank_pragmas.h>

#include <BlitzBlank.h>

struct Library *BlitzBlankBase;
char *VersionString="$VER: BB.StarField 2.50 (25.12.94)";

char *text[]={"\33c\33uStarField\33n\n\nModule for BlitzBlank\n\nCopyright 1994\nby\nMatthias Bock",
              "Sta_rs:",
              "Sp_eed:",
              "C_olor:" };


struct BB_Object object[]={ {&object[1],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[2],BB_Slider,1,1000,100,NULL,NULL},
                            {&object[3],BB_Slider,1,10,5,NULL,NULL},
                            {&object[4],BB_Check,0,0,0,NULL,NULL},
                            {NULL      ,BB_VGroup_End,0,0,0,NULL,NULL} };



struct BB_Message message;

struct BB_Screeninfo *screeninfo;


void blank (void)
{
  struct RastPort *rp;
  struct ViewPort *vp;

// screeninfo->width    = Breite
// screeninfo->height   = Hhe
// screeninfo->depth    = Tiefe
// screeninfo->bbscreen = Screenstruktur

// object[1].set        = Anzahl der Sterne
// object[2].set        = Geschwindigkeit
// object[3].set        = Color ja/nein

  rp=&screeninfo->bbscreen->RastPort;
  vp=&screeninfo->bbscreen->ViewPort;

  SetRGB4 (vp,0,0,0,0);
  SetRGB4 (vp,1,15,15,15);

  SetAPen (rp,1);
  Move (rp,100,100);
  Text (rp,"Dieses Modul hat noch keine Blankroutine!",41);

  ScreenToFront (screeninfo->bbscreen);
  if (!CheckSignal (SIGBREAKF_CTRL_C))
  {
    BBL_ModuleRunning ();
    Wait (SIGBREAKF_CTRL_C);
  }
  return;
}


void main(int argc,char **argv)
{
  int i;

  if (!(BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
    exit (0);

  message.flags=BBF_Screenmode;
  message.first=&object[0];


  if (strcmp (argv[1],"BLANK")==0)
  {
    StrToLong (argv[3],(long *) &screeninfo);
    BBL_SendMessage (&message,argv[2]);
    if (screeninfo->bbscreen)
      blank ();
    BBL_BlankDone ();
  }
  else
  {
    message.infotext=BBL_GetString (300,text[0]);
    for (i=1;i<=3;i++)
       object[i].label=BBL_GetString (300+i,text[i]);
    if (strcmp (argv[1],"CONFIG")==0)
    {
      BBL_SendMessage (&message,argv[2]);
    }
    else
    {
      message.first=NULL;
      BBL_SendMessage (&message,argv[2]);
    }
  }
  CloseLibrary (BlitzBlankBase);
  exit (0);
}

