
/* Beispiel fr eine GUI, noch ohne Blank-Funktion */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <pragmas/blitzblank_pragmas.h>
#include <BlitzBlank.h>

struct Library *BlitzBlankBase;
char *VersionString="$VER: BB.Splines 2.50 (25.12.94)";

char *text[]={"\33c\33uSplines\33n\n\nModule for BlitzBlank\n\nCopyright 1994\nby\nJrgen Denner",
              "Straight",
              "Bouncing",
              "Various",
              "_Fixpoints:",
              "Sp_lines:",
              "Spli_ne Speed:",
              "_Random Range:" };


char *pgrouplabels[4];

struct BB_Object object[]={ {&object[ 1],BB_PGroup,0,0,1,NULL,(char *)pgrouplabels},
                            {&object[ 2],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[ 3],BB_Slider,10,30,22,NULL,NULL},
                            {&object[ 4],BB_Slider,10,99,43,NULL,NULL},
                            {&object[ 5],BB_Slider,0,20,19,NULL,NULL},
                            {&object[ 6],BB_Slider,3,40,5,NULL,NULL},
                            {&object[ 7],BB_VGroup_End,0,0,0,NULL,NULL},
                            {&object[ 8],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[ 9],BB_Slider,10,30,20,NULL,NULL},
                            {&object[10],BB_Slider,10,99,33,NULL,NULL},
                            {&object[11],BB_Slider,0,20,20,NULL,NULL},
                            {&object[12],BB_Slider,3,40,6,NULL,NULL},
                            {&object[13],BB_VGroup_End,0,0,0,NULL,NULL},
                            {&object[14],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[15],BB_Slider,10,30,17,NULL,NULL},
                            {&object[16],BB_Slider,10,99,52,NULL,NULL},
                            {&object[17],BB_Slider,0,20,20,NULL,NULL},
                            {&object[18],BB_Slider,3,40,5,NULL,NULL},
                            {&object[19],BB_VGroup_End,0,0,0,NULL,NULL},
                            {NULL       ,BB_PGroup_End,0,0,0,NULL,NULL} };



struct BB_Message message;

struct BB_Screeninfo *screeninfo;


void blank (void)
{
  struct RastPort *rp;
  struct ViewPort *vp;

// screeninfo->width    = Breite
// screeninfo->height   = Hhe
// screeninfo->depth    = Tiefe
// screeninfo->bbscreen = Screenstruktur

// object[ 0].set       = Modus (0/1/2)

// object[ 2].set       = Modus 0, Fixpoints
// object[ 3].set       = Modus 0, Splines
// object[ 4].set       = Modus 0, Spline Speed
// object[ 5].set       = Modus 0, Random Range

// object[ 8].set       = Modus 1, Fixpoints
// object[ 9].set       = Modus 1, Splines
// object[10].set       = Modus 1, Spline Speed
// object[11].set       = Modus 1, Random Range

// object[14].set       = Modus 2, Fixpoints
// object[15].set       = Modus 2, Splines
// object[16].set       = Modus 2, Spline Speed
// object[17].set       = Modus 2, Random Range


  rp=&screeninfo->bbscreen->RastPort;
  vp=&screeninfo->bbscreen->ViewPort;

  SetRGB4 (vp,0,0,0,0);
  SetRGB4 (vp,1,15,15,15);

  SetAPen (rp,1);
  Move (rp,100,100);
  Text (rp,"Dieses Modul hat noch keine Blankroutine!",41);

  ScreenToFront (screeninfo->bbscreen);
  if (!CheckSignal (SIGBREAKF_CTRL_C))
  {
    BBL_ModuleRunning ();
    Wait (SIGBREAKF_CTRL_C);
  }
  return;
}


void main(int argc,char **argv)
{
  int i;

  if (!(BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
    exit (0);

  message.flags=BBF_Screenmode;
  message.first=&object[0];

  if (strcmp (argv[1],"BLANK")==0)
  {
    StrToLong (argv[3],(long *) &screeninfo);
    screeninfo->depth=1;
    BBL_SendMessage (&message,argv[2]);
    if (screeninfo->bbscreen)
      blank ();
    BBL_BlankDone ();
  }
  else
  {
    message.infotext=BBL_GetString (310,text[0]);
    for (i=1;i<=3;i++)
      pgrouplabels[i-1]=BBL_GetString (310+i,text[i]);
    pgrouplabels[3]=NULL;
    for (i=4;i<=7;i++)
      object[i-2].label=object[i+4].label=object[i+10].label=BBL_GetString (310+i,text[i]);
    if (strcmp (argv[1],"CONFIG")==0)
    {
      BBL_SendMessage (&message,argv[2]);
    }
    else
    {
      message.first=NULL;
      BBL_SendMessage (&message,argv[2]);
    }
  }
  CloseLibrary (BlitzBlankBase);
  exit (0);
}

