#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <pragmas/blitzblank_pragmas.h>

#include <BlitzBlank.h>

struct Library *BlitzBlankBase;
static const char version[]="$VER: BB.Melt 2.50 (25.12.94)";

char *text[]={"\33c\33uMelt\33n\n\nModule for BlitzBlank\n\nCopyright 1994\nby\nThomas Brkel",
              "Sp_eed:",
              "Si_ze:",
              "R_efresh Cycle:",
              "_Brightness:",
              "_Delay:" };

struct BB_Object object[]={ {&object[1],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[2],BB_Slider,1,150,100,NULL,NULL},
                            {&object[3],BB_Slider,1,100,30,NULL,NULL},
                            {&object[4],BB_Slider,10,500,100,NULL,NULL},
                            {&object[5],BB_Slider,0,100,70,NULL,NULL},
                            {&object[6],BB_Slider,0,20,1,NULL,NULL},
                            {NULL,BB_VGroup_End,0,0,0,NULL,NULL} };

struct BB_Message message;
struct BB_Screeninfo *screeninfo;


void blank (void)
{
  int i,x,y,c;
  long a=0;
  struct RastPort *rp;

  rp=&screeninfo->bbscreen->RastPort;

  c=BBL_GetDarkestPen (screeninfo->bbscreen);

  ScreenToFront (screeninfo->bbscreen);

  if (!CheckSignal (SIGBREAKF_CTRL_C))
  {
    BBL_ModuleRunning ();
    if (BBL_FadeDown (screeninfo->bbscreen,object[4].set,object[5].set))
    {
      SetAPen (rp,c);
      Move (rp,0,0);
      Draw (rp,screeninfo->width-1,0);
      do
      {
        WaitTOF ();
        for (i=1;i<=object[1].set+30;i++)
        {
          x=drand48 ()*(screeninfo->width-object[2].set+1);
          y=drand48 ()*(screeninfo->height-3);
    //      if (ReadPixel (rp,x,y))
    //      {
            BltBitMap (rp->BitMap,x,y,rp->BitMap,x,y+1,object[2].set,1,0xc0,0xff,0);
            BltBitMap (rp->BitMap,x,y,rp->BitMap,x,y+2,object[2].set,1,0xc0,0xff,0);
            a++;
    //      }
          if (a>10000*object[3].set)
          {
            a=0;
            BBL_CopyOriginalScreen (screeninfo->bbscreen);
            SetAPen (rp,c);
            Move (rp,0,0);
            Draw (rp,screeninfo->width-1,0);
          }
        }
      } while (!CheckSignal (SIGBREAKF_CTRL_C));
    }
  }
  return;
}


void main (int argc,char **argv)
{
  int i;

  if (!(BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
    exit (0);

  message.flags=BBF_CloneScreen|BBF_Interleaved;
  message.first=&object[0];


  if (strcmp (argv[1],"BLANK")==0)
  {
    StrToLong (argv[3],(long *) &screeninfo);
    BBL_SendMessage (&message,argv[2]);
    if (screeninfo->bbscreen)
      blank ();
    BBL_BlankDone ();
  }
  else
  {
    message.infotext=BBL_GetString (200,text[0]);
    for (i=1;i<=5;i++)
      object[i].label=BBL_GetString (200+i,text[i]);
    if (strcmp (argv[1],"CONFIG")==0)
    {
      BBL_SendMessage (&message,argv[2]);
    }
    else
    {
      message.first=NULL;
      BBL_SendMessage (&message,argv[2]);
    }
  }
  CloseLibrary (BlitzBlankBase);
  exit (0);
}

