/*
 * Module: BB.Guru.c
 *
 * Aktion: Zeigt den gefrchteten Guru.
 *
 * Version:
 *   1.1  (27.01.95) Portierung nach BlitzBlank
 *   1.0             Originalimplementation fr SuperDark
 *
 * Autor:
 *   Dirk Farin
 *   Kapellenweg 15
 *   72070 Tbingen
 *   Germany
 *
 *   EMail: farindk@trick.informatik.uni-stuttgart.de
 *
 * Copyright:
 *   Dieses Programm ist Freeware, es darf nur
 *   unentgeltlich und unverndert kopiert werden.
 */

#define __USE_SYSBASE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <dos.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <proto/dos.h>
#include <blitzblank_pragmas.h>
#include <BlitzBlank.h>

struct Library *BlitzBlankBase;

char *VersionString="$VER: BB.Guru 1.1 (27.01.95)";


#define TXTBASE 430

#define TXT_INFO 0

char *text[]={ "\33c\33uGuru\33n\n\nVersion 1.1\n\nCopyright 1995\nby\nDirk Farin"
             };

char* StandardGuru[2] = { "Software failure.       Press left mouse button to continue.",
                          "Error:  8000 0002   Task:  07D829E0" };

int   BlinkDelay = 50; // Wartezeit zwischen den Blinkphasen

char* txt[2]; // Verweis auf den Text des Gurus

struct TextFont* topaz80;
struct TextAttr  topaz80attr = { "topaz.font",8,NULL,NULL };

struct BB_Object object[]={ {NULL,BB_Dummy,0,0,0,NULL,NULL} };

struct BB_Message message;

struct BB_Screeninfo *screeninfo;

struct Screen*   scr;
struct RastPort* rp;
struct ViewPort* vp;

int ytxtstart[2] = { 15,30 }; // Y-Baseline-Position der beiden Textzeilen


//----------------------
    void blank (void)
//----------------------
{
  int   guruon=FALSE;   // ob Guru gerade an oder aus ist.
  int   i;
  struct Window* nomousehandle;



  // Texte auswhlen

  txt[0] = StandardGuru[0];
  txt[1] = StandardGuru[1];


  // Bildschirm und Zeichensatz ffnen und initialisieren

  scr=OpenScreenTags(NULL,
                    SA_Width ,640,
                    SA_Height, 40,
                    SA_Depth,2,
                    SA_DisplayID, HIRES_KEY,
                    SA_Behind,TRUE,
                    SA_Quiet,TRUE,TAG_DONE);

  if (!scr) goto cleanexit;

  nomousehandle = BBL_BlankMouse( scr,0 );

  vp = &scr->ViewPort;
  rp = &scr->RastPort;

  SetRGB4(vp,0,0,0,0);
  SetRGB4(vp,1,0,0,0);
  SetRGB4(vp,2,15,0,0);

  topaz80 = OpenFont(&topaz80attr);
  if (!topaz80) goto cleanexit;

  SetFont(rp,topaz80);


  // Rahmen malen

  SetAPen(rp,1);
  RectFill(rp,0,0,scr->Width-1,scr->Height-1);

  SetAPen(rp,0);
  RectFill(rp,5,3,scr->Width-6,scr->Height-4);


  // Text (zentriert) schreiben

  SetAPen(rp,2);

  for (i=0;i<2;i++)
  {
    int xpos;

    xpos  = scr->Width - TextLength(rp,txt[i],strlen(txt[i]));
    xpos /= 2;

    Move(rp,xpos,ytxtstart[i]);
    Text(rp,txt[i],strlen(txt[i]));
  }



  // Blankerschleife: Rahmen blinken

  if (!CheckSignal (SIGBREAKF_CTRL_C))
  {
    screeninfo->bbscreen=scr;
    ScreenToFront(scr);
    BBL_ModuleRunning ();

    do
    {
      Delay(BlinkDelay);
      if (guruon) { guruon=FALSE; SetRGB4(vp,1, 0,0,0); }
      else        { guruon=TRUE;  SetRGB4(vp,1,15,0,0); }
    }
    while (!CheckSignal (SIGBREAKF_CTRL_C));
  }

cleanexit:
  if (topaz80) CloseFont(topaz80);
  if (scr)     { BBL_UnBlankMouse(nomousehandle);
                 CloseScreen(scr);
               }
  return;
}


//-----------------------------------
    void main(int argc,char **argv)
//-----------------------------------
{
  if (!(BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
    exit (0);

  message.flags=BBF_NoScreen;
  message.first=&object[0];


  if (strcmp (argv[1],"BLANK")==0)
  {
    StrToLong (argv[3],(long *) &screeninfo);
    BBL_SendMessage (&message,argv[2]);
    blank ();
    BBL_BlankDone ();
  }
  else
  {
    message.infotext=BBL_GetString (TXT_INFO+TXTBASE,text[TXT_INFO]);

    if (strcmp (argv[1],"CONFIG")==0)
    {
      BBL_SendMessage (&message,argv[2]);
    }
    else
    {
      message.first=NULL;
      BBL_SendMessage (&message,argv[2]);
    }
  }
  CloseLibrary (BlitzBlankBase);
  exit (0);
}


