#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <pragmas/blitzblank_pragmas.h>
#include <BlitzBlank.h>

struct Library *BlitzBlankBase;
static const char version[]="$VER: BB.Fade 2.50 (25.12.94)";

struct rgb
{
  ULONG r;
  ULONG g;
  ULONG b;
};


char *text[]={"\33c\33uFade\33n\n\nModule for BlitzBlank\n\nCopyright 1994\nby\nThomas Brkel",
              "_Brightness:",
              "_Delay:" };

struct BB_Object object[]={ {&object[1],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[2],BB_Slider,0,99,20,NULL,NULL},
                            {&object[3],BB_Slider,0,20,1,NULL,NULL},
                            {NULL,BB_VGroup_End,0,0,0,NULL,NULL} };

struct BB_Message message;

struct BB_Screeninfo *screeninfo;


void waitnobeep(struct Screen *screen)
{
  while (screen->Flags & BEEPING)
  {
    WaitTOF ();
    WaitTOF ();
  }
}


void blank (void)
{
  int v39=0,depth,colors,i,final;
  long *pal37,r,g,b;
  ULONG *col;
  struct rgb *pal;
  struct IntuitionBase *ibase;
  struct Screen *firstscreen;
  struct ViewPort *vp;
  struct ColorMap *cm;

  final=object[1].set;

  ibase=(struct IntuitionBase *) OpenLibrary ("intuition.library",39);
  if (ibase)
    v39=TRUE;
  else
    ibase=(struct IntuitionBase *) OpenLibrary ("intuition.library",37);
  CloseLibrary ((struct Library *) ibase);
  firstscreen=screeninfo->bbscreen;
  depth=screeninfo->depth;
  colors=1L << depth;
  vp=&firstscreen->ViewPort;
  cm=vp->ColorMap;
  if (v39)
  {
    if ((pal=calloc (colors,sizeof (struct rgb)))==NULL)
      return;
    if ((col=calloc (colors+2,sizeof (long)*3))==NULL)
      return;
    col[0]=colors << 16;
  }
  else
    if ((pal37=malloc (sizeof (long)*colors))==NULL)
      return;

  waitnobeep (firstscreen);

  if (!CheckSignal (SIGBREAKF_CTRL_C))
  {
    ScreenToFront (firstscreen);
    BBL_ModuleRunning ();

    for (i=0;i<colors;i++)
    {
      if (v39)
      {
        GetRGB32 (cm,i,1,(ULONG *)&pal[i]);
        pal[i].r=pal[i].r & 255;
        pal[i].g=pal[i].g & 255;
        pal[i].b=pal[i].b & 255;
      }
      else
        pal37[i]=GetRGB4 (cm,i);
    }

    if (BBL_FadeDown (firstscreen,final,object[2].set))
      Wait (SIGBREAKF_CTRL_C);

    if (BBL_ScreenAvailable (firstscreen))
    {
      waitnobeep (firstscreen);

      for (i=0;i<=colors-1;i++)
      {
        if (v39)
        {
          r=pal[i].r;
          g=pal[i].g;
          b=pal[i].b;
          col[1+i*3]=r|r << 8|r << 16|r << 24;
          col[2+i*3]=g|g << 8|g << 16|g << 24;
          col[3+i*3]=b|b << 8|b << 16|b << 24;
        }
        else
          SetRGB4 (vp,i,pal37[i] >> 8 & 15,pal37[i] >> 4 & 15,pal37[i] & 15);
      }
      if (v39)
        LoadRGB32 (vp,col);

    }
  }
  return;
}


void main(int argc,char **argv)
{

  if (!(BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
    exit (0);

  message.flags=BBF_NoWatch|BBF_FirstScreen;
  message.first=&object[0];

  if (strcmp (argv[1],"BLANK")==0)
  {
    StrToLong (argv[3],(long *) &screeninfo);
    BBL_SendMessage (&message,argv[2]);
    if (screeninfo->bbscreen)
      blank ();
    BBL_BlankDone ();
  }
  else
  {
    message.infotext=BBL_GetString (210,text[0]);
    object[1].label=BBL_GetString (211,text[1]);
    object[2].label=BBL_GetString (212,text[2]);
    if (strcmp (argv[1],"CONFIG")==0)
    {
      BBL_SendMessage (&message,argv[2]);
    }
    else
    {
      message.first=NULL;
      BBL_SendMessage (&message,argv[2]);
    }
  }
  CloseLibrary (BlitzBlankBase);
  exit (0);
}

