#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <pragmas/blitzblank_pragmas.h>
#include <BlitzBlank.h>

struct Library *BlitzBlankBase;
static const char version[]="$VER: BB.Crumble 2.50 (25.12.94)";

char *text[]={"\33c\33uCrumble\33n\n\nModule for BlitzBlank\n\nCopyright 1994\nby\nThomas Brkel",
              "Sp_eed:",
              "Da_rk Background:",
              "_Brightness",
              "_Delay:" };

struct BB_Object object[]={ {&object[1],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[2],BB_Slider,1,100,100,NULL,NULL},
                            {&object[3],BB_Check,0,0,0,NULL,NULL},
                            {&object[4],BB_Slider,0,100,70,NULL,NULL},
                            {&object[5],BB_Slider,0,20,1,NULL,NULL},
                            {NULL,BB_VGroup_End,0,0,0,NULL,NULL} };

struct BB_Message message;
struct BB_Screeninfo *screeninfo;

int a,*top,*bot;
struct RastPort *rp;


void setup (void)
{
  int i;
  a=0;
  SetAPen (rp,0);
  Move (rp,0,screeninfo->height-1);
  Draw (rp,screeninfo->width-1,screeninfo->height-1);
  Move (rp,0,screeninfo->height-2);
  Draw (rp,screeninfo->width-1,screeninfo->height-2);
  for (i=0;i<screeninfo->width;i++)
  {
    top[i]=screeninfo->height-2;
    bot[i]=screeninfo->height;
  }
}


void blank (void)
{
  int i,x,c,b=0;

  rp=&screeninfo->bbscreen->RastPort;

  top=calloc (screeninfo->width,sizeof (int));
  bot=calloc (screeninfo->width,sizeof (int));

  if (top==NULL || bot==NULL)
    return;

  if (object[2].set)
    b=BBL_GetDarkestPen (screeninfo->bbscreen);

  ScreenToFront (screeninfo->bbscreen);

  if (!CheckSignal (SIGBREAKF_CTRL_C))
  {
    BBL_ModuleRunning ();
    if (BBL_FadeDown (screeninfo->bbscreen,object[3].set,object[4].set))
    {
      setup ();
      do
      {
        WaitTOF ();
        for (i=1;i<=object[1].set;i++)
        {
          x=drand48 ()*screeninfo->width;
          if (top[x]>=0)
          {
            do
            {
              c=ReadPixel (rp,x,top[x]);
              top[x]--;
            } while (c==b && top[x]!=-1);
            if (top[x]==-1 && c==b)
              a++;
            else
              top[x]++;
            if (c!=b)
            {
              SetAPen (rp,b);
              WritePixel (rp,x,top[x]);
              if (drand48 ()*3<1)
              {
                bot[x]--;
                SetAPen (rp,c);
                WritePixel (rp,x,bot[x]);
              }
            }
            else
              if (a==screeninfo->width)
              {
                BBL_CopyOriginalScreen (screeninfo->bbscreen);
                setup ();
              }
          }
        }
      } while (!CheckSignal (SIGBREAKF_CTRL_C));
    }
  }
  return;
}


void main(int argc,char **argv)
{
  int i;

  if (!(BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
    exit (0);

  message.flags=BBF_CloneScreen;
  message.first=&object[0];

  if (strcmp (argv[1],"BLANK")==0)
  {
    StrToLong (argv[3],(long *) &screeninfo);
    BBL_SendMessage (&message,argv[2]);
    if (screeninfo->bbscreen)
      blank ();
    BBL_BlankDone ();
  }
  else
  {
    message.infotext=BBL_GetString (230,text[0]);
    for (i=1;i<=4;i++)
      object[i].label=BBL_GetString (230+i,text[i]);
    if (strcmp (argv[1],"CONFIG")==0)
    {
      BBL_SendMessage (&message,argv[2]);
    }
    else
    {
      message.first=NULL;
      BBL_SendMessage (&message,argv[2]);
    }
  }
  CloseLibrary (BlitzBlankBase);
  exit (0);
}

