#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos/dos.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>
#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <pragmas/blitzblank_pragmas.h>

#include <BlitzBlank.h>
#include <iff.h>

struct Library *BlitzBlankBase,*IFFBase;
static const char version[]="$VER: BB.AmigaSign 2.50 (30.01.94)";

char *text[]={"\33c\33uAmigaSign\33n\n\nModule for BlitzBlank\n\nCopyright 1995\nby\nThomas Brkel\n\nGraphics by Alexander Wiggert",
              "_Movement:",
              "_Rotspeed:",
              "Sp_eed:",
              "_Buffering:",
              "horizontal",
              "vertical",
              "diagonal" };

char *cycleentries[4]={NULL,NULL,NULL,NULL};

struct BB_Object object[]={ {&object[1],BB_VGroup,0,0,0,NULL,NULL},
                            {&object[2],BB_Cycle,0,0,2,(char *)cycleentries,NULL},
                            {&object[3],BB_Slider,-5,5,0,NULL,NULL},
                            {&object[4],BB_Slider,1,10,10,NULL,NULL},
                            {&object[5],BB_Check,0,0,0,NULL,NULL},
                            {NULL      ,BB_VGroup_End,0,0,0,NULL,NULL} };



struct BB_Message message;
struct BB_Screeninfo *screeninfo;
int depth=4;

void blank (void)
{
  char file[256],actual,stop=FALSE;
  int count,dx=0,dy=0,sizex=110,sizey=80,xpos,ypos,buf=0,db,rotdelay,rotcount=0,piccount=1,i,movedelay,movecount=0;
  UWORD colortable[256];
  ULONG dbufhandle;
  IFFL_HANDLE iff,form,loopform;
  struct IFFL_BMHD *bmhd;
  struct ViewPort *vp;
  struct BitMap *bm[4]={NULL};

  vp=&screeninfo->bbscreen->ViewPort;
  bm[0]=screeninfo->bbscreen->RastPort.BitMap;

  if (object[1].set==0 || object[1].set==2)
    dx=1;
  if (object[1].set==1 || object[1].set==2)
    dy=1;

  rotdelay=-object[2].set;
  if (rotdelay<0)
  {
    piccount=-rotdelay+1;
    rotdelay=0;
  }

  movedelay=10-object[3].set;

  db=object[4].set;

  xpos=screeninfo->width/2-sizex/2;
  ypos=screeninfo->height/2-sizey/2;

  if (db)
  {
    bm[1]=BBL_AllocDBufBitMap (screeninfo->bbscreen);
    dbufhandle=BBL_InitDBuf (screeninfo->bbscreen,bm[1]);
  }

  if (!db || (bm[1] && dbufhandle))
  {

    strcpy (file,message.path);
    strcat (file,"BB.AmigaSign.data");

    if ((iff=IFFL_OpenIFF (file,IFFL_MODE_READ)))
    {
      form=(IFFL_HANDLE)((UBYTE *)iff+12);
      if ((bmhd=IFFL_GetBMHD (form)))
      {
        count=IFFL_GetColorTab (form,(WORD *) colortable);
        LoadRGB4 (vp,colortable,count);
        if ((bm[2]=BBL_AllocBitMap (sizex+10,sizey+10,depth,BMF_CLEAR)))
        {
          if ((bm[3]=BBL_AllocBitMap (sizex+10,sizey+10,depth,BMF_CLEAR)))
          {
            if ((IFFL_DecodePic(form,bm[2])))
            {
              if (!CheckSignal (SIGBREAKF_CTRL_C))
              {
                ScreenToFront (screeninfo->bbscreen);
                BBL_ModuleRunning ();
                IFFL_DecodePic (form,bm[3]);
                form=IFFL_FindChunk (form,0L);
                if ((IFFL_ModifyFrame (form,bm[2])))
                {
                  loopform=IFFL_FindChunk (form,0L);
                  actual=3;
                  form=loopform;
                  do
                  {
                    if (rotcount==0)
                    {
                      for (i=1;i<=piccount;i++)
                      {
                        if ((IFFL_ModifyFrame (form,bm[actual])))
                        {
                          if (actual==3)
                            actual=2;
                          else
                            actual=3;
                        }
                        else
                          stop=TRUE;
                        form=IFFL_FindChunk (form,0L);
                        if (*(ULONG *)form!=ID_FORM)
                          form=loopform;
                      }
                      rotcount=rotdelay;
                    }
                    else
                      rotcount--;
                    if (!db)
                      WaitTOF ();
                    BltBitMap (bm[actual],0,0,bm[buf],xpos,ypos,sizex,sizey,0xc0,0xff,NULL);

                    if (db)
                    {
                      WaitBlit ();
                      BBL_ShowBitMap (screeninfo->bbscreen,bm[buf],dbufhandle);
//                      WaitTOF ();
                      buf=1-buf;
                    }

                    if (movecount==0)
                    {
                      xpos+=dx;
                      ypos+=dy;
                      movecount=movedelay;
                    }
                    else
                      movecount--;
                    if (xpos+sizex>screeninfo->width || xpos<0)
                    {
                      dx=-dx;
                      xpos+=dx+dx;
                    }
                    if (ypos+sizey>screeninfo->height || ypos<0)
                    {
                      dy=-dy;
                      ypos+=dy+dy;
                    }
                  } while (!CheckSignal (SIGBREAKF_CTRL_C) && !stop);
                  ScreenToBack (screeninfo->bbscreen);
                }
              }
            }
            BBL_FreeBitMap (bm[3]);
          }
          BBL_FreeBitMap (bm[2]);
        }
      }
      IFFL_CloseIFF (iff);
    }
  }
  if (db)
  {
    BBL_ShowBitMap (screeninfo->bbscreen,bm[0],dbufhandle);
//    WaitTOF ();
    BBL_EndDBuf (dbufhandle);
    BBL_FreeBitMap (bm[1]);
  }
  return;
}


void main (int argc,char **argv)
{
  int i;

  if ((BlitzBlankBase=OpenLibrary ("blitzblank.library",BLITZBLANKLIB_VER)))
  {
    if ((IFFBase=OpenLibrary ("iff.library",23)))
    {
      message.flags=BBF_Screenmode;
      message.first=&object[0];

      if (strcmp (argv[1],"BLANK")==0)
      {
        StrToLong (argv[3],(long *) &screeninfo);
        screeninfo->depth=depth;
        BBL_SendMessage (&message,argv[2]);
        if (screeninfo->bbscreen)
          blank ();
        BBL_BlankDone ();
      }
      else
      {
        message.infotext=BBL_GetString (320,text[0]);
        for (i=1;i<=4;i++)
           object[i].label=BBL_GetString (320+i,text[i]);
        cycleentries[0]=BBL_GetString (325,text[5]);
        cycleentries[1]=BBL_GetString (326,text[6]);
        cycleentries[2]=BBL_GetString (327,text[7]);
        if (strcmp (argv[1],"CONFIG")==0)
        {
          BBL_SendMessage (&message,argv[2]);
        }
        else
        {
          message.first=NULL;
          BBL_SendMessage (&message,argv[2]);
        }
      }
      CloseLibrary (IFFBase);
    }
    CloseLibrary (BlitzBlankBase);
  }
  exit (0);
}
