/*====================================================================
This file is part of the Blackout screen saver.       v0.91 1995-04-15
Copyright (C) 1995 by Staffan Ulfberg.    See README file for details.
====================================================================*/
#define INCL_DOS
#define INCL_KBD
#define INCL_NOPM
#define INCL_DOSMONITORS

#include <os2.h>
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "16bit.h"
ULONG progtype(PID idSession);

static PGINFOSEG gdt;
static void start_monitor(int);
static int keybchild = -1, mousechild = -1;

void sighandler() {
  printf("Interrupt!  Killing child processes.");
  if (keybchild > 0) {
    kill(keybchild, SIGKILL);
    wait(NULL);
  }
  if (mousechild > 0) {
    kill(mousechild, SIGKILL);
    wait(NULL);
  }
  exit(0);
} 

int main(int argc, char *argv[], char *envp[]) {
  SEL gdt_descriptor, ldt_descriptor;
  static UCHAR c, n;

  DosGetInfoSeg(&gdt_descriptor, &ldt_descriptor);
  gdt = (PGINFOSEG)MAKEP(gdt_descriptor, 0);
  
  signal(SIGINT, &sighandler);

  c = 255;
  for (;;) {
    if (c != (n = gdt->sgCurrent)) {
      c = n;
      if (keybchild != -1) {
	kill(keybchild, SIGKILL);
	keybchild = -1;
	wait(NULL);
      }
      if (mousechild != -1) {
	kill(mousechild, SIGKILL);
	mousechild = -1;
	wait(NULL);
      }
      if (keybchild = fork()) {
	if (!(mousechild = fork()))
	  start_monitor(1); 
      } else
	start_monitor(0);
    }
    sleep(5);
  }
}

static void start_monitor(int device) {
  time_t LastTimePosted = 0, temptime;
  USHORT count, rc;
  HKBD KBDHandle = (HKBD)0;
  MONIN *pmonInbuf;
  MONOUT *pmonOutbuf;
  KEYPACKET *pkeybuff;
  static HEV hevKeyb;

  if (!(pmonInbuf = _tcalloc(1, sizeof(MONIN))) ||
      !(pmonOutbuf = _tcalloc(1, sizeof(MONOUT))) ||
      !(pkeybuff = _tcalloc(1, sizeof(KEYPACKET)))) {
    printf("Could not allocate buffers.\n", rc);
    exit(1);
  }
  if (rc = DosOpenEventSem("\\SEM32\\BLACKOUT\\KEYB", &hevKeyb)) {
    printf("DosOpenEventSem: %d\nBlackout is not running?\n", rc);
    exit(1);
  }
  if (device)
    sleep(8); /* Dirty fix to skip initialization mouse
		 message from black.exe */
  pmonInbuf->cb  = sizeof(MONIN);
  pmonOutbuf->cb = sizeof(MONOUT);

  if (rc = DosMonOpen(device ? "MOUSE$" : "KBD$", &KBDHandle)) {
    printf("DosMonOpen: %d\n", rc);
    exit(1);
  }
  if (rc = DosMonReg(KBDHandle, (PBYTE)pmonInbuf, (PBYTE)pmonOutbuf,
		     MONITOR_BEGIN, gdt->sgCurrent)) {
    printf("DosMonReg: %d\n", rc);
    exit(1);
  }
  for (;;) {
    count = sizeof(KEYPACKET);
    DosMonRead((PBYTE)pmonInbuf, IO_WAIT, (PBYTE)pkeybuff, &count);
    DosMonWrite((PBYTE)pmonOutbuf,(PBYTE)pkeybuff,count);

    if (time(&temptime) - LastTimePosted > 10) {
      LastTimePosted = temptime; 
      DosPostEventSem(hevKeyb);
    } 
  }
}




