a--mand { ;; eli.frm
  z = c = pixel:
   z = (sqr(z)+c) / |c|
    |z|<p1
}

a---mand { ;; eli.frm
  z = c = pixel:
   z = z^c + sin(c)
    |z|<p1
}

A1 (XAXIS) {  ;; a1.frm
    z = Pixel:
    z = ((2*(z*z*z))-(3*(z*z))+1)^p1
    z = z+Pixel
    z = Sqr(z) * (p1)
    |z| <= 4;
}

aa-c-to-z (XAXIS)  { ;; eli.frm
  z = pixel, c = z:
   z = c^z;
    |z| <= p1
}


aa-diamand { ;; eli.frm
  z = c = pixel:
   z = sqr(z)+c;
    (real(z)+imag(z))<p1
}

aa-mand-im (XAXIS) { ;; eli.frm
  z = c = pixel:
   z = sqr(z)+c;
    imag(z)<p1
}

aa-mand-re (XAXIS) { ;; eli.frm
  z = c = pixel:
   z = sqr(z)+c;
    real(z)<p1
}

aa-z-to-c (XAXIS)  { ;; eli.frm
  z = pixel, c = z:
   z = exp(c*log(z));
    |z| <= p1
}

aa-z-to-z (XAXIS)  { ;; eli.frm
  z = pixel, c = z:
   z = exp(z*log(z));
    |z| <= p1
}
aaa-deals { ;; eli.frm
  z = pixel, a=real(z), b=imag(z), i=((0-1)^0.5):
   x = real(z)
   y = imag(z)
   u = x*x + y*y + a
   v = (0-2)*x*y + b
   z = u + v*i;
    |z|<p1
}

aaa { ;; dan.frm
    z = pixel, c = z:
    z = sqr(c);
    |z|<p1
}

aaaa (XAXIS)  { ;; dan.frm
    z = pixel, c = z:
    z = exp(z*log(z));
    |z| <= p1
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

BirdOfPrey (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(z=cos(z)+pixel),
    x=x+1, |z|<=4
}

BirdOfPreyC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=cos(z)+pixel)*(10<=x),
    x=x+1, |z|<=4
}

bizarre    { ;; bizarre.frm
        (x<10)*(z=sqr(z)+pixel),
        (10<=x)*(x<20)*(z=exp(z)+pixel),
        (20<=x)*(z=log(z)+pixel),
        x=x+1, |z|<=4
        }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

DeepSpaceProbe (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=sin(z)+pixel),
    (20<=x)*(z=cos(z)+pixel),
    x=x+1, |z|<=4
}

DeepSpaceProbeTwo (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=exp(z)+pixel),
    (20<=x)*(z=cos(z)+pixel),
    x=x+1, |z|<=4
}

DeepSpaceProbeTwoC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=exp(z)+pixel)*(10<=x)*(x<20)+(z=cos(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

;; DeepSpaceProbeC demonstrates a more complicated IF-THEN-ELSE structure
;;    if x<10 then z=sqr(z)+pixel
;;    else if x<20 then z=sin(z)+pixel
;;    else z=cos(z)+pixel

;; Verified with Testpt.c version

DeepSpaceProbeC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=sin(z)+pixel)*(10<=x)*(x<20)+(z=cos(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

dots { ;; eli.frm
  z = c = pixel:
   z = z^c + c
    |z|<p1
}

DrChaosbrot1 (xaxis) { ;; drcha.frm, based on phi
    z = c = pixel:
    z = sqr(z) + (((sqrt 5 + 1)/2)+c)
    |z| <= 4;
}


DrChaosbrot2 (xyaxis) { ;; drcha.frm, based on phi
    z = c = pixel:
    z = sqr(z) + (((sqrt 5 + 1)/2)+c)
    |z| <= 4;
}

Element (xyaxis) { ;; drcha.frm, phi lingam
    z = pixel:
    z = z*z*z*z + ((sqrt 5 + 1)/2)
    |z| <= 4;
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

;; EvilEyeC demonstrates an IF-THEN-ELSE structure.
;;    if |z|<1 then z=sin(z)+pixel
;;    else z=cos(z)+pixel

;; Verified with Testpt.c version

EvilEyeC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z)+pixel)*(1<x)+(z=cos(z)+pixel)*(x<=1),
    x=|z|, x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Eyeball (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(z=sinh(z)+pixel),
    x=x+1, |z|<=4
}

EyeballC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=sinh(z)+pixel)*(10<=x),
    x=x+1, |z|<=4
}

;; {=======================================================================}
;; {      File originally distributed with FRAC'Cetera Vol 2 Iss 6         }
;; {=======================================================================
;; =  From GRAPHDEV Fractal Sources forum messages - Dec-92.                =
;; =  Chaotic Liars   Author: Chuck Ebbert        CIS: 76306,1226           =
;; =  F'names,  where present,  are  FRAC'Cetera  created variations or     =
;; =  derivatives based, sometimes quite loosely, on the author's originals =
;; ========================================================================}

;; { Chaotic Liar formulas for FRACTINT, from Liar.FRM
;;
;;    These formulas reproduce some of the pictures in the paper 'Pattern
;; and Chaos: New Images in the Semantics of Paradox' by Gary Mar and
;; Patrick Grim of the Department of Philosophy, SUNY at Stony Brook.
;;
;;    "...what is being graphed within the unit square is simply
;; information regarding the semantic behavior for different inputs of a
;; pair of English sentences:"
;;
;; Fm: Dan Farmer 70703,1632
;;
;;    I tried out the Chaotic Liar formulas.  Interesting.
;; Liar1 is rather dull, Liar2 gets better, and Liar3 is really
;; interesting.  But, best of all, run Liar3 with Sound = z and
;; floating point OFF.  Press "O" for orbits. Great sound and a
;; really different orbits display. I did discover that these
;; types require floating point math.  I get either black
;; screen or totally different results with integer math
;;
;; !_Press_F2_!     {; There is text in this formula file.  Shell to DOS
;;                  ; with <d> key and use a text reader to browse file
;;                   }

F'Liar1 { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel:
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    fn1(abs(z))<p1 }

F'Liar1A { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    |z| <= p1 }

F'Liar1C { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    fn2(abs(z))<p1 }

F'Liar1D { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = p1 - abs(imag(z)-real(z) ) + flip(p2 - abs(1-real(z)-imag(z) ) );
    |z| <1 }

flip0_man_j (ORIGIN) { ;; flip.frm
   z=pixel:
   z = flip(sqr(z) + p1),
   |z| <= 4
   }

flip0_man_m (XAXIS) { ;; flip.frm
   z=0:
   z = flip(sqr(z) + pixel),
   |z| <= 4
   }

flip1_man_j (ORIGIN) { ;; flip.frm
   z=pixel, q = p1:
   q = flip(q),
   z = sqr(z) + q,
   |z| <= 4
   }

flip1_man_m { ;; flip.frm
   z=0, q = pixel:
   q = flip(q),
   z = sqr(z) + q,
   |z| <= 4
   }

flip2_man_j (ORIGIN) { ;; flip.frm
   z=pixel, q = p1:
   q = flip(q),
   z = flip(sqr(z) + q),
   |z| <= 4
   }

flip2_man_m { ;; flip.frm
   z=0, q = pixel:
   q = flip(q),
   z = flip(sqr(z) + q),
   |z| <= 4
   }

flip3_man_j { ;; flip.frm
   z = pixel:
   z = 1/flip(sqr(z) + p1),
   |z| <= 4
   }

flip3_man_m (XAXIS) { ;; flip.frm
   z = 0:
   z = 1/flip(sqr(z) + pixel),
   |z| <= 4
   }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Fly (XAXIS_NOPARM) {
    z=p1:
    x=real(z),
    (x<0)*(z=sqr(z)+pixel),
    (0<=x)*(z=sqr(z)-pixel),
    |z|<=4
}

FlyC (XAXIS_NOPARM) {
    z=p1:
    x=real(z),
    (z=sqr(z)+pixel)*(x<0)+(z=sqr(z)-pixel)*(0<=x),
    |z|<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

FlyingSquirrel (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=sin(z)/cos(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FlyingSquirrelC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z)/cos(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FnxZpZ  { ;; ebbert.frm
  ; Duplicate of built-in 'fn*z+z' type.
  ; p1, p2 same as built-in
  z = pixel:
   z = (p1 * fn1(z) + p2 ) * z,
    |z| <= 64
 }

FnZpFnPix { ;; ebbert.frm
  ; Duplicate of built-in type 'fn(z)+fn(pix).'
  ; P1 = perturbation of z(0), p2 = multiplication factor.
  z = pixel + p1, c = p2 * fn2(pixel):
   z = fn1(z) + c,
    |z| <= 64
 }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

FractalFender (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=cosh(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FractalFenderC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

FractalFenderTwo (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=cos(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FractalFenderTwoC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=cos(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Frog (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=sinh(z)/cosh(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FrogC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sinh(z)/cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;;
;; Lee.FRM, Lee2.FRM
;;
;; The following are from Lee Skinner, have been partially generalized
;;

Fzpcocoh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / cosh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopcs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z| <= 50}

Fzpcopct  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosxx(pixel) / sin(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

Fzpcophc  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcophs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopht  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosh(pixel) / sinh(pixel) ):
                       z = cosxx (z)+f,|z|<= 50}

Fzpcopse  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sqr(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopta  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sin(pixel) / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

Fzpcopth  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sinh(pixel) / cosh(pixel) ):
                        z = cosxx (z)+f,|z|<= 50}

Fzpcoseh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / sinh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpfncoh  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./cosh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzpfnseh  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./sinh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppchco  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppcoch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcocs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / cosxx(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcoct  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx(pixel) / sin(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

Fzppcoex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcohs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcoht  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh(pixel) / sinh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

Fzppcolo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopc  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosxx(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcope  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (exp(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopl  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (log(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = (pixel) ^ (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopr  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcops  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcore  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcos   { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcose  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / sin(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcosh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppcosi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcosq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcosr  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = (pixel) ^ 0.5:
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcota  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin(pixel) / cosxx(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

Fzppcoth  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh(pixel) / cosh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

Fzppexch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexco  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexp   { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppfncs  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./cos(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnct  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = cos(pixel)/sin(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnht  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = cosh(pixel)/sinh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzppfnpo  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = (pixel)^(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnre  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnse  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./sin(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnsr  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = (pixel)^.5:
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnta  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = tan(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnth  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = tanh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzppshch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshco  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppsich  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsico  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsiex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsinh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppsish  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsisq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsqlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = sqr (z)  + f, |z| <= 50}

Fzppsqsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = sqr (z)  + f, |z| <= 50}

Fzppsqsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = sqr (z)  + f, |z| <= 50}

Gen_01 { ;; ebbert.frm
  ; generalized type
  ; p1=p2=0, fn1=fn2=fn3=ident, fn4=sqr gives Mandelbrot
  z=pixel, t=p1+4, q = (p2+1) * fn1(pixel):
   z=fn2(fn3(fn4(z))) + q,
    |z|<=t
  }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

IslandOfChaos (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(z=sin(z)/cos(z)+pixel),
    x=x+1, |z|<=4
}

IslandOfChaosC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=sin(z)/cos(z)+pixel)*(10<=x),
    x=x+1, |z|<=4
}

;;; tchebych.frm
;;;   JULIA TYPE FRACTALS
;;;

J_TchebychevC2 {
   c = pixel, z = P1:
   z = c*(z*z-2),
   |z|<100
}

J_TchebychevC3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-3),
   |z|<100
}

J_TchebychevC4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

J_TchebychevC5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

J_TchebychevC6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

J_TchebychevC7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}

J_TchebychevS2 {
   c = pixel, z = P1:
   z = c*(z*z-1),
   |z|<100
}

J_TchebychevS3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-2),
   |z|<100
}

J_TchebychevS4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

J_TchebychevS5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

J_TchebychevS6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

J_TchebychevS7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

J_TchebychevT2 {
   c = pixel, z = P1:
   z = c*(2*z*z-1),
   |z|<100
}

J_TchebychevT3 {   ;
   c = pixel, z = P1:
   z = c*z*(4*z*z-3),
   |z|<100
}

J_TchebychevT4 {
   c = pixel, z = P1:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

J_TchebychevT5 {    ;
   c = pixel, z = P1:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

J_TchebychevT6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

J_TchebychevT7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

J_TchebychevU2 {
   c = pixel, z = P1:
   z = c*(4*z*z-1),
   |z|<100
}

J_TchebychevU3 {   ;
   c = pixel, z = P1:
   z = c*z*(8*z*z-4),
   |z|<100
}

J_TchebychevU4 {
   c = pixel, z = P1:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

J_TchebychevU5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

J_TchebychevU6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

J_TchebychevU7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

J_Lagandre2 {
   c = pixel, z = P1:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

J_Lagandre3 {
   c = pixel, z = P1:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

J_Lagandre4 {
   c = pixel, z = P1:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

J_Lagandre5 {
   c = pixel, z = P1:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

J_Lagandre6 {
   c = pixel, z = P1:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

J_Lagandre7 {
   c = pixel, z = P1:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

J_Laguerre2 {
   c = pixel, z = P1:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

J_Laguerre3 {
   c = pixel, z = P1:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

J_Laguerre4 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

J_Laguerre5 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

J_Laguerre6 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720 + c,
   |z| < 100
}

j1 { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2,
	|z| <= 4
	}

jc { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*c,
	|z| <= 4
	}

jfnc { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*fn1(c),
	|z| <= 4
	}

jfnz { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*fn1(z),
	|z| <= 4
	}

joc { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2/c,
	|z| <= 4
	}

joz { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2/z,
	|z| <= 4
	}

jz { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*z,
	|z| <= 4
	}

LambdaFnOrFn { ;; Ebbert.frm
   ; Duplicate of built-in 'lambda(fn||fn).'
   ; P1 = lambda, real(p2) changes shift value from default of 1,
   ;  imag(p2) changes bailout from default of 64.
  z = pixel, modz = |z|, b = imag(p2) + 64, t = real(p2) + 1:
   z = ( fn1(z) * (modz<t) + fn2(z) * (real(t)<=modz ) ) * p1,
   modz = |z|,
    modz <= b
 }

Leeze (XAXIS) = { ;; Lee2.FRM (Lee Skinner)
       s = exp(1.,0.), z = Pixel, f = Pixel ^ s:
                       z = cosxx (z) + f, |z| <= 50 }

;;
;;      ;    #: 7363 S4/Fractal Sources
        ;    08-Dec-92 18:46:48
        ;    Sb: #Chaotic Liars
        ;    Fm: Chuck Ebbert 76306,1226
        ;    To: All
        ; Chaotic Liar formulas for FRACTINT.
        ; These formulas reproduce some of the pictures in the paper
        ;  'Pattern and Chaos: New Images in the Semantics of Paradox'
        ;  by Gary Mar and Patrick Grim of the Department of Philosophy,
        ;  SUNY at Stony Brook.

        ; Formulas by Chuck Ebbert  CIS [76306,1226], from Liar.FRM
        ; "...what is being graphed within the unit square is simply
        ;  information regarding the semantic behavior for different
        ;  inputs of a pair of English sentences:"
        ; }

Liar1 { ; by Chuck Ebbert.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
   z = pixel:
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) )
  |z| <= 1 ;
 }

Liar2 { ; by Chuck Ebbert.
        ; Same as Liar1 but use sequential reasoning, calculating
        ;  new y value using new x value.
        ; x(n+1) = 1 - abs(y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)-real(z))
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
 }

Liar3 { ; by Chuck Ebbert.
        ; X: X is true to P1 times the extent that Y is true
        ; Y: Y is true to the extent that X is false.
        ; Sequential reasoning.  P1 usually 0 to 1.  P1=1 is Liar2 formula.
        ; x(n+1) = 1 - abs(p1*y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)*real(p1)-real(z) )
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
}

Liar4 { ; by Chuck Ebbert.
        ; X: X is as true as (p1+1) times Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; Real part of p1 changes probability.  Use floating point.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel, p = p1 + 1:
   z = 1-abs(imag(z)*p-real(z))+flip(1-abs(1-real(z)-imag(z)));
    |z| <= 1
    }

;;; tchebych.frm
;;;   MANDELBROT TYPE FRACTALS
;;;

M_Lagandre2 {
   c = P1, z = Pixel:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

M_Lagandre3 {
   c = P1, z = Pixel:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

M_Lagandre4 {
   c = P1, z = Pixel:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

M_Lagandre5 {
   c = P1, z = Pixel:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

M_Lagandre6 {
   c = P1, z = Pixel:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

M_Lagandre7 {
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

M_Laguerre2 {
   c = P1, z = Pixel:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

M_Laguerre3 {
   c = P1, z = Pixel:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

M_Laguerre4 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

M_Laguerre5 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

M_Laguerre6 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720 + c,
   |z| < 100
}

M_TchebychevC2 {
   c = P1, z = Pixel:
   z = c*(z*z-2),
   |z|<100
}

M_TchebychevC3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-3),
   |z|<100
}

M_TchebychevC4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

M_TchebychevC5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

M_TchebychevC6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

M_TchebychevC7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}

M_TchebychevS2 {
   c = P1, z = Pixel:
   z = c*(z*z-1),
   |z|<100
}

M_TchebychevS3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-2),
   |z|<100
}

M_TchebychevS4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

M_TchebychevS5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

M_TchebychevS6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

M_TchebychevS7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

M_TchebychevT2 {
   c = P1, z = Pixel:
   z = c*(2*z*z-1),
   |z|<100
}

M_TchebychevT3 {   ;
   c = P1, z = Pixel:
   z = c*z*(4*z*z-3),
   |z|<100
}

M_TchebychevT4 {
   c = P1, z = Pixel:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

M_TchebychevT5 {    ;
   c = P1, z = Pixel:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

M_TchebychevT6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

M_TchebychevT7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

M_TchebychevU2 {
   c = P1, z = Pixel:
   z = c*(4*z*z-1),
   |z|<100
}

M_TchebychevU3 {   ;
   c = P1, z = Pixel:
   z = c*z*(8*z*z-4),
   |z|<100
}

M_TchebychevU4 {
   c = P1, z = Pixel:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

M_TchebychevU5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

M_TchebychevU6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

M_TchebychevU7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

m1 { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1,
	|z| <= 4
	}

Magnet1M (XAXIS) { ;; ebbert.frm
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z = p1, cm1 = pixel - 1, cm2 = cm1 - 1:
   z = sqr( (z*z+cm1 ) / (z+z+cm2 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

Magnet2M (XAXIS) { ;; ebbert.frm
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z=p1,c1=pixel-1,c1x3=c1*3,c2x3=c1x3-3,c1c2=c1*c1-c1,c1c2p1=c1c2+1:
   z=sqr( ( (z*z+c1x3 )*z+c1c2 ) / ( (z*3+c2x3 )*z+c1c2p1 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

ManInTheOzone (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=cos(z)+pixel),
    (20<=x)*(z=sin(z)+pixel),
    x=x+1, |z|<=4
}

ManInTheOzoneC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=cos(z)+pixel)*(10<=x)*(x<20)+(z=sin(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

mc { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*c,
	|z| <= 4
	}

mfnc { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*fn1(c),
	|z| <= 4
	}

mfnz { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*fn1(z),
	|z| <= 4
	}

Michaelbrot (origin) {    ;; drcha.frm, based on the golden mean
    z = pixel:
    z = sqr(z) + ((sqrt 5 + 1)/2),
    |z| <= 4;
} 

moc { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1/c,
	|z| <= 4
	}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Moth (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=exp(z)+pixel),
    (20<=x)*(z=log(z)+pixel),
    x=x+1, |z|<=4
}

MothC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=exp(z)+pixel)*(10<=x)*(x<20)+(z=log(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

moz { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1/z,
	|z| <= 4
	}

mz { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*z,
	|z| <= 4
	}

Natura (xyaxis)  { ;; drcha.frm, phi yoni
    z = pixel:
    z = z*z*z + ((sqrt 5 + 1)/2)
    |z| <= 4;
}

non-conformal { ;; flip.frm
   ; From Media Magic Calender - August
   z=x=y=x2=y2=0:
   t = x * y,
   x = x2 + t + real(pixel),  y = y2 - t + imag(pixel),
   x2 = sqr(x),  y2 = sqr(y), z=x + flip(y),
   |z| <= 4
   }

phoenix_j (XAXIS) { ;; flip.frm
   ; Use P1=0.56667/-0.5   &   .1/.8
   x=real(pixel), y=imag(pixel), z=nx=ny=x1=x2=y1=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(p1) + imag(p1) * nx,
   y1 = 2 * x * y + imag(p1) * ny,
   nx=x, ny=y, x=x1, y=y1, z=nx + flip(ny),
   |z| <= 4
   }
phoenix_m { ;; flip.frm
   ; Mandelbrot stye map of the Phoenix curves
   z=x=y=nx=ny=x1=y1=x2=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(pixel) + imag(pixel) * nx,
   y1 = 2 * x * y + imag(pixel) * ny,
   nx=x, ny=y, x=x1, y=y1, z=x + flip(y),
   |z| <= 4
   }
Raphaelbrot (xyaxis) {  ;; drcha.frm, based on phi
    z = pixel:
    z = sqr(z) + ((sqrt 5 - 1)/2)
    |z| <= 4;
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

SinEgg (XAXIS_NOPARM) {
    z=p1,x=|z|:(1<x)*(z=sin(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

SinEggC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

SinhEgg (XAXIS_NOPARM) {
    z=p1,x=|z|:(1<x)*(z=sinh(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

SinhEggC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sinh(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;;; symmicon.frm

SymmIcon {
        z = P1, x = P2, bar = (1,-1), l = real(P1), a = imag(P2),
        b = .2, g = .1, w = 0, n = 5:

        zbar = z*bar;
        z = ((l + (a * z * zbar) + (b * real(z^n))  + (w * i)) * z) + g*(zbar^(n-1)) + pixel;
        }

;;; tchebych.frm

Tchebychev-c6 (XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=0:
   zsq = z*z,
   z = pixel * (zsq*zsq*zsq - 6*zsq*zsq + 9*zsq - 2),
   |z| <= 4
   }

Tchebychev-t5 (XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=(0.654,0):
   zcube = z*z*z,
   z = pixel * (16*z*z*zcube - 20*zcube + 5*z),
   |z| <= 4
   }

;; drcha.frm
;; try inside=maxiter and outside=imag on this

test (xyaxis) { ;; =phi
    z = ((sqrt 5 + 1)/2)/pixel:
    z =  z*z + pixel*((sqrt 5 + 1)/2)
    |z| <= 4;
}

test1 (xyaxis) { ;; =phi
    c = pixel
    z = ((sqrt 5 + 1)/2):
    z =  z*z + pixel*((sqrt 5 + 1)/2) + c
    |z| <= 4;
}

test2 (xyaxis) { ;; =phi
    z = ((sqrt 5 + 1)/2)/pixel:
    z =  z*z*z + pixel*((sqrt 5 + 1)/2)
    |z| <= 4;
}

test3 (xyaxis) { ;; =phi
    z = ((sqrt 5 + 1)/2)/pixel:
    z =  z*z + pixel*((sqrt 5 + 1)/2)/((sqrt 5 - 1)/2)
    |z| <= 4;
}

;;; tchebych.frm

test {
  z=pixel,c=p1:
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / (16 * (z+c))
   |z| < 100
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

;; TestSinMandC demonstrates an IF-THEN type formula as an IF-THEN-ELSE
;; without the ELSE.
;;    if |z|<1 then z=sin(z)
;;    else nothing
;;    z=sqr(z)+pixel
  
;; Verified with Testpt.c version

TestSinMandC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z))*(1<x)+(z=z)*(x<=1),
    (z=sqr(z)+pixel),
    x=|z|, x<=4
}

Tetrate(XAXIS) { ;; ebbert.frm
  ; duplicate of built-in type.
  ; p1=initial perturbation of z(0), p2 changes bailout from 4.
  z = pixel + p1, b = real(p2) + 4:
   z = pixel ^ z;
    |z| <= b;
 }

Tetratephi (xyaxis) { ;; drcha.frm, ?
    z  = c = ((sqrt 5 +1)/2)/pixel:
    z = c^z + ((sqrt 5 +1)/2)
    |z| <= 4;
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

TurtleC (XAXIS_NOPARM) {
    z=p1:
    x=real(z),
    (z=sqr(z)+pixel)*(x<0)+(z=sqr(z)-pixel)*(0<=x),
    |z|<=4
}

;;;
;;; uli.frm
;;;

   ULI_1 = {
      z = Pixel: z = fn1(1/fn2(z))
      |z| <= 4
   }

   ULI_2 = {
      z = Pixel: z = fn1(1/fn2(z+p1))
      |z| <= p2
   }

   ULI_3 = {
      z = Pixel: z = fn1(1/fn2(z+p1)+p1)
      |z| <= p2
   }

   ULI_4 = {
      z = Pixel: z = fn1(1/(z+p1))*fn2(z+p1)
      |z| <= p2
   }

   ULI_5 = {
      z = Pixel, c = fn1(pixel):
      z = fn2(1/(z+c))*fn3(z+c)
      |z| <= p1
   }

   ULI_6 = {
      z = Pixel: z = fn1(p1+z)*fn2(p2-z)
      |z| <= p2+16
   }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

WaldoTwinsC (XAXIS_NOPARM) {
    z=p1:
    z=cos(sin(z+pixel))+pixel,
    |z|<=4
}

Zppchco8  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z|<=8192}


