#include "xinternl.h"
#include <conio.h>
/*==================================================================
XPOINT.CPP contains the basic functions for pixel manipulation in
mode X.

These routines were written initially by Themie Gouthas and
company and modified March 1995 by Victor B. Putz.
===================================================================*/


extern int ScrnLogicalByteWidth;
extern unsigned char * pbVGABuffer;

/*
@func Puts a pixel to the screen at the appropriate
offset, x, y location.
*/
void x_put_pix(
  xScreenCoord_t wX,
  xScreenCoord_t wY,
  xPageHandle_t wPageBase,
  xColor_t wColor
)
{
  int iOffset = ScrnLogicalByteWidth * wY + (wX / 4) + wPageBase;
  outpw( SC_INDEX,  ( 0x0100 << ( wX & 3 ) ) + MAP_MASK );
  pbVGABuffer[ iOffset ] = ( BYTE )wColor;
}

/*
@func Gets a pixel's color from the screen at the given offset, x,
y location.
*/
xColor_t x_get_pix(
  xScreenCoord_t wX,
  xScreenCoord_t wY,
  xPageHandle_t wPageBase
)
{
  int iOffset = ScrnLogicalByteWidth * wY + (wX / 4) + wPageBase;
  outpw( GC_INDEX, ( (wX & 3) << 8 ) + READ_MAP );
  return pbVGABuffer[ iOffset ];
}
