/*-----------------------------------------------------------------------
;
; XPBITMAP - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
; ****** Aeronautical Research Laboratory              ****************
; ****** Defence Science and Technology Organisation   ****************
; ****** Australia                                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XPBITMAP_H_
#define _XPBITMAP_H_

#include "xdefs.h"
/* FUNCTIONS =========================================================== */


void x_put_masked_pbm(  /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,    /* only non zero pixels to VRAM           */
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap);

void x_flip_masked_pbm(  /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,     /* only non zero pixels to VRAM. Bitmap   */
  xScreenCoord_t Y,     /* is mirrored.                           */
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap,
  int orientation);

void x_put_pbm(         /* Copy a planar bitmap from SRAM to VRAM */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap);

void x_flip_pbm(         /* Copy a planar bitmap from SRAM to VRAM */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap,
  int orientation);

void x_get_pbm(         /* Copy a planar bitmap from VRAM to SRAM */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  int iNibbleWidth,
  int iPixelHeight,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap);


#endif


