#include "xinternl.h"
#include <conio.h>
#include <mem.h>

/*==================================================================
XPAL.CPP contains the basic variables and functions for palette
handling.

These routines were written initially by Themie Gouthas and
company and modified March 1995 by Victor B. Putz.
===================================================================*/


void  x_get_pal_raw(       /* Read DAC palette into raw buffer       */
  BYTE * pal,
  int num_colrs,
  int start_index
)
{
  BYTE * pb = pal + ( start_index * 3 );
  outp( DAC_READ_INDEX, start_index );
  while ( num_colrs-- ) {
    *pb++ = ( BYTE )inp( DAC_DATA );
  }
}

void  x_get_pal_struc(     /* Read DAC palette into annotated buffer */
  BYTE  * pal,
  int num_colrs,
  int start_index
)
{
  *pal++ = ( BYTE )start_index;
  *pal++ = ( BYTE )num_colrs;
  x_get_pal_raw( pal, num_colrs, start_index );
}



inline void WaitVsyncStart(
  void
)
{
  while( inp( INPUT_STATUS_0 ) & 0x08 );
  while( !( inp( INPUT_STATUS_0 ) & 0x08 ) );
}

void  x_put_pal_raw(       /* Write DAC palette from raw buffer      */
  BYTE * pal,
  int num_colrs,
  int start_index)
{
 BYTE * pb = pal + ( start_index * 3 );
 WaitVsyncStart();
 outp( DAC_WRITE_INDEX, start_index );
 while( num_colrs-- ) {
   outp( DAC_DATA, *pb++ );
   outp( DAC_DATA, *pb++ );
   outp( DAC_DATA, *pb++ );
 }
}


void  x_put_pal_struc(     /* Write DAC palette from annotated buffer*/
  BYTE * pal
)
{
  x_put_pal_raw( pal + 2, *(pal + 1), *pal );
}

void  x_set_rgb(                /* Set the RGB components of a color index*/
  BYTE color,
  BYTE red_c,
  BYTE green_c,
  BYTE blue_c
)
{
  outp( DAC_WRITE_INDEX, color );
  outp( DAC_DATA, red_c );
  outp( DAC_DATA, green_c );
  outp( DAC_DATA, blue_c );
}

void  x_rot_pal_raw(           /* Rotate a raw palette buffer             */
  BYTE  * pal,
  int direction,
  int num_colrs
)
{
	//decrement num_colrs, since we're only moving ( num_colrs - 1 ) in the block.
	num_colrs--;
	switch ( direction ) {
  	case 0 : {
      int iRed = *pal;
      int iGreen = *( pal + 1 );
      int iBlue = *( pal + 2 );
      memmove( pal, pal + 3, num_colrs * 3 );
      pal += num_colrs * 3;
      *( pal + 0 ) = ( BYTE )iRed;
      *( pal + 1 ) = ( BYTE )iGreen;
      *( pal + 2 ) = ( BYTE )iBlue;
    }
		break;
    case 1 : {
      int iRed = *( pal + ( num_colrs * 3 ) );
      int iGreen = *( pal + ( num_colrs * 3 ) + 1 );
      int iBlue = *( pal + ( num_colrs * 3 ) + 2 );
      memmove( pal + 3, pal, num_colrs * 3 );
      *( pal + 0 ) = ( BYTE )iRed;
      *( pal + 1 ) = ( BYTE )iGreen;
      *( pal + 2 ) = ( BYTE )iBlue;
    }
    break;
  }
}

void  x_rot_pal_struc(    /* Rotate an anottated palette buffer      */
  BYTE  * pal,
  int direction
)
{
  x_rot_pal_raw( pal + 2, direction, *(pal + 1) );
}

WORD  x_cpcontrast_pal_struc(     /* Copy and contrast adjust annotated  */
  BYTE  *src_pal,  /*  palette buffer                     */
  BYTE  *dest_pal,
  BYTE Intensity
)
{
  int iDelta = ( 0xff - Intensity ) & 0x7f;
  //copy start and number of colors
  *dest_pal++ = *src_pal++;
  int iNumColors = *dest_pal++ = *src_pal++;
  WORD wFlag = 0;	//returns zero if all colors are zero
	for( int i = 0; i < iNumColors * 3; ++i ) {
    int iTemp = *src_pal++;
    iTemp -= iDelta;
    if ( iTemp < 0 ) {
      iTemp = 0;
    }
    if ( iTemp > 0 ) {
      wFlag = 1;
    }
    *dest_pal++ = ( BYTE )iTemp;
  }
  return wFlag;
}

void  x_transpose_pal_struc(  /* Write DAC palette from annotated type*/
  BYTE  * pal, /* buffer with a new offset             */
  int StartColor)
{

}


void  x_put_contrast_pal_struc( /* Write DAC palette from annotated */
  BYTE  * pal,   /* type buffer with specified intensity  */
  BYTE  intensity)
{

}