/*-----------------------------------------------------------------------
;
; XMOUSE - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XMOUSE_H_
#define _XMOUSE_H_

#define LEFT_PRESSED  1
#define RIGHT_PRESSED 2

/* GLOBAL VARS ========================================================= */

extern int MouseInstalled;   /* Indicates whether mouse handler installed */
extern int MouseHidden;      /* Indicates whether mouse cursor is hidden  */
extern int MouseButtonStatus;/* Holds the mouse button status             */
extern int MouseX;           /* Current X position of mouse cursor        */
extern int MouseY;           /* Current Y position of mouse cursor        */
extern BYTE MouseFrozen;      /* Disallows position updates if TRUE        */
extern xColor_t MouseColor;       /* The mouse cursors colour                  */

/* FUNCTIONS =========================================================== */




void x_mouse_init(void);       /* Initialize mouse cursor            */

void x_define_mouse_cursor(    /* Define and set a cursor shape      */
     char * MouseDef,
     xColor_t color);

void x_update_mouse(void);     /* Force mouse cursor position update */

void x_show_mouse(void);       /* Show mouse cursor if hidden        */

void x_hide_mouse(void);       /* Hide mouse cursor if visible       */

void x_mouse_remove(void);     /* Remove installed mouse handler     */

void x_position_mouse(         /* Set the mouse position             */
   xScreenCoord_t x,
   xScreenCoord_t y);

void x_put_cursor(             /* Draw the mouse cursor (NOT FOR     */
   xScreenCoord_t x,               /* general use)                       */
   xScreenCoord_t y,
   xScreenCoord_t topclip,
   xScreenCoord_t botclip,
   xPageHandle_t ScrnOff);


void x_mouse_window(
	xScreenCoord_t x0,     /* Define a mouse window */
  xScreenCoord_t y0,
  xScreenCoord_t x1,
  xScreenCoord_t y1);


#endif
