#ifndef XINTERNL_H
#define XINTERNL_H

#define BACKWARD 0
#define FORWARD  1

#define X_MODE_INVALID  -1
#define ERROR            1
#define OK               0

/*
This block contains defines for the various controller indices, etc
*/
#define AC_INDEX        0x03c0    //Attribute controller index
#define MISC_OUTPUT     0x03c2    //Miscellaneous output register
#define SC_INDEX        0x3c4     //Sequence controller index
#define GC_INDEX        0x3ce     //Graphics Controller index
#define CRTC_INDEX      0x3d4     //CRT controller index
#define DAC_READ_INDEX  0x3c7
#define DAC_WRITE_INDEX 0x3c8
#define DAC_DATA        0x3c9
#define INPUT_STATUS_0  0x3da     //input status 0 register
#define VGAENABLE_ADDR  0x3c3     //not sure what this is...

#define SCREEN_SEG      ((char *)(0xa000 << 4))

#define MAP_MASK        0x02      //index in SC of map mask register
#define READ_MAP        0x04      //index in GC of read map register
#define BIT_MASK        0x08      //index in GC of bit mask register

#define OVERFLOW        0x07      //crtc overflow register index
#define MAX_SCAN_LINE   0x09      //crtc maximum scan line register index
#define ADDR_HIGH       0x0c      //index of Start Address High register in CRTC
#define ADDR_LOW        0x0d      //index of Start Address Low register in CRTC
#define CRTC_OFFSET     0x13      //CRTC offset register index
#define UNDERLINE       0x14      //CRTC underline location register index
#define MODE_CONTROL    0x17      //CRTC mode control register index
#define LINE_COMPARE    0x18      //CRTC line compare register index (bits 0-7 of 
                                  //split screen scan line

#define AC_MODE_CONTROL 0x10      //Index of mode control register in AC
#define PEL_PANNING     0x13      //Pel panning register index in AC
#define PATTERN_BUFFER  0xfffc    //offset in screen memory of pattern buffer

#define TRUE 1
#define FALSE 0
#define OK 0
#define ERROR 1

#define ALL_PLANES      0x0f02

#include "xdefs.h"

#endif //XINTERNL_H
