#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include "xlib.h"
#include "xpoint.h"
#include "xrect.h"
#include "xpal.h"
#include "xtext.h"
#include "xline.h"
#include "xcircle.h"
#include "xmouse.h"
#include "xpbitmap.h"
#include "xscalebm.h"
#include "xplanput.h"
#include <time.h>
#include <iostream.h>

BYTE XFont[ 2048 ];
int loadfontX(char *fname)
{
    FILE *fp;

    fp = fopen(fname, "rb");

    if (fp == NULL) {
        return 0;
    } else {
        fread(XFont, 8, 256, fp);
        fclose(fp);
        return 1;
    }
}

static BYTE  bm[] = {4,12,
  /* plane 0 */
  2,2,2,2,2,1,1,1,2,1,1,1,2,3,3,1,
  2,0,0,3,2,0,0,3,2,0,0,3,2,0,0,3,
  2,3,3,1,2,1,1,1,2,1,1,1,2,2,2,2,
  /* plane 1 */
  2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,1,
  1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,
  1,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,
  /* plane 2 */
  2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,1,
  1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,
  1,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,
  /* plane 3 */
  2,2,2,2,1,1,1,2,1,1,1,2,1,3,3,2,
  3,0,0,2,3,0,0,2,3,0,0,2,3,0,0,2,
  1,3,3,2,1,1,1,2,1,1,1,2,2,2,2,2};

BYTE StraightBm[] = {
  5, 5,
  2, 2, 2, 2, 2,
  2, 1, 1, 1, 2, 
  2, 1, 3, 1, 2, 
  2, 1, 1, 1, 2, 
  2, 2, 2, 2, 2
};

BYTE bm2[ 2048 ];

const int CiNumTrials = 1000;

void main(
  void
)
{
  //a test of mode X routines in protected mode.  Just sets 320x240 mode.
  x_set_mode( 2, (WORD)500 );
  int iColor = 0;
  x_text_init();
  x_rect_fill( 0, 0, ScrnLogicalPixelWidth, ScrnLogicalHeight, VisiblePageOffs, 160 );
  loadfontX( "fixed6x8.fnt" );
  x_register_userfont( XFont );
  x_set_font( 2 );
  x_put_pbm( 161,100, VisiblePageOffs, bm );
  x_put_masked_pbm( 110, 110, VisiblePageOffs, bm2 );


  clock_t clkNormalBegin = 0;
  clock_t clkNormalEnd = 0;
  clkNormalBegin = clock();
  for ( int iTrial = 0; iTrial < CiNumTrials; ++iTrial ) {
    for (int iCounter = 0; iCounter < 180; ++iCounter ) {
      x_put_masked_pbm( iCounter, iCounter, VisiblePageOffs, bm );
    }
  }
  clkNormalEnd = clock();

  clock_t clkPlanarBegin = 0;
  clock_t clkPlanarEnd = 0;
  clkPlanarBegin = clock();
  for ( iTrial = 0; iTrial < CiNumTrials; ++iTrial ) {
    for ( int iPlaneLoop = 0; iPlaneLoop < 4; ++iPlaneLoop ) {
      x_set_write_plane( (BYTE)iPlaneLoop );
      for ( int iCounter = 0; iCounter < 180; ++iCounter ) {
        x_put_plane_masked_pbm( iCounter, iCounter, VisiblePageOffs, bm );
      }
    }
  }
  clkPlanarEnd = clock();

  
  x_text_mode();
  cout << "Normal mode: " << ( clkNormalEnd - clkNormalBegin ) << "\n";
  cout << "Planar mode: " << ( clkPlanarEnd - clkPlanarBegin ) << "\n";

}
