/* spr_edit.c - edit sprite files
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <pc.h>
#include <unistd.h>
#include "f:\gcc\proj\spr\src\jlib.h"

/* color of all on screen text */
#define COLOR 15

/* key values of "y" and "Y" */
#define BIG_Y 89
#define SMALL_Y 121

/* x / y pos of in and out sprites on screen */
#define INX 60
#define INY 60
#define OUTX 160
#define OUTY 60

/* menu codes */
#define ERROR 1
#define QUIT 2
#define COPY 3
#define SAVE 4
#define NOT_EVENT 5
#define IN_PLUS 6
#define IN_MINUS 7
#define OUT_PLUS 8
#define OUT_MINUS 9

/* stuff for menu buttons */
 typedef struct{
	  USHORT x;
	  USHORT y;
	  USHORT width;
	  USHORT height;
	  char   *text;
 }menu_button;

 menu_button B_quit = { 0,10,34,10,"Quit" };
 menu_button B_save = { 36,10,34,10,"Save" };
 menu_button B_copy = { 72,10,34,10,"Copy" };
 menu_button B_inplus = { INX,INY+SPR_MAX_Y+5,10,10,"+" };
 menu_button B_inminus = { INX+40,INY+SPR_MAX_Y+5,10,10,"-" };
 menu_button B_outplus = { OUTX,OUTY+SPR_MAX_Y+5,10,10,"+" };
 menu_button B_outminus = { OUTX+40,OUTY+SPR_MAX_Y+5,10,10,"-" };


/* protos */
void draw_button(menu_button *m);
int is_in_button(int x,int y, menu_button *m);
void blank_space(int x1,int y1,int x2,int y2);
int get_event();
void do_quit();
void do_copy(sprite_system *in,sprite_system *out,int cin,int cout);
void cleanup();
void write_out_file(char *file,sprite_system *outsys);


/****************************************************************************/
void main(int argc, char *argv[])
{
  int code;
  char tmpstr[100];
  sprite_system *ssys, *outsys;
  USHORT current_in = 0, current_out = 0;


  /* initialisation stuff... */
  if(argc!=3){
	      printf("spr_edit - edit sprite files.\n");
	      printf("Usage: spr_edit <infile> <outfile> \n");
	      printf("Where: <infile>  = file to get sprites from.\n");
	      printf("Where: <outfile> = file to put sprites into.\n");
	      exit(-1);
  }

  if(!mouse_present()){
     printf("ERROR: No mouse installed.\n");
     exit(-1);
  }

  ssys=sprite_init(16,256);
  outsys=sprite_init(16,256);

  if(sprite_load(argv[1],ssys)!=SUCCESS){
     printf("ERROR: Could not load sprite file %s.\n",argv[1]);
     exit(-1);
  }

  screen_set_video_mode();

  screen_draw_stringNC("Sprite File Editor v1.0",100,0,COLOR);

  draw_button(&B_quit);
  draw_button(&B_save);
  draw_button(&B_copy);
  draw_button(&B_inplus);
  draw_button(&B_inminus);
  draw_button(&B_outplus);
  draw_button(&B_outminus);


  /* draw boxes to surround the sprites */
  screen_draw_boxNC(INX,INY,INX+SPR_MAX_X+2,INY+SPR_MAX_Y+2,COLOR);
  screen_draw_boxNC(OUTX,OUTY,OUTX+SPR_MAX_X+2,OUTY+SPR_MAX_Y+2,COLOR);

  mouse_show_pointer();

  do{

    mouse_hide_pointer();

    /* blank the status areas above each sprite box */
    blank_space(INX,INY-10,INX+SPR_MAX_X,INY-1);
    blank_space(OUTX,OUTY-10,OUTX+SPR_MAX_X,OUTY-1);

    /* update the values of each sprite */
    sprintf(tmpstr,"Frame: %3d\n",current_in);
    screen_draw_stringNC(tmpstr,INX,INY-10,COLOR);
    sprintf(tmpstr,"Frame: %3d\n",current_out);
    screen_draw_stringNC(tmpstr,OUTX,OUTY-10,COLOR);

    /* draw each sprite */
    if(ssys->sprite_data[current_in] !=NULL){
       blank_space(INX+1,INY+1,INX+SPR_MAX_X,INY+SPR_MAX_Y);
       screen_stamp_spriteNC(INX+1,INY+1,ssys,current_in);
    }
    else{
       blank_space(INX+1,INY+1,INX+SPR_MAX_X,INY+SPR_MAX_Y);
       screen_draw_stringNC("End Of File",INX+10,INY+10,COLOR);
    }

    if(outsys->sprite_data[current_out] !=NULL){
       blank_space(OUTX+1,OUTY+1,OUTX+SPR_MAX_X,OUTY+SPR_MAX_Y);
       screen_stamp_spriteNC(OUTX+1,OUTY+1,outsys,current_out);
    }
    else{
       blank_space(OUTX+1,OUTY+1,OUTX+SPR_MAX_X,OUTY+SPR_MAX_Y);
       screen_draw_stringNC("Vacant",OUTX+10,OUTY+10,COLOR);
    }

    mouse_show_pointer();

    code = get_event();

    switch(code){
	 case QUIT:
		   do_quit();
		   break;

	 case SAVE:
		   write_out_file(argv[2],outsys);
		   break;

	 case COPY:
		   do_copy(ssys,outsys,current_in,current_out);
		   break;

	 case IN_PLUS:
		   if(ssys->sprite_data[current_in] != NULL){
		      ++current_in;
		   }
		   break;

	 case IN_MINUS:
		   if(current_in!=0){
		      --current_in;
		   }
		   break;

	 case OUT_PLUS:
		   if(outsys->sprite_data[current_out] != NULL){
		      ++current_out;
		   }
		   break;

	 case OUT_MINUS:
		   if(current_out!=0){
		      --current_out;
		   }
		   break;


	 case NOT_EVENT:
		   break;

	 default:
		   break;
    }

  }while(1);

  /* finish up */
  cleanup();
}

/****************************************************************************/
void draw_button(menu_button *m)
{
 screen_draw_boxNC(m->x,m->y,m->x+m->width,m->y+m->height,COLOR);
 screen_draw_stringNC(m->text,m->x+2,m->y+2,COLOR);
}

/****************************************************************************/
int is_in_button(int x,int y, menu_button *m)
{
 if((x>m->x)&&(y > m->y)&&(x<(m->x+m->width))&&(y<(m->y+m->height))){
    return 1;
 }
 else{
    return 0;
 }
}

/****************************************************************************/
void blank_space(int x1,int y1,int x2,int y2)
{
 screen_draw_rectNC(x1,y1,x2,y2,0);
}

/****************************************************************************/
/* return an event code corresponding to an event */
int get_event()
{
 int xpos,ypos,buttons;

 /* this loop waits until the left button is pressed */
 do{
   mouse_get_status(&xpos,&ypos,&buttons);
 }while(!(LEFT_BUTTON_DOWN(buttons)));

 /* this loop waits until the left button is released */
 do{
   mouse_get_status(&xpos,&ypos,&buttons);
 }while(LEFT_BUTTON_DOWN(buttons));

 xpos=MOUSE_X_TO_SCREEN(xpos);
 ypos=MOUSE_Y_TO_SCREEN(ypos);

 /* check the buttons */
 if(is_in_button(xpos,ypos,&B_quit)){
    return QUIT;
 }
 if(is_in_button(xpos,ypos,&B_save)){
    return SAVE;
 }
 if(is_in_button(xpos,ypos,&B_copy)){
    return COPY;
 }
 if(is_in_button(xpos,ypos,&B_inplus)){
    return IN_PLUS;
 }
 if(is_in_button(xpos,ypos,&B_inminus)){
    return IN_MINUS;
 }
 if(is_in_button(xpos,ypos,&B_outplus)){
    return OUT_PLUS;
 }
 if(is_in_button(xpos,ypos,&B_outminus)){
    return OUT_MINUS;
 }

 return NOT_EVENT;
}

/****************************************************************************/
/* handle the quit button */
void do_quit()
{
 char c;

 mouse_hide_pointer();

 screen_draw_stringNC("Quit : Are you sure (Y/N) ?",100,25,COLOR);

 c=getkey();

 if((c == BIG_Y) || (c == SMALL_Y)){
     cleanup();
 }
 else{
    /* we just clear the message and let program flow continue through the
    ** switch statement in the caller.
    */
    blank_space(100,25,210,33);
    mouse_show_pointer();
 }
}

/****************************************************************************/
void cleanup()
{
  mouse_hide_pointer();
  screen_set_text_mode();

  exit(-1);
}

/****************************************************************************/
void write_out_file(char *file,sprite_system *outsys)
{
 unsigned short i=0;
 int width,height;
 FILE *fp;

  if((fp=fopen(file,"wb"))==NULL){
     cleanup();
  }

 /* write out dummy value for num sprites in file */
 fwrite(&i,sizeof(unsigned short),1,fp);

 /* write out each sprite */
 while(outsys->sprite_data[i]!=NULL){
       width = outsys->sprite_data[i]->width;
       height = outsys->sprite_data[i]->height;

       fputc(width,fp);
       fputc(height,fp);

       fwrite(outsys->sprite_data[i]->data,width*height,1,fp);

      /* assume a bounding rectangle of the whole sprite */
      fputc(1,fp); /* one rect */

      fputc(0,fp);
      fputc(0,fp);      /* 0,0 to w,h */
      fputc(width,fp);
      fputc(height,fp);


       i++;            /* add 1 sprite to count */
 }

 /* write correct number of sprites */
 fseek(fp,0,SEEK_SET);
 fwrite(&i,sizeof(unsigned short),1,fp);

 fclose(fp);
}

/****************************************************************************/
void do_copy(sprite_system *in,sprite_system *out,int cin,int cout)
{
  out->sprite_data[cout]=in->sprite_data[cin];

}
