/* sprgrab.c - grab  sprites from a 256 color PCX file
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <stdio.h>
#include <assert.h>
#include <unistd.h>
#include "f:\gcc\proj\spr\src\jlib.h"

#define COLOR 15

void save_sprite(FILE *fp,int x1,int y1,int x2,int y2);

void main(int argc, char *argv[])
{
  int xpos,ypos,buttons,i,j,stx,sty,edx,edy;
  unsigned short numspr =0;
  FILE *new;
  image *pcx_pic;
  buffer_rec *offscreen;
  UBYTE *box_buffer;

  if(argc!=3){
	      printf("sprgrab - grab  sprites from a .pcx into a spr file.\n");
	      printf("Usage: sprgrab <infile> <outfile> \n");
	      printf("Where: <infile>  = .pcx file to get sprites from.\n");
	      printf("Where: <outfile> = file to put sprites into.\n");
	      exit(-1);
  }

  offscreen = buff_init(320,200);
  pcx_pic = image_load_pcx(argv[1]);
  BOX_SAVE_MALLOC(box_buffer);

  if(!mouse_present()){
     printf("No mouse installed.\n");
     exit(0);
  }

  assert(pcx_pic != NULL);

  if((new=fopen(argv[2],"wb"))==NULL){
     printf(" ERROR: Could not open file %s for writing.",argv[2]);
     exit(-1);
  }

  /* write dummy value into start of .spr file */
  fwrite(&numspr,sizeof(unsigned short),1,new);

  printf("Use the mouse + left button to outline the sprite.\n");
  printf("Remember that the border will NOT be saved.\n");
  printf("outline the mouse then:\n");
  printf("Click the right button to save a sprite out.\n");
  printf("Or hit a key to outline another.\n");
  printf("Click the right button to exit when not in select mode.\n");
  printf("press any key...\n");

  getch();

  /* copy image to buffer */
  for(i=0;i<pcx_pic->height;i++){
      for(j=0;j<pcx_pic->width;j++){
	 offscreen->buffer[i*B_X_SIZE(offscreen)+j]=pcx_pic->data[i*pcx_pic->width+j];
      }
  }

  screen_set_video_mode();

  screen_block_set_pal(IMG_PALETTE(pcx_pic));

  /* display pcx */
  screen_blit_fs_buffer(offscreen,0,0);

  mouse_show_pointer();

   do{
    mouse_get_status(&xpos,&ypos,&buttons);

    if(LEFT_BUTTON_DOWN(buttons)){

       while(LEFT_BUTTON_DOWN(buttons)){
		  mouse_get_status(&xpos,&ypos,&buttons);
       }
       stx=MOUSE_X_TO_SCREEN(xpos);
       sty=MOUSE_Y_TO_SCREEN(ypos);
       do{
	 mouse_get_status(&xpos,&ypos,&buttons);
	 if(LEFT_BUTTON_DOWN(buttons)){
	    edx=MOUSE_X_TO_SCREEN(xpos);
	    edy=MOUSE_Y_TO_SCREEN(ypos);

	    while(LEFT_BUTTON_DOWN(buttons)){
		  mouse_get_status(&xpos,&ypos,&buttons);
	    }

	    mouse_hide_pointer();
	    screen_draw_boxNC(stx,sty,edx,edy,COLOR);
	    mouse_show_pointer();
	 }

	 if(RIGHT_BUTTON_DOWN(buttons)){
	    save_sprite(new,stx,sty,edx,edy);
	    numspr++;
	    while(RIGHT_BUTTON_DOWN(buttons)){
		  mouse_get_status(&xpos,&ypos,&buttons);
	    }
	 }
       }while(!kbhit());
       fgetc(stdin);

       mouse_hide_pointer();
       screen_blit_fs_buffer(offscreen,0,0);
       mouse_show_pointer();
    }
    else{
	if(RIGHT_BUTTON_DOWN(buttons)){
	   break;
	}
    }
 }while(1);


  /* finish up */
  mouse_hide_pointer();
  screen_set_text_mode();

  fseek(new,0L,SEEK_SET);
  fwrite(&numspr,sizeof(unsigned short),1,new);

  fclose(new);
}

void save_sprite(FILE *fp,int x1,int y1,int x2,int y2)
{
 int i,j;
 UBYTE *screen=SCREEN_START;

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 /* skip the lines of the bounding box */
 x1++;
 y1++;
 x2--;
 y2--;

 /* write out and width & height */
 fputc(x2-x1+1,fp);
 fputc(y2-y1+1,fp);

 /* write out data */
 for(i=y1;i<=y2;i++){
     for(j=x1;j<=x2;j++){
	 fputc(screen[i*SCREEN_WIDTH+j],fp);
     }
 }

 /* assume a bounding rectangle of the whole sprite */
 fputc(1,fp); /* one rect */

 fputc(0,fp);
 fputc(0,fp);      /* 0,0 to w,h */
 fputc(x2-x1+1,fp);
 putc(y2-y1+1,fp);

}
