/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"
#include "..\memcopy.h"

#define NOT_CLIPPED 0

#define X_LEFT   (xpos)
#define X_RIGHT  (xpos+width)
#define Y_TOP    (ypos)
#define Y_BOTTOM (ypos+height)

/*+----------------------------------------------------------------------+*/
/*|draw_sprite - draw a sprite on screen with clipping                   |*/
/*+----------------------------------------------------------------------+*/
/*| note - this version is a 'knock up' concieved only because I couldn't|*/
/*| justify procrastinating any more.  it is even LESS optimised than the|*/
/*| non clipping functions.                                              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_sprite
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_sprite(sprite_system *spr_sys, USHORT snum)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data;
 UBYTE width,height,status=NOT_CLIPPED;
 UBYTE count1,count2,startx,starty,endx,endy;
 UBYTE *pos_on_screen,datum;
 USHORT xpos,ypos;


 LIBDEBUG(printf("\nEntering screen_draw_sprite()\n\n"));

 /* don't draw sprite if it isn't turned on */
 if(SPR_IS_ON(spr_sys,snum)){

    LIBDEBUG(printf("Sprite %d is ON\n",snum));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    data = current_sprite_data->data;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* set initial values of startx , endx etc */
    startx=0;
    starty=0;
    endx=width;
    endy=height;

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the screen.*/
    xpos = spr_sys->sprites[snum]->x;
    ypos = spr_sys->sprites[snum]->y;


    /* check for "don't draw"  clipping  */
    if((X_LEFT > SCREEN_WIDTH + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > SCREEN_HEIGHT + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)){
      return;
    }

    /* check the other 4 clipping conditions */
    if(X_LEFT < SPR_MAX_X){
       /* some portion of the left side of the sprite is obscured */
       status++;
       startx = SPR_MAX_X - X_LEFT;
    }
    else{
       if(X_RIGHT > SCREEN_WIDTH + SPR_MAX_X){
	  /* some portion of the right side of the sprite is obscured */
	  status++;
	  endx = (SCREEN_WIDTH + SPR_MAX_X) - X_LEFT;
       }
    }

    if(Y_TOP < SPR_MAX_Y){
       /* some portion of the top side of the sprite is obscured */
       status++;
       starty = SPR_MAX_Y - Y_TOP;
    }
    else{
       if(Y_BOTTOM > SCREEN_HEIGHT + SPR_MAX_X){
	  /* some portion of the bottom side of the sprite is obscured */
	  status++;
	  endy = (SCREEN_HEIGHT + SPR_MAX_Y) - Y_TOP;
       }
    }

    /* only use the drawing routine below if needed */
    if(status == NOT_CLIPPED){
       screen_draw_spriteNC(spr_sys,snum);
       return;
    }


    pos_on_screen=(UBYTE *)(SCREEN_START_ADDRESS+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*SCREEN_WIDTH)
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* start at the appropriate place in the data */
     data+=(starty*width)+startx;

     /* start at the appropriate place on screen */
     pos_on_screen+=(starty*SCREEN_WIDTH)+startx;


    /* move through the data, determining which pixels to draw */
    for(count1=starty;count1<endy;count1++){
	for(count2=startx;count2<endx;count2++){
	    datum = *data;

	    if(datum){
	       *pos_on_screen = *data;
	    }

	    pos_on_screen ++;
	    data ++;
	}

	pos_on_screen += SCREEN_WIDTH-(endx-startx);
	data += width - (endx-startx);
    }
 }/* IF */

 LIBDEBUG(printf("\nLeaving screen_draw_sprite()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|draw_spriteNC - draw a sprite on screen without clipping              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_spriteNC(sprite_system *spr_sys, USHORT snum)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_on_screen,datum;
 int rlecount;


 LIBDEBUG(printf("\nEntering screen_draw_spriteNC()\n\n"));

 /* don't draw sprite if it isn't turned on */
 if(SPR_IS_ON(spr_sys,snum)){

    LIBDEBUG(printf("Sprite %d is ON\n",snum));

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the screen.*/
    pos_on_screen=(UBYTE *)(SCREEN_START_ADDRESS+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*SCREEN_WIDTH)
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    data = current_sprite_data->data;
    pattern=current_sprite_data->pattern;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* move through the RLE pattern determining which pixels to draw */
    for(count1=0;count1<height;count1++){
	LIBDEBUG(printf("processing row %d\n",count1));
	LIBDEBUG(printf("row value is %d\n",*pattern));
	
	for(count2=*pattern,++pattern;count2>0;count2--){
	
	    datum=*pattern;
	    ++pattern;

	    rlecount=*pattern;
	    ++pattern;
	
	    LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	    if(datum){
	      _bcopy(data,pos_on_screen,rlecount);
	    }

	    pos_on_screen += rlecount;
	    data += rlecount;
	}

	LIBDEBUG(printf("\n"));

	pos_on_screen += SCREEN_WIDTH-width;
    }
 }/* IF */

 LIBDEBUG(printf("\nLeaving screen_draw_spriteNC()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|save_sprite - save the screen under a sprite with clipping            |*/
/*+----------------------------------------------------------------------+*/
/*| NOTE - this version is a 'knock up' concieved only because I couldn't|*/
/*| justify procrastinating any more.  it is even LESS optimised than the|*/
/*| non clipping functions.                                              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_sprite
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_sprite(sprite_system *spr_sys, USHORT snum)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*buffer;
 UBYTE width,height,status=NOT_CLIPPED;
 UBYTE count1,count2,startx,starty,endx,endy;
 UBYTE *pos_on_screen,datum;
 USHORT xpos,ypos;


 LIBDEBUG(printf("\nEntering screen_save_sprite()\n\n"));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    data = current_sprite_data->data;
    buffer=spr_sys->sprites[snum]->buffer;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* set initial values of startx , endx etc */
    startx=0;
    starty=0;
    endx=width;
    endy=height;

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the screen.*/
    xpos = spr_sys->sprites[snum]->x;
    ypos = spr_sys->sprites[snum]->y;


    /* check for "don't save"  clipping  */
    if((X_LEFT > SCREEN_WIDTH + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > SCREEN_HEIGHT + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)){
      return;
    }

    /* check the other 4 clipping conditions */
    if(X_LEFT < SPR_MAX_X){
       /* some portion of the left side of the sprite is obscured */
       status++;
       startx = SPR_MAX_X - X_LEFT;
    }
    else{
       if(X_RIGHT > SCREEN_WIDTH + SPR_MAX_X){
	  /* some portion of the right side of the sprite is obscured */
	  status++;
	  endx = (SCREEN_WIDTH + SPR_MAX_X) - X_LEFT;
       }
    }

    if(Y_TOP < SPR_MAX_Y){
       /* some portion of the top side of the sprite is obscured */
       status++;
       starty = SPR_MAX_Y - Y_TOP;
    }
    else{
       if(Y_BOTTOM > SCREEN_HEIGHT + SPR_MAX_X){
	  /* some portion of the bottom side of the sprite is obscured */
	  status++;
	  endy = (SCREEN_HEIGHT + SPR_MAX_Y) - Y_TOP;
       }
    }

    /* only use the saving routine below if needed */
    if(status == NOT_CLIPPED){
       screen_save_spriteNC(spr_sys,snum);
       return;
    }


    pos_on_screen=(UBYTE *)(SCREEN_START_ADDRESS+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*SCREEN_WIDTH)
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* start at the appropriate place in the data */
     data+=(starty*width)+startx;

     /* start at the appropriate place on screen */
     pos_on_screen+=(starty*SCREEN_WIDTH)+startx;


    /* move through the data,  saving non-zero pixels */
    for(count1=starty;count1<endy;count1++){
	for(count2=startx;count2<endx;count2++){
	    datum = *data;

	    if(datum){
	       *buffer = *pos_on_screen;
	    }

	    pos_on_screen++;
	    data++;
	    buffer++;
	}

	pos_on_screen += SCREEN_WIDTH-(endx-startx);
	data += width - (endx-startx);
    }

 LIBDEBUG(printf("\nLeaving screen_save_sprite()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|screen_save_spriteNC - save the screen under a sprite into its buffer |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_spriteNC(sprite_system *spr_sys, USHORT snum)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *buffer,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_on_screen,datum;
 int rlecount;


 LIBDEBUG(printf("\nEntering screen_save_spriteNC()\n\n"));

 /* posistion is calculated from x and y minus the maximum sprite width */
 /* and height, so that we can have sprites off the edges of the screen.*/
 pos_on_screen=(UBYTE *)(SCREEN_START_ADDRESS+
			((spr_sys->sprites[snum]->y-SPR_MAX_Y)*SCREEN_WIDTH)
			+ (spr_sys->sprites[snum]->x-SPR_MAX_Y));

 LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
 LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

  /* the data is the sprite_data_rec indicated by it's frame */
 current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

 buffer = spr_sys->sprites[snum]->buffer;

 pattern=current_sprite_data->pattern;
 width=current_sprite_data->width;
 height=current_sprite_data->height;

 LIBDEBUG(printf("height is (%d)\n",height));
 LIBDEBUG(printf("width is  (%d)\n",width));

  /* move through the RLE pattern determining which pixels to save */
 for(count1=0;count1<height;count1++){
     LIBDEBUG(printf("processing row %d\n",count1));
     LIBDEBUG(printf("row value is %d\n",*pattern));
	
     for(count2=*pattern,++pattern;count2>0;count2--){
	
	 datum=*pattern;
	 ++pattern;

	 rlecount=*pattern;
	 ++pattern;
	
	 LIBDEBUG(printf("(%d,%d)\n",datum,rlecount));

	 if(datum){
	    _bcopy(pos_on_screen,buffer,rlecount);
	    buffer += rlecount;
	 }
	 pos_on_screen += rlecount;

     }

     LIBDEBUG(printf("\n"));

     pos_on_screen += SCREEN_WIDTH-width;
 }

 LIBDEBUG(printf("\nLeaving screen_save_spriteNC()\n\n"));
}

/*+----------------------------------------------------------------------+*/
/*|rest_sprite - restore the screen under a sprite with clipping         |*/
/*+----------------------------------------------------------------------+*/
/*| NOTE - this version is a 'knock up' concieved only because I couldn't|*/
/*| justify procrastinating any more.  it is even LESS optimised than the|*/
/*| non clipping functions.                                              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_sprite
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_sprite(sprite_system *spr_sys, USHORT snum)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*buffer;
 UBYTE width,height,status=NOT_CLIPPED;
 UBYTE count1,count2,startx,starty,endx,endy;
 UBYTE *pos_on_screen,datum;
 USHORT xpos,ypos;


 LIBDEBUG(printf("\nEntering screen_rest_sprite()\n\n"));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    data = current_sprite_data->data;
    buffer=spr_sys->sprites[snum]->buffer;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* set initial values of startx , endx etc */
    startx=0;
    starty=0;
    endx=width;
    endy=height;

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the screen.*/
    xpos = spr_sys->sprites[snum]->x;
    ypos = spr_sys->sprites[snum]->y;


    /* check for "don't restore"  clipping  */
    if((X_LEFT > SCREEN_WIDTH + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > SCREEN_HEIGHT + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)){
      return;
    }

    /* check the other 4 clipping conditions */
    if(X_LEFT < SPR_MAX_X){
       /* some portion of the left side of the sprite is obscured */
       status++;
       startx = SPR_MAX_X - X_LEFT;
    }
    else{
       if(X_RIGHT > SCREEN_WIDTH + SPR_MAX_X){
	  /* some portion of the right side of the sprite is obscured */
	  status++;
	  endx = (SCREEN_WIDTH + SPR_MAX_X) - X_LEFT;
       }
    }

    if(Y_TOP < SPR_MAX_Y){
       /* some portion of the top side of the sprite is obscured */
       status++;
       starty = SPR_MAX_Y - Y_TOP;
    }
    else{
       if(Y_BOTTOM > SCREEN_HEIGHT + SPR_MAX_X){
	  /* some portion of the bottom side of the sprite is obscured */
	  status++;
	  endy = (SCREEN_HEIGHT + SPR_MAX_Y) - Y_TOP;
       }
    }

    /* only use the saving routine below if needed */
    if(status == NOT_CLIPPED){
       screen_rest_spriteNC(spr_sys,snum);
       return;
    }


    pos_on_screen=(UBYTE *)(SCREEN_START_ADDRESS+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*SCREEN_WIDTH)
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* start at the appropriate place in the data */
     data+=(starty*width)+startx;

     /* start at the appropriate place on screen */
     pos_on_screen+=(starty*SCREEN_WIDTH)+startx;


    /* move through the data,  saving non-zero pixels */
    for(count1=starty;count1<endy;count1++){
	for(count2=startx;count2<endx;count2++){
	    datum = *data;

	    if(datum){
	       *pos_on_screen= *buffer;
	    }

	    pos_on_screen++;
	    data++;
	    buffer++;
	}

	pos_on_screen += SCREEN_WIDTH-(endx-startx);
	data += width - (endx-startx);
    }

 LIBDEBUG(printf("\nLeaving screen_rest_sprite()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|screen_rest_spriteNC - rest the screen under a sprite from its buffer |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_spriteNC(sprite_system *spr_sys, USHORT snum)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *buffer,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_on_screen,datum;
 int rlecount;


 LIBDEBUG(printf("\nEntering screen_rest_spriteNC()\n\n"));


  /* posistion is calculated from x and y minus the maximum sprite width */
  /* and height, so that we can have sprites off the edges of the screen.*/
   pos_on_screen=(UBYTE *)(SCREEN_START_ADDRESS+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*SCREEN_WIDTH)
			   + (spr_sys->sprites[snum]->x-SPR_MAX_X));

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    buffer = spr_sys->sprites[snum]->buffer;

    pattern=current_sprite_data->pattern;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

     /* move through the RLE pattern determining which pixels to restore */
    for(count1=0;count1<height;count1++){
	LIBDEBUG(printf("processing row %d\n",count1));
	LIBDEBUG(printf("row value is %d\n",*pattern));
	
	for(count2=*pattern,++pattern;count2>0;count2--){
	
	    datum=*pattern;
	    ++pattern;

	    rlecount=*pattern;
	    ++pattern;
	
	    LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	    if(datum){
	       _bcopy(buffer,pos_on_screen,rlecount);
	       buffer += rlecount;
	    }
	
	    pos_on_screen += rlecount;
	}

	LIBDEBUG(printf("\n"));

	pos_on_screen += SCREEN_WIDTH-width;
    }

 LIBDEBUG(printf("\nLeaving screen_rest_spriteNC()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|stamp a sprite frame on screen without clipping                       |*/
/*|                                                                      |*/
/*|"stamp" means that the background is drawn as black.                  |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_stamp_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_stamp_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			     USHORT frame)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_on_screen,datum;
 int rlecount;

 LIBDEBUG(printf("\nEntering screen_stamp_spriteNC()\n\n"));

 pos_on_screen=(UBYTE *)SCREEN_START_ADDRESS+(y*SCREEN_WIDTH)+x;

 LIBDEBUG(printf("X is (%d)\n",x));
 LIBDEBUG(printf("Y is (%d)\n",y));


 current_sprite_data=spr_sys->sprite_data[frame];

 data = current_sprite_data->data;
 pattern=current_sprite_data->pattern;
 width=current_sprite_data->width;
 height=current_sprite_data->height;

 LIBDEBUG(printf("height is (%d)\n",height));
 LIBDEBUG(printf("width is  (%d)\n",width));

 for(count1=0;count1<height;count1++){
     LIBDEBUG(printf("processing row %d\n",count1));
     LIBDEBUG(printf("row value is %d\n",*pattern));
	
     for(count2=*pattern,++pattern;count2>0;count2--){
	
	 datum=*pattern;
	 ++pattern;

	 rlecount=*pattern;
	 ++pattern;
	
	 LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	 _bcopy(data,pos_on_screen,rlecount);

	 pos_on_screen += rlecount;
	 data += rlecount;
     }

     LIBDEBUG(printf("\n"));

     pos_on_screen += SCREEN_WIDTH-width;
 }

 LIBDEBUG(printf("\nLeaving screen_stamp_spriteNC()\n\n"));
}

/*+----------------------------------------------------------------------+*/
/*|stencil a sprite frame on screen without clipping                     |*/
/*|                                                                      |*/
/*|"stencil" means that the background remains transparent.              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_stencil_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_stencil_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			     USHORT frame)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_on_screen,datum;
 int rlecount;

 LIBDEBUG(printf("\nEntering screen_stencil_spriteNC()\n\n"));

 pos_on_screen=(UBYTE *)SCREEN_START_ADDRESS+(y*SCREEN_WIDTH)+x;

 LIBDEBUG(printf("X is (%d)\n",x));
 LIBDEBUG(printf("Y is (%d)\n",y));


 current_sprite_data=spr_sys->sprite_data[frame];

 data = current_sprite_data->data;
 pattern=current_sprite_data->pattern;
 width=current_sprite_data->width;
 height=current_sprite_data->height;

 LIBDEBUG(printf("height is (%d)\n",height));
 LIBDEBUG(printf("width is  (%d)\n",width));

 for(count1=0;count1<height;count1++){
     LIBDEBUG(printf("processing row %d\n",count1));
     LIBDEBUG(printf("row value is %d\n",*pattern));
	
     for(count2=*pattern,++pattern;count2>0;count2--){
	
	 datum=*pattern;
	 ++pattern;

	 rlecount=*pattern;
	 ++pattern;
	
	 LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	 if(datum){
	    _bcopy(data,pos_on_screen,rlecount);
	 }

	 pos_on_screen += rlecount;
	 data += rlecount;
     }

     LIBDEBUG(printf("\n"));

     pos_on_screen += SCREEN_WIDTH-width;
 }

 LIBDEBUG(printf("\nLeaving screen_stencil_spriteNC()\n\n"));
}

/*+----------------------------------------------------------------------+*/
/*|screen_draw_all_sprites                                               |*/
/*+----------------------------------------------------------------------+*/
/*|draw all active sprites to the screen.                                |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_all_sprites
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_all_sprites(sprite_system *spr_sys)
{
 int count;

 LIBDEBUG(printf("\nEntering screen_draw_all_sprites()\n\n"));


 for(count=0;count<spr_sys->no_sprites;count++){
     if(SPR_IS_ON(spr_sys,count)){
	screen_draw_sprite(spr_sys,count);
     }
 }

 LIBDEBUG(printf("\nLeaving screen_draw_all_sprites()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|screen_save_all_sprites                                               |*/
/*+----------------------------------------------------------------------+*/
/*|save all active sprites to the screen.                                |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_all_sprites
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_all_sprites(sprite_system *spr_sys)
{
 int count;

 LIBDEBUG(printf("\nEntering screen_save_all_sprites()\n\n"));


 for(count=0;count<spr_sys->no_sprites;count++){
     if(SPR_IS_ON(spr_sys,count)){
	screen_save_sprite(spr_sys,count);
     }
 }

 LIBDEBUG(printf("\nLeaving screen_save_all_sprites()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|screen_rest_all_sprites                                               |*/
/*+----------------------------------------------------------------------+*/
/*|rest all active sprites to the screen.                                |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_all_sprites
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_all_sprites(sprite_system *spr_sys)
{
 int count;

 LIBDEBUG(printf("\nEntering screen_rest_all_sprites()\n\n"));


 for(count=0;count<spr_sys->no_sprites;count++){
     if(SPR_IS_ON(spr_sys,count)){
	screen_rest_sprite(spr_sys,count);
     }
 }

 LIBDEBUG(printf("\nLeaving screen_rest_all_sprites()\n\n"));
}
