/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"


#define FAST_320_MUL(x) (((x)<< 8)+((x)<< 6))

/*+------------------------------------------------------------------------+*/
/*|draw a rect with corners x1, y1 to x2 , y2 in color c without clipping   |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_rectNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_rectNC(USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c)
{
 UBYTE *screen=SCREEN_START;
 USHORT width;

 LIBDEBUG(printf("\nEntering screen_draw_rectNC()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 width=x2-x1;

 screen=SCREEN_START+(FAST_320_MUL(y1))+x1;

 for(;y2>y1;y2--){
     memset(screen,(int)c,(size_t)width+1);  /* this is NOT a cludge! */
     screen+=SCREEN_WIDTH;
 }

 LIBDEBUG(printf("\nLeaving screen_draw_rectNC()\n\n"));
}


