/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <dos.h>
#include "..\jlib.h"

#define FAST_320_MUL(x) (((x)<< 8)+((x)<< 6))

/*+------------------------------------------------------------------------+*/
/*|plot a dot at (x, y) with color c with clipping                         |*/
/*+------------------------------------------------------------------------+*/

__inline void screen_draw_point(USHORT x, USHORT y, UBYTE c)
{
 UBYTE  *addr=SCREEN_START;

  if((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y)){
     return;
  }

  addr[(FAST_320_MUL(y))+x]=c;
}

/*+------------------------------------------------------------------------+*/
/*|plot a dot at (x, y) with color c without clipping                      |*/
/*+------------------------------------------------------------------------+*/

__inline void screen_draw_pointNC(USHORT x, USHORT y, UBYTE c)
{
 static UBYTE  *addr=SCREEN_START;

 addr[(FAST_320_MUL(y))+x]=c;
}


/*+------------------------------------------------------------------------+*/
/*|get a dot from (x, y) with clipping                                     |*/
/*+------------------------------------------------------------------------+*/
__inline UBYTE screen_get_point(USHORT x, USHORT y)
{
 UBYTE  *addr=SCREEN_START;

  if((x>SCREEN_MAX_X) || (y > SCREEN_MAX_Y)){
     return 0;
  }

  return addr[(FAST_320_MUL(y))+x];
}


/*+------------------------------------------------------------------------+*/
/*|get a dot from (x, y) without clipping                                  |*/
/*+------------------------------------------------------------------------+*/

__inline UBYTE screen_get_pointNC(USHORT x, USHORT y)
{
 UBYTE  *addr=SCREEN_START;

  return addr[(FAST_320_MUL(y))+x];
}

