/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <pc.h>
#include "..\jlib.h"

/*+------------------------------------------------------------------------+*/
/*|set a DAC color register                                                |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_put_pal
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue)
{
 UBYTE a;
 LIBDEBUG(printf("\nEntering screen_put_pal()\n\n"));

 outportb(0x3c8, col);
 a = inportb(0x80);
 outportb(0x3c9, red>>2);
 a = inportb(0x80);
 outportb(0x3c9, green>>2);
 a = inportb(0x80);
 outportb(0x3c9, blue>>2);

 LIBDEBUG(printf("\nLeaving screen_put_pal()\n\n"));
}

/*+------------------------------------------------------------------------+*/
/*|set a block of DAC color registers                                      |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_block_set_pal
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_block_set_pal(UBYTE *pal)
{
 int i;

 LIBDEBUG(printf("\nEntering screen_block_set_pal()\n\n"));

 for(i=0;i<255;i++){
     screen_put_pal(i,pal[i*3],pal[i*3+1],pal[i*3+2]);
 }

 LIBDEBUG(printf("\nLeaving screen_block_set_pal()\n\n"));

}


/*+------------------------------------------------------------------------+*/
/*|set all DAC color registers to zero                                     |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_blank_pal
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_blank_pal(void)
{
 int i;

 LIBDEBUG(printf("\nEntering screen_blank_pal()\n\n"));

 for(i=0;i<255;i++){
     screen_put_pal(i,0,0,0);
 }

 LIBDEBUG(printf("\nLeaving screen_blank_pal()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|load a palette from a file                                              |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_load_pal
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

#define SIZEOFPAL 768

UBYTE *screen_load_pal(char *fname)
{
 UBYTE *tmp;
 FILE *fp;

 LIBDEBUG(printf("\nEntering screen_load_pal()\n\n"));

 /* allocate memory for the palette */
 if((tmp = (UBYTE *)malloc(SIZEOFPAL*sizeof(UBYTE)))==NULL){
    LIBDEBUG(printf("\nMalloc Failed at screen_load_pal line %d\n",__LINE__));
    return (UBYTE *)NULL;
 }
 LIBDEBUG(printf("\nMalloc OK at screen_load_pal line %d\n",__LINE__));

 /* open file */
 if((fp = fopen(fname,"rb"))==NULL){
    LIBDEBUG(printf("\nCouldn't open file %s\n",fname));
    return (UBYTE *)NULL;
 }

 /* read in the palette */
 fread(tmp,(sizeof(UBYTE)*SIZEOFPAL),1,fp);

 /* give if back */
 return tmp;

 LIBDEBUG(printf("\nLeaving screen_load_pal()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette in                                                       |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_fade_in_pal
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

#define PALSIZE 255

void delay(unsigned msec);  /* where is this prototyped? */

void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE*3];

  LIBDEBUG(printf("\nEntering screen_fade_in_pal()\n\n"));

  memset(temp_pal,(int)0,PALSIZE*3);

  for(i=0;i<255;i++){
      for(j=0;j<(PALSIZE*3);j++){
	  if(pal[j]>i){
	     temp_pal[j]=i;
	  }
      }
      screen_block_set_pal(temp_pal);
      delay(delaytime);
  }

  LIBDEBUG(printf("\nLeaving screen_fade_in_pal()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette out                                                      |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_fade_out_pal
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

#define PALSIZE 255

void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE*3];

  LIBDEBUG(printf("\nEntering screen_fade_out_pal()\n\n"));

  /* copy the palette into our local copy */
  memcpy(temp_pal,pal,PALSIZE*3);

  for(i=255;i>0;i--){
      for(j=0;j<(PALSIZE*3);j++){
	  if(temp_pal[j]>0){
	     (temp_pal[j])--;
	  }
      }
      screen_block_set_pal(temp_pal);
      delay(delaytime);
  }

  LIBDEBUG(printf("\nLeaving screen_fade_out_pal()\n\n"));
}

