/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include <pc.h>
#include <dos.h>
#include <stdlib.h>
#include "..\jlib.h"

/*+------------------------------------------------------------------------+*/
/*|use the bios to set video mode  13h                                     |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_set_video_mode
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_set_video_mode(void)
{
 union REGS r;

  LIBDEBUG(printf("\nEntering screen_set_video_mode()\n\n"));

  LIBDEBUG(printf("Setting screen mode 13h\n"));
  r.x.ax = 0x13;
  int86(0x10, &r, &r);

  /* set up global screen buffer */
  __jlib_mode13h_screen = (buffer_rec *)malloc(sizeof(buffer_rec));
  B_X_SIZE(__jlib_mode13h_screen)=SCREEN_WIDTH;
  B_Y_SIZE(__jlib_mode13h_screen)=SCREEN_HEIGHT;
  B_BUFF_PTR(__jlib_mode13h_screen)=SCREEN_START;

  LIBDEBUG(printf("\nLeaving screen_set_video_mode()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|use the bios to set video mode  03h (text)                              |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_set_text_mode
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_set_text_mode(void)
{
 union REGS r;

   LIBDEBUG(printf("\nEntering screen_set_text_mode()\n\n"));

   free(__jlib_mode13h_screen);

   LIBDEBUG(printf("\nSetting text_mode 3h\n"));
   r.x.ax = 0x3;
   int86(0x10, &r, &r);



   LIBDEBUG(printf("\nLeaving screen_set_text_mode()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|clear the screen by filling it with zeros.                              |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_clear
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_clear(void)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_clear()\n\n"));

 memset(screen,(int)0,SCREEN_WIDTH*SCREEN_HEIGHT);


 LIBDEBUG(printf("\nLeaving screen_clear()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|fill the screen with a particular colour.                               |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_fill
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_fill(int colour)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_fill()\n\n"));

 memset(screen,colour,SCREEN_WIDTH*SCREEN_HEIGHT);

 LIBDEBUG(printf("\nLeaving screen_fill()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|turn on square pixel mode                                               |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_go_square_pixel
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void  screen_go_square_pixel(void)
{
 LIBDEBUG(printf("\nEntering screen_go_square_pixel()\n\n"));

 outportb(0x3c2,0xe3);
 LIBDEBUG(printf("\nLeaving screen_go_square_pixel()\n\n"));
}

