/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"

#define ABS(a)   ((a < 0) ? -a : a)
#define SGN(a)   ((a < 0) ? -1 : 1)
#define FAST_320_MUL(x) (((x)<< 8)+((x)<< 6))

/*+-------------------------------------------------------------------------+*/
/*|draw a line from x1, y1 to x2, y2 in color c                             |*/
/*|                                                                         |*/
/*|this function uses a pathetic excuse for clipping but it will have to do |*/
/*|for the moment.                                                          |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_line(USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c)
{
 int d, x, y, ax, ay, sx, sy, dx, dy;
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_draw_line()\n\n"));

 /* clip the points (sigh) */
 if(x1 > SCREEN_MAX_X){
    x1=SCREEN_MAX_X;
 }

 if(x2 > SCREEN_MAX_X){
    x2=SCREEN_MAX_X;
 }

 if(y1 > SCREEN_MAX_Y){
    y1=SCREEN_MAX_Y;
 }

 if(y2 > SCREEN_MAX_Y){
    y2=SCREEN_MAX_Y;
 }

 dx = x2-x1;
 ax = ABS(dx) << 1;
 sx = SGN(dx);
 dy = y2-y1;
 ay = ABS(dy) << 1;
 sy = SGN(dy);

 x = x1;
 y = y1;

 if( ax > ay ){
    d = ay - (ax >> 1);
    while( x != x2 ){
	 screen[(FAST_320_MUL(y))+x]=c;
	if( d >= 0 ){
	   y += sy;
	   d -= ax;
	}
	x += sx;
	d += ay;
    }
 }
 else{
     d = ax - (ay >> 1);
     while( y != y2 ){
	 screen[(FAST_320_MUL(y))+x]=c;
	 if( d >= 0 ){
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
     }
 }

 LIBDEBUG(printf("\nLeaving screen_draw_line()\n\n"));
}

/*+-------------------------------------------------------------------------+*/
/*|draw a line from x1, y1 to x2, y2 in color c                             |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_lineNC(USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c)
{
 int d, x, y, ax, ay, sx, sy, dx, dy;
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_draw_line_NC()\n\n"));

 dx = x2-x1;
 ax = ABS(dx) << 1;
 sx = SGN(dx);
 dy = y2-y1;
 ay = ABS(dy) << 1;
 sy = SGN(dy);

 x = x1;
 y = y1;

 if( ax > ay ){
    d = ay - (ax >> 1);
    while( x != x2 ){
	 screen[(FAST_320_MUL(y))+x]=c;
	if( d >= 0 ){
	   y += sy;
	   d -= ax;
	}
	x += sx;
	d += ay;
    }
 }
 else{
     d = ax - (ay >> 1);
     while( y != y2 ){
	 screen[(FAST_320_MUL(y))+x]=c;
	 if( d >= 0 ){
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
     }
 }

 LIBDEBUG(printf("\nLeaving screen_draw_line_NC()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|draw a horizontal line from x1, y1 to x2 in color c with clipping       |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_h_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_h_line(USHORT x1, USHORT y1, USHORT x2, UBYTE c)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_draw_h_line()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 /* clip points */
 if((x1 > SCREEN_MAX_X) || (y1 > SCREEN_MAX_Y)){
    return;
 }

 if(x2 > SCREEN_MAX_X){
    x2 = SCREEN_MAX_X;
 }

 screen+=(FAST_320_MUL(y1))+x1;
 memset(screen,(int)c,(size_t)x2-x1);

 LIBDEBUG(printf("\nLeaving screen_draw_h_line()\n\n"));
}

/*+------------------------------------------------------------------------+*/
/*|draw a horizontal line from x1, y1 to x2 in color c without clipping    |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_h_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_h_lineNC(USHORT x1, USHORT y1, USHORT x2, UBYTE c)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_draw_h_line_NC()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }
 screen+=(FAST_320_MUL(y1))+x1;
 memset(screen,(int)c,(size_t)x2-x1);

 LIBDEBUG(printf("\nLeaving screen_draw_h_line_NC()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|draw a vertical line from x1, y1 to x2 in color c with clipping         |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_v_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_v_line(USHORT x1, USHORT y1, USHORT y2, UBYTE c)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_draw_v_line()\n\n"));

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 /* clip coords if needed */
 if((y1 > SCREEN_MAX_Y) || (x1 > SCREEN_MAX_X)){
    return;
 }

 if(y2 > SCREEN_MAX_Y){
    y2=SCREEN_MAX_Y;
 }

 screen+=(FAST_320_MUL(y1))+x1;

 for(;y2>y1;y2--){
     *screen=c;
     screen+=SCREEN_WIDTH;
 }

 LIBDEBUG(printf("\nLeaving screen_draw_v_line()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|draw a vertical line from x1, y1 to x2 in color c without clipping      |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_v_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_v_lineNC(USHORT x1, USHORT y1, USHORT y2, UBYTE c)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_draw_v_lineNC()\n\n"));

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 screen+=(FAST_320_MUL(y1))+x1;

 for(;y2>y1;y2--){
     *screen=c;
     screen+=SCREEN_WIDTH;
 }

 LIBDEBUG(printf("\nLeaving screen_draw_v_lineNC()\n\n"));
}

/*+-------------------------------------------------------------------------+*/
/*|save a line from x1, y1 to x2, y2 into the given buffer                  |*/
/*|                                                                         |*/
/*|this function uses a pathetic excuse for clipping but it will have to do |*/
/*|for the moment.                                                          |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2, USHORT y2)
{
 int d, x, y, ax, ay, sx, sy, dx, dy;
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_save_line()\n\n"));

 /* clip the points (sigh) */
 if(x1 > SCREEN_MAX_X){
    x1=SCREEN_MAX_X;
 }

 if(x2 > SCREEN_MAX_X){
    x2=SCREEN_MAX_X;
 }

 if(y1 > SCREEN_MAX_Y){
    y1=SCREEN_MAX_Y;
 }

 if(y2 > SCREEN_MAX_Y){
    y2=SCREEN_MAX_Y;
 }

 dx = x2-x1;
 ax = ABS(dx) << 1;
 sx = SGN(dx);
 dy = y2-y1;
 ay = ABS(dy) << 1;
 sy = SGN(dy);

 x = x1;
 y = y1;

 if( ax > ay ){
    d = ay - (ax >> 1);
    while( x != x2 ){
	 *buff=screen[(FAST_320_MUL(y))+x];
	++buff;
	if( d >= 0 ){
	   y += sy;
	   d -= ax;
	}
	x += sx;
	d += ay;
    }
 }
 else{
     d = ax - (ay >> 1);
     while( y != y2 ){
	 *buff=screen[(FAST_320_MUL(y))+x];
	 ++buff;
	 if( d >= 0 ){
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
     }
 }

 LIBDEBUG(printf("\nLeaving screen_save_line()\n\n"));
}

/*+-------------------------------------------------------------------------+*/
/*|save a line from x1, y1 to x2, y2 into the given buffer                  |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_lineNC(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2, USHORT y2)
{
 int d, x, y, ax, ay, sx, sy, dx, dy;
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_save_line_NC()\n\n"));

 dx = x2-x1;
 ax = ABS(dx) << 1;
 sx = SGN(dx);
 dy = y2-y1;
 ay = ABS(dy) << 1;
 sy = SGN(dy);

 x = x1;
 y = y1;

 if( ax > ay ){
    d = ay - (ax >> 1);
    while( x != x2 ){
	 *buff=screen[(FAST_320_MUL(y))+x];
	 ++buff;
	if( d >= 0 ){
	   y += sy;
	   d -= ax;
	}
	x += sx;
	d += ay;
    }
 }
 else{
     d = ax - (ay >> 1);
     while( y != y2 ){
	 *buff=screen[(FAST_320_MUL(y))+x];
	 ++buff;
	 if( d >= 0 ){
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
     }
 }

 LIBDEBUG(printf("\nLeaving screen_save_line_NC()\n\n"));
}



/*+------------------------------------------------------------------------+*/
/*|save a horizontal line from x1, y1 to x2 into the given buffer          |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_h_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_h_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_save_h_line()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 /* clip coords if needed */
 if(x1 > SCREEN_MAX_X){
    return;
 }

 if(y1 > SCREEN_MAX_Y){
    return;
 }

 if(x2 > SCREEN_MAX_X){
    x2=SCREEN_MAX_X;
 }

 screen+=(FAST_320_MUL(y1))+x1;
 _bcopy(screen,buff,x2-x1);

 LIBDEBUG(printf("\nLeaving screen_save_h_line()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|save a horizontal line from x1, y1 to x2 into the given buffer          |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_h_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_h_lineNC(UBYTE *buff, USHORT x1, USHORT y1, USHORT x2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_save_h_line_NC()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }
 screen+=(FAST_320_MUL(y1))+x1;
 _bcopy(screen,buff,x2-x1);

 LIBDEBUG(printf("\nLeaving screen_save_h_line_NC()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|save a vertical line from x1, y1 to x2 into the given buffer            |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_v_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_v_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT y2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_save_v_line()\n\n"));

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 /* clip coords if needed */
 if(y1 > SCREEN_MAX_Y){
    return;
 }

 if(x1 > SCREEN_MAX_X){
    return;
 }

 if(y2 > SCREEN_MAX_Y){
    y2=SCREEN_MAX_Y;
 }

 screen+=(FAST_320_MUL(y1))+x1;

 for(;y2>y1;y2--){
     *buff=*screen;
     ++buff;
     screen+=SCREEN_WIDTH;
 }

 LIBDEBUG(printf("\nLeaving screen_save_v_line()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|save a vertical line from x1, y1 to x2 into the given buffer            |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_save_v_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_save_v_lineNC(UBYTE *buff, USHORT x1, USHORT y1, USHORT y2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_save_v_lineNC()\n\n"));

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 screen+=(FAST_320_MUL(y1))+x1;

 for(;y2>y1;y2--){
     *buff=*screen;
     ++buff;
     screen+=SCREEN_WIDTH;
 }

 LIBDEBUG(printf("\nLeaving screen_save_v_lineNC()\n\n"));
}


/*+-------------------------------------------------------------------------+*/
/*|restore a line from x1, y1 to x2, y2 into the given buffer               |*/
/*|                                                                         |*/
/*|this function uses a pathetic excuse for clipping but it will have to do |*/
/*|for the moment.                                                          |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2, USHORT y2)
{
 int d, x, y, ax, ay, sx, sy, dx, dy;
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_rest_line()\n\n"));

 /* clip the points (sigh) */
 if(x1 > SCREEN_MAX_X){
    x1=SCREEN_MAX_X;
 }

 if(x2 > SCREEN_MAX_X){
    x2=SCREEN_MAX_X;
 }

 if(y1 > SCREEN_MAX_Y){
    y1=SCREEN_MAX_Y;
 }

 if(y2 > SCREEN_MAX_Y){
    y2=SCREEN_MAX_Y;
 }

 dx = x2-x1;
 ax = ABS(dx) << 1;
 sx = SGN(dx);
 dy = y2-y1;
 ay = ABS(dy) << 1;
 sy = SGN(dy);

 x = x1;
 y = y1;

 if( ax > ay ){
    d = ay - (ax >> 1);
    while( x != x2 ){
	screen[(FAST_320_MUL(y))+x]=*buff;
	++buff;
	if( d >= 0 ){
	   y += sy;
	   d -= ax;
	}
	x += sx;
	d += ay;
    }
 }
 else{
     d = ax - (ay >> 1);
     while( y != y2 ){
	 screen[(FAST_320_MUL(y))+x]=*buff;
	 ++buff;
	 if( d >= 0 ){
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
     }
 }

 LIBDEBUG(printf("\nLeaving screen_rest_line()\n\n"));
}


/*+-------------------------------------------------------------------------+*/
/*|restore a line from x1, y1 to x2, y2 into the given buffer               |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_lineNC(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2, USHORT y2)
{
 int d, x, y, ax, ay, sx, sy, dx, dy;
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_rest_line_NC()\n\n"));

 dx = x2-x1;
 ax = ABS(dx) << 1;
 sx = SGN(dx);
 dy = y2-y1;
 ay = ABS(dy) << 1;
 sy = SGN(dy);

 x = x1;
 y = y1;

 if( ax > ay ){
    d = ay - (ax >> 1);
    while( x != x2 ){
	 screen[(FAST_320_MUL(y))+x]=*buff;
	 ++buff;
	if( d >= 0 ){
	   y += sy;
	   d -= ax;
	}
	x += sx;
	d += ay;
    }
 }
 else{
     d = ax - (ay >> 1);
     while( y != y2 ){
	 screen[(FAST_320_MUL(y))+x]=*buff;
	 ++buff;
	 if( d >= 0 ){
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
     }
 }

 LIBDEBUG(printf("\nLeaving screen_rest_line_NC()\n\n"));
}
/*+------------------------------------------------------------------------+*/
/*|restore a horizontal line from x1, y1 to x2 into the given buffer       |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_h_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_h_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_rest_h_line()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 /* clip coords if needed */
 if(x1 > SCREEN_MAX_X){
    return;
 }

 if(y1 > SCREEN_MAX_Y){
    return;
 }

 if(x2 > SCREEN_MAX_X){
    x2=SCREEN_MAX_X;
 }

 screen+=(FAST_320_MUL(y1))+x1;
 _bcopy(buff,screen,x2-x1);

 LIBDEBUG(printf("\nLeaving screen_rest_h_line()\n\n"));
}

/*+------------------------------------------------------------------------+*/
/*|restore a horizontal line from x1, y1 to x2 into the given buffer       |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_h_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_h_lineNC(UBYTE *buff, USHORT x1, USHORT y1, USHORT x2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_rest_h_line_NC()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }
 screen+=(FAST_320_MUL(y1))+x1;
  _bcopy(buff,screen,x2-x1);

 LIBDEBUG(printf("\nLeaving screen_rest_h_line_NC()\n\n"));
}

/*+------------------------------------------------------------------------+*/
/*|restore a vertical line from x1, y1 to x2 into the given buffer         |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_v_line
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_v_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT y2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_rest_v_line()\n\n"));

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 /* clip coords if needed */
 if(y1 > SCREEN_MAX_Y){
    return;
 }

 if(x1 > SCREEN_MAX_X){
    return;
 }

 if(y2 > SCREEN_MAX_Y){
    y2=SCREEN_MAX_Y;
 }

 screen+=(FAST_320_MUL(y1))+x1;

 for(;y2>y1;y2--){
     *screen=*buff;
     ++buff;
     screen+=SCREEN_WIDTH;
 }

 LIBDEBUG(printf("\nLeaving screen_rest_v_line()\n\n"));
}

/*+------------------------------------------------------------------------+*/
/*|restore a vertical line from x1, y1 to x2 into the given buffer         |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_rest_v_lineNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_rest_v_lineNC(UBYTE *buff, USHORT x1, USHORT y1, USHORT y2)
{
 UBYTE *screen=SCREEN_START;

 LIBDEBUG(printf("\nEntering screen_rest_v_lineNC()\n\n"));

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 screen+=(FAST_320_MUL(y1))+x1;

 for(;y2>y1;y2--){
     *screen=*buff;
     ++buff;
     screen+=SCREEN_WIDTH;
 }

 LIBDEBUG(printf("\nLeaving screen_rest_v_lineNC()\n\n"));
}
