/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"
#include "font.h"

/*+-------------------------------------------------------------------------+*/
/*|Draw a character on the screen at x,y in color c                         |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_charNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

#define FAST_320_MUL(x) (((x)<< 8)+((x)<< 6))

void screen_draw_charNC(UBYTE letter,USHORT x, USHORT y, UBYTE colour)
{
 UBYTE *screen = SCREEN_START;
 UBYTE width,height,a,b;
 USHORT i;

 LIBDEBUG(printf("\nEntering screen_draw_charNC().\n"));

 if(!HAS_FONT(letter)){
    LIBDEBUG(printf("character %d is non printable.\n",letter));
    return;
 }

 screen += FAST_320_MUL(y)+x;

 width = CHAR_WIDTH(letter);
 height = CHAR_HEIGHT(letter);

 i = ((letter-32)*32); /* set i to point to letter data */

 for(a=0;a<height;a++){
     for(b=0;b<width;b++){
	 if(__font_data[i++]){
	    *screen = colour;
	 }
	 ++screen;
     }
     screen+= SCREEN_WIDTH - width;
 }

 LIBDEBUG(printf("\nLeaving screen_draw_charNC().\n"));
}


/*+--------------------------------------------------------------------------+*/
/*|Draw a string of characters on the screen at x,y in color c               |*/
/*+--------------------------------------------------------------------------+*/
#ifdef __DEBUG_screen_draw_stringNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

#define FAST_320_MUL(x) (((x)<< 8)+((x)<< 6))

void screen_draw_stringNC(char *string,USHORT x, USHORT y, UBYTE colour)
{
 UBYTE i;

 LIBDEBUG(printf("\nEntering screen_draw_stringNC().\n"));

 for(i=0;i<strlen(string);i++){
     if(HAS_FONT(string[i])){
	screen_draw_charNC(string[i],x,y,colour);
	x += CHAR_WIDTH(string[i]);
     }
 }

 LIBDEBUG(printf("\nLeaving screen_draw_stringNC().\n"));
}
