/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"


#define FAST_320_MUL(x) (((x)<< 8)+((x)<< 6))

/*+------------------------------------------------------------------------+*/
/*|draw a box with corners x1, y1 to x2 , y2 in color c with clipping      |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_box
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_box(USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c)
{
 UBYTE *screen=SCREEN_START;
 USHORT width;

 LIBDEBUG(printf("\nEntering screen_draw_box()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 /* clip coords if nessisary */
 if((x1 > SCREEN_MAX_X) || (y1 > SCREEN_MAX_Y)){
    return;
 }

 if(x2 > SCREEN_MAX_X){
    x2 = SCREEN_MAX_X;
 }

 if(y2 > SCREEN_MAX_Y){
    y2 = SCREEN_MAX_Y;
 }

 width=x2-x1;

 /* draw bottom line first */
 screen+=(FAST_320_MUL(y2))+x1;
 memset(screen,(int)c,(size_t)width);

 /* draw top line */
 screen=SCREEN_START+(FAST_320_MUL(y1))+x1;
 memset(screen,(int)c,(size_t)width+1);  /* this is NOT a cludge! */

 /* draw the 2 vertical sides at the same tip */
  for(;y2>y1;y2--){
     screen+=SCREEN_WIDTH;
     *screen=c;
     *(screen+width)=c;
 }

 LIBDEBUG(printf("\nLeaving screen_draw_box()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|draw a box with corners x1, y1 to x2 , y2 in color c without clipping   |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_draw_boxNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_draw_boxNC(USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c)
{
 UBYTE *screen=SCREEN_START;
 USHORT width;

 LIBDEBUG(printf("\nEntering screen_draw_boxNC()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 width=x2-x1;

 /* draw bottom line first */
 screen+=(FAST_320_MUL(y2))+x1;
 memset(screen,(int)c,(size_t)width);

 /* draw top line */
 screen=SCREEN_START+(FAST_320_MUL(y1))+x1;
 memset(screen,(int)c,(size_t)width+1);  /* this is NOT a cludge! */

 /* draw the 2 vertical sides at the same tip */
  for(;y2>y1;y2--){
     screen+=SCREEN_WIDTH;
     *screen=c;
     *(screen+width)=c;
 }

 LIBDEBUG(printf("\nLeaving screen_draw_boxNC()\n\n"));
}


