/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

/* this file contains all of the blits TO the screen */
#include <dos.h>
#include <string.h>
#include "..\jlib.h"
#include "..\memcopy.h"


/*+------------------------------------------------------------------------+*/
/*|blit an offscreen buffer to the screen with clipping to scx,scy         |*/
/*+------------------------------------------------------------------------+*/
/*|Note that we avoid checking if coords are < 0 because we are using an   |*/
/*|unsigned type.                                                          |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_blit_buffer_to
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

__inline void screen_blit_buffer_to( USHORT scx, USHORT scy,
		     buffer_rec *buff,USHORT x1, USHORT y1,USHORT x2, USHORT y2)
{
 int v_iterations,h_len,count;
 UBYTE *screen=SCREEN_START;
 UBYTE *obuff;

 LIBDEBUG(printf("\nEntering screen_blit_buffer_to()\n\n"));

 /* check that scx and scy are valid */
 if((scx > SCREEN_WIDTH) || (scy > SCREEN_HEIGHT)){
    return;
 }

 /* check that x1 and y1 are valid */
 if((x1 > B_X_SIZE(buff)) || (y1 > B_Y_SIZE(buff))){
    return;
 }

 /* clip x2 and y2 to the buffer if needed */
 if(x2 > B_X_SIZE(buff)){
    x2 = B_X_SIZE(buff);
 }

 if(y2 > B_Y_SIZE(buff)){
    y2 = B_Y_SIZE(buff);
 }

 /* set screen to point to where we want to start copying to */
 screen+=(scy*SCREEN_WIDTH)+scx;

 /* set obuff to point to where we want to start copying from */
 obuff=buff->buffer+((y1*B_X_SIZE(buff))+x1);

 v_iterations=(y2-y1); /* number of times to repeat horiz. blit */

 /* check that v_iterations will fit on screen */
 if((scy + v_iterations) >SCREEN_HEIGHT){
    v_iterations = SCREEN_HEIGHT - scy;
 }

 h_len=(x2-x1);  /* length of horizontal blit */

 /* check that h_len will fit on screen */
 if((scx + h_len) >SCREEN_WIDTH){
    h_len = SCREEN_WIDTH - scx;
 }

 for(count=0;count<v_iterations;count++){
      _bytecopy(obuff,screen,h_len);
     screen += SCREEN_WIDTH;
     obuff += B_X_SIZE(buff);
 }

 LIBDEBUG(printf("\nLeaving screen_blit_buffer_to()\n\n"));
}



/*+------------------------------------------------------------------------+*/
/*|blit an offscreen buffer to the screen without clipping to scx,scy      |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_blit_buffer_toNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

__inline void screen_blit_buffer_toNC( USHORT scx, USHORT scy,
		     buffer_rec *buff,USHORT x1, USHORT y1,USHORT x2, USHORT y2)
{
 int v_iterations,h_len,count;
 UBYTE *screen=SCREEN_START;
 UBYTE *obuff;

 LIBDEBUG(printf("\nEntering screen_blit_buffer_toNC()\n\n"));

 /* set screen to point to where we want to start copying to */
 screen+=(scy*SCREEN_WIDTH)+scx;

 /* set obuff to point to where we want to start copying from */
 obuff=buff->buffer+((y1*B_X_SIZE(buff))+x1);

 v_iterations=(y2-y1); /* number of times to repeat horiz. blit */

 h_len=(x2-x1);  /* length of horizontal blit */

 for(count=0;count<v_iterations;count++){
     _bytecopy(obuff,screen,h_len);

     screen += SCREEN_WIDTH;
     obuff += B_X_SIZE(buff);
 }

 LIBDEBUG(printf("\nLeaving screen_blit_buffer_toNC()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|blit a fullscreen buffer to the screen                                  |*/
/*+------------------------------------------------------------------------+*/
/*|this routine is just a normal blit that assumes a width of 320 and a    |*/
/*|height of 200.                                                          |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_screen_blit_fs_buffer
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void screen_blit_fs_buffer(buffer_rec *buff,USHORT x, USHORT y)
/* NOTE: buffer must be word aligned and the same width as the screen!*/
{
 UBYTE *screen=SCREEN_START;
 UBYTE *obuff;

 LIBDEBUG(printf("\nEntering screen_blit_fs_buffer()\n\n"));

 obuff=(buff->buffer)+((y*B_X_SIZE(buff))+x);

  _wordcopy(obuff,screen,32000);


 LIBDEBUG(printf("\nLeaving screen_blit_fs_buffer()\n\n"));
}
