/*
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

#include <dos.h>
#include <pc.h>
#include "..\jlib.h"


#define MOUSE_INTERRUPT 0x33

/*+--------------------------------------------------------------------------+*/
/*|check for the presence of a mouse.                                        |*/
/*+--------------------------------------------------------------------------+*/
/*|this routine should always be called FIRST to initialize the mouse        |*/
/*+--------------------------------------------------------------------------+*/
int mouse_present(void)
{
   union REGS r;

   r.x.ax = 0x0000;
   int86(MOUSE_INTERRUPT, &r, &r);
   if (r.x.ax == 0xffff){
      return MOUSE_PRESENT;
   }
   else{
      return MOUSE_ABSENT;
   }
}

/*+--------------------------------------------------------------------------+*/
/*|show the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_show_pointer(void)
{
   union REGS r;

   r.x.ax = 0x0001;
   int86(MOUSE_INTERRUPT, &r, &r);
}


/*+--------------------------------------------------------------------------+*/
/*|hide the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_hide_pointer(void)
{
   union REGS r;

   r.x.ax = 0x0002;
   int86(MOUSE_INTERRUPT, &r, &r);
}

/*+--------------------------------------------------------------------------+*/
/*|read pointer coordinates                                                  |*/
/*+--------------------------------------------------------------------------+*/
void mouse_get_status(int *x_pos, int *y_pos, int *b_status)
{
   union REGS r;

   r.x.ax = 0x0003;

   int86(MOUSE_INTERRUPT, &r, &r);
      *x_pos=r.x.cx;
      *y_pos=r.x.dx;
      *b_status=r.x.bx;
}

/*+--------------------------------------------------------------------------+*/
/*|change pointer coordinates                                                |*/
/*+--------------------------------------------------------------------------+*/
void mouse_set_status( int x, int y)
{
   union REGS r;

   r.x.ax = 0x0004;
   r.x.cx = x;
   r.x.dx = y;

   int86(MOUSE_INTERRUPT, &r, &r);
}


/*+--------------------------------------------------------------------------+*/
/*|set horizontal and vertical limits (constrain pointer in a box)           |*/
/*+--------------------------------------------------------------------------+*/
void mouse_set_limits( USHORT x0, USHORT  y0, USHORT x1, USHORT y1)
{
   union REGS r;

   r.x.ax = 0x0007;
   r.x.cx = x0;
   r.x.dx = x1;

   int86(MOUSE_INTERRUPT, &r, &r);

   r.x.ax = 0x0008;
   r.x.cx = y0;
   r.x.dx = y1;

   int86(MOUSE_INTERRUPT, &r, &r);
}

                      
/*+--------------------------------------------------------------------------+*/
/*|reset horizontal and vertical limits                                      |*/
/*+--------------------------------------------------------------------------+*/
void mouse_reset_limits(void)
{
   union REGS r;

   r.x.ax = 0x0007;
   r.x.cx = 0;
   r.x.dx = SCREEN_MAX_X;

   int86(MOUSE_INTERRUPT, &r, &r);

   r.x.ax = 0x0008;
   r.x.cx = 0;
   r.x.dx = SCREEN_MAX_Y;

   int86(MOUSE_INTERRUPT, &r, &r);
}
