#include "vr.h"

 static int TmrVal,DOSTmrCnt;

void InitVRServer(void)
{

   _go32_dpmi_get_real_mode_interrupt_vector(0x8,&VR_old_vect);

   VR_new_vect.pm_offset = (int)Timer;
   _go32_dpmi_allocate_real_mode_callback_iret(&VR_new_vect,&VR_regs);

   _go32_dpmi_set_real_mode_interrupt_vector(0x8,&VR_new_vect);

   SyncVRServer();  /* synchronize timer to display refresh */
}

void Timer(_go32_dpmi_registers *r)
{
  _go32_dpmi_registers f_regs;

  asm volatile ("sti");

  asm volatile ("                     \n
	movb     $0x20,%al            \n
	outb     %al,$0x20            \n
	movw     $0x03DA,%dx          \n
   wnvr:                              \n
	inb      %dx,%al              \n
	testb    $8,%al               \n
	jnz     wnvr                  ");

	PreVRFunct();                /* call the Pre-VR function */


  asm volatile ("                     \n
	movw     _TmrVal,%bx           \n
	movw     $0x03DA,%dx          \n
    wvr:                              \n
	inb      %dx,%al              \n
	testb    $8,%al               \n
	jz       wvr                  \n
				      \n
	movb     $0x30,%al            \n
	outb     %al,$0x43            \n
	movb     %bl,%al              \n
	outb     %al,$0x40            \n
	movb     %bh,%al              \n
	outb     %al,$0x40            ");


	VRFunct();                /* call the VR function */


  asm volatile ("clc");


   if(TmrVal+DOSTmrCnt>65535){
      f_regs.x.cs = VR_old_vect.rm_segment;
      f_regs.x.ip = VR_old_vect.rm_offset;
      f_regs.x.ss = f_regs.x.sp = 0;
      _go32_dpmi_simulate_fcall_iret(&f_regs);
    }

}

void RemoveVRServer(void)
{

   _go32_dpmi_set_real_mode_interrupt_vector(0x8,&VR_old_vect);
   _go32_dpmi_free_real_mode_callback(&VR_new_vect);

}


#define WAITVR                 \
	       while((inportb(0x3da)&& 8)!=0) {}; \
	       while((inportb(0x3da)&& 8)==0) {};

void SyncVRServer(void)
{
 unsigned char c;
 unsigned short *s;


       asm volatile ("cli");            /* disable interrupts for maximum accuracy */

read:
       WAITVR

       c = 0x36;
       outportb(0x43,c);   /* port , data */
       c^=c;
       outportb(0x40,c);   /* port , data */
       outportb(0x40,c);   /* port , data */

	WAITVR

       c^=c;
       outportb(0x43,c);   /* port , data */
       TmrVal =-( inportb(0x40) * 16 + inportb(0x40));

     /*   movw    %al,%ah
	inw     $0x40,%al
	xchgw   %ah,%al
	negw    %ax
	mov     %ax,_TmrVal
     */

	WAITVR

       c = 0x36;
       outportb(0x43,c);   /* port , data */
       c^=c;
       outportb(0x40,c);   /* port , data */
       outportb(0x40,c);   /* port , data */

	WAITVR


	c^=c;
	outportb(0x43,c);   /* port , data */
	TmrVal -= -( inportb(0x40) * 16 + inportb(0x40));

	if ((TmrVal >2) || (TmrVal < -2)){
	    goto read;
	}


	TmrVal = ((TmrVal *975)/1000) >>1;

	WAITVR

	outportb(0x43,0x30);
	s = (unsigned short *)(&TmrVal);
	s++;
	outportw(0x40,*s);
	s = (unsigned short *)(&TmrVal);
	outportw(0x40,*s);

    /*    movw    $0x30,%al
	outw    %al,$0x43
	movw    %bl,%al
	outw    %al,$0x40
	movw    %bh,%al
	outw    %al,$0x40
    */

	DOSTmrCnt = 0;

	outportb(0x20,0x20); /* send EOI signal to the PIC*/

	asm volatile("sti");          /* enable ints */
}






