@rem *************************************************************************
@rem **                                                                     **
@rem **         This is the screen library batch file:                      **
@rem **         Use it to make the library.                                 **
@rem **         this builds a non-debug version                             **
@rem *************************************************************************

@echo making the sprite object files...
@cd sp
@call gcc -c *.c  -O3 -Wall @..\options.txt
@cd ..

@echo making the buffer object files...
@cd bf
@call gcc -c *.c  -O3  -Wall @..\options.txt
@cd ..

@echo making the image object files...
@cd img
@call gcc -c *.c -O3 -Wall   @..\options.txt
@cd ..

@echo making the screen object files...
@cd sc
@call gcc -c *.c  -O3  -Wall @..\options.txt
@call gcc -c *.S  -O3  -Wall @..\options.txt
@cd ..

@echo making the mouse object files...
@cd ms
@call gcc -c *.c -O3 -Wall   @..\options.txt
@cd ..

@echo creating library "libj.a" ...
@call ar -cr f:\gcc\lib\libj.a sp\*.o
@call ar -r f:\gcc\lib\libj.a sc\*.o
@call ar -r f:\gcc\lib\libj.a bf\*.o
@call ar -r f:\gcc\lib\libj.a img\*.o
@call ar -r f:\gcc\lib\libj.a ms\*.o

@echo All done!
