/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

#ifndef __JLIB_H__
#include "f:\gcc\proj\spr\src\usrtypes.h"

/*+-----------------------------------------------------------------------+*/
/*|images - routines to load 256 col images from files into buffers       |*/
/*+-----------------------------------------------------------------------+*/

#define COLOUR_AT(ptr,x,y)  (ptr->data[((ptr->width*y)+x)])
#define IMG_WIDTH(img_ptr)  (img_ptr->width)
#define IMG_HEIGHT(img_ptr) (img_ptr->height)
#define IMG_PALETTE(img_ptr) (img_ptr->palette)

typedef struct{
      USHORT width;
      USHORT height;
      UBYTE  *data;
      UBYTE  *palette;
}image;


/* function protos */

image *image_load_pcx(char *filename );



/*+-----------------------------------------------------------------------+*/
/*|sprites - sprite functions                                             |*/
/*+-----------------------------------------------------------------------+*/

/* return codes of function 'sprite_load' */
#define COULDNT_OPEN      1
#define TOO_MANY_IN_FILE  2
#define OUT_OF_MEMORY     3
#define SUCCESS           0

#define SPR_MAX_X (64)        /* biggest possible sprite x */
#define SPR_MAX_Y (64)        /* biggest possible sprite y */

#define SPR_MAX_ANIM_FRAMES (128)   /* the most animation frames allowed */

/* hard code values to use for hard code generation */
#define SPR_HARD_MAX_FRAMES   (255)
#define SPR_HARD_MAX_SPRITES  (16)
#define SPR_HARD_SPRITES_X    (32)
#define SPR_HARD_SPRITES_Y    (32)

#ifdef FIXED_SPRITE_NUMBERS
 #define SPR_MAX_SPRITES(x) (HARD_MAX_SPRITES)
#else
 #define SPR_MAX_SPRITES(x) (x->no_sprites)
#endif

#ifdef FIXED_SPRITE_FRAMES
 #define SPR_MAX_FRAMES(x) (HARD_MAX_FRAMES)
#else
 #define SPR_MAX_FRAMES(x) (x->no_frames)
#endif

#ifdef FIXED_SPRITE_SIZE
 #define SPR_X_SIZE(spr_ptr) (HARD_SPRITES_X)
 #define SPR_Y_SIZE(spr_ptr) (HARD_SPRITES_Y)
#else
 #define SPR_X_SIZE(spr_ptr) (spr_ptr->width)
 #define SPR_Y_SIZE(spr_ptr) (spr_ptr->height)
#endif

#define SPR_IS_ON(spr_sys_ptr,spr_num) (spr_sys_ptr->active_sprites[(spr_num)])

#define SPR_XPOS(sys,spr)   (sys->sprites[spr]->x)
#define SPR_YPOS(sys,spr)   (sys->sprites[spr]->y)

#define SPR_SET_WIDTH(spr_ptr,w)  (spr_ptr->width=w)
#define SPR_SET_HEIGHT(spr_ptr,h) (spr_ptr->height=h)
#define SPR_SET_XPOS(spr_ptr,x)   (spr_ptr->x=x)
#define SPR_SET_YPOS(spr_ptr,y)   (spr_ptr->y=y)
#define SPR_GET_XPOS(sys,snum)   (sys->sprites[snum]->x)
#define SPR_GET_YPOS(sys,snum)   (sys->sprites[snum]->y)

  typedef struct{
	USHORT x;           /* current location */
	USHORT y;

	UBYTE speed;        /* movement speed (0 = not moving ) */
	UBYTE speed_counter;
	BYTE xinc;          /* x and y increments when moving  */
	BYTE yinc;

	UBYTE animspeed;    /* animation speed (0 = not animating ) */
	UBYTE animspeed_counter;
	UBYTE noframes;     /* no of animation frames */
	USHORT frame_count;
	USHORT frame;       /* current frame */
	USHORT *animframes; /* array of frames in animation */

	UBYTE *buffer;      /* holds the info under the sprite */
  }sprite_record;


  typedef struct{
	UBYTE width;     /* width of sprite */
	UBYTE height;    /* width of sprite */
	UBYTE *data;     /* x*y array of the data */
	UBYTE *pattern;  /* RLE storage pattern */
	UBYTE no_rects;  /* number of bounding rects */
	UBYTE *rect_coords; /* coords of rects */
  }sprite_data_rec;


  typedef struct{
	USHORT no_sprites;             /* max number of sprites in system     */
	UBYTE  *active_sprites;        /* array of flags for active sprites   */
	sprite_record **sprites;       /* array of the sprites themselves     */
	USHORT no_frames;              /* num of sprite data frames in system */
	sprite_data_rec **sprite_data; /* array of frame data                 */
  }sprite_system;


/* function protos  */

  sprite_system *sprite_init(USHORT max_sprites,USHORT max_frames);

  UBYTE sprite_load(char *filename,sprite_system *ssys);

  void sprite_turn_on(sprite_system *spr_sys,USHORT snum);

  void sprite_turn_off(sprite_system *spr_sys,USHORT snum);

  void sprite_set_xy(sprite_system *spr_sys,USHORT snum,USHORT newx,USHORT newy);

  void sprite_set_an_frame(sprite_system *ssys,USHORT snum,USHORT frame);

  USHORT sprite_find_first_free(sprite_system *spr_sys);

  void sprite_set_move_info(sprite_system *spr_sys,USHORT snum,
			  UBYTE speed,BYTE xinc,BYTE yinc);

  void sprite_set_anim_info(sprite_system *spr_sys,USHORT snum,
			  UBYTE anspeed,UBYTE noframes,USHORT *animpat);

  void sprite_update_anim_and_move(sprite_system *spr_sys,USHORT snum);

  void sprite_update_all_anim_and_move(sprite_system *spr_sys);


/*+-----------------------------------------------------------------------+*/
/*|buffers - offscreen buffer video functions                             |*/
/*+-----------------------------------------------------------------------+*/

/* these are the dimensions of all buffers if FIXED_BUFFER_SIZE is defined */
#define HARD_BUFF_XSIZE  (320)
#define HARD_BUFF_YSIZE  (200)

#ifdef FIXED_BUFFER_SIZE
 #define B_X_SIZE(buff_ptr) (HARD_BUFF_XSIZE)
 #define B_Y_SIZE(buff_ptr) (HARD_BUFF_YSIZE)
 #define B_SIZE(buff_ptr)   (HARD_BUFF_XSIZE*HARD_BUFF_YSIZE)
#else
 #define B_X_SIZE(buff_ptr) (buff_ptr->width)
 #define B_Y_SIZE(buff_ptr) (buff_ptr->height)
 #define B_SIZE(buff_ptr)   ((buff_ptr->width)*(buff_ptr->height))
#endif

#define B_BUFF_PTR(buff_ptr) (buff_ptr->buffer)

typedef struct{
      USHORT width;   /* width of buffer */
      USHORT height;  /* height of buffer */
      UBYTE *buffer;  /* the buffer */
}buffer_rec;


/* function protos */
buffer_rec *buff_init(USHORT width,USHORT height);


/* blits */
void buff_blit_screen_toNC( USHORT bfx, USHORT bfy,
		     buffer_rec *buff,USHORT x1, USHORT y1,USHORT x2, USHORT y2);

/* points */
void buff_draw_point(buffer_rec *buff,USHORT x, USHORT y, UBYTE c);

void buff_draw_pointNC(buffer_rec *buff,USHORT x, USHORT y, UBYTE c);

UBYTE buff_get_point(buffer_rec *buff,USHORT x, USHORT y);

UBYTE buff_get_pointNC(buffer_rec *buff,USHORT x, USHORT y);


/* boxes */
void buff_draw_box(buffer_rec *buff,USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c);

void buff_draw_boxNC(buffer_rec *buff,USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c);


/* font */
void buff_draw_charNC(buffer_rec *buff,UBYTE letter,USHORT x, USHORT y, UBYTE colour);

void buff_draw_stringNC(buffer_rec *buff,char *string,USHORT x, USHORT y, UBYTE colour);



/* sprites */
void buff_draw_sprite(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff);

void buff_draw_spriteNC(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff);

void buff_draw_all_sprites(sprite_system *spr_sys,buffer_rec *obuff);


void buff_save_sprite(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff);

void buff_save_spriteNC(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff);

void buff_save_all_sprites(sprite_system *spr_sys,buffer_rec *obuff);


void buff_rest_sprite(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff);

void buff_rest_spriteNC(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff);

void buff_rest_all_sprites(sprite_system *spr_sys,buffer_rec *obuff);


void buff_stencil_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			     USHORT frame,buffer_rec *obuff);

void buff_stamp_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			     USHORT frame,buffer_rec *obuff);


/*+-----------------------------------------------------------------------+*/
/*|screen - on screen graphics primitives                                 |*/
/*+-----------------------------------------------------------------------+*/

/* this global buffer allows screen access to use buffer routines */
buffer_rec *__jlib_mode13h_screen;

#define SCREEN_START (UBYTE *)0xD0000000
#define SCREEN_START_ADDRESS  0xD0000000
#define SCREEN_WIDTH  (320)
#define SCREEN_HEIGHT (200)
#define SCREEN_MAX_X  (319)
#define SCREEN_MAX_Y  (199)


/* basics */
void screen_set_video_mode(void);

void screen_set_text_mode(void);

void screen_clear(void);

void screen_fill(int colour);

void screen_go_square_pixel(void);

void screen_wait_vsync(void);


/* palette */
UBYTE *screen_load_pal(char *fname);

void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);

void screen_block_set_pal(UBYTE *pal);

void screen_blank_pal(void);

void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);

void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);


/* points */
void screen_draw_point(USHORT x, USHORT y, UBYTE c);

void screen_draw_pointNC(USHORT x, USHORT y, UBYTE c);

UBYTE screen_get_point(USHORT x, USHORT y);

UBYTE screen_get_pointNC(USHORT x, USHORT y);


/* lines */
void screen_draw_line(USHORT x, USHORT y, USHORT x2, USHORT y2, UBYTE c);

void screen_draw_lineNC(USHORT x, USHORT y, USHORT x2, USHORT y2, UBYTE c);

void screen_save_line(UBYTE *buff,USHORT x, USHORT y, USHORT x2, USHORT y2);

void screen_save_lineNC(UBYTE *buff,USHORT x, USHORT y, USHORT x2, USHORT y2);

void screen_rest_line(UBYTE *buff,USHORT x, USHORT y, USHORT x2, USHORT y2);

void screen_rest_lineNC(UBYTE *buff,USHORT x, USHORT y, USHORT x2, USHORT y2);



void screen_draw_h_line(USHORT x1, USHORT y1, USHORT x2, UBYTE c);

void screen_draw_h_lineNC(USHORT x1, USHORT y1, USHORT x2, UBYTE c);

void screen_save_h_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2);

void screen_save_h_lineNC(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2);

void screen_rest_h_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2);

void screen_rest_h_lineNC(UBYTE *buff,USHORT x1, USHORT y1, USHORT x2);


void screen_draw_v_line(USHORT x1, USHORT y1, USHORT y2, UBYTE c);

void screen_draw_v_lineNC(USHORT x1, USHORT y1, USHORT y2, UBYTE c);

void screen_save_v_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT y2);

void screen_save_v_lineNC(UBYTE *buff,USHORT x1, USHORT y1, USHORT y2);

void screen_rest_v_line(UBYTE *buff,USHORT x1, USHORT y1, USHORT y2);

void screen_rest_v_lineNC(UBYTE *buff,USHORT x1, USHORT y1, USHORT y2);


/* these will grab enough memory to hold the largest possible object */
#define LINE_SAVE_MALLOC(x) x=(UBYTE *)malloc(SCREEN_WIDTH * sizeof(UBYTE))
#define H_LINE_SAVE_MALLOC(x) x=(UBYTE *)malloc(SCREEN_WIDTH * sizeof(UBYTE))
#define V_LINE_SAVE_MALLOC(x) x=(UBYTE *)malloc(SCREEN_HEIGHT * sizeof(UBYTE))
#define BOX_SAVE_MALLOC(x) x=(UBYTE *)malloc((SCREEN_HEIGHT * 2) *      \
					    (SCREEN_WIDTH * 2) * sizeof(UBYTE))


/* boxes */
void screen_draw_box(USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c);

void screen_draw_boxNC(USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c);

void screen_draw_rectNC(USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c);


/* blits */
void screen_blit_fs_buffer(buffer_rec *buff,USHORT x, USHORT y);

void screen_blit_buffer_to( USHORT scx, USHORT scy,
		     buffer_rec *buff,USHORT x1,USHORT y1,USHORT x2,USHORT y2);

void screen_blit_buffer_toNC( USHORT scx, USHORT scy,
		     buffer_rec *buff,USHORT x1,USHORT y1,USHORT x2,USHORT y2);


/* sprites */
void screen_draw_sprite(sprite_system *spr_sys, USHORT snum);

void screen_draw_spriteNC(sprite_system *spr_sys, USHORT snum);

void screen_draw_all_sprites(sprite_system *spr_sys);


void screen_save_sprite(sprite_system *spr_sys, USHORT snum);

void screen_save_spriteNC(sprite_system *spr_sys, USHORT snum);

void screen_save_all_sprites(sprite_system *spr_sys);


void screen_rest_sprite(sprite_system *spr_sys, USHORT snum);

void screen_rest_spriteNC(sprite_system *spr_sys, USHORT snum);

void screen_rest_all_sprites(sprite_system *spr_sys);


void screen_stencil_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			     USHORT frame);

void screen_stamp_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			   USHORT frame);


/* font */

void screen_draw_charNC(UBYTE letter,USHORT x, USHORT y, UBYTE colour);

void screen_draw_stringNC(char *string,USHORT x, USHORT y, UBYTE colour);



/*      To clear confusion - here is the screen layout:
**
**       0 ----------------------> x      319
**   0  +------------------------------------+
**   |  |                                    |
**   |  |                                    |
**   |  |                                    |
**   |  |          + <-this dot is at:       |
**  \|/ |            A: (y*SCREENWIDTH)+x;   |   (think about it..)
**   y  |            B: (x,y);               |
**      |                                    |
**  199 +------------------------------------+
*/


/*+-----------------------------------------------------------------------+*/
/*|mouse - mouse routines                                                 |*/
/*+-----------------------------------------------------------------------+*/

#define MOUSE_PRESENT 1
#define MOUSE_ABSENT  0

#define LEFT_BUTTON_DOWN(status)  (status & 0x1)
#define RIGHT_BUTTON_DOWN(status) (status & 0x2)

#define MOUSE_X_TO_SCREEN(x)  (x>>1)
#define MOUSE_Y_TO_SCREEN(y)  (y)
#define SCREEN_X_TO_MOUSE(x)  (x<<1)
#define SCREEN_Y_TO_MOUSE(yn)  (y)

int mouse_present(void);

void mouse_show_pointer(void);

void mouse_hide_pointer(void);


void mouse_get_status(int *x_pos, int *y_pos, int *b_status);

void mouse_set_status( int x, int y);


void mouse_set_limits( USHORT x0, USHORT  y0, USHORT x1, USHORT y1);

void mouse_reset_limits(void);

#define __JLIB_H__   1

/* end of file */
#endif
