/*
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

#include <stdio.h>
#include <malloc.h>
#include <unistd.h>
#include "..\jlib.h"

#ifdef __DEBUG_image_load_pcx
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

typedef struct PCX_HEADER {
  UBYTE manufacturer;
  UBYTE version;
  UBYTE encoding;
  UBYTE bits_per_pixel;
  SHORT  xmin,ymin;
  SHORT  xmax,ymax;
  SHORT  hres;
  SHORT  vres;
  UBYTE palette16[48];
  UBYTE reserved;
  UBYTE color_planes;
  SHORT  bytes_per_line;
  SHORT  palette_type;
  UBYTE filler[58];
} pcx_header;

image *image_load_pcx(char *filename)
{
  FILE *infile;
  image *timg;
  int i,c;
  pcx_header pcxhead;

  LIBDEBUG(printf("\nEntering image_load_pcx()\n\n"));

  /* grab mem for header record */
  if((timg=(image *)malloc(sizeof(image)))==NULL){
    LIBDEBUG(printf("Malloc failed at line %d\n",__LINE__));
    return (image *)NULL;
  }
  LIBDEBUG(printf("Malloc OK at line %d\n",__LINE__));

  /* grab mem for palette */
  if((timg->palette=(UBYTE *)malloc(768*sizeof(UBYTE)))==NULL){
    LIBDEBUG(printf("Malloc failed at line %d\n",__LINE__));
    return (image *)NULL;
  }
  LIBDEBUG(printf("Malloc OK at line %d\n",__LINE__));

  /* Open the file */
  if ((infile = fopen(filename,"rb"))==NULL) {
      LIBDEBUG(printf("fopen failed at line %d\n",__LINE__));
      free(timg->palette);
      return (image *)NULL;
  }
  LIBDEBUG(printf("fopen OK at line %d\n",__LINE__));

  /* read in header record */
  fseek(infile,0L,SEEK_SET);
  fread(&pcxhead,sizeof(pcx_header),1,infile);

  LIBDEBUG(printf("x and y min are %d and %d\n",pcxhead.xmin,pcxhead.ymin));
  LIBDEBUG(printf("x and y max are %d and %d\n",pcxhead.xmax,pcxhead.ymax));

  /* set width and height */
  timg->width = (pcxhead.xmax-pcxhead.xmin) + 1;
  timg->height = (pcxhead.ymax-pcxhead.ymin) + 1;

  LIBDEBUG(printf("Width and Height are %d and %d\n",timg->width,timg->height));

  /* grab memory for buffer */
  if((timg->data=(UBYTE *)malloc((timg->width*timg->height)*sizeof(UBYTE)))==NULL){
    LIBDEBUG(printf("Malloc failed at line %d\n",__LINE__));
    free(timg->palette);
    free(timg);
    return (image *)NULL;
  }
  LIBDEBUG(printf("Malloc OK at line %d\n",__LINE__));

  /* get the RLE data into the buffer */
  for(i=0;i<(timg->width * timg->height);){
      unsigned int x;

      c=fgetc(infile) & 0xff;

      if((c & 0xc0) == 0xc0){
	 x=c & 0x3f;
	 c=fgetc(infile);
	 LIBDEBUG(printf("repeat %d %d times\n",c,x));
	 while(x--){
	      timg->data[i]=c;
	      i++;
	 }
      }
      else{
	 LIBDEBUG(printf("data %d\n",c));
	 timg->data[i]=c;
	 i++;
      }
  }

  /* Get the check marker for 256-colour files */
  fseek(infile,-769L,SEEK_END);
  c = fgetc(infile);
  if (c!=0x0C) {
      LIBDEBUG(printf("Checksum incorrect\n"));
      free(timg->data);
      free(timg->palette);
      free(timg);
      fclose(infile);
      return (image *)NULL;
  }
  LIBDEBUG(printf("Checksum OK\n"));

  /* Read in the 256 colour palette */
  if ((c = fread( timg->palette, 1, 768, infile )) != 768) {
      LIBDEBUG(printf("palette read failed\n"));
      free(timg->data);
      free(timg->palette);
      free(timg);
      fclose(infile);
      return (image *)NULL;
  }
  LIBDEBUG(printf("palette read OK\n"));

  fclose(infile);

  LIBDEBUG(printf("\nLeaving image_load_pcx()\n\n"));
  /* return a pointer to the image */
  return timg;
}
