/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"
#include "..\memcopy.h"

#define NOT_CLIPPED 0

#define X_LEFT   (xpos)
#define X_RIGHT  (xpos+width)
#define Y_TOP    (ypos)
#define Y_BOTTOM (ypos+height)

/*+----------------------------------------------------------------------+*/
/*|draw_sprite - draw a sprite on screen with clipping                   |*/
/*+----------------------------------------------------------------------+*/
/*| note - this version is a 'knock up' concieved only because I couldn't|*/
/*| justify procrastinating any more.  it is even LESS optimised than the|*/
/*| non clipping functions.                                              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_draw_sprite
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_draw_sprite(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data;
 UBYTE width,height,status=NOT_CLIPPED;
 UBYTE count1,count2,startx,starty,endx,endy;
 UBYTE *pos_in_buff,datum;
 USHORT xpos,ypos;


 LIBDEBUG(printf("\nEntering buff_draw_sprite()\n\n"));

 /* don't draw sprite if it isn't turned on */
 if(SPR_IS_ON(spr_sys,snum)){

    LIBDEBUG(printf("Sprite %d is ON\n",snum));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    data = current_sprite_data->data;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* set initial values of startx , endx etc */
    startx=0;
    starty=0;
    endx=width;
    endy=height;

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the buff.*/
    xpos = spr_sys->sprites[snum]->x;
    ypos = spr_sys->sprites[snum]->y;


    /* check for "don't draw"  clipping  */
    if((X_LEFT > B_X_SIZE(obuff) + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > B_Y_SIZE(obuff) + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)){
      return;
    }

    /* check the other 4 clipping conditions */
    if(X_LEFT < SPR_MAX_X){
       /* some portion of the left side of the sprite is obscured */
       status++;
       startx = SPR_MAX_X - X_LEFT;
    }
    else{
       if(X_RIGHT > B_X_SIZE(obuff) + SPR_MAX_X){
	  /* some portion of the right side of the sprite is obscured */
	  status++;
	  endx = (B_X_SIZE(obuff) + SPR_MAX_X) - X_LEFT;
       }
    }

    if(Y_TOP < SPR_MAX_Y){
       /* some portion of the top side of the sprite is obscured */
       status++;
       starty = SPR_MAX_Y - Y_TOP;
    }
    else{
       if(Y_BOTTOM > B_Y_SIZE(obuff) + SPR_MAX_X){
	  /* some portion of the bottom side of the sprite is obscured */
	  status++;
	  endy = (B_Y_SIZE(obuff) + SPR_MAX_Y) - Y_TOP;
       }
    }

    /* only use the drawing routine below if needed */
    if(status == NOT_CLIPPED){
       buff_draw_spriteNC(spr_sys,snum,obuff);
       return;
    }


    pos_in_buff=(UBYTE *)(obuff->buffer+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*B_X_SIZE(obuff))
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* start at the appropriate place in the data */
     data+=(starty*width)+startx;

     /* start at the appropriate place in buff */
     pos_in_buff+=(starty*B_X_SIZE(obuff))+startx;


    /* move through the data, determining which pixels to draw */
    for(count1=starty;count1<endy;count1++){
	for(count2=startx;count2<endx;count2++){
	    datum = *data;

	    if(datum){
	       *pos_in_buff = *data;
	    }

	    pos_in_buff ++;
	    data ++;
	}

	pos_in_buff += B_X_SIZE(obuff)-(endx-startx);
	data += width - (endx-startx);
    }
 }/* IF */

 LIBDEBUG(printf("\nLeaving buff_draw_sprite()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|draw_spriteNC - draw a sprite on buff without clipping              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_draw_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_draw_spriteNC(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_in_buff,datum;
 int rlecount;


 LIBDEBUG(printf("\nEntering buff_draw_spriteNC()\n\n"));

 /* don't draw sprite if it isn't turned on */
 if(SPR_IS_ON(spr_sys,snum)){

    LIBDEBUG(printf("Sprite %d is ON\n",snum));

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the buff.*/
    pos_in_buff=(UBYTE *)(obuff->buffer+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*B_X_SIZE(obuff))
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    data = current_sprite_data->data;
    pattern=current_sprite_data->pattern;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* move through the RLE pattern determining which pixels to draw */
    for(count1=0;count1<height;count1++){
	LIBDEBUG(printf("processing row %d\n",count1));
	LIBDEBUG(printf("row value is %d\n",*pattern));
	
	for(count2=*pattern,++pattern;count2>0;count2--){
	
	    datum=*pattern;
	    ++pattern;

	    rlecount=*pattern;
	    ++pattern;
	
	    LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	    if(datum){
	      _bcopy(data,pos_in_buff,rlecount);
	    }

	    pos_in_buff += rlecount;
	    data += rlecount;
	}

	LIBDEBUG(printf("\n"));

	pos_in_buff += B_X_SIZE(obuff)-width;
    }
 }/* IF */

 LIBDEBUG(printf("\nLeaving buff_draw_spriteNC()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|save_sprite - save the buff under a sprite with clipping            |*/
/*+----------------------------------------------------------------------+*/
/*| NOTE - this version is a 'knock up' concieved only because I couldn't|*/
/*| justify procrastinating any more.  it is even LESS optimised than the|*/
/*| non clipping functions.                                              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_save_sprite
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_save_sprite(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*buffer;
 UBYTE width,height,status=NOT_CLIPPED;
 UBYTE count1,count2,startx,starty,endx,endy;
 UBYTE *pos_in_buff,datum;
 USHORT xpos,ypos;


 LIBDEBUG(printf("\nEntering buff_save_sprite()\n\n"));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    LIBDEBUG(printf("snum is (%d)\n",snum));
    LIBDEBUG(printf("frame is (%d)\n",spr_sys->sprites[snum]->frame));

    data = current_sprite_data->data;
    buffer=spr_sys->sprites[snum]->buffer;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* set initial values of startx , endx etc */
    startx=0;
    starty=0;
    endx=width;
    endy=height;

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the buff.*/
    xpos = spr_sys->sprites[snum]->x;
    ypos = spr_sys->sprites[snum]->y;


    /* check for "don't save"  clipping  */
    if((X_LEFT > B_X_SIZE(obuff) + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > B_Y_SIZE(obuff) + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)){
      return;
    }

    /* check the other 4 clipping conditions */
    if(X_LEFT < SPR_MAX_X){
       /* some portion of the left side of the sprite is obscured */
       status++;
       startx = SPR_MAX_X - X_LEFT;
    }
    else{
       if(X_RIGHT > B_X_SIZE(obuff) + SPR_MAX_X){
	  /* some portion of the right side of the sprite is obscured */
	  status++;
	  endx = (B_X_SIZE(obuff) + SPR_MAX_X) - X_LEFT;
       }
    }

    if(Y_TOP < SPR_MAX_Y){
       /* some portion of the top side of the sprite is obscured */
       status++;
       starty = SPR_MAX_Y - Y_TOP;
    }
    else{
       if(Y_BOTTOM > B_Y_SIZE(obuff) + SPR_MAX_X){
	  /* some portion of the bottom side of the sprite is obscured */
	  status++;
	  endy = (B_Y_SIZE(obuff) + SPR_MAX_Y) - Y_TOP;
       }
    }

    /* only use the saving routine below if needed */
    if(status == NOT_CLIPPED){
       buff_save_spriteNC(spr_sys,snum,obuff);
       return;
    }


    pos_in_buff=(UBYTE *)(obuff->buffer+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*B_X_SIZE(obuff))
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* start at the appropriate place in the data */
     data+=(starty*width)+startx;

     /* start at the appropriate place in buff */
     pos_in_buff+=(starty*B_X_SIZE(obuff))+startx;


    /* move through the data,  saving non-zero pixels */
    for(count1=starty;count1<endy;count1++){
	for(count2=startx;count2<endx;count2++){
	    datum = *data;

	    if(datum){
	       *buffer = *pos_in_buff;
	    }

	    pos_in_buff++;
	    data++;
	    buffer++;
	}

	pos_in_buff += B_X_SIZE(obuff)-(endx-startx);
	data += width - (endx-startx);
    }

 LIBDEBUG(printf("\nLeaving buff_save_sprite()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|buff_save_spriteNC - save the buff under a sprite into its buffer |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_save_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_save_spriteNC(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *buffer,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_in_buff,datum;
 int rlecount;


 LIBDEBUG(printf("\nEntering buff_save_spriteNC()\n\n"));

 /* posistion is calculated from x and y minus the maximum sprite width */
 /* and height, so that we can have sprites off the edges of the buff.*/
 pos_in_buff=(UBYTE *)(obuff->buffer+
			((spr_sys->sprites[snum]->y-SPR_MAX_Y)*B_X_SIZE(obuff))
			+ (spr_sys->sprites[snum]->x-SPR_MAX_Y));

 LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
 LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

  /* the data is the sprite_data_rec indicated by it's frame */
 current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

 buffer = spr_sys->sprites[snum]->buffer;

 pattern=current_sprite_data->pattern;
 width=current_sprite_data->width;
 height=current_sprite_data->height;

 LIBDEBUG(printf("height is (%d)\n",height));
 LIBDEBUG(printf("width is  (%d)\n",width));

  /* move through the RLE pattern determining which pixels to save */
 for(count1=0;count1<height;count1++){
     LIBDEBUG(printf("processing row %d\n",count1));
     LIBDEBUG(printf("row value is %d\n",*pattern));
	
     for(count2=*pattern,++pattern;count2>0;count2--){
	
	 datum=*pattern;
	 ++pattern;

	 rlecount=*pattern;
	 ++pattern;
	
	 LIBDEBUG(printf("(%d,%d)\n",datum,rlecount));

	 if(datum){
	    _bcopy(pos_in_buff,buffer,rlecount);
	    buffer += rlecount;
	 }
	 pos_in_buff += rlecount;

     }

     LIBDEBUG(printf("\n"));

     pos_in_buff += B_X_SIZE(obuff)-width;
 }

 LIBDEBUG(printf("\nLeaving buff_save_spriteNC()\n\n"));
}

/*+----------------------------------------------------------------------+*/
/*|rest_sprite - restore the buff under a sprite with clipping         |*/
/*+----------------------------------------------------------------------+*/
/*| NOTE - this version is a 'knock up' concieved only because I couldn't|*/
/*| justify procrastinating any more.  it is even LESS optimised than the|*/
/*| non clipping functions.                                              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_rest_sprite
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_rest_sprite(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*buffer;
 UBYTE width,height,status=NOT_CLIPPED;
 UBYTE count1,count2,startx,starty,endx,endy;
 UBYTE *pos_in_buff,datum;
 USHORT xpos,ypos;


 LIBDEBUG(printf("\nEntering buff_rest_sprite()\n\n"));

    /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    data = current_sprite_data->data;
    buffer=spr_sys->sprites[snum]->buffer;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

    /* set initial values of startx , endx etc */
    startx=0;
    starty=0;
    endx=width;
    endy=height;

    /* posistion is calculated from x and y minus the maximum sprite width */
    /* and height, so that we can have sprites off the edges of the buff.*/
    xpos = spr_sys->sprites[snum]->x;
    ypos = spr_sys->sprites[snum]->y;


    /* check for "don't restore"  clipping  */
    if((X_LEFT > B_X_SIZE(obuff) + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > B_Y_SIZE(obuff) + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)){
      return;
    }

    /* check the other 4 clipping conditions */
    if(X_LEFT < SPR_MAX_X){
       /* some portion of the left side of the sprite is obscured */
       status++;
       startx = SPR_MAX_X - X_LEFT;
    }
    else{
       if(X_RIGHT > B_X_SIZE(obuff) + SPR_MAX_X){
	  /* some portion of the right side of the sprite is obscured */
	  status++;
	  endx = (B_X_SIZE(obuff) + SPR_MAX_X) - X_LEFT;
       }
    }

    if(Y_TOP < SPR_MAX_Y){
       /* some portion of the top side of the sprite is obscured */
       status++;
       starty = SPR_MAX_Y - Y_TOP;
    }
    else{
       if(Y_BOTTOM > B_Y_SIZE(obuff) + SPR_MAX_X){
	  /* some portion of the bottom side of the sprite is obscured */
	  status++;
	  endy = (B_Y_SIZE(obuff) + SPR_MAX_Y) - Y_TOP;
       }
    }

    /* only use the saving routine below if needed */
    if(status == NOT_CLIPPED){
       buff_rest_spriteNC(spr_sys,snum,obuff);
       return;
    }


    pos_in_buff=(UBYTE *)(obuff->buffer+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*B_X_SIZE(obuff))
			   + (spr_sys->sprites[snum]->x)-SPR_MAX_X);

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* start at the appropriate place in the data */
     data+=(starty*width)+startx;

     /* start at the appropriate place on buff */
     pos_in_buff+=(starty*B_X_SIZE(obuff))+startx;


    /* move through the data,  saving non-zero pixels */
    for(count1=starty;count1<endy;count1++){
	for(count2=startx;count2<endx;count2++){
	    datum = *data;

	    if(datum){
	       *pos_in_buff= *buffer;
	    }

	    pos_in_buff++;
	    data++;
	    buffer++;
	}

	pos_in_buff += B_X_SIZE(obuff)-(endx-startx);
	data += width - (endx-startx);
    }

 LIBDEBUG(printf("\nLeaving buff_rest_sprite()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|buff_rest_spriteNC - rest the buff under a sprite from its buffer |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_rest_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_rest_spriteNC(sprite_system *spr_sys, USHORT snum,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *buffer,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_in_buff,datum;
 int rlecount;


 LIBDEBUG(printf("\nEntering buff_rest_spriteNC()\n\n"));


  /* posistion is calculated from x and y minus the maximum sprite width */
  /* and height, so that we can have sprites off the edges of the buff.*/
   pos_in_buff=(UBYTE *)(obuff->buffer+
			   ((spr_sys->sprites[snum]->y-SPR_MAX_Y)*B_X_SIZE(obuff))
			   + (spr_sys->sprites[snum]->x-SPR_MAX_X));

    LIBDEBUG(printf("X Pos is (%d)\n",spr_sys->sprites[snum]->x-SPR_MAX_X));
    LIBDEBUG(printf("Y Pos is (%d)\n",spr_sys->sprites[snum]->y-SPR_MAX_Y));

     /* the data is the sprite_data_rec indicated by it's frame */
    current_sprite_data=spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

    buffer = spr_sys->sprites[snum]->buffer;

    pattern=current_sprite_data->pattern;
    width=current_sprite_data->width;
    height=current_sprite_data->height;

    LIBDEBUG(printf("height is (%d)\n",height));
    LIBDEBUG(printf("width is  (%d)\n",width));

     /* move through the RLE pattern determining which pixels to restore */
    for(count1=0;count1<height;count1++){
	LIBDEBUG(printf("processing row %d\n",count1));
	LIBDEBUG(printf("row value is %d\n",*pattern));
	
	for(count2=*pattern,++pattern;count2>0;count2--){
	
	    datum=*pattern;
	    ++pattern;

	    rlecount=*pattern;
	    ++pattern;
	
	    LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	    if(datum){
	       _bcopy(buffer,pos_in_buff,rlecount);
	       buffer += rlecount;
	    }
	
	    pos_in_buff += rlecount;
	}

	LIBDEBUG(printf("\n"));

	pos_in_buff += B_X_SIZE(obuff)-width;
    }

 LIBDEBUG(printf("\nLeaving buff_rest_spriteNC()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|stamp a sprite frame on buff without clipping                       |*/
/*|                                                                      |*/
/*|"stamp" means that the background is drawn as black.                  |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_stamp_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_stamp_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			     USHORT frame,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_in_buff,datum;
 int rlecount;

 LIBDEBUG(printf("\nEntering buff_stamp_spriteNC()\n\n"));

 pos_in_buff=(UBYTE *)obuff->buffer+(y*B_X_SIZE(obuff))+x;

 LIBDEBUG(printf("X is (%d)\n",x));
 LIBDEBUG(printf("Y is (%d)\n",y));


 current_sprite_data=spr_sys->sprite_data[frame];

 data = current_sprite_data->data;
 pattern=current_sprite_data->pattern;
 width=current_sprite_data->width;
 height=current_sprite_data->height;

 LIBDEBUG(printf("height is (%d)\n",height));
 LIBDEBUG(printf("width is  (%d)\n",width));

 for(count1=0;count1<height;count1++){
     LIBDEBUG(printf("processing row %d\n",count1));
     LIBDEBUG(printf("row value is %d\n",*pattern));
	
     for(count2=*pattern,++pattern;count2>0;count2--){
	
	 datum=*pattern;
	 ++pattern;

	 rlecount=*pattern;
	 ++pattern;
	
	 LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	 _bcopy(data,pos_in_buff,rlecount);

	 pos_in_buff += rlecount;
	 data += rlecount;
     }

     LIBDEBUG(printf("\n"));

     pos_in_buff += B_X_SIZE(obuff)-width;
 }

 LIBDEBUG(printf("\nLeaving buff_stamp_spriteNC()\n\n"));
}

/*+----------------------------------------------------------------------+*/
/*|stencil a sprite frame on buff without clipping                     |*/
/*|                                                                      |*/
/*|"stencil" means that the background remains transparent.              |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_stencil_spriteNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_stencil_spriteNC(USHORT x,USHORT y,sprite_system *spr_sys,
			     USHORT frame,buffer_rec *obuff)
{
 sprite_data_rec *current_sprite_data;
 UBYTE *data,*pattern;
 UBYTE width,height;
 UBYTE count1,count2;
 UBYTE *pos_in_buff,datum;
 int rlecount;

 LIBDEBUG(printf("\nEntering buff_stencil_spriteNC()\n\n"));

 pos_in_buff=(UBYTE *)obuff->buffer+(y*B_X_SIZE(obuff))+x;

 LIBDEBUG(printf("X is (%d)\n",x));
 LIBDEBUG(printf("Y is (%d)\n",y));


 current_sprite_data=spr_sys->sprite_data[frame];

 data = current_sprite_data->data;
 pattern=current_sprite_data->pattern;
 width=current_sprite_data->width;
 height=current_sprite_data->height;

 LIBDEBUG(printf("height is (%d)\n",height));
 LIBDEBUG(printf("width is  (%d)\n",width));

 for(count1=0;count1<height;count1++){
     LIBDEBUG(printf("processing row %d\n",count1));
     LIBDEBUG(printf("row value is %d\n",*pattern));
	
     for(count2=*pattern,++pattern;count2>0;count2--){
	
	 datum=*pattern;
	 ++pattern;

	 rlecount=*pattern;
	 ++pattern;
	
	 LIBDEBUG(printf("(%d,%d) ",datum,rlecount));

	 if(datum){
	    _bcopy(data,pos_in_buff,rlecount);
	 }

	 pos_in_buff += rlecount;
	 data += rlecount;
     }

     LIBDEBUG(printf("\n"));

     pos_in_buff += B_X_SIZE(obuff)-width;
 }

 LIBDEBUG(printf("\nLeaving buff_stencil_spriteNC()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|buff_draw_all_sprites                                                 |*/
/*+----------------------------------------------------------------------+*/
/*|draw all active sprites to the given buff.                            |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_draw_all_sprites
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_draw_all_sprites(sprite_system *spr_sys,buffer_rec *obuff)
{
 int count;

 LIBDEBUG(printf("\nEntering buff_draw_all_sprites()\n\n"));


 for(count=0;count<spr_sys->no_sprites;count++){
     if(SPR_IS_ON(spr_sys,count)){
	buff_draw_sprite(spr_sys,count,obuff);
     }
 }

 LIBDEBUG(printf("\nLeaving buff_draw_all_sprites()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|buff_save_all_sprites                                                 |*/
/*+----------------------------------------------------------------------+*/
/*|save all active sprites to the given buff.                            |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_save_all_sprites
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_save_all_sprites(sprite_system *spr_sys,buffer_rec *obuff)
{
 int count;

 LIBDEBUG(printf("\nEntering buff_save_all_sprites()\n\n"));


 for(count=0;count<spr_sys->no_sprites;count++){
     if(SPR_IS_ON(spr_sys,count)){
	buff_save_sprite(spr_sys,count,obuff);
     }
 }

 LIBDEBUG(printf("\nLeaving buff_save_all_sprites()\n\n"));
}


/*+----------------------------------------------------------------------+*/
/*|buff_rest_all_sprites                                                 |*/
/*+----------------------------------------------------------------------+*/
/*|rest all active sprites to the given buff.                            |*/
/*+----------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_rest_all_sprites
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_rest_all_sprites(sprite_system *spr_sys,buffer_rec *obuff)
{
 int count;

 LIBDEBUG(printf("\nEntering buff_rest_all_sprites()\n\n"));


 for(count=0;count<spr_sys->no_sprites;count++){
     if(SPR_IS_ON(spr_sys,count)){
	buff_rest_sprite(spr_sys,count,obuff);
     }
 }

 LIBDEBUG(printf("\nLeaving buff_rest_all_sprites()\n\n"));
}
