/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <malloc.h>
#include "..\jlib.h"

#ifndef NULL
 #define NULL 0L;
#endif

/*+------------------------------------------------------------------------+*/
/*|initialise an offscreen buffer                                          |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_init
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

buffer_rec *buff_init(USHORT width,USHORT height)
{
 buffer_rec *tbrp;

 LIBDEBUG(printf("\nEntering buff_init()\n\n"));

 /* allocate memory for the buffer record */
 if((tbrp=(buffer_rec*)malloc(sizeof(buffer_rec)))==NULL){
    return (buffer_rec *)NULL;
 }

 #ifdef FIXED_BUFFER_SIZE
  tbrp->width=HARD_BUFF_XSIZE;
  tbrp->height=HARD_BUFF_YSIZE;
 #else
  tbrp->width=width;
  tbrp->height=height;
 #endif

  /* allocate memory for the buffer itself */
 if((tbrp->buffer=
   (UBYTE *)malloc(B_SIZE(tbrp)*sizeof(UBYTE)))==NULL){
     LIBDEBUG(printf("\nMalloc failed at %d\n",__LINE__));
     return (buffer_rec *)NULL;
 }
 LIBDEBUG(printf("\nMalloc succesfull at %d\n",__LINE__));

 /* clear the buffer */
 memset(tbrp->buffer,B_SIZE(tbrp),0);

 LIBDEBUG(printf("\nLeaving buff_init()\n\n"));

 /* return a handle */
 return tbrp;
}

