/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"
#include "bfont.h"

/*+-------------------------------------------------------------------------+*/
/*|Draw a character in a buffer at x,y in color c                           |*/
/*+-------------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_draw_charNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_draw_charNC(buffer_rec *buff,UBYTE letter,USHORT x, USHORT y, UBYTE colour)
{
 UBYTE *buffer = B_BUFF_PTR(buff);
 UBYTE width,height,a,b;
 USHORT i;

 LIBDEBUG(printf("\nEntering buff_draw_charNC().\n"));

 if(!HAS_FONT(letter)){
    LIBDEBUG(printf("character %d is non printable.\n",letter));
    return;
 }

 buffer += (B_X_SIZE(buff)*y)+x;

 width = CHAR_WIDTH(letter);
 height = CHAR_HEIGHT(letter);

 i = ((letter-32)*32); /* set i to point to letter data */

 for(a=0;a<height;a++){
     for(b=0;b<width;b++){
	 if(__font_data[i++]){
	    *buffer = colour;
	 }
	 ++buffer;
     }
     buffer+= B_X_SIZE(buff) - width;
 }

 LIBDEBUG(printf("\nLeaving buff_draw_charNC().\n"));
}


/*+--------------------------------------------------------------------------+*/
/*|Draw a string of characters on the buff at x,y in color c               |*/
/*+--------------------------------------------------------------------------+*/
#ifdef __DEBUG_buff_draw_stringNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

void buff_draw_stringNC(buffer_rec *buff,char *string,USHORT x, USHORT y, UBYTE colour)
{
 UBYTE i;

 LIBDEBUG(printf("\nEntering buff_draw_stringNC().\n"));

 for(i=0;i<strlen(string);i++){
     if(HAS_FONT(string[i])){
	buff_draw_charNC(buff,string[i],x,y,colour);
	x += CHAR_WIDTH(string[i]);
     }
 }

 LIBDEBUG(printf("\nLeaving buff_draw_stringNC().\n"));
}
