/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#include <string.h>
#include "..\jlib.h"

/*+------------------------------------------------------------------------+*/
/*|draw a box with corners x1, y1 to x2 , y2 in color c with clipping      |*/
/*+------------------------------------------------------------------------+*/
#ifdef __DEBUG_buff_draw_box
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

inline void buff_draw_box(buffer_rec *buff,USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c)
{
 UBYTE *buffer = B_BUFF_PTR(buff);
 USHORT width = B_X_SIZE(buff);
 USHORT height = B_Y_SIZE(buff);
 USHORT boxwidth;

 LIBDEBUG(printf("\nEntering buff_draw_box()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 /* clip coords if nessisary */
 if((x1 > width) || (y1 > height)){
    return;
 }

 if(x2 > width){
    x2 = width;
 }

 if(y2 > height){
    y2 = height;
 }

 boxwidth=x2-x1;
 y2 -= y1;

 /* draw top line */
 buffer += (width*y1);
 buffer += x1;
 memset(buffer,(int)c,(size_t)boxwidth+1);  /* this is NOT a cludge! */

 /* draw the 2 vertical sides at the same tip */
  for(;y2 != 0;y2--){
     buffer+=width;
     *buffer=c;
     *(buffer+boxwidth)=c;
 }

 /* draw bottom line  */
 memset(buffer,(int)c,(size_t)boxwidth);

 LIBDEBUG(printf("\nLeaving buff_draw_box()\n\n"));
}


/*+------------------------------------------------------------------------+*/
/*|draw a box with corners x1, y1 to x2 , y2 in color c without clipping   |*/
/*+------------------------------------------------------------------------+*/
#ifdef __DEBUG_buff_draw_box
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

inline void buff_draw_boxNC(buffer_rec *buff,USHORT x1, USHORT y1, USHORT x2,USHORT y2, UBYTE c)
{
 UBYTE *buffer = B_BUFF_PTR(buff);
 USHORT width = B_X_SIZE(buff);
 USHORT boxwidth;

 LIBDEBUG(printf("\nEntering buff_draw_box()\n\n"));

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 boxwidth=x2-x1;
 y2 -= y1;

 /* draw top line */
 buffer += (width*y1);
 buffer += x1;
 memset(buffer,(int)c,(size_t)boxwidth+1);  /* this is NOT a cludge! */

 /* draw the 2 vertical sides at the same tip */
  for(;y2 != 0;y2--){
     buffer+=width;
     *buffer=c;
     *(buffer+boxwidth)=c;
 }

 /* draw bottom line  */
 memset(buffer,(int)c,(size_t)boxwidth);

 LIBDEBUG(printf("\nLeaving buff_draw_box()\n\n"));
}




