/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

#include <dos.h>
#include <string.h>
#include "..\jlib.h"
#include "..\memcopy.h"

#define FAST_2_DIV(x) ((x) >> 1)

/*+------------------------------------------------------------------------+*/
/*|blit a portion of the screen without clipping to bfx,bfy                |*/
/*+------------------------------------------------------------------------+*/

#ifdef __DEBUG_buff_blit_screen_toNC
 #include <stdio.h>
 #define LIBDEBUG(x) x;fflush(stdout)
#else
 #define LIBDEBUG(x)
#endif

#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif

__inline void buff_blit_screen_toNC( USHORT bfx, USHORT bfy,
		     buffer_rec *buff,USHORT x1, USHORT y1,USHORT x2, USHORT y2)
{
 int v_iterations,h_len,count;
 UBYTE *screen=SCREEN_START;
 UBYTE *obuff;

 LIBDEBUG(printf("\nEntering buff_blit_screen_toNC()\n\n"));

 /* sort coordinates if needed */
 if(x2<x1){
    _SWAP(x1,x2);
 }

 if(y2<y1){
    _SWAP(y1,y2);
 }

 /* set screen to point to where we want to start copying from */
 screen+=(y1*SCREEN_WIDTH)+x1;

 /* set obuff to point to where we want to start copying to */
 obuff=buff->buffer+((bfy*B_X_SIZE(buff))+bfx);

 v_iterations=(y2-y1); /* number of times to repeat horiz. blit */

 h_len=(x2-x1);  /* length of horizontal blit */

 for(count=0;count<v_iterations;count++){
      _bytecopy(screen,obuff,h_len);
     screen += SCREEN_WIDTH;
     obuff += B_X_SIZE(buff);
 }

 LIBDEBUG(printf("\nLeaving buff_blit_screen_toNC()\n\n"));
}

