/* ellipse.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

#include "f:\gcc\proj\spr\src\jlib.h"

#define FAST_2_MUL(x) ((x)<<1)
#define FAST_3_MUL(x) (((x)<<1)+x)
#define FAST_4_DIV(x) ((x)>>2)


void ellipse(USHORT x0,USHORT y0, USHORT a,USHORT b, UBYTE c)
{
 int x, y, y1, aa, bb, d, g, h;

  aa = a*a;
  bb = b*b;

  h = (FAST_4_DIV(aa)) - b*aa + bb;
  g = (FAST_4_DIV(9*aa)) - (FAST_3_MUL(b*aa)) + bb;
  x = 0;
  y = b;

  while(g < 0){
    screen_draw_pointNC(x0+x,y0+y,c);
    screen_draw_pointNC(x0-x,y0+y,c);
    screen_draw_pointNC(x0-x,y0-y,c);
    screen_draw_pointNC(x0+x,y0-y,c);

    if(h < 0){
       d = ((FAST_2_MUL(x))+3)*bb;
       g+=d;
    }
    else{
       d = ((FAST_2_MUL(x))+3)*bb - FAST_2_MUL((y-1)*aa);
       g+=(d + (FAST_2_MUL(aa)));
       --y;
    }

    h+=d;
    ++x;
  }

  y1 = y;
  h = (FAST_4_DIV(bb)) - a*bb + aa;
  x = a;
  y = 0;

  while(y <= y1){
	screen_draw_pointNC(x0+x,y0+y,c);
	screen_draw_pointNC(x0-x,y0+y,c);
	screen_draw_pointNC(x0-x,y0-y,c);
	screen_draw_pointNC(x0+x,y0-y,c);

    if(h < 0){
      h+=((FAST_2_MUL(y))+3)*aa;
    }
    else{
	h+=(((FAST_2_MUL(y)+3)*aa)-(FAST_2_MUL(x-1)*bb));
	--x;
    }
    ++y;
  }

}

