/* demo6.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pc.h>
#include "f:\gcc\proj\spr\src\jlib.h"

#define NUM_SPRITES 400
#define RANDOM(num) ((rand()*num)/RAND_MAX)
#define NUM_ITERATIONS 500

void main()
{
 int i,t,len=16000;
 unsigned char *pal,*onscreen=SCREEN_START;
 sprite_system *demo_sprites;
 buffer_rec *offscreen;
 USHORT animation[4] = {0,1,2,1};
 double start_time,end_time;

/* init stuff*/
 offscreen = buff_init(320,200);
 demo_sprites = sprite_init(NUM_SPRITES,64);
 pal = screen_load_pal("demo6.pal");
 sprite_load("demo6.spr",demo_sprites);
 screen_set_video_mode();

 srand(time(NULL));

 screen_block_set_pal(pal);

 /* set up sprite movements */
 for(i=0;i<NUM_SPRITES;i++){
     sprite_set_xy(demo_sprites,i,RANDOM(B_X_SIZE(offscreen))+SPR_MAX_X,
				  RANDOM(B_Y_SIZE(offscreen))+SPR_MAX_Y);
     sprite_set_an_frame(demo_sprites,i,RANDOM(4));
     sprite_set_move_info(demo_sprites,i,RANDOM(2)+1,-(RANDOM(4)),-(RANDOM(4)));
     sprite_set_anim_info(demo_sprites,i,RANDOM(3)+1,4,animation);
     sprite_turn_on(demo_sprites,i);
 }

 getch();


 start_time = clock();

 for(i=0;i<NUM_ITERATIONS;i++){
   buff_save_all_sprites(demo_sprites,offscreen);

   buff_draw_all_sprites(demo_sprites,offscreen);

   screen_blit_fs_buffer(offscreen,0,0);

   buff_rest_all_sprites(demo_sprites,offscreen);

   sprite_update_all_anim_and_move(demo_sprites);
 };

 end_time = clock();

 screen_set_text_mode();
 printf("FPS: %f",NUM_ITERATIONS/((end_time-start_time)/CLOCKS_PER_SEC));
}
